"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debugBtn = debugBtn;
exports.default = void 0;

var _react = _interopRequireDefault(require("devtools/client/shared/vendor/react"));

var _propTypes = _interopRequireDefault(require("devtools/client/shared/vendor/react-prop-types"));

var _AccessibleImage = _interopRequireDefault(require("../AccessibleImage"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const classnames = require("devtools/client/shared/classnames.js");

function debugBtn(onClick, type, className, tooltip, disabled = false, ariaPressed = false) {
  return _react.default.createElement(CommandBarButton, {
    className: classnames(type, className),
    disabled: disabled,
    key: type,
    onClick: onClick,
    pressed: ariaPressed,
    title: tooltip
  }, _react.default.createElement(_AccessibleImage.default, {
    className: type
  }));
}

const CommandBarButton = props => {
  const {
    children,
    className,
    pressed = false,
    ...rest
  } = props;
  return _react.default.createElement("button", _extends({
    "aria-pressed": pressed,
    className: classnames("command-bar-button", className)
  }, rest), children);
};

CommandBarButton.propTypes = {
  children: _propTypes.default.node.isRequired,
  className: _propTypes.default.string.isRequired,
  pressed: _propTypes.default.bool
};
var _default = CommandBarButton;
exports.default = _default;