/*
 * Copyright (c) 2005 Jacob Meuser <jakemsr@jakemsr.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: bsdav_tables.c,v 1.3 2005/11/20 00:35:17 jakemsr Exp $
 */

#include "includes.h"

#include <string.h>

#include "bsdav.h"


struct bsdav_vid_formats bsdav_vid_fmts[] = {
{ "none",	0,	0x00000000,	-1 },
{ "yv12",	12,	0x32315659,	-1 },
{ "i420",	12,	0x30323449,	-1 },
{ "yv16",	16,	0x36315659,	-1 },
{ "yuy2",	16,	0x32595559,	-1 },
{ "uyvy",	16,	0x59565955,	-1 },
{ "rv15",	16,	0x35315652,	-1 },
{ "rv16",	16,	0x36315652,	-1 },
{ 0, 0, 0, 0}
};


#if defined(HAVE_SUN_AUDIO)
struct bsdav_aud_formats bsdav_aud_fmts[] = {
{ "none",	0,	AUDIO_ENCODING_NONE,		-1 },
{ "ulaw",	8,	AUDIO_ENCODING_ULAW,		-1 },
{ "alaw",	8,	AUDIO_ENCODING_ALAW,		-1 },
{ "slinear_le",	16,	AUDIO_ENCODING_SLINEAR_LE,	-1 },
{ "slinear_be",	16,	AUDIO_ENCODING_SLINEAR_BE,	-1 },
{ "ulinear_le",	16,	AUDIO_ENCODING_ULINEAR_LE,	-1 },
{ "ulinear_be",	16,	AUDIO_ENCODING_ULINEAR_BE,	-1 },
{ "slinear",	8,	AUDIO_ENCODING_SLINEAR,		-1 },
{ "ulinear",	8,	AUDIO_ENCODING_ULINEAR,		-1 },
{ 0, 0, 0, 0}
};
#elif defined(HAVE_OSS_AUDIO)
struct bsdav_aud_formats bsdav_aud_fmts[] = {
{ "none",	0,	AFMT_QUERY,	-1 },
{ "ulaw",	8,	AFMT_MU_LAW,	-1 },
{ "alaw",	8,	AFMT_A_LAW,	-1 },
{ "slinear_le",	16,	AFMT_S16_LE,	-1 },
{ "slinear_be",	16,	AFMT_S16_BE,	-1 },
{ "ulinear_le",	16,	AFMT_U16_LE,	-1 },
{ "ulinear_be",	16,	AFMT_U16_BE,	-1 },
{ "slinear",	8,	AFMT_S8,	-1 },
{ "ulinear",	8,	AFMT_U8,	-1 },
{ 0, 0, 0, 0}
};
#endif

struct bsdav_vid_norms bsdav_vid_nrms[] = {
{ "none",	{ 0, 1 },	BT848_IFORM_F_AUTO,	0,	0 },
{ "ntsc",	{ 30000, 1001 },BT848_IFORM_F_NTSCM,	640,	480 },
{ "pal",	{ 25, 1 },	BT848_IFORM_F_PALBDGHI,	768,	576 },
{ "secam",	{ 25, 1 },	BT848_IFORM_F_SECAM,	768,	576 },
{ 0, { 0, 0 }, 0, 0 }
};


struct bsdav_vid_sources bsdav_vid_srcs[] = {
{ "none", 		0 },
{ "composite",		METEOR_INPUT_DEV0 },
{ "tuner",		METEOR_INPUT_DEV1 },
{ "scomp",		METEOR_INPUT_DEV2 },
{ "svideo",		METEOR_INPUT_DEV_SVIDEO },
{ "input3",		METEOR_INPUT_DEV3 },
{ 0, 0 }
};


int
bsdav_find_aud_fmt(char *name)
{
	int i, found = 0;

	for (i = 0; bsdav_aud_fmts[i].name; i++) {
		if (strncmp(bsdav_aud_fmts[i].name, name,
		    strlen(bsdav_aud_fmts[i].name)) == 0) {
			found = 1;
			break;
		}
	}
	if (found == 1)
		return(i);
	else
		return(-1);
}


int
bsdav_find_vid_fmt(char *name)
{
	int i, found = 0;

	for (i = 0; bsdav_vid_fmts[i].name; i++) {
		if (strncmp(bsdav_vid_fmts[i].name, name,
		    strlen(bsdav_vid_fmts[i].name)) == 0) {
			found = 1;
			break;
		}
	}
	if (found == 1)
		return(i);
	else
		return(-1);
}


int
bsdav_find_vid_norm(char *name)
{
	int i, found = 0;

	for (i = 0; bsdav_vid_nrms[i].name; i++) {
		if (strncmp(bsdav_vid_nrms[i].name, name,
		    strlen(bsdav_vid_nrms[i].name)) == 0) {
			found = 1;
			break;
		}
	}
	if (found == 1)
		return(i);
	else
		return(-1);
}


int
bsdav_find_vid_source(char *name)
{
	int i, found = 0;

	for (i = 0; bsdav_vid_srcs[i].name; i++) {
		if (strncmp(bsdav_vid_srcs[i].name, name,
		    strlen(bsdav_vid_srcs[i].name)) == 0) {
			found = 1;
			break;
		}
	}
	if (found == 1)
		return(i);
	else
		return(-1);
}

