;; -*- coding: euc-jp ; mode: scheme -*-
;; test plugin module.
;; Kahua.plugin ⥸塼Υƥ

;; $Id: plugin.scm,v 1.4 2006/05/12 04:11:33 bizenn Exp $

(use gauche.test)
(use file.util)
(use kahua.sandbox)
(use kahua.config)


(test-start "plugin manager")

;; --------------------------------------------------------------
(test-section "initialization")
(sys-system "rm -rf _work")
(sys-mkdir "_work" #o775)
(sys-mkdir "_work/plugins" #o775)

(copy-file "../plugins/allow-module.scm" "_work/plugins/allow-module.scm")
(copy-file "../plugins/sendmail.scm" "_work/plugins/sendmail.scm")

(set! (ref (kahua-config) 'working-directory) "./_work")


;;---------------------------------------------------------------
;; ץ饰⥸塼ΥƥȤ򳫻Ϥ롣
(test-section "plugin")

;; ɥƥ
;; kahua.plugin ɤǤޤΥ󥿡ե
;; ʤȤǧ롣
(use kahua.plugin)
(test-module 'kahua.plugin)

;; ץ饰νǤ뤳Ȥǧ롣
(test* "initialize plugins" "#<undef>"
       (x->string (initialize-plugins)))

;; ץ饰Ͽ줿Ȥǧ롣
(test* "are there plugins" #t
       (> (length (all-plugins)) 1))

;;---------------------------------------------------------------
;; ɥܥåǤΥƥ
(test-section "in a sandbox")

(define *sandbox* (make-sandbox-module))

;; ץ饰 srfi-1 ɤˤ filter ³ʤΤǡ
;; ƥȤ˼Ԥ뤳Ȥǧ롣
(test* "no plugin loads yet"
       *test-error*
       (eval '(filter odd? '(1 2 3 4 5))  *sandbox*))

;; ץ饰 srfi-1 ɤȤ filter ³Ȥ뤳Ȥ
;; ǧ롣
(test* "load srfi-1 plugin"
       '(1 3 5)
       (eval '(begin (use srfi-1) (filter odd? '(1 2 3 4 5))) *sandbox*))

;; ץ饰 srfi-1  filter ³Ǥ뤳Ȥǧ롣
(test* "this is srfi-1's filter"
       (eval 'filter (find-module 'srfi-1))
       (eval 'filter *sandbox*))

;; ץ饰 gauche.collection ɤȤ filter ³
;; gauche.collectionΤΤǤ뤳Ȥǧ롣
(test* "replace filter to the gauche.collections's one"
       (eval 'filter (find-module 'gauche.collection))
       (eval '(begin (use gauche.collection) filter) *sandbox*))

;; ץ饰 sendmail ɤˤ sendmail ³ʤȤ
;; ǧ롣
(test* "sendmail does not exists"
       *test-error*
       (eval 'sendmail *sandbox*))

;; ץ饰 sendmail ɤȤ sendmail ³뤳Ȥ
;; ǧ롣
(test* "load sendmail plugin" #t
       (eval '(begin (use-plugin sendmail)
                     (global-variable-bound? (current-module) 'sendmail))
             *sandbox*))

(test-end)
