;; -*- coding: euc-jp ; mode: scheme -*-
;; test admin scripts.
;; this test isn't for modules, but for actual scripts.
;; kahua-admin ƥ

;; $Id: admin.scm,v 1.6 2006/11/28 06:22:49 bizenn Exp $

(use gauche.test)
(use gauche.process)
(use gauche.net)
(use file.util)
(use kahua.config)
(use kahua.gsid)

(test-start "kahua-admin script")

;;---------------------------------------------------------------
(test-section "initialization")

(sys-system "rm -rf _tmp _work user.conf")
(sys-mkdir "_tmp" #o755)
(sys-mkdir "_work" #o755)
(sys-mkdir "_work/checkout" #o755)
(sys-mkdir "_work/checkout/hello" #o755)
(sys-mkdir "_work/checkout/greeting" #o755)
(sys-mkdir "_work/checkout/lister" #o755)
(copy-file "hello-world.kahua" "_work/checkout/hello/hello.kahua")
(copy-file "greeting.kahua"    "_work/checkout/greeting/greeting.kahua")
(copy-file "lister.kahua"      "_work/checkout/lister/lister.kahua")
(sys-mkdir "_work/plugins" #o755)
(copy-file "../plugins/allow-module.scm"  "_work/plugins/allow-module.scm")

;; copy user.conf
(copy-file "testuser.conf" "user.conf")

;; prepare app-servers file
(with-output-to-file "_work/app-servers"
  (lambda ()
    (write '((hello    :run-by-default 1)
             (greeting :run-by-default 0)
             (lister   :run-by-default 0)
             ))))

(define *config* "./test.conf")
(define *spvr*   #f)
(define *admin*  #f)

;;---------------------------------------------------------------
;; ƥȤɬפ2ĤΥץȤư롣
(test-section "run scripts")

;; kahua-spvr ư롣
(test* "start spvr" #t
       (let ((p (run-process "../src/kahua-spvr" "--test"
			     "-c" *config*)))
	 (sys-sleep 3)
	 (and (file-exists? "_tmp/kahua")
	      (or (eq? (file-type "_tmp/kahua") 'socket)
                  (eq? (file-type "_tmp/kahua") 'fifo)))))

;; kahua-admin ư롣
(test* "start admin" 'spvr>
       (let ((p (run-process "../src/kahua-admin" "--test"
			     "-c" *config* 
			     :input :pipe :output :pipe :error :pipe)))
	 (set! *admin* p)
	 (sys-sleep 1)
	 (let* ((out (process-input  *admin*))
		(in  (process-output *admin*)))
	   (read in))))

;;---------------------------------------------------------------
;; ƥѤΥ桼ƥƥ롣
(test-section "define utilities")

(define (admin-out)
  (process-input *admin*))
(define (admin-in)
  (process-output *admin*))

(define (send msg)
  (let* ((out (admin-out)))
    (write msg out)
    (newline out)))

(define (send&recv msg)
  (let* ((out (admin-out))
	 (in  (admin-in)))
    (read in)      ;; read prompt
    (if (pair? msg)
	(for-each (lambda (e)
		    (write e out) (display " " out)) msg)
	(write msg out))   ;; write command
    (newline out)
    (flush out)
    (read in)))

(define (send&recv-str msg)
  (let* ((out (admin-out))
	 (in  (admin-in)))
    (read in)         ;; read prompt
    (if (pair? msg)
	(for-each (lambda (e)
		    (write e out) (display " " out)) msg)
	(write msg out))   ;; write command
    (newline out)
    (flush out)
    (sys-sleep 2)
    (let1 ret (read-block 1000 in)
	  (newline out)
	  (string-incomplete->complete ret))))

(newline (admin-out))


;;------------------------------------------------------------
;; kahua-admin ưǧ롣
(test-section "spvr command test")

;; ls ޥɤ¹ԡ
;; hello ץꥱ󤬰ˤ뤳Ȥǧ롣
(test* "admin: ls" #f
       (not (#/wno\s+pid\s+type\s+since\s+wid.+hello/
	     (send&recv-str 'ls))))

;; help ޥɤ¹ԡ
;; ޥɤΥꥹȤɽ뤳Ȥǧ롣
(test* "admin: help" #t
       (let1 ans (send&recv 'help)
	     (and (list? ans)
		  (< 0 (length ans)))))

;; type ޥɤ¹ԡ
;; hello greeting lister 3ĤΥץꥱɽ
;; Ȥǧ롣
(test* "admin: types" '(hello greeting lister)
       (send&recv 'types))

;; run ޥɤΥƥȡ1ܡ
;; greeting ư뤳Ȥǧ롣
(test* "admin: run greeting" #f
       (let1 ans (send&recv-str '(run greeting))
	     (not (#/greeting/ ans))))

;; run ޥɤΥƥȡ2ܡ
;; lister ư뤳Ȥǧ롣
(test* "admin: run lister" #f
       (let1 ans (send&recv-str '(run lister))
	     (not (#/lister/ ans))))

;; kill ޥɤΥƥȡ
;; greeting λǤ뤳Ȥǧ롣
(test* "admin: kill 1(greeting)" #f
       (let1 ans (send&recv-str '(kill 1))
	     (#/greeting/ ans)))

;; reload ޥɤΥƥȡ
;; app-server ϿƤ3ĤΥץꥱ
;; ɽ뤳Ȥǧ롣
(test* "admin: reload" '(hello greeting lister)
       (send&recv 'reload))

;; update ޥɤΥƥ
;; hello 򹹿Ǥ뤳Ȥǧ롣
(test* "admin: update" 'update:
       (send&recv '(update hello)))

;;------------------------------------------------------------
;; kahua-server ³ connect ޥɤƥȤ롣
(test-section "server connect test")

;; ֹ 0 hello ³Ǥ뤳Ȥǧ롣
(test* "admin: connect 0(hello)" #t
       (not (not (#/hello/ (send&recv-str '(connect 0))))))

;; ³褬 hello Ǥ뤳Ȥǧ롣
(test* "admin: connect: (kahua-worker-type)" "hello"
       (begin
	 (write '(kahua-worker-type) (admin-out))
	 (newline (admin-out))
	 (flush (admin-out))
	 (read (admin-in))))

;; hello ǤǤ뤳Ȥǧ롣
(test* "admin: connect: disconnect" #f
       (begin
	 (write 'disconnect (admin-out))
	 (newline (admin-out))
	 (flush (admin-out))
	 (sys-sleep 1)
	 (not (#/spvr>/ (string-incomplete->complete
			 (read-block 1000 (admin-in)))))))

(newline (admin-out))

;;------------------------------------------------------------
;; ȯԥȤƥȤ롣
(test-section "developer account test")

;; lsuser ޥɤ¹Ԥ桼 gandalf ͤˤ뤳Ȥ
;; ǧ롣
(test* "admin: lsuser" '("gandalf")
       (send&recv '(lsuser)))

;; adduser ޥɤ¹Ԥ桼 bilbo ϿǤ뤳Ȥ
;; ǧ롣
(test* "admin: adduser" 'done
       (send&recv '(adduser bilbo baggins)))

;; lsuser ޥɤ¹Ԥ桼 gandalf  bilbo ˤ뤳Ȥ
;; ǧ롣
(test* "admin: lsuser" '("gandalf" "bilbo")
       (send&recv '(lsuser)))

;; deluser ޥɤ¹Ԥ桼 gandalf Ǥ뤳Ȥǧ롣
(test* "admin: deluser" 'done
       (send&recv '(deluser gandalf)))

;; lsuser ޥɤ¹Ԥ桼 bilbo ͤˤ뤳Ȥǧ롣
(test* "admin: lsuser" '("bilbo")
       (send&recv '(lsuser)))


;;------------------------------------------------------------
;; ƥȽλ
(test-section "finalize")

;; shutdown ޥɤ¹Ԥkahua-spvr λǤ뤳Ȥǧ롣
(test* "shutdown spvr" '()
       (begin
	 (send&recv 'shutdown)
	 (call/cc (lambda (exit)
		    (dotimes (i 15)
		      (sys-sleep 1)
		      (when (null? (directory-list "_tmp" :children? #t))
			(exit '())))
		    #f))))

;; kahua-admin λ뤳Ȥǧ롣
(test* "shutdown admin" #t
       (begin
	 (process-send-signal *admin* SIGTERM)
         (sys-sleep 1) ;; give the spvr time to shutdown ...
	 (process-wait *admin*)))

(test-end)

