/////////////////////////////////////////////////////////////////////////////
/*
  Copyright 2001 Ronald S. Burkey.
  Latex support Copyright 2001 Joe Cherry.

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	OutputXml.c 
  Purpose:	Outputs the XML file.
  Mods:		01/13/02 RSB	Created.
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <zlib.h>
#include "AutoMark.h"

//--------------------------------------------------------------------------
// Handles just the output, after all analysis has been completed.
// Returns 0 on success, non-zero on error.

int
OutputXml (FILE * OutputFile, AnalysisDataset * Dataset)
{
  int ErrorCode, c, lastc, Remove, AtEnd;
  MarkupRecord Mark;
  unsigned long Offset;
  char s[256];
  int InParagraph = 0;
  int InPreformatted = 0, LastNewline = 1;
  int AfterBreak = 0;
  int Removed = -1;
  int JumpedPastHeader = 0;
  int InPrefatoryArea = 0;

  // Print output header.
  fseek (Dataset->InputFile, 0, SEEK_SET);
  fgets (s, sizeof (s) - 1, Dataset->InputFile);
  fgets (s + strlen (s), sizeof (s) - strlen (s) - 1, Dataset->InputFile);
  NormalizeTitle (s, sizeof (s));
  // write to output file ...

  // Print marked-up text.  This is basically a matter 
  // of merging the markup file with the input file.
  fseek (Dataset->MarkupFile, 0, SEEK_SET);
  fseek (Dataset->InputFile, 0, SEEK_SET);
  if (Dataset->YesHeader)
    {
      ErrorCode = fread (&Mark, sizeof (Mark), 1, Dataset->MarkupFile);
      if (ErrorCode != 1)
	Mark.Type = MarkNoMoreMarks;
      Offset = 0;
    }
  else
    {
      do
	{
	  ErrorCode = fread (&Mark, sizeof (Mark), 1, Dataset->MarkupFile);
	  if (ErrorCode != 1)
	    {
	      Mark.Type = MarkNoMoreMarks;
	      break;
	    }
	}
      while (Mark.Offset < Dataset->TextStart);
      fseek (Dataset->InputFile, Dataset->TextStart, SEEK_SET);
      Offset = Dataset->TextStart;
    }
  for (Remove = AtEnd = c = 0;
       (lastc = c, c = fgetc (Dataset->InputFile)) != EOF; Offset++)
    {
      if (!isspace (c))
	AfterBreak = 0;
    LastShot:
      while (Offset == Mark.Offset && Mark.Type != MarkNoMoreMarks)
	{
	  switch (Mark.Type)
	    {
	    case MarkTolower:
	      // write to output file ...
	      //putc (DiacriticalTolower (c), OutputFile);
	      Remove = 1;
	      break;
	    case MarkToupper:
	      // write to output file ...
	      //putc (DiacriticalToupper (c), OutputFile);
	      Remove = 1;
	      break;
	    case MarkBeginSmartQuote:
	      // write to output file ...
	      Remove = 1;
	      break;
	    case MarkEndSmartQuote:
	      // write to output file ...
	      Remove = 1;
	      break;
	    case MarkLsquo:
	      // write to output file ...
	      Remove = 1;
	      break;
	    case MarkRsquo:
	      // write to output file ...
	      Remove = 1;
	      break;
	    case MarkRemoveChar:
	      Remove = 1;
	      Removed = Offset;
	      break;
	    case MarkInsertChar:
	      // write to output file ...
	      //OutputCharacter (Dataset->ForceNumeric, OutputFile, Mark.Insert);
	      break;
	    case MarkNbsp:
	      // write to output file ...
	      break;
	    case MarkBeginJustifiedParagraph:
	      InParagraph = 1;
	      // write to output file ...
	      break;
	    case MarkBeginRaggedParagraph:
	      InParagraph = 1;
	      // write to output file ...
	      break;
	    case MarkBeginCenteredParagraph:
	      InParagraph = 1;
	      // write to output file ...
	      break;
	    case MarkEndParagraph:
	      InParagraph = 0;
	      // write to output file ...
	      break;
	    case MarkBeginItalics:
	      // write to output file ...
	      break;
	    case MarkEndItalics:
	      // write to output file ...
	      break;
	    case MarkBeginBold:
	      // write to output file ...
	      break;
	    case MarkEndBold:
	      // write to output file ...
	      break;
	    case MarkBeginUnderline:
	      // write to output file ...
	      break;
	    case MarkEndUnderline:
	      // write to output file ...
	      break;
	    case MarkBreak:
	      AfterBreak = 1;
	      // write to output file ...
	      break;
	    case MarkBlockquote:
	      InParagraph = 1;
	      // write to output file ...
	      break;
	    case MarkEndBlockquote:
	      InParagraph = 0;
	      // write to output file ...
	      break;
	    case MarkHeader1:
	      InPrefatoryArea = 0;
	      // write to output file ...
	      break;
	    case MarkEndHeader1:
	      // write to output file ...
	      break;
	    case MarkBeginSubtitle:
	      // write to output file ...
	      break;
	    case MarkEndSubtitle:
	      // write to output file ...
	      break;
	    case MarkBeginTable:
	      InPreformatted = 1;
	      LastNewline = 0;
	      // write to output file ...
	      break;
	    case MarkEndTable:
	      InPreformatted = 0;
	      // write to output file ...
	      break;
	    case MarkInsertMdash:
	      // write to output file ...
	      break;
	    case MarkInsertNdash:
	      // write to output file ...
	      break;
	    case MarkSoftHyphen:
	      // write to output file ...
	      break;
	    case MarkJumpPastGutenbergHeader:
	      JumpedPastHeader = 1;
	      // write to output file ...
	      break;
	    case MarkEndOfGutenbergHeader:
	      // write to output file ...
	      break;
	    case MarkGutenbergEnder:
	      // write to output file ...
	      if (Dataset->YesHeader)
		{
		}
	      else
		AtEnd = 1;
	      break;
	    case MarkNoMoreMarks:
	      break;
	    }
	  ErrorCode = fread (&Mark, sizeof (Mark), 1, Dataset->MarkupFile);
	  if (ErrorCode != 1)
	    Mark.Type = MarkNoMoreMarks;
	}
      if (AtEnd)
	break;
      if (Remove)
	Remove = 0;
      else			// write a single character.
	{
	  // write to output file ...
	}
    }

  // What this does is to allow us to process any remaining markups that
  // are supposed to occur at the very end of the input (such as end of 
  // paragraph).  
  if (AtEnd == 0)
    {
      AtEnd = 1;
      goto LastShot;
    }

  // Last stage:  Close the output stream.          
  // write to output file ...

  return (0);
}
