///////////////////////////////////////////////////////////////////////////// 
/* 
  Copyright 2001 Ronald S. Burkey 
 
  This file is part of GutenMark. 
 
  GutenMark is free software; you can redistribute it and/or modify 
  it under the terms of the GNU General Public License as published by 
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version. 
 
  GutenMark is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
  GNU General Public License for more details. 
 
  You should have received a copy of the GNU General Public License 
  along with GutenMark; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 
  Filename:	MarkByLineNeural.c 
  Purpose:	This handles just things high-level aspects of the line-level
  		analysis, using data provided from LineAnalysisPass.  In other
		words, it does things like detect headings, paragraph starts,
		paragraph ends, verse, etc., and supplies the appropriate
		markup.
  Mods:		12/30/01 RSB	Split off from MarkBody.c, where it was
  				formerly a large chunk of the MarkBody 
				function. 
				
  This function is (functionally) equivalent to the MarkByLineHeuristic 
  function.  It embodies the original approach I used in GutenMark.  
  It's intended to be an improved replacement.  Both sets of code will be kept, 
  and the one used will be selectable at runtime with a command-line switch.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "AutoMark.h"

//--------------------------------------------------------------------- 
// As complex as this function is, at base it's trying to do something
// pretty simple:  Just to locate headings, starts and ends of paragraphs,
// versified areas, etc.
// Returns:
//      0       Success
//      5       Disk error
//      -1      At end of file 

int
MarkByLineNeural (AnalysisDataset * Dataset, MarkStatus * Status,
		  int LineNum, char *s)
{
  return (100);
}
