///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2002 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	MagicFile.h
  Purpose:	Replaces some of the standard file operations with 
  		similar operations that transparently use other file 
		formats such as gzipped files or zipped files.
  Mods:		01/14/02 RSB	Began.
*/
///////////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_MAGICFILE_H
#define _INCLUDE_MAGICFILE_H

#include <stdlib.h>
#include <stdio.h>
#include <zlib.h>
#include <zziplib.h>

// We don't define any constants, because we use the usual NULL, EOF,
// SEEK_SET, SEEK_CUR, and SEEK_END constants.

//-------------------------------------------------------------------------
// Data structures.

enum MagicType { MagicGzip, MagicZip };

typedef struct
{
  enum MagicType FileType;
  gzFile GzFile;
  ZZIP_DIR *ZipDir;
  ZZIP_FILE *ZipFile;  
}
MagicFILE;

//-------------------------------------------------------------------------
// Prototypes

MagicFILE *MagicOpen (const char *, const char *);
int MagicClose (MagicFile *);
int MagicSeek (MagicFFILE *, long, int);
void *MagicGets (char *, long, MagicFILE *);
int MagicGetc (MagicFILE *);

#endif // _INCLUDE_MAGICFILE_H

