///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2001 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	names_english.c
  Purpose:	Converts lists of names from the U.S. Census Bureau
  		to the single-word-per-line wordlist format required by 
		GutenMark.  Refer to www.census.gov/genealogy/names/.  
		There is no specific licensing information available
		concerning the namelists themselves, but the government
		web page from which I got them seems to 
		imply that the information is available under the 
		Freedom of Information Act.  So I suppose, you're 
		entitled to the information if you're an American,
		and not necessarily entitled to it if you're not ...
  Mods:		11/09/01 RSB	Began.
*/
///////////////////////////////////////////////////////////////////////////

/*
  A trivial program to read some American namelists, strip off
  statistics, correct the capitalization, and write them out
  again to be used as word lists.
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

int
main (void)
{
  char s[1000], ss[1000], *sss;
  s[sizeof (s) - 1] = 0;
  while (NULL != fgets (s, sizeof (s) - 1, stdin))
    {
      if (1 != sscanf (s, "%s", ss))
	continue;
      for (sss = ss + 1; *sss; sss++)
	*sss = tolower (*sss);
      if (!strncmp (ss, "Mc", 2))
	ss[2] = toupper (ss[2]);
      else if (!strncmp (ss, "Mac", 3))
	ss[3] = toupper (ss[3]);
      printf ("%s\n", ss);
    }
  return (0);
}
