///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2001 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	espa~nol.c
  Purpose:	Converts a Spanish ispell dictionary
  		(ftp://ftp.fi.upm.es/pub/unix/espa~nol.tar.gz) to the 
		single-word-per-line format needed by GutenMark.
		The original ispell dictionary is copyright 2001
		by Rodriquez & Carretero, and is GPL'd.
  Mods:		11/09/01 RSB	Began.
*/
///////////////////////////////////////////////////////////////////////////

/*
  This is just a simple thing I threw together to filter some 7-bit escape
  sequences in the espa~nol ispell dictionary.  I've no doubt that some
  standard utility like SED can do it, but I've already spent far more time
  trying to figure it out than the 5 minutes it will cost to write this
  program.
*/

#include <stdio.h>

int
main (void)
{
  int ch, next;
  while (EOF != (ch = getchar ()))
    {
      if (ch == '\'')
	{
	  next = getchar ();
	  if (next == EOF)
	    putchar (ch);
	  else if (next == 'a')
	    putchar (225);
	  else if (next == 'A')
	    putchar (193);
	  else if (next == 'e')
	    putchar (233);
	  else if (next == 'E')
	    putchar (201);
	  else if (next == 'i')
	    putchar (237);
	  else if (next == 'I')
	    putchar (205);
	  else if (next == 'n')
	    putchar (241);
	  else if (next == 'N')
	    putchar (209);
	  else if (next == 'o')
	    putchar (243);
	  else if (next == 'O')
	    putchar (211);
	  else if (next == 'u')
	    putchar (250);
	  else if (next == 'U')
	    putchar (218);
	  else
	    {
	      putchar (ch);
	      putchar (next);
	    }
	}
      else if (ch == '\"')
	{
	  next = getchar ();
	  if (next == 'u')
	    putchar (252);
	  else if (next == 'U')
	    putchar (220);
	  else if (next == EOF)
	    putchar (ch);
	  else
	    {
	      putchar (ch);
	      putchar (next);
	    }
	}
      else
	putchar (ch);
    }
  return (0);
}
