/*
 * Copyright (c) 2015, Marcos Medeiros
 * Licensed under BSD 3-clause.
 */
#ifdef TMS34010_DEBUGGER
#include <QDebug>
#endif
#include "tms34010.h"
#include "tms34010_defs.h"

namespace tms {

using namespace ops;

static void unimplemented(cpu_state *cpu, word opcode) {
#ifdef TMS34010_DEBUGGER
    qDebug() << "OP_UNIMPL" << QString::number(opcode, 16);
    qDebug() << QString::number(cpu->pc-16,16) << "::" << QString::fromStdString(dasm(cpu->pc-16,nullptr));
    cpu->reason = BREAKPOINT_FOUND;
    cpu->icounter = 0;
#endif
}

static void nop(cpu_state *cpu, word opcode) { CONSUME_CYCLES(1); }

opcode_handler opcode_table[0x1000] = {
/* 0000 0000 0000 */ &unimplemented,
/* 0000 0000 0001 */ &unimplemented,
/* 0000 0000 0010 */ &rev_rd,
/* 0000 0000 0011 */ &rev_rd,
/* 0000 0000 0100 */ &unimplemented,
/* 0000 0000 0101 */ &unimplemented,
/* 0000 0000 0110 */ &unimplemented,
/* 0000 0000 0111 */ &unimplemented,
/* 0000 0000 1000 */ &unimplemented,
/* 0000 0000 1001 */ &unimplemented,
/* 0000 0000 1010 */ &unimplemented,
/* 0000 0000 1011 */ &unimplemented,
/* 0000 0000 1100 */ &unimplemented,
/* 0000 0000 1101 */ &unimplemented,
/* 0000 0000 1110 */ &unimplemented,
/* 0000 0000 1111 */ &unimplemented,

/* 0000 0001 0000 */ &emu,
/* 0000 0001 0001 */ &unimplemented,
/* 0000 0001 0010 */ &exgpc,
/* 0000 0001 0011 */ &exgpc,
/* 0000 0001 0100 */ &getpc,
/* 0000 0001 0101 */ &getpc,
/* 0000 0001 0110 */ &jump_rs,
/* 0000 0001 0111 */ &jump_rs,
/* 0000 0001 1000 */ &getst,
/* 0000 0001 1001 */ &getst,
/* 0000 0001 1010 */ &putst,
/* 0000 0001 1011 */ &putst,
/* 0000 0001 1100 */ &popst,
/* 0000 0001 1101 */ &unimplemented,
/* 0000 0001 1110 */ &pushst,
/* 0000 0001 1111 */ &unimplemented,

/* 0000 0010 0000 */ &unimplemented,
/* 0000 0010 0001 */ &unimplemented,
/* 0000 0010 0010 */ &unimplemented,
/* 0000 0010 0011 */ &unimplemented,
/* 0000 0010 0100 */ &unimplemented,
/* 0000 0010 0101 */ &unimplemented,
/* 0000 0010 0110 */ &unimplemented,
/* 0000 0010 0111 */ &unimplemented,
/* 0000 0010 1000 */ &unimplemented,
/* 0000 0010 1001 */ &unimplemented,
/* 0000 0010 1010 */ &unimplemented,
/* 0000 0010 1011 */ &unimplemented,
/* 0000 0010 1100 */ &unimplemented,
/* 0000 0010 1101 */ &unimplemented,
/* 0000 0010 1110 */ &unimplemented,
/* 0000 0010 1111 */ &unimplemented,

/* 0000 0011 0000 */ &nop,
/* 0000 0011 0001 */ &unimplemented,
/* 0000 0011 0010 */ &clrc,
/* 0000 0011 0011 */ &unimplemented,
/* 0000 0011 0100 */ &movb_saddr_daddr,
/* 0000 0011 0101 */ &unimplemented,
/* 0000 0011 0110 */ &dint,
/* 0000 0011 0111 */ &unimplemented,
/* 0000 0011 1000 */ &abs_rd,
/* 0000 0011 1001 */ &abs_rd,
/* 0000 0011 1010 */ &neg_rd,
/* 0000 0011 1011 */ &neg_rd,
/* 0000 0011 1100 */ &unimplemented,
/* 0000 0011 1101 */ &unimplemented,
/* 0000 0011 1110 */ &not_rd,
/* 0000 0011 1111 */ &not_rd,

/* 0000 0100 0000 */ &unimplemented,
/* 0000 0100 0001 */ &unimplemented,
/* 0000 0100 0010 */ &unimplemented,
/* 0000 0100 0011 */ &unimplemented,
/* 0000 0100 0100 */ &unimplemented,
/* 0000 0100 0101 */ &unimplemented,
/* 0000 0100 0110 */ &unimplemented,
/* 0000 0100 0111 */ &unimplemented,
/* 0000 0100 1000 */ &unimplemented,
/* 0000 0100 1001 */ &unimplemented,
/* 0000 0100 1010 */ &unimplemented,
/* 0000 0100 1011 */ &unimplemented,
/* 0000 0100 1100 */ &unimplemented,
/* 0000 0100 1101 */ &unimplemented,
/* 0000 0100 1110 */ &unimplemented,
/* 0000 0100 1111 */ &unimplemented,

/* 0000 0101 0000 */ &sext_rd_0,
/* 0000 0101 0001 */ &sext_rd_0,
/* 0000 0101 0010 */ &zext_rd_0,
/* 0000 0101 0011 */ &zext_rd_0,
/* 0000 0101 0100 */ &setf_0,
/* 0000 0101 0101 */ &setf_0,
/* 0000 0101 0110 */ &setf_0,
/* 0000 0101 0111 */ &setf_0,
/* 0000 0101 1000 */ &move_rs_daddr_0,
/* 0000 0101 1001 */ &move_rs_daddr_0,
/* 0000 0101 1010 */ &move_saddr_rd_0,
/* 0000 0101 1011 */ &move_saddr_rd_0,
/* 0000 0101 1100 */ &move_saddr_daddr_0,
/* 0000 0101 1101 */ &unimplemented,
/* 0000 0101 1110 */ &movb_rs_daddr,
/* 0000 0101 1111 */ &movb_rs_daddr,

/* 0000 0110 0000 */ &unimplemented,
/* 0000 0110 0001 */ &unimplemented,
/* 0000 0110 0010 */ &unimplemented,
/* 0000 0110 0011 */ &unimplemented,
/* 0000 0110 0100 */ &unimplemented,
/* 0000 0110 0101 */ &unimplemented,
/* 0000 0110 0110 */ &unimplemented,
/* 0000 0110 0111 */ &unimplemented,
/* 0000 0110 1000 */ &unimplemented,
/* 0000 0110 1001 */ &unimplemented,
/* 0000 0110 1010 */ &unimplemented,
/* 0000 0110 1011 */ &unimplemented,
/* 0000 0110 1100 */ &unimplemented,
/* 0000 0110 1101 */ &unimplemented,
/* 0000 0110 1110 */ &unimplemented,
/* 0000 0110 1111 */ &unimplemented,

/* 0000 0111 0000 */ &sext_rd_1,
/* 0000 0111 0001 */ &sext_rd_1,
/* 0000 0111 0010 */ &zext_rd_1,
/* 0000 0111 0011 */ &zext_rd_1,
/* 0000 0111 0100 */ &setf_1,
/* 0000 0111 0101 */ &setf_1,
/* 0000 0111 0110 */ &setf_1,
/* 0000 0111 0111 */ &setf_1,
/* 0000 0111 1000 */ &move_rs_daddr_1,
/* 0000 0111 1001 */ &move_rs_daddr_1,
/* 0000 0111 1010 */ &move_saddr_rd_1,
/* 0000 0111 1011 */ &move_saddr_rd_1,
/* 0000 0111 1100 */ &move_saddr_daddr_1,
/* 0000 0111 1101 */ &unimplemented,
/* 0000 0111 1110 */ &movb_addr_rd,
/* 0000 0111 1111 */ &movb_addr_rd,

/* 0000 1000 0000 */ &unimplemented,
/* 0000 1000 0001 */ &unimplemented,
/* 0000 1000 0010 */ &unimplemented,
/* 0000 1000 0011 */ &unimplemented,
/* 0000 1000 0100 */ &unimplemented,
/* 0000 1000 0101 */ &unimplemented,
/* 0000 1000 0110 */ &unimplemented,
/* 0000 1000 0111 */ &unimplemented,
/* 0000 1000 1000 */ &unimplemented,
/* 0000 1000 1001 */ &unimplemented,
/* 0000 1000 1010 */ &unimplemented,
/* 0000 1000 1011 */ &unimplemented,
/* 0000 1000 1100 */ &unimplemented,
/* 0000 1000 1101 */ &unimplemented,
/* 0000 1000 1110 */ &unimplemented,
/* 0000 1000 1111 */ &unimplemented,

/* 0000 1001 0000 */ &trap,
/* 0000 1001 0001 */ &trap,
/* 0000 1001 0010 */ &call_rs,
/* 0000 1001 0011 */ &call_rs,
/* 0000 1001 0100 */ &reti,
/* 0000 1001 0101 */ &unimplemented,
/* 0000 1001 0110 */ &rets,
/* 0000 1001 0111 */ &rets,
/* 0000 1001 1000 */ &mmtm,
/* 0000 1001 1001 */ &mmtm,
/* 0000 1001 1010 */ &mmfm,
/* 0000 1001 1011 */ &mmfm,
/* 0000 1001 1100 */ &movi_iw_rd,
/* 0000 1001 1101 */ &movi_iw_rd,
/* 0000 1001 1110 */ &movi_il_rd,
/* 0000 1001 1111 */ &movi_il_rd,

/* 0000 1010 0000 */ &unimplemented,
/* 0000 1010 0001 */ &unimplemented,
/* 0000 1010 0010 */ &unimplemented,
/* 0000 1010 0011 */ &unimplemented,
/* 0000 1010 0100 */ &unimplemented,
/* 0000 1010 0101 */ &unimplemented,
/* 0000 1010 0110 */ &unimplemented,
/* 0000 1010 0111 */ &unimplemented,
/* 0000 1010 1000 */ &unimplemented,
/* 0000 1010 1001 */ &unimplemented,
/* 0000 1010 1010 */ &unimplemented,
/* 0000 1010 1011 */ &unimplemented,
/* 0000 1010 1100 */ &unimplemented,
/* 0000 1010 1101 */ &unimplemented,
/* 0000 1010 1110 */ &unimplemented,
/* 0000 1010 1111 */ &unimplemented,

/* 0000 1011 0000 */ &addi_iw_rd,
/* 0000 1011 0001 */ &addi_iw_rd,
/* 0000 1011 0010 */ &addi_il_rd,
/* 0000 1011 0011 */ &addi_il_rd,
/* 0000 1011 0100 */ &cmpi_iw_rd,
/* 0000 1011 0101 */ &cmpi_iw_rd,
/* 0000 1011 0110 */ &cmpi_il_rd,
/* 0000 1011 0111 */ &cmpi_il_rd,
/* 0000 1011 1000 */ &andi_il_rd,
/* 0000 1011 1001 */ &andi_il_rd,
/* 0000 1011 1010 */ &ori_il_rd,
/* 0000 1011 1011 */ &ori_il_rd,
/* 0000 1011 1100 */ &xori_il_rd,
/* 0000 1011 1101 */ &xori_il_rd,
/* 0000 1011 1110 */ &subi_iw_rd,
/* 0000 1011 1111 */ &subi_iw_rd,

/* 0000 1100 0000 */ &unimplemented,
/* 0000 1100 0001 */ &unimplemented,
/* 0000 1100 0010 */ &unimplemented,
/* 0000 1100 0011 */ &unimplemented,
/* 0000 1100 0100 */ &unimplemented,
/* 0000 1100 0101 */ &unimplemented,
/* 0000 1100 0110 */ &unimplemented,
/* 0000 1100 0111 */ &unimplemented,
/* 0000 1100 1000 */ &unimplemented,
/* 0000 1100 1001 */ &unimplemented,
/* 0000 1100 1010 */ &unimplemented,
/* 0000 1100 1011 */ &unimplemented,
/* 0000 1100 1100 */ &unimplemented,
/* 0000 1100 1101 */ &unimplemented,
/* 0000 1100 1110 */ &unimplemented,
/* 0000 1100 1111 */ &unimplemented,

/* 0000 1101 0000 */ &subi_il_rd,
/* 0000 1101 0001 */ &subi_il_rd,
/* 0000 1101 0010 */ &unimplemented,
/* 0000 1101 0011 */ &callr,
/* 0000 1101 0100 */ &unimplemented,
/* 0000 1101 0101 */ &calla,
/* 0000 1101 0110 */ &eint,
/* 0000 1101 0111 */ &unimplemented,
/* 0000 1101 1000 */ &dsj,
/* 0000 1101 1001 */ &dsj,
/* 0000 1101 1010 */ &dsjeq,
/* 0000 1101 1011 */ &dsjeq,
/* 0000 1101 1100 */ &dsjne,
/* 0000 1101 1101 */ &dsjne,
/* 0000 1101 1110 */ &setc,
/* 0000 1101 1111 */ &unimplemented,

/* 0000 1110 0000 */ &unimplemented,
/* 0000 1110 0001 */ &unimplemented,
/* 0000 1110 0010 */ &unimplemented,
/* 0000 1110 0011 */ &unimplemented,
/* 0000 1110 0100 */ &unimplemented,
/* 0000 1110 0101 */ &unimplemented,
/* 0000 1110 0110 */ &unimplemented,
/* 0000 1110 0111 */ &unimplemented,
/* 0000 1110 1000 */ &unimplemented,
/* 0000 1110 1001 */ &unimplemented,
/* 0000 1110 1010 */ &unimplemented,
/* 0000 1110 1011 */ &unimplemented,
/* 0000 1110 1100 */ &unimplemented,
/* 0000 1110 1101 */ &unimplemented,
/* 0000 1110 1110 */ &unimplemented,
/* 0000 1110 1111 */ &unimplemented,

/* 0000 1111 0000 */ &unimplemented,
/* 0000 1111 0001 */ &unimplemented,
/* 0000 1111 0010 */ &unimplemented,
/* 0000 1111 0011 */ &unimplemented,
/* 0000 1111 0100 */ &unimplemented,
/* 0000 1111 0101 */ &unimplemented,
/* 0000 1111 0110 */ &unimplemented,
/* 0000 1111 0111 */ &unimplemented,
/* 0000 1111 1000 */ &unimplemented,
/* 0000 1111 1001 */ &unimplemented,
/* 0000 1111 1010 */ &pixblt_b_xy,
/* 0000 1111 1011 */ &unimplemented,
/* 0000 1111 1100 */ &fill_l,
/* 0000 1111 1101 */ &unimplemented,
/* 0000 1111 1110 */ &fill_xy,
/* 0000 1111 1111 */ &unimplemented,

/* 0001 0000 0000 */ &add_k_rd,
/* 0001 0000 0001 */ &add_k_rd,
/* 0001 0000 0010 */ &add_k_rd,
/* 0001 0000 0011 */ &add_k_rd,
/* 0001 0000 0100 */ &add_k_rd,
/* 0001 0000 0101 */ &add_k_rd,
/* 0001 0000 0110 */ &add_k_rd,
/* 0001 0000 0111 */ &add_k_rd,
/* 0001 0000 1000 */ &add_k_rd,
/* 0001 0000 1001 */ &add_k_rd,
/* 0001 0000 1010 */ &add_k_rd,
/* 0001 0000 1011 */ &add_k_rd,
/* 0001 0000 1100 */ &add_k_rd,
/* 0001 0000 1101 */ &add_k_rd,
/* 0001 0000 1110 */ &add_k_rd,
/* 0001 0000 1111 */ &add_k_rd,

/* 0001 0001 0000 */ &add_k_rd,
/* 0001 0001 0001 */ &add_k_rd,
/* 0001 0001 0010 */ &add_k_rd,
/* 0001 0001 0011 */ &add_k_rd,
/* 0001 0001 0100 */ &add_k_rd,
/* 0001 0001 0101 */ &add_k_rd,
/* 0001 0001 0110 */ &add_k_rd,
/* 0001 0001 0111 */ &add_k_rd,
/* 0001 0001 1000 */ &add_k_rd,
/* 0001 0001 1001 */ &add_k_rd,
/* 0001 0001 1010 */ &add_k_rd,
/* 0001 0001 1011 */ &add_k_rd,
/* 0001 0001 1100 */ &add_k_rd,
/* 0001 0001 1101 */ &add_k_rd,
/* 0001 0001 1110 */ &add_k_rd,
/* 0001 0001 1111 */ &add_k_rd,

/* 0001 0010 0000 */ &add_k_rd,
/* 0001 0010 0001 */ &add_k_rd,
/* 0001 0010 0010 */ &add_k_rd,
/* 0001 0010 0011 */ &add_k_rd,
/* 0001 0010 0100 */ &add_k_rd,
/* 0001 0010 0101 */ &add_k_rd,
/* 0001 0010 0110 */ &add_k_rd,
/* 0001 0010 0111 */ &add_k_rd,
/* 0001 0010 1000 */ &add_k_rd,
/* 0001 0010 1001 */ &add_k_rd,
/* 0001 0010 1010 */ &add_k_rd,
/* 0001 0010 1011 */ &add_k_rd,
/* 0001 0010 1100 */ &add_k_rd,
/* 0001 0010 1101 */ &add_k_rd,
/* 0001 0010 1110 */ &add_k_rd,
/* 0001 0010 1111 */ &add_k_rd,

/* 0001 0011 0000 */ &add_k_rd,
/* 0001 0011 0001 */ &add_k_rd,
/* 0001 0011 0010 */ &add_k_rd,
/* 0001 0011 0011 */ &add_k_rd,
/* 0001 0011 0100 */ &add_k_rd,
/* 0001 0011 0101 */ &add_k_rd,
/* 0001 0011 0110 */ &add_k_rd,
/* 0001 0011 0111 */ &add_k_rd,
/* 0001 0011 1000 */ &add_k_rd,
/* 0001 0011 1001 */ &add_k_rd,
/* 0001 0011 1010 */ &add_k_rd,
/* 0001 0011 1011 */ &add_k_rd,
/* 0001 0011 1100 */ &add_k_rd,
/* 0001 0011 1101 */ &add_k_rd,
/* 0001 0011 1110 */ &add_k_rd,
/* 0001 0011 1111 */ &add_k_rd,

/* 0001 0100 0000 */ &sub_k_rd,
/* 0001 0100 0001 */ &sub_k_rd,
/* 0001 0100 0010 */ &sub_k_rd,
/* 0001 0100 0011 */ &sub_k_rd,
/* 0001 0100 0100 */ &sub_k_rd,
/* 0001 0100 0101 */ &sub_k_rd,
/* 0001 0100 0110 */ &sub_k_rd,
/* 0001 0100 0111 */ &sub_k_rd,
/* 0001 0100 1000 */ &sub_k_rd,
/* 0001 0100 1001 */ &sub_k_rd,
/* 0001 0100 1010 */ &sub_k_rd,
/* 0001 0100 1011 */ &sub_k_rd,
/* 0001 0100 1100 */ &sub_k_rd,
/* 0001 0100 1101 */ &sub_k_rd,
/* 0001 0100 1110 */ &sub_k_rd,
/* 0001 0100 1111 */ &sub_k_rd,

/* 0001 0101 0000 */ &sub_k_rd,
/* 0001 0101 0001 */ &sub_k_rd,
/* 0001 0101 0010 */ &sub_k_rd,
/* 0001 0101 0011 */ &sub_k_rd,
/* 0001 0101 0100 */ &sub_k_rd,
/* 0001 0101 0101 */ &sub_k_rd,
/* 0001 0101 0110 */ &sub_k_rd,
/* 0001 0101 0111 */ &sub_k_rd,
/* 0001 0101 1000 */ &sub_k_rd,
/* 0001 0101 1001 */ &sub_k_rd,
/* 0001 0101 1010 */ &sub_k_rd,
/* 0001 0101 1011 */ &sub_k_rd,
/* 0001 0101 1100 */ &sub_k_rd,
/* 0001 0101 1101 */ &sub_k_rd,
/* 0001 0101 1110 */ &sub_k_rd,
/* 0001 0101 1111 */ &sub_k_rd,

/* 0001 0110 0000 */ &sub_k_rd,
/* 0001 0110 0001 */ &sub_k_rd,
/* 0001 0110 0010 */ &sub_k_rd,
/* 0001 0110 0011 */ &sub_k_rd,
/* 0001 0110 0100 */ &sub_k_rd,
/* 0001 0110 0101 */ &sub_k_rd,
/* 0001 0110 0110 */ &sub_k_rd,
/* 0001 0110 0111 */ &sub_k_rd,
/* 0001 0110 1000 */ &sub_k_rd,
/* 0001 0110 1001 */ &sub_k_rd,
/* 0001 0110 1010 */ &sub_k_rd,
/* 0001 0110 1011 */ &sub_k_rd,
/* 0001 0110 1100 */ &sub_k_rd,
/* 0001 0110 1101 */ &sub_k_rd,
/* 0001 0110 1110 */ &sub_k_rd,
/* 0001 0110 1111 */ &sub_k_rd,

/* 0001 0111 0000 */ &sub_k_rd,
/* 0001 0111 0001 */ &sub_k_rd,
/* 0001 0111 0010 */ &sub_k_rd,
/* 0001 0111 0011 */ &sub_k_rd,
/* 0001 0111 0100 */ &sub_k_rd,
/* 0001 0111 0101 */ &sub_k_rd,
/* 0001 0111 0110 */ &sub_k_rd,
/* 0001 0111 0111 */ &sub_k_rd,
/* 0001 0111 1000 */ &sub_k_rd,
/* 0001 0111 1001 */ &sub_k_rd,
/* 0001 0111 1010 */ &sub_k_rd,
/* 0001 0111 1011 */ &sub_k_rd,
/* 0001 0111 1100 */ &sub_k_rd,
/* 0001 0111 1101 */ &sub_k_rd,
/* 0001 0111 1110 */ &sub_k_rd,
/* 0001 0111 1111 */ &sub_k_rd,

/* 0001 1000 0000 */ &movk_k_rd,
/* 0001 1000 0001 */ &movk_k_rd,
/* 0001 1000 0010 */ &movk_k_rd,
/* 0001 1000 0011 */ &movk_k_rd,
/* 0001 1000 0100 */ &movk_k_rd,
/* 0001 1000 0101 */ &movk_k_rd,
/* 0001 1000 0110 */ &movk_k_rd,
/* 0001 1000 0111 */ &movk_k_rd,
/* 0001 1000 1000 */ &movk_k_rd,
/* 0001 1000 1001 */ &movk_k_rd,
/* 0001 1000 1010 */ &movk_k_rd,
/* 0001 1000 1011 */ &movk_k_rd,
/* 0001 1000 1100 */ &movk_k_rd,
/* 0001 1000 1101 */ &movk_k_rd,
/* 0001 1000 1110 */ &movk_k_rd,
/* 0001 1000 1111 */ &movk_k_rd,

/* 0001 1001 0000 */ &movk_k_rd,
/* 0001 1001 0001 */ &movk_k_rd,
/* 0001 1001 0010 */ &movk_k_rd,
/* 0001 1001 0011 */ &movk_k_rd,
/* 0001 1001 0100 */ &movk_k_rd,
/* 0001 1001 0101 */ &movk_k_rd,
/* 0001 1001 0110 */ &movk_k_rd,
/* 0001 1001 0111 */ &movk_k_rd,
/* 0001 1001 1000 */ &movk_k_rd,
/* 0001 1001 1001 */ &movk_k_rd,
/* 0001 1001 1010 */ &movk_k_rd,
/* 0001 1001 1011 */ &movk_k_rd,
/* 0001 1001 1100 */ &movk_k_rd,
/* 0001 1001 1101 */ &movk_k_rd,
/* 0001 1001 1110 */ &movk_k_rd,
/* 0001 1001 1111 */ &movk_k_rd,

/* 0001 1010 0000 */ &movk_k_rd,
/* 0001 1010 0001 */ &movk_k_rd,
/* 0001 1010 0010 */ &movk_k_rd,
/* 0001 1010 0011 */ &movk_k_rd,
/* 0001 1010 0100 */ &movk_k_rd,
/* 0001 1010 0101 */ &movk_k_rd,
/* 0001 1010 0110 */ &movk_k_rd,
/* 0001 1010 0111 */ &movk_k_rd,
/* 0001 1010 1000 */ &movk_k_rd,
/* 0001 1010 1001 */ &movk_k_rd,
/* 0001 1010 1010 */ &movk_k_rd,
/* 0001 1010 1011 */ &movk_k_rd,
/* 0001 1010 1100 */ &movk_k_rd,
/* 0001 1010 1101 */ &movk_k_rd,
/* 0001 1010 1110 */ &movk_k_rd,
/* 0001 1010 1111 */ &movk_k_rd,

/* 0001 1011 0000 */ &movk_k_rd,
/* 0001 1011 0001 */ &movk_k_rd,
/* 0001 1011 0010 */ &movk_k_rd,
/* 0001 1011 0011 */ &movk_k_rd,
/* 0001 1011 0100 */ &movk_k_rd,
/* 0001 1011 0101 */ &movk_k_rd,
/* 0001 1011 0110 */ &movk_k_rd,
/* 0001 1011 0111 */ &movk_k_rd,
/* 0001 1011 1000 */ &movk_k_rd,
/* 0001 1011 1001 */ &movk_k_rd,
/* 0001 1011 1010 */ &movk_k_rd,
/* 0001 1011 1011 */ &movk_k_rd,
/* 0001 1011 1100 */ &movk_k_rd,
/* 0001 1011 1101 */ &movk_k_rd,
/* 0001 1011 1110 */ &movk_k_rd,
/* 0001 1011 1111 */ &movk_k_rd,

/* 0001 1100 0000 */ &btst_k_rd,
/* 0001 1100 0001 */ &btst_k_rd,
/* 0001 1100 0010 */ &btst_k_rd,
/* 0001 1100 0011 */ &btst_k_rd,
/* 0001 1100 0100 */ &btst_k_rd,
/* 0001 1100 0101 */ &btst_k_rd,
/* 0001 1100 0110 */ &btst_k_rd,
/* 0001 1100 0111 */ &btst_k_rd,
/* 0001 1100 1000 */ &btst_k_rd,
/* 0001 1100 1001 */ &btst_k_rd,
/* 0001 1100 1010 */ &btst_k_rd,
/* 0001 1100 1011 */ &btst_k_rd,
/* 0001 1100 1100 */ &btst_k_rd,
/* 0001 1100 1101 */ &btst_k_rd,
/* 0001 1100 1110 */ &btst_k_rd,
/* 0001 1100 1111 */ &btst_k_rd,

/* 0001 1101 0000 */ &btst_k_rd,
/* 0001 1101 0001 */ &btst_k_rd,
/* 0001 1101 0010 */ &btst_k_rd,
/* 0001 1101 0011 */ &btst_k_rd,
/* 0001 1101 0100 */ &btst_k_rd,
/* 0001 1101 0101 */ &btst_k_rd,
/* 0001 1101 0110 */ &btst_k_rd,
/* 0001 1101 0111 */ &btst_k_rd,
/* 0001 1101 1000 */ &btst_k_rd,
/* 0001 1101 1001 */ &btst_k_rd,
/* 0001 1101 1010 */ &btst_k_rd,
/* 0001 1101 1011 */ &btst_k_rd,
/* 0001 1101 1100 */ &btst_k_rd,
/* 0001 1101 1101 */ &btst_k_rd,
/* 0001 1101 1110 */ &btst_k_rd,
/* 0001 1101 1111 */ &btst_k_rd,

/* 0001 1110 0000 */ &btst_k_rd,
/* 0001 1110 0001 */ &btst_k_rd,
/* 0001 1110 0010 */ &btst_k_rd,
/* 0001 1110 0011 */ &btst_k_rd,
/* 0001 1110 0100 */ &btst_k_rd,
/* 0001 1110 0101 */ &btst_k_rd,
/* 0001 1110 0110 */ &btst_k_rd,
/* 0001 1110 0111 */ &btst_k_rd,
/* 0001 1110 1000 */ &btst_k_rd,
/* 0001 1110 1001 */ &btst_k_rd,
/* 0001 1110 1010 */ &btst_k_rd,
/* 0001 1110 1011 */ &btst_k_rd,
/* 0001 1110 1100 */ &btst_k_rd,
/* 0001 1110 1101 */ &btst_k_rd,
/* 0001 1110 1110 */ &btst_k_rd,
/* 0001 1110 1111 */ &btst_k_rd,

/* 0001 1111 0000 */ &btst_k_rd,
/* 0001 1111 0001 */ &btst_k_rd,
/* 0001 1111 0010 */ &btst_k_rd,
/* 0001 1111 0011 */ &btst_k_rd,
/* 0001 1111 0100 */ &btst_k_rd,
/* 0001 1111 0101 */ &btst_k_rd,
/* 0001 1111 0110 */ &btst_k_rd,
/* 0001 1111 0111 */ &btst_k_rd,
/* 0001 1111 1000 */ &btst_k_rd,
/* 0001 1111 1001 */ &btst_k_rd,
/* 0001 1111 1010 */ &btst_k_rd,
/* 0001 1111 1011 */ &btst_k_rd,
/* 0001 1111 1100 */ &btst_k_rd,
/* 0001 1111 1101 */ &btst_k_rd,
/* 0001 1111 1110 */ &btst_k_rd,
/* 0001 1111 1111 */ &btst_k_rd,

/* 0010 0000 0000 */ &sla_k_rd,
/* 0010 0000 0001 */ &sla_k_rd,
/* 0010 0000 0010 */ &sla_k_rd,
/* 0010 0000 0011 */ &sla_k_rd,
/* 0010 0000 0100 */ &sla_k_rd,
/* 0010 0000 0101 */ &sla_k_rd,
/* 0010 0000 0110 */ &sla_k_rd,
/* 0010 0000 0111 */ &sla_k_rd,
/* 0010 0000 1000 */ &sla_k_rd,
/* 0010 0000 1001 */ &sla_k_rd,
/* 0010 0000 1010 */ &sla_k_rd,
/* 0010 0000 1011 */ &sla_k_rd,
/* 0010 0000 1100 */ &sla_k_rd,
/* 0010 0000 1101 */ &sla_k_rd,
/* 0010 0000 1110 */ &sla_k_rd,
/* 0010 0000 1111 */ &sla_k_rd,

/* 0010 0001 0000 */ &sla_k_rd,
/* 0010 0001 0001 */ &sla_k_rd,
/* 0010 0001 0010 */ &sla_k_rd,
/* 0010 0001 0011 */ &sla_k_rd,
/* 0010 0001 0100 */ &sla_k_rd,
/* 0010 0001 0101 */ &sla_k_rd,
/* 0010 0001 0110 */ &sla_k_rd,
/* 0010 0001 0111 */ &sla_k_rd,
/* 0010 0001 1000 */ &sla_k_rd,
/* 0010 0001 1001 */ &sla_k_rd,
/* 0010 0001 1010 */ &sla_k_rd,
/* 0010 0001 1011 */ &sla_k_rd,
/* 0010 0001 1100 */ &sla_k_rd,
/* 0010 0001 1101 */ &sla_k_rd,
/* 0010 0001 1110 */ &sla_k_rd,
/* 0010 0001 1111 */ &sla_k_rd,

/* 0010 0010 0000 */ &sla_k_rd,
/* 0010 0010 0001 */ &sla_k_rd,
/* 0010 0010 0010 */ &sla_k_rd,
/* 0010 0010 0011 */ &sla_k_rd,
/* 0010 0010 0100 */ &sla_k_rd,
/* 0010 0010 0101 */ &sla_k_rd,
/* 0010 0010 0110 */ &sla_k_rd,
/* 0010 0010 0111 */ &sla_k_rd,
/* 0010 0010 1000 */ &sla_k_rd,
/* 0010 0010 1001 */ &sla_k_rd,
/* 0010 0010 1010 */ &sla_k_rd,
/* 0010 0010 1011 */ &sla_k_rd,
/* 0010 0010 1100 */ &sla_k_rd,
/* 0010 0010 1101 */ &sla_k_rd,
/* 0010 0010 1110 */ &sla_k_rd,
/* 0010 0010 1111 */ &sla_k_rd,

/* 0010 0011 0000 */ &sla_k_rd,
/* 0010 0011 0001 */ &sla_k_rd,
/* 0010 0011 0010 */ &sla_k_rd,
/* 0010 0011 0011 */ &sla_k_rd,
/* 0010 0011 0100 */ &sla_k_rd,
/* 0010 0011 0101 */ &sla_k_rd,
/* 0010 0011 0110 */ &sla_k_rd,
/* 0010 0011 0111 */ &sla_k_rd,
/* 0010 0011 1000 */ &sla_k_rd,
/* 0010 0011 1001 */ &sla_k_rd,
/* 0010 0011 1010 */ &sla_k_rd,
/* 0010 0011 1011 */ &sla_k_rd,
/* 0010 0011 1100 */ &sla_k_rd,
/* 0010 0011 1101 */ &sla_k_rd,
/* 0010 0011 1110 */ &sla_k_rd,
/* 0010 0011 1111 */ &sla_k_rd,

/* 0010 0100 0000 */ &sll_k_rd,
/* 0010 0100 0001 */ &sll_k_rd,
/* 0010 0100 0010 */ &sll_k_rd,
/* 0010 0100 0011 */ &sll_k_rd,
/* 0010 0100 0100 */ &sll_k_rd,
/* 0010 0100 0101 */ &sll_k_rd,
/* 0010 0100 0110 */ &sll_k_rd,
/* 0010 0100 0111 */ &sll_k_rd,
/* 0010 0100 1000 */ &sll_k_rd,
/* 0010 0100 1001 */ &sll_k_rd,
/* 0010 0100 1010 */ &sll_k_rd,
/* 0010 0100 1011 */ &sll_k_rd,
/* 0010 0100 1100 */ &sll_k_rd,
/* 0010 0100 1101 */ &sll_k_rd,
/* 0010 0100 1110 */ &sll_k_rd,
/* 0010 0100 1111 */ &sll_k_rd,

/* 0010 0101 0000 */ &sll_k_rd,
/* 0010 0101 0001 */ &sll_k_rd,
/* 0010 0101 0010 */ &sll_k_rd,
/* 0010 0101 0011 */ &sll_k_rd,
/* 0010 0101 0100 */ &sll_k_rd,
/* 0010 0101 0101 */ &sll_k_rd,
/* 0010 0101 0110 */ &sll_k_rd,
/* 0010 0101 0111 */ &sll_k_rd,
/* 0010 0101 1000 */ &sll_k_rd,
/* 0010 0101 1001 */ &sll_k_rd,
/* 0010 0101 1010 */ &sll_k_rd,
/* 0010 0101 1011 */ &sll_k_rd,
/* 0010 0101 1100 */ &sll_k_rd,
/* 0010 0101 1101 */ &sll_k_rd,
/* 0010 0101 1110 */ &sll_k_rd,
/* 0010 0101 1111 */ &sll_k_rd,

/* 0010 0110 0000 */ &sll_k_rd,
/* 0010 0110 0001 */ &sll_k_rd,
/* 0010 0110 0010 */ &sll_k_rd,
/* 0010 0110 0011 */ &sll_k_rd,
/* 0010 0110 0100 */ &sll_k_rd,
/* 0010 0110 0101 */ &sll_k_rd,
/* 0010 0110 0110 */ &sll_k_rd,
/* 0010 0110 0111 */ &sll_k_rd,
/* 0010 0110 1000 */ &sll_k_rd,
/* 0010 0110 1001 */ &sll_k_rd,
/* 0010 0110 1010 */ &sll_k_rd,
/* 0010 0110 1011 */ &sll_k_rd,
/* 0010 0110 1100 */ &sll_k_rd,
/* 0010 0110 1101 */ &sll_k_rd,
/* 0010 0110 1110 */ &sll_k_rd,
/* 0010 0110 1111 */ &sll_k_rd,

/* 0010 0111 0000 */ &sll_k_rd,
/* 0010 0111 0001 */ &sll_k_rd,
/* 0010 0111 0010 */ &sll_k_rd,
/* 0010 0111 0011 */ &sll_k_rd,
/* 0010 0111 0100 */ &sll_k_rd,
/* 0010 0111 0101 */ &sll_k_rd,
/* 0010 0111 0110 */ &sll_k_rd,
/* 0010 0111 0111 */ &sll_k_rd,
/* 0010 0111 1000 */ &sll_k_rd,
/* 0010 0111 1001 */ &sll_k_rd,
/* 0010 0111 1010 */ &sll_k_rd,
/* 0010 0111 1011 */ &sll_k_rd,
/* 0010 0111 1100 */ &sll_k_rd,
/* 0010 0111 1101 */ &sll_k_rd,
/* 0010 0111 1110 */ &sll_k_rd,
/* 0010 0111 1111 */ &sll_k_rd,

/* 0010 1000 0000 */ &sra_k_rd,
/* 0010 1000 0001 */ &sra_k_rd,
/* 0010 1000 0010 */ &sra_k_rd,
/* 0010 1000 0011 */ &sra_k_rd,
/* 0010 1000 0100 */ &sra_k_rd,
/* 0010 1000 0101 */ &sra_k_rd,
/* 0010 1000 0110 */ &sra_k_rd,
/* 0010 1000 0111 */ &sra_k_rd,
/* 0010 1000 1000 */ &sra_k_rd,
/* 0010 1000 1001 */ &sra_k_rd,
/* 0010 1000 1010 */ &sra_k_rd,
/* 0010 1000 1011 */ &sra_k_rd,
/* 0010 1000 1100 */ &sra_k_rd,
/* 0010 1000 1101 */ &sra_k_rd,
/* 0010 1000 1110 */ &sra_k_rd,
/* 0010 1000 1111 */ &sra_k_rd,

/* 0010 1001 0000 */ &sra_k_rd,
/* 0010 1001 0001 */ &sra_k_rd,
/* 0010 1001 0010 */ &sra_k_rd,
/* 0010 1001 0011 */ &sra_k_rd,
/* 0010 1001 0100 */ &sra_k_rd,
/* 0010 1001 0101 */ &sra_k_rd,
/* 0010 1001 0110 */ &sra_k_rd,
/* 0010 1001 0111 */ &sra_k_rd,
/* 0010 1001 1000 */ &sra_k_rd,
/* 0010 1001 1001 */ &sra_k_rd,
/* 0010 1001 1010 */ &sra_k_rd,
/* 0010 1001 1011 */ &sra_k_rd,
/* 0010 1001 1100 */ &sra_k_rd,
/* 0010 1001 1101 */ &sra_k_rd,
/* 0010 1001 1110 */ &sra_k_rd,
/* 0010 1001 1111 */ &sra_k_rd,

/* 0010 1010 0000 */ &sra_k_rd,
/* 0010 1010 0001 */ &sra_k_rd,
/* 0010 1010 0010 */ &sra_k_rd,
/* 0010 1010 0011 */ &sra_k_rd,
/* 0010 1010 0100 */ &sra_k_rd,
/* 0010 1010 0101 */ &sra_k_rd,
/* 0010 1010 0110 */ &sra_k_rd,
/* 0010 1010 0111 */ &sra_k_rd,
/* 0010 1010 1000 */ &sra_k_rd,
/* 0010 1010 1001 */ &sra_k_rd,
/* 0010 1010 1010 */ &sra_k_rd,
/* 0010 1010 1011 */ &sra_k_rd,
/* 0010 1010 1100 */ &sra_k_rd,
/* 0010 1010 1101 */ &sra_k_rd,
/* 0010 1010 1110 */ &sra_k_rd,
/* 0010 1010 1111 */ &sra_k_rd,

/* 0010 1011 0000 */ &sra_k_rd,
/* 0010 1011 0001 */ &sra_k_rd,
/* 0010 1011 0010 */ &sra_k_rd,
/* 0010 1011 0011 */ &sra_k_rd,
/* 0010 1011 0100 */ &sra_k_rd,
/* 0010 1011 0101 */ &sra_k_rd,
/* 0010 1011 0110 */ &sra_k_rd,
/* 0010 1011 0111 */ &sra_k_rd,
/* 0010 1011 1000 */ &sra_k_rd,
/* 0010 1011 1001 */ &sra_k_rd,
/* 0010 1011 1010 */ &sra_k_rd,
/* 0010 1011 1011 */ &sra_k_rd,
/* 0010 1011 1100 */ &sra_k_rd,
/* 0010 1011 1101 */ &sra_k_rd,
/* 0010 1011 1110 */ &sra_k_rd,
/* 0010 1011 1111 */ &sra_k_rd,

/* 0010 1100 0000 */ &srl_k_rd,
/* 0010 1100 0001 */ &srl_k_rd,
/* 0010 1100 0010 */ &srl_k_rd,
/* 0010 1100 0011 */ &srl_k_rd,
/* 0010 1100 0100 */ &srl_k_rd,
/* 0010 1100 0101 */ &srl_k_rd,
/* 0010 1100 0110 */ &srl_k_rd,
/* 0010 1100 0111 */ &srl_k_rd,
/* 0010 1100 1000 */ &srl_k_rd,
/* 0010 1100 1001 */ &srl_k_rd,
/* 0010 1100 1010 */ &srl_k_rd,
/* 0010 1100 1011 */ &srl_k_rd,
/* 0010 1100 1100 */ &srl_k_rd,
/* 0010 1100 1101 */ &srl_k_rd,
/* 0010 1100 1110 */ &srl_k_rd,
/* 0010 1100 1111 */ &srl_k_rd,

/* 0010 1101 0000 */ &srl_k_rd,
/* 0010 1101 0001 */ &srl_k_rd,
/* 0010 1101 0010 */ &srl_k_rd,
/* 0010 1101 0011 */ &srl_k_rd,
/* 0010 1101 0100 */ &srl_k_rd,
/* 0010 1101 0101 */ &srl_k_rd,
/* 0010 1101 0110 */ &srl_k_rd,
/* 0010 1101 0111 */ &srl_k_rd,
/* 0010 1101 1000 */ &srl_k_rd,
/* 0010 1101 1001 */ &srl_k_rd,
/* 0010 1101 1010 */ &srl_k_rd,
/* 0010 1101 1011 */ &srl_k_rd,
/* 0010 1101 1100 */ &srl_k_rd,
/* 0010 1101 1101 */ &srl_k_rd,
/* 0010 1101 1110 */ &srl_k_rd,
/* 0010 1101 1111 */ &srl_k_rd,

/* 0010 1110 0000 */ &srl_k_rd,
/* 0010 1110 0001 */ &srl_k_rd,
/* 0010 1110 0010 */ &srl_k_rd,
/* 0010 1110 0011 */ &srl_k_rd,
/* 0010 1110 0100 */ &srl_k_rd,
/* 0010 1110 0101 */ &srl_k_rd,
/* 0010 1110 0110 */ &srl_k_rd,
/* 0010 1110 0111 */ &srl_k_rd,
/* 0010 1110 1000 */ &srl_k_rd,
/* 0010 1110 1001 */ &srl_k_rd,
/* 0010 1110 1010 */ &srl_k_rd,
/* 0010 1110 1011 */ &srl_k_rd,
/* 0010 1110 1100 */ &srl_k_rd,
/* 0010 1110 1101 */ &srl_k_rd,
/* 0010 1110 1110 */ &srl_k_rd,
/* 0010 1110 1111 */ &srl_k_rd,

/* 0010 1111 0000 */ &srl_k_rd,
/* 0010 1111 0001 */ &srl_k_rd,
/* 0010 1111 0010 */ &srl_k_rd,
/* 0010 1111 0011 */ &srl_k_rd,
/* 0010 1111 0100 */ &srl_k_rd,
/* 0010 1111 0101 */ &srl_k_rd,
/* 0010 1111 0110 */ &srl_k_rd,
/* 0010 1111 0111 */ &srl_k_rd,
/* 0010 1111 1000 */ &srl_k_rd,
/* 0010 1111 1001 */ &srl_k_rd,
/* 0010 1111 1010 */ &srl_k_rd,
/* 0010 1111 1011 */ &srl_k_rd,
/* 0010 1111 1100 */ &srl_k_rd,
/* 0010 1111 1101 */ &srl_k_rd,
/* 0010 1111 1110 */ &srl_k_rd,
/* 0010 1111 1111 */ &srl_k_rd,

/* 0011 0000 0000 */ &rl_k_rd,
/* 0011 0000 0001 */ &rl_k_rd,
/* 0011 0000 0010 */ &rl_k_rd,
/* 0011 0000 0011 */ &rl_k_rd,
/* 0011 0000 0100 */ &rl_k_rd,
/* 0011 0000 0101 */ &rl_k_rd,
/* 0011 0000 0110 */ &rl_k_rd,
/* 0011 0000 0111 */ &rl_k_rd,
/* 0011 0000 1000 */ &rl_k_rd,
/* 0011 0000 1001 */ &rl_k_rd,
/* 0011 0000 1010 */ &rl_k_rd,
/* 0011 0000 1011 */ &rl_k_rd,
/* 0011 0000 1100 */ &rl_k_rd,
/* 0011 0000 1101 */ &rl_k_rd,
/* 0011 0000 1110 */ &rl_k_rd,
/* 0011 0000 1111 */ &rl_k_rd,

/* 0011 0001 0000 */ &rl_k_rd,
/* 0011 0001 0001 */ &rl_k_rd,
/* 0011 0001 0010 */ &rl_k_rd,
/* 0011 0001 0011 */ &rl_k_rd,
/* 0011 0001 0100 */ &rl_k_rd,
/* 0011 0001 0101 */ &rl_k_rd,
/* 0011 0001 0110 */ &rl_k_rd,
/* 0011 0001 0111 */ &rl_k_rd,
/* 0011 0001 1000 */ &rl_k_rd,
/* 0011 0001 1001 */ &rl_k_rd,
/* 0011 0001 1010 */ &rl_k_rd,
/* 0011 0001 1011 */ &rl_k_rd,
/* 0011 0001 1100 */ &rl_k_rd,
/* 0011 0001 1101 */ &rl_k_rd,
/* 0011 0001 1110 */ &rl_k_rd,
/* 0011 0001 1111 */ &rl_k_rd,

/* 0011 0010 0000 */ &rl_k_rd,
/* 0011 0010 0001 */ &rl_k_rd,
/* 0011 0010 0010 */ &rl_k_rd,
/* 0011 0010 0011 */ &rl_k_rd,
/* 0011 0010 0100 */ &rl_k_rd,
/* 0011 0010 0101 */ &rl_k_rd,
/* 0011 0010 0110 */ &rl_k_rd,
/* 0011 0010 0111 */ &rl_k_rd,
/* 0011 0010 1000 */ &rl_k_rd,
/* 0011 0010 1001 */ &rl_k_rd,
/* 0011 0010 1010 */ &rl_k_rd,
/* 0011 0010 1011 */ &rl_k_rd,
/* 0011 0010 1100 */ &rl_k_rd,
/* 0011 0010 1101 */ &rl_k_rd,
/* 0011 0010 1110 */ &rl_k_rd,
/* 0011 0010 1111 */ &rl_k_rd,

/* 0011 0011 0000 */ &rl_k_rd,
/* 0011 0011 0001 */ &rl_k_rd,
/* 0011 0011 0010 */ &rl_k_rd,
/* 0011 0011 0011 */ &rl_k_rd,
/* 0011 0011 0100 */ &rl_k_rd,
/* 0011 0011 0101 */ &rl_k_rd,
/* 0011 0011 0110 */ &rl_k_rd,
/* 0011 0011 0111 */ &rl_k_rd,
/* 0011 0011 1000 */ &rl_k_rd,
/* 0011 0011 1001 */ &rl_k_rd,
/* 0011 0011 1010 */ &rl_k_rd,
/* 0011 0011 1011 */ &rl_k_rd,
/* 0011 0011 1100 */ &rl_k_rd,
/* 0011 0011 1101 */ &rl_k_rd,
/* 0011 0011 1110 */ &rl_k_rd,
/* 0011 0011 1111 */ &rl_k_rd,

/* 0011 0100 0000 */ &unimplemented,
/* 0011 0100 0001 */ &unimplemented,
/* 0011 0100 0010 */ &unimplemented,
/* 0011 0100 0011 */ &unimplemented,
/* 0011 0100 0100 */ &unimplemented,
/* 0011 0100 0101 */ &unimplemented,
/* 0011 0100 0110 */ &unimplemented,
/* 0011 0100 0111 */ &unimplemented,
/* 0011 0100 1000 */ &unimplemented,
/* 0011 0100 1001 */ &unimplemented,
/* 0011 0100 1010 */ &unimplemented,
/* 0011 0100 1011 */ &unimplemented,
/* 0011 0100 1100 */ &unimplemented,
/* 0011 0100 1101 */ &unimplemented,
/* 0011 0100 1110 */ &unimplemented,
/* 0011 0100 1111 */ &unimplemented,

/* 0011 0101 0000 */ &unimplemented,
/* 0011 0101 0001 */ &unimplemented,
/* 0011 0101 0010 */ &unimplemented,
/* 0011 0101 0011 */ &unimplemented,
/* 0011 0101 0100 */ &unimplemented,
/* 0011 0101 0101 */ &unimplemented,
/* 0011 0101 0110 */ &unimplemented,
/* 0011 0101 0111 */ &unimplemented,
/* 0011 0101 1000 */ &unimplemented,
/* 0011 0101 1001 */ &unimplemented,
/* 0011 0101 1010 */ &unimplemented,
/* 0011 0101 1011 */ &unimplemented,
/* 0011 0101 1100 */ &unimplemented,
/* 0011 0101 1101 */ &unimplemented,
/* 0011 0101 1110 */ &unimplemented,
/* 0011 0101 1111 */ &unimplemented,

/* 0011 0110 0000 */ &unimplemented,
/* 0011 0110 0001 */ &unimplemented,
/* 0011 0110 0010 */ &unimplemented,
/* 0011 0110 0011 */ &unimplemented,
/* 0011 0110 0100 */ &unimplemented,
/* 0011 0110 0101 */ &unimplemented,
/* 0011 0110 0110 */ &unimplemented,
/* 0011 0110 0111 */ &unimplemented,
/* 0011 0110 1000 */ &unimplemented,
/* 0011 0110 1001 */ &unimplemented,
/* 0011 0110 1010 */ &unimplemented,
/* 0011 0110 1011 */ &unimplemented,
/* 0011 0110 1100 */ &unimplemented,
/* 0011 0110 1101 */ &unimplemented,
/* 0011 0110 1110 */ &unimplemented,
/* 0011 0110 1111 */ &unimplemented,

/* 0011 0111 0000 */ &unimplemented,
/* 0011 0111 0001 */ &unimplemented,
/* 0011 0111 0010 */ &unimplemented,
/* 0011 0111 0011 */ &unimplemented,
/* 0011 0111 0100 */ &unimplemented,
/* 0011 0111 0101 */ &unimplemented,
/* 0011 0111 0110 */ &unimplemented,
/* 0011 0111 0111 */ &unimplemented,
/* 0011 0111 1000 */ &unimplemented,
/* 0011 0111 1001 */ &unimplemented,
/* 0011 0111 1010 */ &unimplemented,
/* 0011 0111 1011 */ &unimplemented,
/* 0011 0111 1100 */ &unimplemented,
/* 0011 0111 1101 */ &unimplemented,
/* 0011 0111 1110 */ &unimplemented,
/* 0011 0111 1111 */ &unimplemented,

/* 0011 1000 0000 */ &dsjs,
/* 0011 1000 0001 */ &dsjs,
/* 0011 1000 0010 */ &dsjs,
/* 0011 1000 0011 */ &dsjs,
/* 0011 1000 0100 */ &dsjs,
/* 0011 1000 0101 */ &dsjs,
/* 0011 1000 0110 */ &dsjs,
/* 0011 1000 0111 */ &dsjs,
/* 0011 1000 1000 */ &dsjs,
/* 0011 1000 1001 */ &dsjs,
/* 0011 1000 1010 */ &dsjs,
/* 0011 1000 1011 */ &dsjs,
/* 0011 1000 1100 */ &dsjs,
/* 0011 1000 1101 */ &dsjs,
/* 0011 1000 1110 */ &dsjs,
/* 0011 1000 1111 */ &dsjs,

/* 0011 1001 0000 */ &dsjs,
/* 0011 1001 0001 */ &dsjs,
/* 0011 1001 0010 */ &dsjs,
/* 0011 1001 0011 */ &dsjs,
/* 0011 1001 0100 */ &dsjs,
/* 0011 1001 0101 */ &dsjs,
/* 0011 1001 0110 */ &dsjs,
/* 0011 1001 0111 */ &dsjs,
/* 0011 1001 1000 */ &dsjs,
/* 0011 1001 1001 */ &dsjs,
/* 0011 1001 1010 */ &dsjs,
/* 0011 1001 1011 */ &dsjs,
/* 0011 1001 1100 */ &dsjs,
/* 0011 1001 1101 */ &dsjs,
/* 0011 1001 1110 */ &dsjs,
/* 0011 1001 1111 */ &dsjs,

/* 0011 1010 0000 */ &dsjs,
/* 0011 1010 0001 */ &dsjs,
/* 0011 1010 0010 */ &dsjs,
/* 0011 1010 0011 */ &dsjs,
/* 0011 1010 0100 */ &dsjs,
/* 0011 1010 0101 */ &dsjs,
/* 0011 1010 0110 */ &dsjs,
/* 0011 1010 0111 */ &dsjs,
/* 0011 1010 1000 */ &dsjs,
/* 0011 1010 1001 */ &dsjs,
/* 0011 1010 1010 */ &dsjs,
/* 0011 1010 1011 */ &dsjs,
/* 0011 1010 1100 */ &dsjs,
/* 0011 1010 1101 */ &dsjs,
/* 0011 1010 1110 */ &dsjs,
/* 0011 1010 1111 */ &dsjs,

/* 0011 1011 0000 */ &dsjs,
/* 0011 1011 0001 */ &dsjs,
/* 0011 1011 0010 */ &dsjs,
/* 0011 1011 0011 */ &dsjs,
/* 0011 1011 0100 */ &dsjs,
/* 0011 1011 0101 */ &dsjs,
/* 0011 1011 0110 */ &dsjs,
/* 0011 1011 0111 */ &dsjs,
/* 0011 1011 1000 */ &dsjs,
/* 0011 1011 1001 */ &dsjs,
/* 0011 1011 1010 */ &dsjs,
/* 0011 1011 1011 */ &dsjs,
/* 0011 1011 1100 */ &dsjs,
/* 0011 1011 1101 */ &dsjs,
/* 0011 1011 1110 */ &dsjs,
/* 0011 1011 1111 */ &dsjs,

/* 0011 1100 0000 */ &dsjs,
/* 0011 1100 0001 */ &dsjs,
/* 0011 1100 0010 */ &dsjs,
/* 0011 1100 0011 */ &dsjs,
/* 0011 1100 0100 */ &dsjs,
/* 0011 1100 0101 */ &dsjs,
/* 0011 1100 0110 */ &dsjs,
/* 0011 1100 0111 */ &dsjs,
/* 0011 1100 1000 */ &dsjs,
/* 0011 1100 1001 */ &dsjs,
/* 0011 1100 1010 */ &dsjs,
/* 0011 1100 1011 */ &dsjs,
/* 0011 1100 1100 */ &dsjs,
/* 0011 1100 1101 */ &dsjs,
/* 0011 1100 1110 */ &dsjs,
/* 0011 1100 1111 */ &dsjs,

/* 0011 1101 0000 */ &dsjs,
/* 0011 1101 0001 */ &dsjs,
/* 0011 1101 0010 */ &dsjs,
/* 0011 1101 0011 */ &dsjs,
/* 0011 1101 0100 */ &dsjs,
/* 0011 1101 0101 */ &dsjs,
/* 0011 1101 0110 */ &dsjs,
/* 0011 1101 0111 */ &dsjs,
/* 0011 1101 1000 */ &dsjs,
/* 0011 1101 1001 */ &dsjs,
/* 0011 1101 1010 */ &dsjs,
/* 0011 1101 1011 */ &dsjs,
/* 0011 1101 1100 */ &dsjs,
/* 0011 1101 1101 */ &dsjs,
/* 0011 1101 1110 */ &dsjs,
/* 0011 1101 1111 */ &dsjs,

/* 0011 1110 0000 */ &dsjs,
/* 0011 1110 0001 */ &dsjs,
/* 0011 1110 0010 */ &dsjs,
/* 0011 1110 0011 */ &dsjs,
/* 0011 1110 0100 */ &dsjs,
/* 0011 1110 0101 */ &dsjs,
/* 0011 1110 0110 */ &dsjs,
/* 0011 1110 0111 */ &dsjs,
/* 0011 1110 1000 */ &dsjs,
/* 0011 1110 1001 */ &dsjs,
/* 0011 1110 1010 */ &dsjs,
/* 0011 1110 1011 */ &dsjs,
/* 0011 1110 1100 */ &dsjs,
/* 0011 1110 1101 */ &dsjs,
/* 0011 1110 1110 */ &dsjs,
/* 0011 1110 1111 */ &dsjs,

/* 0011 1111 0000 */ &dsjs,
/* 0011 1111 0001 */ &dsjs,
/* 0011 1111 0010 */ &dsjs,
/* 0011 1111 0011 */ &dsjs,
/* 0011 1111 0100 */ &dsjs,
/* 0011 1111 0101 */ &dsjs,
/* 0011 1111 0110 */ &dsjs,
/* 0011 1111 0111 */ &dsjs,
/* 0011 1111 1000 */ &dsjs,
/* 0011 1111 1001 */ &dsjs,
/* 0011 1111 1010 */ &dsjs,
/* 0011 1111 1011 */ &dsjs,
/* 0011 1111 1100 */ &dsjs,
/* 0011 1111 1101 */ &dsjs,
/* 0011 1111 1110 */ &dsjs,
/* 0011 1111 1111 */ &dsjs,

/* 0100 0000 0000 */ &add_rs_rd,
/* 0100 0000 0001 */ &add_rs_rd,
/* 0100 0000 0010 */ &add_rs_rd,
/* 0100 0000 0011 */ &add_rs_rd,
/* 0100 0000 0100 */ &add_rs_rd,
/* 0100 0000 0101 */ &add_rs_rd,
/* 0100 0000 0110 */ &add_rs_rd,
/* 0100 0000 0111 */ &add_rs_rd,
/* 0100 0000 1000 */ &add_rs_rd,
/* 0100 0000 1001 */ &add_rs_rd,
/* 0100 0000 1010 */ &add_rs_rd,
/* 0100 0000 1011 */ &add_rs_rd,
/* 0100 0000 1100 */ &add_rs_rd,
/* 0100 0000 1101 */ &add_rs_rd,
/* 0100 0000 1110 */ &add_rs_rd,
/* 0100 0000 1111 */ &add_rs_rd,

/* 0100 0001 0000 */ &add_rs_rd,
/* 0100 0001 0001 */ &add_rs_rd,
/* 0100 0001 0010 */ &add_rs_rd,
/* 0100 0001 0011 */ &add_rs_rd,
/* 0100 0001 0100 */ &add_rs_rd,
/* 0100 0001 0101 */ &add_rs_rd,
/* 0100 0001 0110 */ &add_rs_rd,
/* 0100 0001 0111 */ &add_rs_rd,
/* 0100 0001 1000 */ &add_rs_rd,
/* 0100 0001 1001 */ &add_rs_rd,
/* 0100 0001 1010 */ &add_rs_rd,
/* 0100 0001 1011 */ &add_rs_rd,
/* 0100 0001 1100 */ &add_rs_rd,
/* 0100 0001 1101 */ &add_rs_rd,
/* 0100 0001 1110 */ &add_rs_rd,
/* 0100 0001 1111 */ &add_rs_rd,

/* 0100 0010 0000 */ &addc_rs_rd,
/* 0100 0010 0001 */ &addc_rs_rd,
/* 0100 0010 0010 */ &addc_rs_rd,
/* 0100 0010 0011 */ &addc_rs_rd,
/* 0100 0010 0100 */ &addc_rs_rd,
/* 0100 0010 0101 */ &addc_rs_rd,
/* 0100 0010 0110 */ &addc_rs_rd,
/* 0100 0010 0111 */ &addc_rs_rd,
/* 0100 0010 1000 */ &addc_rs_rd,
/* 0100 0010 1001 */ &addc_rs_rd,
/* 0100 0010 1010 */ &addc_rs_rd,
/* 0100 0010 1011 */ &addc_rs_rd,
/* 0100 0010 1100 */ &addc_rs_rd,
/* 0100 0010 1101 */ &addc_rs_rd,
/* 0100 0010 1110 */ &addc_rs_rd,
/* 0100 0010 1111 */ &addc_rs_rd,

/* 0100 0011 0000 */ &addc_rs_rd,
/* 0100 0011 0001 */ &addc_rs_rd,
/* 0100 0011 0010 */ &addc_rs_rd,
/* 0100 0011 0011 */ &addc_rs_rd,
/* 0100 0011 0100 */ &addc_rs_rd,
/* 0100 0011 0101 */ &addc_rs_rd,
/* 0100 0011 0110 */ &addc_rs_rd,
/* 0100 0011 0111 */ &addc_rs_rd,
/* 0100 0011 1000 */ &addc_rs_rd,
/* 0100 0011 1001 */ &addc_rs_rd,
/* 0100 0011 1010 */ &addc_rs_rd,
/* 0100 0011 1011 */ &addc_rs_rd,
/* 0100 0011 1100 */ &addc_rs_rd,
/* 0100 0011 1101 */ &addc_rs_rd,
/* 0100 0011 1110 */ &addc_rs_rd,
/* 0100 0011 1111 */ &addc_rs_rd,

/* 0100 0100 0000 */ &sub_rs_rd,
/* 0100 0100 0001 */ &sub_rs_rd,
/* 0100 0100 0010 */ &sub_rs_rd,
/* 0100 0100 0011 */ &sub_rs_rd,
/* 0100 0100 0100 */ &sub_rs_rd,
/* 0100 0100 0101 */ &sub_rs_rd,
/* 0100 0100 0110 */ &sub_rs_rd,
/* 0100 0100 0111 */ &sub_rs_rd,
/* 0100 0100 1000 */ &sub_rs_rd,
/* 0100 0100 1001 */ &sub_rs_rd,
/* 0100 0100 1010 */ &sub_rs_rd,
/* 0100 0100 1011 */ &sub_rs_rd,
/* 0100 0100 1100 */ &sub_rs_rd,
/* 0100 0100 1101 */ &sub_rs_rd,
/* 0100 0100 1110 */ &sub_rs_rd,
/* 0100 0100 1111 */ &sub_rs_rd,

/* 0100 0101 0000 */ &sub_rs_rd,
/* 0100 0101 0001 */ &sub_rs_rd,
/* 0100 0101 0010 */ &sub_rs_rd,
/* 0100 0101 0011 */ &sub_rs_rd,
/* 0100 0101 0100 */ &sub_rs_rd,
/* 0100 0101 0101 */ &sub_rs_rd,
/* 0100 0101 0110 */ &sub_rs_rd,
/* 0100 0101 0111 */ &sub_rs_rd,
/* 0100 0101 1000 */ &sub_rs_rd,
/* 0100 0101 1001 */ &sub_rs_rd,
/* 0100 0101 1010 */ &sub_rs_rd,
/* 0100 0101 1011 */ &sub_rs_rd,
/* 0100 0101 1100 */ &sub_rs_rd,
/* 0100 0101 1101 */ &sub_rs_rd,
/* 0100 0101 1110 */ &sub_rs_rd,
/* 0100 0101 1111 */ &sub_rs_rd,

/* 0100 0110 0000 */ &unimplemented,
/* 0100 0110 0001 */ &unimplemented,
/* 0100 0110 0010 */ &unimplemented,
/* 0100 0110 0011 */ &unimplemented,
/* 0100 0110 0100 */ &unimplemented,
/* 0100 0110 0101 */ &unimplemented,
/* 0100 0110 0110 */ &unimplemented,
/* 0100 0110 0111 */ &unimplemented,
/* 0100 0110 1000 */ &unimplemented,
/* 0100 0110 1001 */ &unimplemented,
/* 0100 0110 1010 */ &unimplemented,
/* 0100 0110 1011 */ &unimplemented,
/* 0100 0110 1100 */ &unimplemented,
/* 0100 0110 1101 */ &unimplemented,
/* 0100 0110 1110 */ &unimplemented,
/* 0100 0110 1111 */ &unimplemented,

/* 0100 0111 0000 */ &unimplemented,
/* 0100 0111 0001 */ &unimplemented,
/* 0100 0111 0010 */ &unimplemented,
/* 0100 0111 0011 */ &unimplemented,
/* 0100 0111 0100 */ &unimplemented,
/* 0100 0111 0101 */ &unimplemented,
/* 0100 0111 0110 */ &unimplemented,
/* 0100 0111 0111 */ &unimplemented,
/* 0100 0111 1000 */ &unimplemented,
/* 0100 0111 1001 */ &unimplemented,
/* 0100 0111 1010 */ &unimplemented,
/* 0100 0111 1011 */ &unimplemented,
/* 0100 0111 1100 */ &unimplemented,
/* 0100 0111 1101 */ &unimplemented,
/* 0100 0111 1110 */ &unimplemented,
/* 0100 0111 1111 */ &unimplemented,

/* 0100 1000 0000 */ &cmp_rs_rd,
/* 0100 1000 0001 */ &cmp_rs_rd,
/* 0100 1000 0010 */ &cmp_rs_rd,
/* 0100 1000 0011 */ &cmp_rs_rd,
/* 0100 1000 0100 */ &cmp_rs_rd,
/* 0100 1000 0101 */ &cmp_rs_rd,
/* 0100 1000 0110 */ &cmp_rs_rd,
/* 0100 1000 0111 */ &cmp_rs_rd,
/* 0100 1000 1000 */ &cmp_rs_rd,
/* 0100 1000 1001 */ &cmp_rs_rd,
/* 0100 1000 1010 */ &cmp_rs_rd,
/* 0100 1000 1011 */ &cmp_rs_rd,
/* 0100 1000 1100 */ &cmp_rs_rd,
/* 0100 1000 1101 */ &cmp_rs_rd,
/* 0100 1000 1110 */ &cmp_rs_rd,
/* 0100 1000 1111 */ &cmp_rs_rd,

/* 0100 1001 0000 */ &cmp_rs_rd,
/* 0100 1001 0001 */ &cmp_rs_rd,
/* 0100 1001 0010 */ &cmp_rs_rd,
/* 0100 1001 0011 */ &cmp_rs_rd,
/* 0100 1001 0100 */ &cmp_rs_rd,
/* 0100 1001 0101 */ &cmp_rs_rd,
/* 0100 1001 0110 */ &cmp_rs_rd,
/* 0100 1001 0111 */ &cmp_rs_rd,
/* 0100 1001 1000 */ &cmp_rs_rd,
/* 0100 1001 1001 */ &cmp_rs_rd,
/* 0100 1001 1010 */ &cmp_rs_rd,
/* 0100 1001 1011 */ &cmp_rs_rd,
/* 0100 1001 1100 */ &cmp_rs_rd,
/* 0100 1001 1101 */ &cmp_rs_rd,
/* 0100 1001 1110 */ &cmp_rs_rd,
/* 0100 1001 1111 */ &cmp_rs_rd,

/* 0100 1010 0000 */ &btst_rs_rd,
/* 0100 1010 0001 */ &btst_rs_rd,
/* 0100 1010 0010 */ &btst_rs_rd,
/* 0100 1010 0011 */ &btst_rs_rd,
/* 0100 1010 0100 */ &btst_rs_rd,
/* 0100 1010 0101 */ &btst_rs_rd,
/* 0100 1010 0110 */ &btst_rs_rd,
/* 0100 1010 0111 */ &btst_rs_rd,
/* 0100 1010 1000 */ &btst_rs_rd,
/* 0100 1010 1001 */ &btst_rs_rd,
/* 0100 1010 1010 */ &btst_rs_rd,
/* 0100 1010 1011 */ &btst_rs_rd,
/* 0100 1010 1100 */ &btst_rs_rd,
/* 0100 1010 1101 */ &btst_rs_rd,
/* 0100 1010 1110 */ &btst_rs_rd,
/* 0100 1010 1111 */ &btst_rs_rd,

/* 0100 1011 0000 */ &btst_rs_rd,
/* 0100 1011 0001 */ &btst_rs_rd,
/* 0100 1011 0010 */ &btst_rs_rd,
/* 0100 1011 0011 */ &btst_rs_rd,
/* 0100 1011 0100 */ &btst_rs_rd,
/* 0100 1011 0101 */ &btst_rs_rd,
/* 0100 1011 0110 */ &btst_rs_rd,
/* 0100 1011 0111 */ &btst_rs_rd,
/* 0100 1011 1000 */ &btst_rs_rd,
/* 0100 1011 1001 */ &btst_rs_rd,
/* 0100 1011 1010 */ &btst_rs_rd,
/* 0100 1011 1011 */ &btst_rs_rd,
/* 0100 1011 1100 */ &btst_rs_rd,
/* 0100 1011 1101 */ &btst_rs_rd,
/* 0100 1011 1110 */ &btst_rs_rd,
/* 0100 1011 1111 */ &btst_rs_rd,

/* 0100 1100 0000 */ &move_rs_rd,
/* 0100 1100 0001 */ &move_rs_rd,
/* 0100 1100 0010 */ &move_rs_rd,
/* 0100 1100 0011 */ &move_rs_rd,
/* 0100 1100 0100 */ &move_rs_rd,
/* 0100 1100 0101 */ &move_rs_rd,
/* 0100 1100 0110 */ &move_rs_rd,
/* 0100 1100 0111 */ &move_rs_rd,
/* 0100 1100 1000 */ &move_rs_rd,
/* 0100 1100 1001 */ &move_rs_rd,
/* 0100 1100 1010 */ &move_rs_rd,
/* 0100 1100 1011 */ &move_rs_rd,
/* 0100 1100 1100 */ &move_rs_rd,
/* 0100 1100 1101 */ &move_rs_rd,
/* 0100 1100 1110 */ &move_rs_rd,
/* 0100 1100 1111 */ &move_rs_rd,

/* 0100 1101 0000 */ &move_rs_rd,
/* 0100 1101 0001 */ &move_rs_rd,
/* 0100 1101 0010 */ &move_rs_rd,
/* 0100 1101 0011 */ &move_rs_rd,
/* 0100 1101 0100 */ &move_rs_rd,
/* 0100 1101 0101 */ &move_rs_rd,
/* 0100 1101 0110 */ &move_rs_rd,
/* 0100 1101 0111 */ &move_rs_rd,
/* 0100 1101 1000 */ &move_rs_rd,
/* 0100 1101 1001 */ &move_rs_rd,
/* 0100 1101 1010 */ &move_rs_rd,
/* 0100 1101 1011 */ &move_rs_rd,
/* 0100 1101 1100 */ &move_rs_rd,
/* 0100 1101 1101 */ &move_rs_rd,
/* 0100 1101 1110 */ &move_rs_rd,
/* 0100 1101 1111 */ &move_rs_rd,

/* 0100 1110 0000 */ &move_rs_rd_a,
/* 0100 1110 0001 */ &move_rs_rd_b,
/* 0100 1110 0010 */ &move_rs_rd_a,
/* 0100 1110 0011 */ &move_rs_rd_b,
/* 0100 1110 0100 */ &move_rs_rd_a,
/* 0100 1110 0101 */ &move_rs_rd_b,
/* 0100 1110 0110 */ &move_rs_rd_a,
/* 0100 1110 0111 */ &move_rs_rd_b,
/* 0100 1110 1000 */ &move_rs_rd_a,
/* 0100 1110 1001 */ &move_rs_rd_b,
/* 0100 1110 1010 */ &move_rs_rd_a,
/* 0100 1110 1011 */ &move_rs_rd_b,
/* 0100 1110 1100 */ &move_rs_rd_a,
/* 0100 1110 1101 */ &move_rs_rd_b,
/* 0100 1110 1110 */ &move_rs_rd_a,
/* 0100 1110 1111 */ &move_rs_rd_b,

/* 0100 1111 0000 */ &move_rs_rd_a,
/* 0100 1111 0001 */ &move_rs_rd_b,
/* 0100 1111 0010 */ &move_rs_rd_a,
/* 0100 1111 0011 */ &move_rs_rd_b,
/* 0100 1111 0100 */ &move_rs_rd_a,
/* 0100 1111 0101 */ &move_rs_rd_b,
/* 0100 1111 0110 */ &move_rs_rd_a,
/* 0100 1111 0111 */ &move_rs_rd_b,
/* 0100 1111 1000 */ &move_rs_rd_a,
/* 0100 1111 1001 */ &move_rs_rd_b,
/* 0100 1111 1010 */ &move_rs_rd_a,
/* 0100 1111 1011 */ &move_rs_rd_b,
/* 0100 1111 1100 */ &move_rs_rd_a,
/* 0100 1111 1101 */ &move_rs_rd_b,
/* 0100 1111 1110 */ &move_rs_rd_a,
/* 0100 1111 1111 */ &move_rs_rd_b,

/* 0101 0000 0000 */ &and_rs_rd,
/* 0101 0000 0001 */ &and_rs_rd,
/* 0101 0000 0010 */ &and_rs_rd,
/* 0101 0000 0011 */ &and_rs_rd,
/* 0101 0000 0100 */ &and_rs_rd,
/* 0101 0000 0101 */ &and_rs_rd,
/* 0101 0000 0110 */ &and_rs_rd,
/* 0101 0000 0111 */ &and_rs_rd,
/* 0101 0000 1000 */ &and_rs_rd,
/* 0101 0000 1001 */ &and_rs_rd,
/* 0101 0000 1010 */ &and_rs_rd,
/* 0101 0000 1011 */ &and_rs_rd,
/* 0101 0000 1100 */ &and_rs_rd,
/* 0101 0000 1101 */ &and_rs_rd,
/* 0101 0000 1110 */ &and_rs_rd,
/* 0101 0000 1111 */ &and_rs_rd,

/* 0101 0001 0000 */ &and_rs_rd,
/* 0101 0001 0001 */ &and_rs_rd,
/* 0101 0001 0010 */ &and_rs_rd,
/* 0101 0001 0011 */ &and_rs_rd,
/* 0101 0001 0100 */ &and_rs_rd,
/* 0101 0001 0101 */ &and_rs_rd,
/* 0101 0001 0110 */ &and_rs_rd,
/* 0101 0001 0111 */ &and_rs_rd,
/* 0101 0001 1000 */ &and_rs_rd,
/* 0101 0001 1001 */ &and_rs_rd,
/* 0101 0001 1010 */ &and_rs_rd,
/* 0101 0001 1011 */ &and_rs_rd,
/* 0101 0001 1100 */ &and_rs_rd,
/* 0101 0001 1101 */ &and_rs_rd,
/* 0101 0001 1110 */ &and_rs_rd,
/* 0101 0001 1111 */ &and_rs_rd,

/* 0101 0010 0000 */ &andn_rs_rd,
/* 0101 0010 0001 */ &andn_rs_rd,
/* 0101 0010 0010 */ &andn_rs_rd,
/* 0101 0010 0011 */ &andn_rs_rd,
/* 0101 0010 0100 */ &andn_rs_rd,
/* 0101 0010 0101 */ &andn_rs_rd,
/* 0101 0010 0110 */ &andn_rs_rd,
/* 0101 0010 0111 */ &andn_rs_rd,
/* 0101 0010 1000 */ &andn_rs_rd,
/* 0101 0010 1001 */ &andn_rs_rd,
/* 0101 0010 1010 */ &andn_rs_rd,
/* 0101 0010 1011 */ &andn_rs_rd,
/* 0101 0010 1100 */ &andn_rs_rd,
/* 0101 0010 1101 */ &andn_rs_rd,
/* 0101 0010 1110 */ &andn_rs_rd,
/* 0101 0010 1111 */ &andn_rs_rd,

/* 0101 0011 0000 */ &andn_rs_rd,
/* 0101 0011 0001 */ &andn_rs_rd,
/* 0101 0011 0010 */ &andn_rs_rd,
/* 0101 0011 0011 */ &andn_rs_rd,
/* 0101 0011 0100 */ &andn_rs_rd,
/* 0101 0011 0101 */ &andn_rs_rd,
/* 0101 0011 0110 */ &andn_rs_rd,
/* 0101 0011 0111 */ &andn_rs_rd,
/* 0101 0011 1000 */ &andn_rs_rd,
/* 0101 0011 1001 */ &andn_rs_rd,
/* 0101 0011 1010 */ &andn_rs_rd,
/* 0101 0011 1011 */ &andn_rs_rd,
/* 0101 0011 1100 */ &andn_rs_rd,
/* 0101 0011 1101 */ &andn_rs_rd,
/* 0101 0011 1110 */ &andn_rs_rd,
/* 0101 0011 1111 */ &andn_rs_rd,

/* 0101 0100 0000 */ &or_rs_rd,
/* 0101 0100 0001 */ &or_rs_rd,
/* 0101 0100 0010 */ &or_rs_rd,
/* 0101 0100 0011 */ &or_rs_rd,
/* 0101 0100 0100 */ &or_rs_rd,
/* 0101 0100 0101 */ &or_rs_rd,
/* 0101 0100 0110 */ &or_rs_rd,
/* 0101 0100 0111 */ &or_rs_rd,
/* 0101 0100 1000 */ &or_rs_rd,
/* 0101 0100 1001 */ &or_rs_rd,
/* 0101 0100 1010 */ &or_rs_rd,
/* 0101 0100 1011 */ &or_rs_rd,
/* 0101 0100 1100 */ &or_rs_rd,
/* 0101 0100 1101 */ &or_rs_rd,
/* 0101 0100 1110 */ &or_rs_rd,
/* 0101 0100 1111 */ &or_rs_rd,

/* 0101 0101 0000 */ &or_rs_rd,
/* 0101 0101 0001 */ &or_rs_rd,
/* 0101 0101 0010 */ &or_rs_rd,
/* 0101 0101 0011 */ &or_rs_rd,
/* 0101 0101 0100 */ &or_rs_rd,
/* 0101 0101 0101 */ &or_rs_rd,
/* 0101 0101 0110 */ &or_rs_rd,
/* 0101 0101 0111 */ &or_rs_rd,
/* 0101 0101 1000 */ &or_rs_rd,
/* 0101 0101 1001 */ &or_rs_rd,
/* 0101 0101 1010 */ &or_rs_rd,
/* 0101 0101 1011 */ &or_rs_rd,
/* 0101 0101 1100 */ &or_rs_rd,
/* 0101 0101 1101 */ &or_rs_rd,
/* 0101 0101 1110 */ &or_rs_rd,
/* 0101 0101 1111 */ &or_rs_rd,

/* 0101 0110 0000 */ &xor_rs_rd,
/* 0101 0110 0001 */ &xor_rs_rd,
/* 0101 0110 0010 */ &xor_rs_rd,
/* 0101 0110 0011 */ &xor_rs_rd,
/* 0101 0110 0100 */ &xor_rs_rd,
/* 0101 0110 0101 */ &xor_rs_rd,
/* 0101 0110 0110 */ &xor_rs_rd,
/* 0101 0110 0111 */ &xor_rs_rd,
/* 0101 0110 1000 */ &xor_rs_rd,
/* 0101 0110 1001 */ &xor_rs_rd,
/* 0101 0110 1010 */ &xor_rs_rd,
/* 0101 0110 1011 */ &xor_rs_rd,
/* 0101 0110 1100 */ &xor_rs_rd,
/* 0101 0110 1101 */ &xor_rs_rd,
/* 0101 0110 1110 */ &xor_rs_rd,
/* 0101 0110 1111 */ &xor_rs_rd,

/* 0101 0111 0000 */ &xor_rs_rd,
/* 0101 0111 0001 */ &xor_rs_rd,
/* 0101 0111 0010 */ &xor_rs_rd,
/* 0101 0111 0011 */ &xor_rs_rd,
/* 0101 0111 0100 */ &xor_rs_rd,
/* 0101 0111 0101 */ &xor_rs_rd,
/* 0101 0111 0110 */ &xor_rs_rd,
/* 0101 0111 0111 */ &xor_rs_rd,
/* 0101 0111 1000 */ &xor_rs_rd,
/* 0101 0111 1001 */ &xor_rs_rd,
/* 0101 0111 1010 */ &xor_rs_rd,
/* 0101 0111 1011 */ &xor_rs_rd,
/* 0101 0111 1100 */ &xor_rs_rd,
/* 0101 0111 1101 */ &xor_rs_rd,
/* 0101 0111 1110 */ &xor_rs_rd,
/* 0101 0111 1111 */ &xor_rs_rd,

/* 0101 1000 0000 */ &divs_rs_rd,
/* 0101 1000 0001 */ &divs_rs_rd,
/* 0101 1000 0010 */ &divs_rs_rd,
/* 0101 1000 0011 */ &divs_rs_rd,
/* 0101 1000 0100 */ &divs_rs_rd,
/* 0101 1000 0101 */ &divs_rs_rd,
/* 0101 1000 0110 */ &divs_rs_rd,
/* 0101 1000 0111 */ &divs_rs_rd,
/* 0101 1000 1000 */ &divs_rs_rd,
/* 0101 1000 1001 */ &divs_rs_rd,
/* 0101 1000 1010 */ &divs_rs_rd,
/* 0101 1000 1011 */ &divs_rs_rd,
/* 0101 1000 1100 */ &divs_rs_rd,
/* 0101 1000 1101 */ &divs_rs_rd,
/* 0101 1000 1110 */ &divs_rs_rd,
/* 0101 1000 1111 */ &divs_rs_rd,

/* 0101 1001 0000 */ &divs_rs_rd,
/* 0101 1001 0001 */ &divs_rs_rd,
/* 0101 1001 0010 */ &divs_rs_rd,
/* 0101 1001 0011 */ &divs_rs_rd,
/* 0101 1001 0100 */ &divs_rs_rd,
/* 0101 1001 0101 */ &divs_rs_rd,
/* 0101 1001 0110 */ &divs_rs_rd,
/* 0101 1001 0111 */ &divs_rs_rd,
/* 0101 1001 1000 */ &divs_rs_rd,
/* 0101 1001 1001 */ &divs_rs_rd,
/* 0101 1001 1010 */ &divs_rs_rd,
/* 0101 1001 1011 */ &divs_rs_rd,
/* 0101 1001 1100 */ &divs_rs_rd,
/* 0101 1001 1101 */ &divs_rs_rd,
/* 0101 1001 1110 */ &divs_rs_rd,
/* 0101 1001 1111 */ &divs_rs_rd,

/* 0101 1010 0000 */ &divu_rs_rd,
/* 0101 1010 0001 */ &divu_rs_rd,
/* 0101 1010 0010 */ &divu_rs_rd,
/* 0101 1010 0011 */ &divu_rs_rd,
/* 0101 1010 0100 */ &divu_rs_rd,
/* 0101 1010 0101 */ &divu_rs_rd,
/* 0101 1010 0110 */ &divu_rs_rd,
/* 0101 1010 0111 */ &divu_rs_rd,
/* 0101 1010 1000 */ &divu_rs_rd,
/* 0101 1010 1001 */ &divu_rs_rd,
/* 0101 1010 1010 */ &divu_rs_rd,
/* 0101 1010 1011 */ &divu_rs_rd,
/* 0101 1010 1100 */ &divu_rs_rd,
/* 0101 1010 1101 */ &divu_rs_rd,
/* 0101 1010 1110 */ &divu_rs_rd,
/* 0101 1010 1111 */ &divu_rs_rd,

/* 0101 1011 0000 */ &divu_rs_rd,
/* 0101 1011 0001 */ &divu_rs_rd,
/* 0101 1011 0010 */ &divu_rs_rd,
/* 0101 1011 0011 */ &divu_rs_rd,
/* 0101 1011 0100 */ &divu_rs_rd,
/* 0101 1011 0101 */ &divu_rs_rd,
/* 0101 1011 0110 */ &divu_rs_rd,
/* 0101 1011 0111 */ &divu_rs_rd,
/* 0101 1011 1000 */ &divu_rs_rd,
/* 0101 1011 1001 */ &divu_rs_rd,
/* 0101 1011 1010 */ &divu_rs_rd,
/* 0101 1011 1011 */ &divu_rs_rd,
/* 0101 1011 1100 */ &divu_rs_rd,
/* 0101 1011 1101 */ &divu_rs_rd,
/* 0101 1011 1110 */ &divu_rs_rd,
/* 0101 1011 1111 */ &divu_rs_rd,

/* 0101 1100 0000 */ &mpys_rs_rd,
/* 0101 1100 0001 */ &mpys_rs_rd,
/* 0101 1100 0010 */ &mpys_rs_rd,
/* 0101 1100 0011 */ &mpys_rs_rd,
/* 0101 1100 0100 */ &mpys_rs_rd,
/* 0101 1100 0101 */ &mpys_rs_rd,
/* 0101 1100 0110 */ &mpys_rs_rd,
/* 0101 1100 0111 */ &mpys_rs_rd,
/* 0101 1100 1000 */ &mpys_rs_rd,
/* 0101 1100 1001 */ &mpys_rs_rd,
/* 0101 1100 1010 */ &mpys_rs_rd,
/* 0101 1100 1011 */ &mpys_rs_rd,
/* 0101 1100 1100 */ &mpys_rs_rd,
/* 0101 1100 1101 */ &mpys_rs_rd,
/* 0101 1100 1110 */ &mpys_rs_rd,
/* 0101 1100 1111 */ &mpys_rs_rd,

/* 0101 1101 0000 */ &mpys_rs_rd,
/* 0101 1101 0001 */ &mpys_rs_rd,
/* 0101 1101 0010 */ &mpys_rs_rd,
/* 0101 1101 0011 */ &mpys_rs_rd,
/* 0101 1101 0100 */ &mpys_rs_rd,
/* 0101 1101 0101 */ &mpys_rs_rd,
/* 0101 1101 0110 */ &mpys_rs_rd,
/* 0101 1101 0111 */ &mpys_rs_rd,
/* 0101 1101 1000 */ &mpys_rs_rd,
/* 0101 1101 1001 */ &mpys_rs_rd,
/* 0101 1101 1010 */ &mpys_rs_rd,
/* 0101 1101 1011 */ &mpys_rs_rd,
/* 0101 1101 1100 */ &mpys_rs_rd,
/* 0101 1101 1101 */ &mpys_rs_rd,
/* 0101 1101 1110 */ &mpys_rs_rd,
/* 0101 1101 1111 */ &mpys_rs_rd,

/* 0101 1110 0000 */ &mpyu_rs_rd,
/* 0101 1110 0001 */ &mpyu_rs_rd,
/* 0101 1110 0010 */ &mpyu_rs_rd,
/* 0101 1110 0011 */ &mpyu_rs_rd,
/* 0101 1110 0100 */ &mpyu_rs_rd,
/* 0101 1110 0101 */ &mpyu_rs_rd,
/* 0101 1110 0110 */ &mpyu_rs_rd,
/* 0101 1110 0111 */ &mpyu_rs_rd,
/* 0101 1110 1000 */ &mpyu_rs_rd,
/* 0101 1110 1001 */ &mpyu_rs_rd,
/* 0101 1110 1010 */ &mpyu_rs_rd,
/* 0101 1110 1011 */ &mpyu_rs_rd,
/* 0101 1110 1100 */ &mpyu_rs_rd,
/* 0101 1110 1101 */ &mpyu_rs_rd,
/* 0101 1110 1110 */ &mpyu_rs_rd,
/* 0101 1110 1111 */ &mpyu_rs_rd,

/* 0101 1111 0000 */ &mpyu_rs_rd,
/* 0101 1111 0001 */ &mpyu_rs_rd,
/* 0101 1111 0010 */ &mpyu_rs_rd,
/* 0101 1111 0011 */ &mpyu_rs_rd,
/* 0101 1111 0100 */ &mpyu_rs_rd,
/* 0101 1111 0101 */ &mpyu_rs_rd,
/* 0101 1111 0110 */ &mpyu_rs_rd,
/* 0101 1111 0111 */ &mpyu_rs_rd,
/* 0101 1111 1000 */ &mpyu_rs_rd,
/* 0101 1111 1001 */ &mpyu_rs_rd,
/* 0101 1111 1010 */ &mpyu_rs_rd,
/* 0101 1111 1011 */ &mpyu_rs_rd,
/* 0101 1111 1100 */ &mpyu_rs_rd,
/* 0101 1111 1101 */ &mpyu_rs_rd,
/* 0101 1111 1110 */ &mpyu_rs_rd,
/* 0101 1111 1111 */ &mpyu_rs_rd,

/* 0110 0000 0000 */ &sla_rs_rd,
/* 0110 0000 0001 */ &sla_rs_rd,
/* 0110 0000 0010 */ &sla_rs_rd,
/* 0110 0000 0011 */ &sla_rs_rd,
/* 0110 0000 0100 */ &sla_rs_rd,
/* 0110 0000 0101 */ &sla_rs_rd,
/* 0110 0000 0110 */ &sla_rs_rd,
/* 0110 0000 0111 */ &sla_rs_rd,
/* 0110 0000 1000 */ &sla_rs_rd,
/* 0110 0000 1001 */ &sla_rs_rd,
/* 0110 0000 1010 */ &sla_rs_rd,
/* 0110 0000 1011 */ &sla_rs_rd,
/* 0110 0000 1100 */ &sla_rs_rd,
/* 0110 0000 1101 */ &sla_rs_rd,
/* 0110 0000 1110 */ &sla_rs_rd,
/* 0110 0000 1111 */ &sla_rs_rd,

/* 0110 0001 0000 */ &sla_rs_rd,
/* 0110 0001 0001 */ &sla_rs_rd,
/* 0110 0001 0010 */ &sla_rs_rd,
/* 0110 0001 0011 */ &sla_rs_rd,
/* 0110 0001 0100 */ &sla_rs_rd,
/* 0110 0001 0101 */ &sla_rs_rd,
/* 0110 0001 0110 */ &sla_rs_rd,
/* 0110 0001 0111 */ &sla_rs_rd,
/* 0110 0001 1000 */ &sla_rs_rd,
/* 0110 0001 1001 */ &sla_rs_rd,
/* 0110 0001 1010 */ &sla_rs_rd,
/* 0110 0001 1011 */ &sla_rs_rd,
/* 0110 0001 1100 */ &sla_rs_rd,
/* 0110 0001 1101 */ &sla_rs_rd,
/* 0110 0001 1110 */ &sla_rs_rd,
/* 0110 0001 1111 */ &sla_rs_rd,

/* 0110 0010 0000 */ &sll_rs_rd,
/* 0110 0010 0001 */ &sll_rs_rd,
/* 0110 0010 0010 */ &sll_rs_rd,
/* 0110 0010 0011 */ &sll_rs_rd,
/* 0110 0010 0100 */ &sll_rs_rd,
/* 0110 0010 0101 */ &sll_rs_rd,
/* 0110 0010 0110 */ &sll_rs_rd,
/* 0110 0010 0111 */ &sll_rs_rd,
/* 0110 0010 1000 */ &sll_rs_rd,
/* 0110 0010 1001 */ &sll_rs_rd,
/* 0110 0010 1010 */ &sll_rs_rd,
/* 0110 0010 1011 */ &sll_rs_rd,
/* 0110 0010 1100 */ &sll_rs_rd,
/* 0110 0010 1101 */ &sll_rs_rd,
/* 0110 0010 1110 */ &sll_rs_rd,
/* 0110 0010 1111 */ &sll_rs_rd,

/* 0110 0011 0000 */ &sll_rs_rd,
/* 0110 0011 0001 */ &sll_rs_rd,
/* 0110 0011 0010 */ &sll_rs_rd,
/* 0110 0011 0011 */ &sll_rs_rd,
/* 0110 0011 0100 */ &sll_rs_rd,
/* 0110 0011 0101 */ &sll_rs_rd,
/* 0110 0011 0110 */ &sll_rs_rd,
/* 0110 0011 0111 */ &sll_rs_rd,
/* 0110 0011 1000 */ &sll_rs_rd,
/* 0110 0011 1001 */ &sll_rs_rd,
/* 0110 0011 1010 */ &sll_rs_rd,
/* 0110 0011 1011 */ &sll_rs_rd,
/* 0110 0011 1100 */ &sll_rs_rd,
/* 0110 0011 1101 */ &sll_rs_rd,
/* 0110 0011 1110 */ &sll_rs_rd,
/* 0110 0011 1111 */ &sll_rs_rd,

/* 0110 0100 0000 */ &sra_rs_rd,
/* 0110 0100 0001 */ &sra_rs_rd,
/* 0110 0100 0010 */ &sra_rs_rd,
/* 0110 0100 0011 */ &sra_rs_rd,
/* 0110 0100 0100 */ &sra_rs_rd,
/* 0110 0100 0101 */ &sra_rs_rd,
/* 0110 0100 0110 */ &sra_rs_rd,
/* 0110 0100 0111 */ &sra_rs_rd,
/* 0110 0100 1000 */ &sra_rs_rd,
/* 0110 0100 1001 */ &sra_rs_rd,
/* 0110 0100 1010 */ &sra_rs_rd,
/* 0110 0100 1011 */ &sra_rs_rd,
/* 0110 0100 1100 */ &sra_rs_rd,
/* 0110 0100 1101 */ &sra_rs_rd,
/* 0110 0100 1110 */ &sra_rs_rd,
/* 0110 0100 1111 */ &sra_rs_rd,

/* 0110 0101 0000 */ &sra_rs_rd,
/* 0110 0101 0001 */ &sra_rs_rd,
/* 0110 0101 0010 */ &sra_rs_rd,
/* 0110 0101 0011 */ &sra_rs_rd,
/* 0110 0101 0100 */ &sra_rs_rd,
/* 0110 0101 0101 */ &sra_rs_rd,
/* 0110 0101 0110 */ &sra_rs_rd,
/* 0110 0101 0111 */ &sra_rs_rd,
/* 0110 0101 1000 */ &sra_rs_rd,
/* 0110 0101 1001 */ &sra_rs_rd,
/* 0110 0101 1010 */ &sra_rs_rd,
/* 0110 0101 1011 */ &sra_rs_rd,
/* 0110 0101 1100 */ &sra_rs_rd,
/* 0110 0101 1101 */ &sra_rs_rd,
/* 0110 0101 1110 */ &sra_rs_rd,
/* 0110 0101 1111 */ &sra_rs_rd,

/* 0110 0110 0000 */ &srl_rs_rd,
/* 0110 0110 0001 */ &srl_rs_rd,
/* 0110 0110 0010 */ &srl_rs_rd,
/* 0110 0110 0011 */ &srl_rs_rd,
/* 0110 0110 0100 */ &srl_rs_rd,
/* 0110 0110 0101 */ &srl_rs_rd,
/* 0110 0110 0110 */ &srl_rs_rd,
/* 0110 0110 0111 */ &srl_rs_rd,
/* 0110 0110 1000 */ &srl_rs_rd,
/* 0110 0110 1001 */ &srl_rs_rd,
/* 0110 0110 1010 */ &srl_rs_rd,
/* 0110 0110 1011 */ &srl_rs_rd,
/* 0110 0110 1100 */ &srl_rs_rd,
/* 0110 0110 1101 */ &srl_rs_rd,
/* 0110 0110 1110 */ &srl_rs_rd,
/* 0110 0110 1111 */ &srl_rs_rd,

/* 0110 0111 0000 */ &srl_rs_rd,
/* 0110 0111 0001 */ &srl_rs_rd,
/* 0110 0111 0010 */ &srl_rs_rd,
/* 0110 0111 0011 */ &srl_rs_rd,
/* 0110 0111 0100 */ &srl_rs_rd,
/* 0110 0111 0101 */ &srl_rs_rd,
/* 0110 0111 0110 */ &srl_rs_rd,
/* 0110 0111 0111 */ &srl_rs_rd,
/* 0110 0111 1000 */ &srl_rs_rd,
/* 0110 0111 1001 */ &srl_rs_rd,
/* 0110 0111 1010 */ &srl_rs_rd,
/* 0110 0111 1011 */ &srl_rs_rd,
/* 0110 0111 1100 */ &srl_rs_rd,
/* 0110 0111 1101 */ &srl_rs_rd,
/* 0110 0111 1110 */ &srl_rs_rd,
/* 0110 0111 1111 */ &srl_rs_rd,

/* 0110 1000 0000 */ &rl_rs_rd,
/* 0110 1000 0001 */ &rl_rs_rd,
/* 0110 1000 0010 */ &rl_rs_rd,
/* 0110 1000 0011 */ &rl_rs_rd,
/* 0110 1000 0100 */ &rl_rs_rd,
/* 0110 1000 0101 */ &rl_rs_rd,
/* 0110 1000 0110 */ &rl_rs_rd,
/* 0110 1000 0111 */ &rl_rs_rd,
/* 0110 1000 1000 */ &rl_rs_rd,
/* 0110 1000 1001 */ &rl_rs_rd,
/* 0110 1000 1010 */ &rl_rs_rd,
/* 0110 1000 1011 */ &rl_rs_rd,
/* 0110 1000 1100 */ &rl_rs_rd,
/* 0110 1000 1101 */ &rl_rs_rd,
/* 0110 1000 1110 */ &rl_rs_rd,
/* 0110 1000 1111 */ &rl_rs_rd,

/* 0110 1001 0000 */ &rl_rs_rd,
/* 0110 1001 0001 */ &rl_rs_rd,
/* 0110 1001 0010 */ &rl_rs_rd,
/* 0110 1001 0011 */ &rl_rs_rd,
/* 0110 1001 0100 */ &rl_rs_rd,
/* 0110 1001 0101 */ &rl_rs_rd,
/* 0110 1001 0110 */ &rl_rs_rd,
/* 0110 1001 0111 */ &rl_rs_rd,
/* 0110 1001 1000 */ &rl_rs_rd,
/* 0110 1001 1001 */ &rl_rs_rd,
/* 0110 1001 1010 */ &rl_rs_rd,
/* 0110 1001 1011 */ &rl_rs_rd,
/* 0110 1001 1100 */ &rl_rs_rd,
/* 0110 1001 1101 */ &rl_rs_rd,
/* 0110 1001 1110 */ &rl_rs_rd,
/* 0110 1001 1111 */ &rl_rs_rd,

/* 0110 1010 0000 */ &lmo_rs_rd,
/* 0110 1010 0001 */ &lmo_rs_rd,
/* 0110 1010 0010 */ &lmo_rs_rd,
/* 0110 1010 0011 */ &lmo_rs_rd,
/* 0110 1010 0100 */ &lmo_rs_rd,
/* 0110 1010 0101 */ &lmo_rs_rd,
/* 0110 1010 0110 */ &lmo_rs_rd,
/* 0110 1010 0111 */ &lmo_rs_rd,
/* 0110 1010 1000 */ &lmo_rs_rd,
/* 0110 1010 1001 */ &lmo_rs_rd,
/* 0110 1010 1010 */ &lmo_rs_rd,
/* 0110 1010 1011 */ &lmo_rs_rd,
/* 0110 1010 1100 */ &lmo_rs_rd,
/* 0110 1010 1101 */ &lmo_rs_rd,
/* 0110 1010 1110 */ &lmo_rs_rd,
/* 0110 1010 1111 */ &lmo_rs_rd,

/* 0110 1011 0000 */ &lmo_rs_rd,
/* 0110 1011 0001 */ &lmo_rs_rd,
/* 0110 1011 0010 */ &lmo_rs_rd,
/* 0110 1011 0011 */ &lmo_rs_rd,
/* 0110 1011 0100 */ &lmo_rs_rd,
/* 0110 1011 0101 */ &lmo_rs_rd,
/* 0110 1011 0110 */ &lmo_rs_rd,
/* 0110 1011 0111 */ &lmo_rs_rd,
/* 0110 1011 1000 */ &lmo_rs_rd,
/* 0110 1011 1001 */ &lmo_rs_rd,
/* 0110 1011 1010 */ &lmo_rs_rd,
/* 0110 1011 1011 */ &lmo_rs_rd,
/* 0110 1011 1100 */ &lmo_rs_rd,
/* 0110 1011 1101 */ &lmo_rs_rd,
/* 0110 1011 1110 */ &lmo_rs_rd,
/* 0110 1011 1111 */ &lmo_rs_rd,

/* 0110 1100 0000 */ &mods_rs_rd,
/* 0110 1100 0001 */ &mods_rs_rd,
/* 0110 1100 0010 */ &mods_rs_rd,
/* 0110 1100 0011 */ &mods_rs_rd,
/* 0110 1100 0100 */ &mods_rs_rd,
/* 0110 1100 0101 */ &mods_rs_rd,
/* 0110 1100 0110 */ &mods_rs_rd,
/* 0110 1100 0111 */ &mods_rs_rd,
/* 0110 1100 1000 */ &mods_rs_rd,
/* 0110 1100 1001 */ &mods_rs_rd,
/* 0110 1100 1010 */ &mods_rs_rd,
/* 0110 1100 1011 */ &mods_rs_rd,
/* 0110 1100 1100 */ &mods_rs_rd,
/* 0110 1100 1101 */ &mods_rs_rd,
/* 0110 1100 1110 */ &mods_rs_rd,
/* 0110 1100 1111 */ &mods_rs_rd,

/* 0110 1101 0000 */ &mods_rs_rd,
/* 0110 1101 0001 */ &mods_rs_rd,
/* 0110 1101 0010 */ &mods_rs_rd,
/* 0110 1101 0011 */ &mods_rs_rd,
/* 0110 1101 0100 */ &mods_rs_rd,
/* 0110 1101 0101 */ &mods_rs_rd,
/* 0110 1101 0110 */ &mods_rs_rd,
/* 0110 1101 0111 */ &mods_rs_rd,
/* 0110 1101 1000 */ &mods_rs_rd,
/* 0110 1101 1001 */ &mods_rs_rd,
/* 0110 1101 1010 */ &mods_rs_rd,
/* 0110 1101 1011 */ &mods_rs_rd,
/* 0110 1101 1100 */ &mods_rs_rd,
/* 0110 1101 1101 */ &mods_rs_rd,
/* 0110 1101 1110 */ &mods_rs_rd,
/* 0110 1101 1111 */ &mods_rs_rd,

/* 0110 1110 0000 */ &modu_rs_rd,
/* 0110 1110 0001 */ &modu_rs_rd,
/* 0110 1110 0010 */ &modu_rs_rd,
/* 0110 1110 0011 */ &modu_rs_rd,
/* 0110 1110 0100 */ &modu_rs_rd,
/* 0110 1110 0101 */ &modu_rs_rd,
/* 0110 1110 0110 */ &modu_rs_rd,
/* 0110 1110 0111 */ &modu_rs_rd,
/* 0110 1110 1000 */ &modu_rs_rd,
/* 0110 1110 1001 */ &modu_rs_rd,
/* 0110 1110 1010 */ &modu_rs_rd,
/* 0110 1110 1011 */ &modu_rs_rd,
/* 0110 1110 1100 */ &modu_rs_rd,
/* 0110 1110 1101 */ &modu_rs_rd,
/* 0110 1110 1110 */ &modu_rs_rd,
/* 0110 1110 1111 */ &modu_rs_rd,

/* 0110 1111 0000 */ &modu_rs_rd,
/* 0110 1111 0001 */ &modu_rs_rd,
/* 0110 1111 0010 */ &modu_rs_rd,
/* 0110 1111 0011 */ &modu_rs_rd,
/* 0110 1111 0100 */ &modu_rs_rd,
/* 0110 1111 0101 */ &modu_rs_rd,
/* 0110 1111 0110 */ &modu_rs_rd,
/* 0110 1111 0111 */ &modu_rs_rd,
/* 0110 1111 1000 */ &modu_rs_rd,
/* 0110 1111 1001 */ &modu_rs_rd,
/* 0110 1111 1010 */ &modu_rs_rd,
/* 0110 1111 1011 */ &modu_rs_rd,
/* 0110 1111 1100 */ &modu_rs_rd,
/* 0110 1111 1101 */ &modu_rs_rd,
/* 0110 1111 1110 */ &modu_rs_rd,
/* 0110 1111 1111 */ &modu_rs_rd,

/* 0111 0000 0000 */ &unimplemented,
/* 0111 0000 0001 */ &unimplemented,
/* 0111 0000 0010 */ &unimplemented,
/* 0111 0000 0011 */ &unimplemented,
/* 0111 0000 0100 */ &unimplemented,
/* 0111 0000 0101 */ &unimplemented,
/* 0111 0000 0110 */ &unimplemented,
/* 0111 0000 0111 */ &unimplemented,
/* 0111 0000 1000 */ &unimplemented,
/* 0111 0000 1001 */ &unimplemented,
/* 0111 0000 1010 */ &unimplemented,
/* 0111 0000 1011 */ &unimplemented,
/* 0111 0000 1100 */ &unimplemented,
/* 0111 0000 1101 */ &unimplemented,
/* 0111 0000 1110 */ &unimplemented,
/* 0111 0000 1111 */ &unimplemented,

/* 0111 0001 0000 */ &unimplemented,
/* 0111 0001 0001 */ &unimplemented,
/* 0111 0001 0010 */ &unimplemented,
/* 0111 0001 0011 */ &unimplemented,
/* 0111 0001 0100 */ &unimplemented,
/* 0111 0001 0101 */ &unimplemented,
/* 0111 0001 0110 */ &unimplemented,
/* 0111 0001 0111 */ &unimplemented,
/* 0111 0001 1000 */ &unimplemented,
/* 0111 0001 1001 */ &unimplemented,
/* 0111 0001 1010 */ &unimplemented,
/* 0111 0001 1011 */ &unimplemented,
/* 0111 0001 1100 */ &unimplemented,
/* 0111 0001 1101 */ &unimplemented,
/* 0111 0001 1110 */ &unimplemented,
/* 0111 0001 1111 */ &unimplemented,

/* 0111 0010 0000 */ &unimplemented,
/* 0111 0010 0001 */ &unimplemented,
/* 0111 0010 0010 */ &unimplemented,
/* 0111 0010 0011 */ &unimplemented,
/* 0111 0010 0100 */ &unimplemented,
/* 0111 0010 0101 */ &unimplemented,
/* 0111 0010 0110 */ &unimplemented,
/* 0111 0010 0111 */ &unimplemented,
/* 0111 0010 1000 */ &unimplemented,
/* 0111 0010 1001 */ &unimplemented,
/* 0111 0010 1010 */ &unimplemented,
/* 0111 0010 1011 */ &unimplemented,
/* 0111 0010 1100 */ &unimplemented,
/* 0111 0010 1101 */ &unimplemented,
/* 0111 0010 1110 */ &unimplemented,
/* 0111 0010 1111 */ &unimplemented,

/* 0111 0011 0000 */ &unimplemented,
/* 0111 0011 0001 */ &unimplemented,
/* 0111 0011 0010 */ &unimplemented,
/* 0111 0011 0011 */ &unimplemented,
/* 0111 0011 0100 */ &unimplemented,
/* 0111 0011 0101 */ &unimplemented,
/* 0111 0011 0110 */ &unimplemented,
/* 0111 0011 0111 */ &unimplemented,
/* 0111 0011 1000 */ &unimplemented,
/* 0111 0011 1001 */ &unimplemented,
/* 0111 0011 1010 */ &unimplemented,
/* 0111 0011 1011 */ &unimplemented,
/* 0111 0011 1100 */ &unimplemented,
/* 0111 0011 1101 */ &unimplemented,
/* 0111 0011 1110 */ &unimplemented,
/* 0111 0011 1111 */ &unimplemented,

/* 0111 0100 0000 */ &unimplemented,
/* 0111 0100 0001 */ &unimplemented,
/* 0111 0100 0010 */ &unimplemented,
/* 0111 0100 0011 */ &unimplemented,
/* 0111 0100 0100 */ &unimplemented,
/* 0111 0100 0101 */ &unimplemented,
/* 0111 0100 0110 */ &unimplemented,
/* 0111 0100 0111 */ &unimplemented,
/* 0111 0100 1000 */ &unimplemented,
/* 0111 0100 1001 */ &unimplemented,
/* 0111 0100 1010 */ &unimplemented,
/* 0111 0100 1011 */ &unimplemented,
/* 0111 0100 1100 */ &unimplemented,
/* 0111 0100 1101 */ &unimplemented,
/* 0111 0100 1110 */ &unimplemented,
/* 0111 0100 1111 */ &unimplemented,

/* 0111 0101 0000 */ &unimplemented,
/* 0111 0101 0001 */ &unimplemented,
/* 0111 0101 0010 */ &unimplemented,
/* 0111 0101 0011 */ &unimplemented,
/* 0111 0101 0100 */ &unimplemented,
/* 0111 0101 0101 */ &unimplemented,
/* 0111 0101 0110 */ &unimplemented,
/* 0111 0101 0111 */ &unimplemented,
/* 0111 0101 1000 */ &unimplemented,
/* 0111 0101 1001 */ &unimplemented,
/* 0111 0101 1010 */ &unimplemented,
/* 0111 0101 1011 */ &unimplemented,
/* 0111 0101 1100 */ &unimplemented,
/* 0111 0101 1101 */ &unimplemented,
/* 0111 0101 1110 */ &unimplemented,
/* 0111 0101 1111 */ &unimplemented,

/* 0111 0110 0000 */ &unimplemented,
/* 0111 0110 0001 */ &unimplemented,
/* 0111 0110 0010 */ &unimplemented,
/* 0111 0110 0011 */ &unimplemented,
/* 0111 0110 0100 */ &unimplemented,
/* 0111 0110 0101 */ &unimplemented,
/* 0111 0110 0110 */ &unimplemented,
/* 0111 0110 0111 */ &unimplemented,
/* 0111 0110 1000 */ &unimplemented,
/* 0111 0110 1001 */ &unimplemented,
/* 0111 0110 1010 */ &unimplemented,
/* 0111 0110 1011 */ &unimplemented,
/* 0111 0110 1100 */ &unimplemented,
/* 0111 0110 1101 */ &unimplemented,
/* 0111 0110 1110 */ &unimplemented,
/* 0111 0110 1111 */ &unimplemented,

/* 0111 0111 0000 */ &unimplemented,
/* 0111 0111 0001 */ &unimplemented,
/* 0111 0111 0010 */ &unimplemented,
/* 0111 0111 0011 */ &unimplemented,
/* 0111 0111 0100 */ &unimplemented,
/* 0111 0111 0101 */ &unimplemented,
/* 0111 0111 0110 */ &unimplemented,
/* 0111 0111 0111 */ &unimplemented,
/* 0111 0111 1000 */ &unimplemented,
/* 0111 0111 1001 */ &unimplemented,
/* 0111 0111 1010 */ &unimplemented,
/* 0111 0111 1011 */ &unimplemented,
/* 0111 0111 1100 */ &unimplemented,
/* 0111 0111 1101 */ &unimplemented,
/* 0111 0111 1110 */ &unimplemented,
/* 0111 0111 1111 */ &unimplemented,

/* 0111 1000 0000 */ &unimplemented,
/* 0111 1000 0001 */ &unimplemented,
/* 0111 1000 0010 */ &unimplemented,
/* 0111 1000 0011 */ &unimplemented,
/* 0111 1000 0100 */ &unimplemented,
/* 0111 1000 0101 */ &unimplemented,
/* 0111 1000 0110 */ &unimplemented,
/* 0111 1000 0111 */ &unimplemented,
/* 0111 1000 1000 */ &unimplemented,
/* 0111 1000 1001 */ &unimplemented,
/* 0111 1000 1010 */ &unimplemented,
/* 0111 1000 1011 */ &unimplemented,
/* 0111 1000 1100 */ &unimplemented,
/* 0111 1000 1101 */ &unimplemented,
/* 0111 1000 1110 */ &unimplemented,
/* 0111 1000 1111 */ &unimplemented,

/* 0111 1001 0000 */ &unimplemented,
/* 0111 1001 0001 */ &unimplemented,
/* 0111 1001 0010 */ &unimplemented,
/* 0111 1001 0011 */ &unimplemented,
/* 0111 1001 0100 */ &unimplemented,
/* 0111 1001 0101 */ &unimplemented,
/* 0111 1001 0110 */ &unimplemented,
/* 0111 1001 0111 */ &unimplemented,
/* 0111 1001 1000 */ &unimplemented,
/* 0111 1001 1001 */ &unimplemented,
/* 0111 1001 1010 */ &unimplemented,
/* 0111 1001 1011 */ &unimplemented,
/* 0111 1001 1100 */ &unimplemented,
/* 0111 1001 1101 */ &unimplemented,
/* 0111 1001 1110 */ &unimplemented,
/* 0111 1001 1111 */ &unimplemented,

/* 0111 1010 0000 */ &unimplemented,
/* 0111 1010 0001 */ &unimplemented,
/* 0111 1010 0010 */ &unimplemented,
/* 0111 1010 0011 */ &unimplemented,
/* 0111 1010 0100 */ &unimplemented,
/* 0111 1010 0101 */ &unimplemented,
/* 0111 1010 0110 */ &unimplemented,
/* 0111 1010 0111 */ &unimplemented,
/* 0111 1010 1000 */ &unimplemented,
/* 0111 1010 1001 */ &unimplemented,
/* 0111 1010 1010 */ &unimplemented,
/* 0111 1010 1011 */ &unimplemented,
/* 0111 1010 1100 */ &unimplemented,
/* 0111 1010 1101 */ &unimplemented,
/* 0111 1010 1110 */ &unimplemented,
/* 0111 1010 1111 */ &unimplemented,

/* 0111 1011 0000 */ &unimplemented,
/* 0111 1011 0001 */ &unimplemented,
/* 0111 1011 0010 */ &unimplemented,
/* 0111 1011 0011 */ &unimplemented,
/* 0111 1011 0100 */ &unimplemented,
/* 0111 1011 0101 */ &unimplemented,
/* 0111 1011 0110 */ &unimplemented,
/* 0111 1011 0111 */ &unimplemented,
/* 0111 1011 1000 */ &unimplemented,
/* 0111 1011 1001 */ &unimplemented,
/* 0111 1011 1010 */ &unimplemented,
/* 0111 1011 1011 */ &unimplemented,
/* 0111 1011 1100 */ &unimplemented,
/* 0111 1011 1101 */ &unimplemented,
/* 0111 1011 1110 */ &unimplemented,
/* 0111 1011 1111 */ &unimplemented,

/* 0111 1100 0000 */ &unimplemented,
/* 0111 1100 0001 */ &unimplemented,
/* 0111 1100 0010 */ &unimplemented,
/* 0111 1100 0011 */ &unimplemented,
/* 0111 1100 0100 */ &unimplemented,
/* 0111 1100 0101 */ &unimplemented,
/* 0111 1100 0110 */ &unimplemented,
/* 0111 1100 0111 */ &unimplemented,
/* 0111 1100 1000 */ &unimplemented,
/* 0111 1100 1001 */ &unimplemented,
/* 0111 1100 1010 */ &unimplemented,
/* 0111 1100 1011 */ &unimplemented,
/* 0111 1100 1100 */ &unimplemented,
/* 0111 1100 1101 */ &unimplemented,
/* 0111 1100 1110 */ &unimplemented,
/* 0111 1100 1111 */ &unimplemented,

/* 0111 1101 0000 */ &unimplemented,
/* 0111 1101 0001 */ &unimplemented,
/* 0111 1101 0010 */ &unimplemented,
/* 0111 1101 0011 */ &unimplemented,
/* 0111 1101 0100 */ &unimplemented,
/* 0111 1101 0101 */ &unimplemented,
/* 0111 1101 0110 */ &unimplemented,
/* 0111 1101 0111 */ &unimplemented,
/* 0111 1101 1000 */ &unimplemented,
/* 0111 1101 1001 */ &unimplemented,
/* 0111 1101 1010 */ &unimplemented,
/* 0111 1101 1011 */ &unimplemented,
/* 0111 1101 1100 */ &unimplemented,
/* 0111 1101 1101 */ &unimplemented,
/* 0111 1101 1110 */ &unimplemented,
/* 0111 1101 1111 */ &unimplemented,

/* 0111 1110 0000 */ &unimplemented,
/* 0111 1110 0001 */ &unimplemented,
/* 0111 1110 0010 */ &unimplemented,
/* 0111 1110 0011 */ &unimplemented,
/* 0111 1110 0100 */ &unimplemented,
/* 0111 1110 0101 */ &unimplemented,
/* 0111 1110 0110 */ &unimplemented,
/* 0111 1110 0111 */ &unimplemented,
/* 0111 1110 1000 */ &unimplemented,
/* 0111 1110 1001 */ &unimplemented,
/* 0111 1110 1010 */ &unimplemented,
/* 0111 1110 1011 */ &unimplemented,
/* 0111 1110 1100 */ &unimplemented,
/* 0111 1110 1101 */ &unimplemented,
/* 0111 1110 1110 */ &unimplemented,
/* 0111 1110 1111 */ &unimplemented,

/* 0111 1111 0000 */ &unimplemented,
/* 0111 1111 0001 */ &unimplemented,
/* 0111 1111 0010 */ &unimplemented,
/* 0111 1111 0011 */ &unimplemented,
/* 0111 1111 0100 */ &unimplemented,
/* 0111 1111 0101 */ &unimplemented,
/* 0111 1111 0110 */ &unimplemented,
/* 0111 1111 0111 */ &unimplemented,
/* 0111 1111 1000 */ &unimplemented,
/* 0111 1111 1001 */ &unimplemented,
/* 0111 1111 1010 */ &unimplemented,
/* 0111 1111 1011 */ &unimplemented,
/* 0111 1111 1100 */ &unimplemented,
/* 0111 1111 1101 */ &unimplemented,
/* 0111 1111 1110 */ &unimplemented,
/* 0111 1111 1111 */ &unimplemented,

/* 1000 0000 0000 */ &move_rs_ird_0,
/* 1000 0000 0001 */ &move_rs_ird_0,
/* 1000 0000 0010 */ &move_rs_ird_0,
/* 1000 0000 0011 */ &move_rs_ird_0,
/* 1000 0000 0100 */ &move_rs_ird_0,
/* 1000 0000 0101 */ &move_rs_ird_0,
/* 1000 0000 0110 */ &move_rs_ird_0,
/* 1000 0000 0111 */ &move_rs_ird_0,
/* 1000 0000 1000 */ &move_rs_ird_0,
/* 1000 0000 1001 */ &move_rs_ird_0,
/* 1000 0000 1010 */ &move_rs_ird_0,
/* 1000 0000 1011 */ &move_rs_ird_0,
/* 1000 0000 1100 */ &move_rs_ird_0,
/* 1000 0000 1101 */ &move_rs_ird_0,
/* 1000 0000 1110 */ &move_rs_ird_0,
/* 1000 0000 1111 */ &move_rs_ird_0,

/* 1000 0001 0000 */ &move_rs_ird_0,
/* 1000 0001 0001 */ &move_rs_ird_0,
/* 1000 0001 0010 */ &move_rs_ird_0,
/* 1000 0001 0011 */ &move_rs_ird_0,
/* 1000 0001 0100 */ &move_rs_ird_0,
/* 1000 0001 0101 */ &move_rs_ird_0,
/* 1000 0001 0110 */ &move_rs_ird_0,
/* 1000 0001 0111 */ &move_rs_ird_0,
/* 1000 0001 1000 */ &move_rs_ird_0,
/* 1000 0001 1001 */ &move_rs_ird_0,
/* 1000 0001 1010 */ &move_rs_ird_0,
/* 1000 0001 1011 */ &move_rs_ird_0,
/* 1000 0001 1100 */ &move_rs_ird_0,
/* 1000 0001 1101 */ &move_rs_ird_0,
/* 1000 0001 1110 */ &move_rs_ird_0,
/* 1000 0001 1111 */ &move_rs_ird_0,

/* 1000 0010 0000 */ &move_rs_ird_1,
/* 1000 0010 0001 */ &move_rs_ird_1,
/* 1000 0010 0010 */ &move_rs_ird_1,
/* 1000 0010 0011 */ &move_rs_ird_1,
/* 1000 0010 0100 */ &move_rs_ird_1,
/* 1000 0010 0101 */ &move_rs_ird_1,
/* 1000 0010 0110 */ &move_rs_ird_1,
/* 1000 0010 0111 */ &move_rs_ird_1,
/* 1000 0010 1000 */ &move_rs_ird_1,
/* 1000 0010 1001 */ &move_rs_ird_1,
/* 1000 0010 1010 */ &move_rs_ird_1,
/* 1000 0010 1011 */ &move_rs_ird_1,
/* 1000 0010 1100 */ &move_rs_ird_1,
/* 1000 0010 1101 */ &move_rs_ird_1,
/* 1000 0010 1110 */ &move_rs_ird_1,
/* 1000 0010 1111 */ &move_rs_ird_1,

/* 1000 0011 0000 */ &move_rs_ird_1,
/* 1000 0011 0001 */ &move_rs_ird_1,
/* 1000 0011 0010 */ &move_rs_ird_1,
/* 1000 0011 0011 */ &move_rs_ird_1,
/* 1000 0011 0100 */ &move_rs_ird_1,
/* 1000 0011 0101 */ &move_rs_ird_1,
/* 1000 0011 0110 */ &move_rs_ird_1,
/* 1000 0011 0111 */ &move_rs_ird_1,
/* 1000 0011 1000 */ &move_rs_ird_1,
/* 1000 0011 1001 */ &move_rs_ird_1,
/* 1000 0011 1010 */ &move_rs_ird_1,
/* 1000 0011 1011 */ &move_rs_ird_1,
/* 1000 0011 1100 */ &move_rs_ird_1,
/* 1000 0011 1101 */ &move_rs_ird_1,
/* 1000 0011 1110 */ &move_rs_ird_1,
/* 1000 0011 1111 */ &move_rs_ird_1,

/* 1000 0100 0000 */ &move_irs_rd_0,
/* 1000 0100 0001 */ &move_irs_rd_0,
/* 1000 0100 0010 */ &move_irs_rd_0,
/* 1000 0100 0011 */ &move_irs_rd_0,
/* 1000 0100 0100 */ &move_irs_rd_0,
/* 1000 0100 0101 */ &move_irs_rd_0,
/* 1000 0100 0110 */ &move_irs_rd_0,
/* 1000 0100 0111 */ &move_irs_rd_0,
/* 1000 0100 1000 */ &move_irs_rd_0,
/* 1000 0100 1001 */ &move_irs_rd_0,
/* 1000 0100 1010 */ &move_irs_rd_0,
/* 1000 0100 1011 */ &move_irs_rd_0,
/* 1000 0100 1100 */ &move_irs_rd_0,
/* 1000 0100 1101 */ &move_irs_rd_0,
/* 1000 0100 1110 */ &move_irs_rd_0,
/* 1000 0100 1111 */ &move_irs_rd_0,

/* 1000 0101 0000 */ &move_irs_rd_0,
/* 1000 0101 0001 */ &move_irs_rd_0,
/* 1000 0101 0010 */ &move_irs_rd_0,
/* 1000 0101 0011 */ &move_irs_rd_0,
/* 1000 0101 0100 */ &move_irs_rd_0,
/* 1000 0101 0101 */ &move_irs_rd_0,
/* 1000 0101 0110 */ &move_irs_rd_0,
/* 1000 0101 0111 */ &move_irs_rd_0,
/* 1000 0101 1000 */ &move_irs_rd_0,
/* 1000 0101 1001 */ &move_irs_rd_0,
/* 1000 0101 1010 */ &move_irs_rd_0,
/* 1000 0101 1011 */ &move_irs_rd_0,
/* 1000 0101 1100 */ &move_irs_rd_0,
/* 1000 0101 1101 */ &move_irs_rd_0,
/* 1000 0101 1110 */ &move_irs_rd_0,
/* 1000 0101 1111 */ &move_irs_rd_0,

/* 1000 0110 0000 */ &move_irs_rd_1,
/* 1000 0110 0001 */ &move_irs_rd_1,
/* 1000 0110 0010 */ &move_irs_rd_1,
/* 1000 0110 0011 */ &move_irs_rd_1,
/* 1000 0110 0100 */ &move_irs_rd_1,
/* 1000 0110 0101 */ &move_irs_rd_1,
/* 1000 0110 0110 */ &move_irs_rd_1,
/* 1000 0110 0111 */ &move_irs_rd_1,
/* 1000 0110 1000 */ &move_irs_rd_1,
/* 1000 0110 1001 */ &move_irs_rd_1,
/* 1000 0110 1010 */ &move_irs_rd_1,
/* 1000 0110 1011 */ &move_irs_rd_1,
/* 1000 0110 1100 */ &move_irs_rd_1,
/* 1000 0110 1101 */ &move_irs_rd_1,
/* 1000 0110 1110 */ &move_irs_rd_1,
/* 1000 0110 1111 */ &move_irs_rd_1,

/* 1000 0111 0000 */ &move_irs_rd_1,
/* 1000 0111 0001 */ &move_irs_rd_1,
/* 1000 0111 0010 */ &move_irs_rd_1,
/* 1000 0111 0011 */ &move_irs_rd_1,
/* 1000 0111 0100 */ &move_irs_rd_1,
/* 1000 0111 0101 */ &move_irs_rd_1,
/* 1000 0111 0110 */ &move_irs_rd_1,
/* 1000 0111 0111 */ &move_irs_rd_1,
/* 1000 0111 1000 */ &move_irs_rd_1,
/* 1000 0111 1001 */ &move_irs_rd_1,
/* 1000 0111 1010 */ &move_irs_rd_1,
/* 1000 0111 1011 */ &move_irs_rd_1,
/* 1000 0111 1100 */ &move_irs_rd_1,
/* 1000 0111 1101 */ &move_irs_rd_1,
/* 1000 0111 1110 */ &move_irs_rd_1,
/* 1000 0111 1111 */ &move_irs_rd_1,

/* 1000 1000 0000 */ &move_irs_ird_0,
/* 1000 1000 0001 */ &move_irs_ird_0,
/* 1000 1000 0010 */ &move_irs_ird_0,
/* 1000 1000 0011 */ &move_irs_ird_0,
/* 1000 1000 0100 */ &move_irs_ird_0,
/* 1000 1000 0101 */ &move_irs_ird_0,
/* 1000 1000 0110 */ &move_irs_ird_0,
/* 1000 1000 0111 */ &move_irs_ird_0,
/* 1000 1000 1000 */ &move_irs_ird_0,
/* 1000 1000 1001 */ &move_irs_ird_0,
/* 1000 1000 1010 */ &move_irs_ird_0,
/* 1000 1000 1011 */ &move_irs_ird_0,
/* 1000 1000 1100 */ &move_irs_ird_0,
/* 1000 1000 1101 */ &move_irs_ird_0,
/* 1000 1000 1110 */ &move_irs_ird_0,
/* 1000 1000 1111 */ &move_irs_ird_0,

/* 1000 1001 0000 */ &move_irs_ird_0,
/* 1000 1001 0001 */ &move_irs_ird_0,
/* 1000 1001 0010 */ &move_irs_ird_0,
/* 1000 1001 0011 */ &move_irs_ird_0,
/* 1000 1001 0100 */ &move_irs_ird_0,
/* 1000 1001 0101 */ &move_irs_ird_0,
/* 1000 1001 0110 */ &move_irs_ird_0,
/* 1000 1001 0111 */ &move_irs_ird_0,
/* 1000 1001 1000 */ &move_irs_ird_0,
/* 1000 1001 1001 */ &move_irs_ird_0,
/* 1000 1001 1010 */ &move_irs_ird_0,
/* 1000 1001 1011 */ &move_irs_ird_0,
/* 1000 1001 1100 */ &move_irs_ird_0,
/* 1000 1001 1101 */ &move_irs_ird_0,
/* 1000 1001 1110 */ &move_irs_ird_0,
/* 1000 1001 1111 */ &move_irs_ird_0,

/* 1000 1010 0000 */ &move_irs_ird_1,
/* 1000 1010 0001 */ &move_irs_ird_1,
/* 1000 1010 0010 */ &move_irs_ird_1,
/* 1000 1010 0011 */ &move_irs_ird_1,
/* 1000 1010 0100 */ &move_irs_ird_1,
/* 1000 1010 0101 */ &move_irs_ird_1,
/* 1000 1010 0110 */ &move_irs_ird_1,
/* 1000 1010 0111 */ &move_irs_ird_1,
/* 1000 1010 1000 */ &move_irs_ird_1,
/* 1000 1010 1001 */ &move_irs_ird_1,
/* 1000 1010 1010 */ &move_irs_ird_1,
/* 1000 1010 1011 */ &move_irs_ird_1,
/* 1000 1010 1100 */ &move_irs_ird_1,
/* 1000 1010 1101 */ &move_irs_ird_1,
/* 1000 1010 1110 */ &move_irs_ird_1,
/* 1000 1010 1111 */ &move_irs_ird_1,

/* 1000 1011 0000 */ &move_irs_ird_1,
/* 1000 1011 0001 */ &move_irs_ird_1,
/* 1000 1011 0010 */ &move_irs_ird_1,
/* 1000 1011 0011 */ &move_irs_ird_1,
/* 1000 1011 0100 */ &move_irs_ird_1,
/* 1000 1011 0101 */ &move_irs_ird_1,
/* 1000 1011 0110 */ &move_irs_ird_1,
/* 1000 1011 0111 */ &move_irs_ird_1,
/* 1000 1011 1000 */ &move_irs_ird_1,
/* 1000 1011 1001 */ &move_irs_ird_1,
/* 1000 1011 1010 */ &move_irs_ird_1,
/* 1000 1011 1011 */ &move_irs_ird_1,
/* 1000 1011 1100 */ &move_irs_ird_1,
/* 1000 1011 1101 */ &move_irs_ird_1,
/* 1000 1011 1110 */ &move_irs_ird_1,
/* 1000 1011 1111 */ &move_irs_ird_1,

/* 1000 1100 0000 */ &movb_rs_ird,
/* 1000 1100 0001 */ &movb_rs_ird,
/* 1000 1100 0010 */ &movb_rs_ird,
/* 1000 1100 0011 */ &movb_rs_ird,
/* 1000 1100 0100 */ &movb_rs_ird,
/* 1000 1100 0101 */ &movb_rs_ird,
/* 1000 1100 0110 */ &movb_rs_ird,
/* 1000 1100 0111 */ &movb_rs_ird,
/* 1000 1100 1000 */ &movb_rs_ird,
/* 1000 1100 1001 */ &movb_rs_ird,
/* 1000 1100 1010 */ &movb_rs_ird,
/* 1000 1100 1011 */ &movb_rs_ird,
/* 1000 1100 1100 */ &movb_rs_ird,
/* 1000 1100 1101 */ &movb_rs_ird,
/* 1000 1100 1110 */ &movb_rs_ird,
/* 1000 1100 1111 */ &movb_rs_ird,

/* 1000 1101 0000 */ &movb_rs_ird,
/* 1000 1101 0001 */ &movb_rs_ird,
/* 1000 1101 0010 */ &movb_rs_ird,
/* 1000 1101 0011 */ &movb_rs_ird,
/* 1000 1101 0100 */ &movb_rs_ird,
/* 1000 1101 0101 */ &movb_rs_ird,
/* 1000 1101 0110 */ &movb_rs_ird,
/* 1000 1101 0111 */ &movb_rs_ird,
/* 1000 1101 1000 */ &movb_rs_ird,
/* 1000 1101 1001 */ &movb_rs_ird,
/* 1000 1101 1010 */ &movb_rs_ird,
/* 1000 1101 1011 */ &movb_rs_ird,
/* 1000 1101 1100 */ &movb_rs_ird,
/* 1000 1101 1101 */ &movb_rs_ird,
/* 1000 1101 1110 */ &movb_rs_ird,
/* 1000 1101 1111 */ &movb_rs_ird,

/* 1000 1110 0000 */ &movb_irs_rd,
/* 1000 1110 0001 */ &movb_irs_rd,
/* 1000 1110 0010 */ &movb_irs_rd,
/* 1000 1110 0011 */ &movb_irs_rd,
/* 1000 1110 0100 */ &movb_irs_rd,
/* 1000 1110 0101 */ &movb_irs_rd,
/* 1000 1110 0110 */ &movb_irs_rd,
/* 1000 1110 0111 */ &movb_irs_rd,
/* 1000 1110 1000 */ &movb_irs_rd,
/* 1000 1110 1001 */ &movb_irs_rd,
/* 1000 1110 1010 */ &movb_irs_rd,
/* 1000 1110 1011 */ &movb_irs_rd,
/* 1000 1110 1100 */ &movb_irs_rd,
/* 1000 1110 1101 */ &movb_irs_rd,
/* 1000 1110 1110 */ &movb_irs_rd,
/* 1000 1110 1111 */ &movb_irs_rd,

/* 1000 1111 0000 */ &movb_irs_rd,
/* 1000 1111 0001 */ &movb_irs_rd,
/* 1000 1111 0010 */ &movb_irs_rd,
/* 1000 1111 0011 */ &movb_irs_rd,
/* 1000 1111 0100 */ &movb_irs_rd,
/* 1000 1111 0101 */ &movb_irs_rd,
/* 1000 1111 0110 */ &movb_irs_rd,
/* 1000 1111 0111 */ &movb_irs_rd,
/* 1000 1111 1000 */ &movb_irs_rd,
/* 1000 1111 1001 */ &movb_irs_rd,
/* 1000 1111 1010 */ &movb_irs_rd,
/* 1000 1111 1011 */ &movb_irs_rd,
/* 1000 1111 1100 */ &movb_irs_rd,
/* 1000 1111 1101 */ &movb_irs_rd,
/* 1000 1111 1110 */ &movb_irs_rd,
/* 1000 1111 1111 */ &movb_irs_rd,

/* 1001 0000 0000 */ &move_rs_irdp_0,
/* 1001 0000 0001 */ &move_rs_irdp_0,
/* 1001 0000 0010 */ &move_rs_irdp_0,
/* 1001 0000 0011 */ &move_rs_irdp_0,
/* 1001 0000 0100 */ &move_rs_irdp_0,
/* 1001 0000 0101 */ &move_rs_irdp_0,
/* 1001 0000 0110 */ &move_rs_irdp_0,
/* 1001 0000 0111 */ &move_rs_irdp_0,
/* 1001 0000 1000 */ &move_rs_irdp_0,
/* 1001 0000 1001 */ &move_rs_irdp_0,
/* 1001 0000 1010 */ &move_rs_irdp_0,
/* 1001 0000 1011 */ &move_rs_irdp_0,
/* 1001 0000 1100 */ &move_rs_irdp_0,
/* 1001 0000 1101 */ &move_rs_irdp_0,
/* 1001 0000 1110 */ &move_rs_irdp_0,
/* 1001 0000 1111 */ &move_rs_irdp_0,

/* 1001 0001 0000 */ &move_rs_irdp_0,
/* 1001 0001 0001 */ &move_rs_irdp_0,
/* 1001 0001 0010 */ &move_rs_irdp_0,
/* 1001 0001 0011 */ &move_rs_irdp_0,
/* 1001 0001 0100 */ &move_rs_irdp_0,
/* 1001 0001 0101 */ &move_rs_irdp_0,
/* 1001 0001 0110 */ &move_rs_irdp_0,
/* 1001 0001 0111 */ &move_rs_irdp_0,
/* 1001 0001 1000 */ &move_rs_irdp_0,
/* 1001 0001 1001 */ &move_rs_irdp_0,
/* 1001 0001 1010 */ &move_rs_irdp_0,
/* 1001 0001 1011 */ &move_rs_irdp_0,
/* 1001 0001 1100 */ &move_rs_irdp_0,
/* 1001 0001 1101 */ &move_rs_irdp_0,
/* 1001 0001 1110 */ &move_rs_irdp_0,
/* 1001 0001 1111 */ &move_rs_irdp_0,

/* 1001 0010 0000 */ &move_rs_irdp_1,
/* 1001 0010 0001 */ &move_rs_irdp_1,
/* 1001 0010 0010 */ &move_rs_irdp_1,
/* 1001 0010 0011 */ &move_rs_irdp_1,
/* 1001 0010 0100 */ &move_rs_irdp_1,
/* 1001 0010 0101 */ &move_rs_irdp_1,
/* 1001 0010 0110 */ &move_rs_irdp_1,
/* 1001 0010 0111 */ &move_rs_irdp_1,
/* 1001 0010 1000 */ &move_rs_irdp_1,
/* 1001 0010 1001 */ &move_rs_irdp_1,
/* 1001 0010 1010 */ &move_rs_irdp_1,
/* 1001 0010 1011 */ &move_rs_irdp_1,
/* 1001 0010 1100 */ &move_rs_irdp_1,
/* 1001 0010 1101 */ &move_rs_irdp_1,
/* 1001 0010 1110 */ &move_rs_irdp_1,
/* 1001 0010 1111 */ &move_rs_irdp_1,

/* 1001 0011 0000 */ &move_rs_irdp_1,
/* 1001 0011 0001 */ &move_rs_irdp_1,
/* 1001 0011 0010 */ &move_rs_irdp_1,
/* 1001 0011 0011 */ &move_rs_irdp_1,
/* 1001 0011 0100 */ &move_rs_irdp_1,
/* 1001 0011 0101 */ &move_rs_irdp_1,
/* 1001 0011 0110 */ &move_rs_irdp_1,
/* 1001 0011 0111 */ &move_rs_irdp_1,
/* 1001 0011 1000 */ &move_rs_irdp_1,
/* 1001 0011 1001 */ &move_rs_irdp_1,
/* 1001 0011 1010 */ &move_rs_irdp_1,
/* 1001 0011 1011 */ &move_rs_irdp_1,
/* 1001 0011 1100 */ &move_rs_irdp_1,
/* 1001 0011 1101 */ &move_rs_irdp_1,
/* 1001 0011 1110 */ &move_rs_irdp_1,
/* 1001 0011 1111 */ &move_rs_irdp_1,

/* 1001 0100 0000 */ &move_irsp_rd_0,
/* 1001 0100 0001 */ &move_irsp_rd_0,
/* 1001 0100 0010 */ &move_irsp_rd_0,
/* 1001 0100 0011 */ &move_irsp_rd_0,
/* 1001 0100 0100 */ &move_irsp_rd_0,
/* 1001 0100 0101 */ &move_irsp_rd_0,
/* 1001 0100 0110 */ &move_irsp_rd_0,
/* 1001 0100 0111 */ &move_irsp_rd_0,
/* 1001 0100 1000 */ &move_irsp_rd_0,
/* 1001 0100 1001 */ &move_irsp_rd_0,
/* 1001 0100 1010 */ &move_irsp_rd_0,
/* 1001 0100 1011 */ &move_irsp_rd_0,
/* 1001 0100 1100 */ &move_irsp_rd_0,
/* 1001 0100 1101 */ &move_irsp_rd_0,
/* 1001 0100 1110 */ &move_irsp_rd_0,
/* 1001 0100 1111 */ &move_irsp_rd_0,

/* 1001 0101 0000 */ &move_irsp_rd_0,
/* 1001 0101 0001 */ &move_irsp_rd_0,
/* 1001 0101 0010 */ &move_irsp_rd_0,
/* 1001 0101 0011 */ &move_irsp_rd_0,
/* 1001 0101 0100 */ &move_irsp_rd_0,
/* 1001 0101 0101 */ &move_irsp_rd_0,
/* 1001 0101 0110 */ &move_irsp_rd_0,
/* 1001 0101 0111 */ &move_irsp_rd_0,
/* 1001 0101 1000 */ &move_irsp_rd_0,
/* 1001 0101 1001 */ &move_irsp_rd_0,
/* 1001 0101 1010 */ &move_irsp_rd_0,
/* 1001 0101 1011 */ &move_irsp_rd_0,
/* 1001 0101 1100 */ &move_irsp_rd_0,
/* 1001 0101 1101 */ &move_irsp_rd_0,
/* 1001 0101 1110 */ &move_irsp_rd_0,
/* 1001 0101 1111 */ &move_irsp_rd_0,

/* 1001 0110 0000 */ &move_irsp_rd_1,
/* 1001 0110 0001 */ &move_irsp_rd_1,
/* 1001 0110 0010 */ &move_irsp_rd_1,
/* 1001 0110 0011 */ &move_irsp_rd_1,
/* 1001 0110 0100 */ &move_irsp_rd_1,
/* 1001 0110 0101 */ &move_irsp_rd_1,
/* 1001 0110 0110 */ &move_irsp_rd_1,
/* 1001 0110 0111 */ &move_irsp_rd_1,
/* 1001 0110 1000 */ &move_irsp_rd_1,
/* 1001 0110 1001 */ &move_irsp_rd_1,
/* 1001 0110 1010 */ &move_irsp_rd_1,
/* 1001 0110 1011 */ &move_irsp_rd_1,
/* 1001 0110 1100 */ &move_irsp_rd_1,
/* 1001 0110 1101 */ &move_irsp_rd_1,
/* 1001 0110 1110 */ &move_irsp_rd_1,
/* 1001 0110 1111 */ &move_irsp_rd_1,

/* 1001 0111 0000 */ &move_irsp_rd_1,
/* 1001 0111 0001 */ &move_irsp_rd_1,
/* 1001 0111 0010 */ &move_irsp_rd_1,
/* 1001 0111 0011 */ &move_irsp_rd_1,
/* 1001 0111 0100 */ &move_irsp_rd_1,
/* 1001 0111 0101 */ &move_irsp_rd_1,
/* 1001 0111 0110 */ &move_irsp_rd_1,
/* 1001 0111 0111 */ &move_irsp_rd_1,
/* 1001 0111 1000 */ &move_irsp_rd_1,
/* 1001 0111 1001 */ &move_irsp_rd_1,
/* 1001 0111 1010 */ &move_irsp_rd_1,
/* 1001 0111 1011 */ &move_irsp_rd_1,
/* 1001 0111 1100 */ &move_irsp_rd_1,
/* 1001 0111 1101 */ &move_irsp_rd_1,
/* 1001 0111 1110 */ &move_irsp_rd_1,
/* 1001 0111 1111 */ &move_irsp_rd_1,

/* 1001 1000 0000 */ &move_irsp_irdp_0,
/* 1001 1000 0001 */ &move_irsp_irdp_0,
/* 1001 1000 0010 */ &move_irsp_irdp_0,
/* 1001 1000 0011 */ &move_irsp_irdp_0,
/* 1001 1000 0100 */ &move_irsp_irdp_0,
/* 1001 1000 0101 */ &move_irsp_irdp_0,
/* 1001 1000 0110 */ &move_irsp_irdp_0,
/* 1001 1000 0111 */ &move_irsp_irdp_0,
/* 1001 1000 1000 */ &move_irsp_irdp_0,
/* 1001 1000 1001 */ &move_irsp_irdp_0,
/* 1001 1000 1010 */ &move_irsp_irdp_0,
/* 1001 1000 1011 */ &move_irsp_irdp_0,
/* 1001 1000 1100 */ &move_irsp_irdp_0,
/* 1001 1000 1101 */ &move_irsp_irdp_0,
/* 1001 1000 1110 */ &move_irsp_irdp_0,
/* 1001 1000 1111 */ &move_irsp_irdp_0,

/* 1001 1001 0000 */ &move_irsp_irdp_0,
/* 1001 1001 0001 */ &move_irsp_irdp_0,
/* 1001 1001 0010 */ &move_irsp_irdp_0,
/* 1001 1001 0011 */ &move_irsp_irdp_0,
/* 1001 1001 0100 */ &move_irsp_irdp_0,
/* 1001 1001 0101 */ &move_irsp_irdp_0,
/* 1001 1001 0110 */ &move_irsp_irdp_0,
/* 1001 1001 0111 */ &move_irsp_irdp_0,
/* 1001 1001 1000 */ &move_irsp_irdp_0,
/* 1001 1001 1001 */ &move_irsp_irdp_0,
/* 1001 1001 1010 */ &move_irsp_irdp_0,
/* 1001 1001 1011 */ &move_irsp_irdp_0,
/* 1001 1001 1100 */ &move_irsp_irdp_0,
/* 1001 1001 1101 */ &move_irsp_irdp_0,
/* 1001 1001 1110 */ &move_irsp_irdp_0,
/* 1001 1001 1111 */ &move_irsp_irdp_0,

/* 1001 1010 0000 */ &move_irsp_irdp_1,
/* 1001 1010 0001 */ &move_irsp_irdp_1,
/* 1001 1010 0010 */ &move_irsp_irdp_1,
/* 1001 1010 0011 */ &move_irsp_irdp_1,
/* 1001 1010 0100 */ &move_irsp_irdp_1,
/* 1001 1010 0101 */ &move_irsp_irdp_1,
/* 1001 1010 0110 */ &move_irsp_irdp_1,
/* 1001 1010 0111 */ &move_irsp_irdp_1,
/* 1001 1010 1000 */ &move_irsp_irdp_1,
/* 1001 1010 1001 */ &move_irsp_irdp_1,
/* 1001 1010 1010 */ &move_irsp_irdp_1,
/* 1001 1010 1011 */ &move_irsp_irdp_1,
/* 1001 1010 1100 */ &move_irsp_irdp_1,
/* 1001 1010 1101 */ &move_irsp_irdp_1,
/* 1001 1010 1110 */ &move_irsp_irdp_1,
/* 1001 1010 1111 */ &move_irsp_irdp_1,

/* 1001 1011 0000 */ &move_irsp_irdp_1,
/* 1001 1011 0001 */ &move_irsp_irdp_1,
/* 1001 1011 0010 */ &move_irsp_irdp_1,
/* 1001 1011 0011 */ &move_irsp_irdp_1,
/* 1001 1011 0100 */ &move_irsp_irdp_1,
/* 1001 1011 0101 */ &move_irsp_irdp_1,
/* 1001 1011 0110 */ &move_irsp_irdp_1,
/* 1001 1011 0111 */ &move_irsp_irdp_1,
/* 1001 1011 1000 */ &move_irsp_irdp_1,
/* 1001 1011 1001 */ &move_irsp_irdp_1,
/* 1001 1011 1010 */ &move_irsp_irdp_1,
/* 1001 1011 1011 */ &move_irsp_irdp_1,
/* 1001 1011 1100 */ &move_irsp_irdp_1,
/* 1001 1011 1101 */ &move_irsp_irdp_1,
/* 1001 1011 1110 */ &move_irsp_irdp_1,
/* 1001 1011 1111 */ &move_irsp_irdp_1,

/* 1001 1100 0000 */ &movb_irs_ird,
/* 1001 1100 0001 */ &movb_irs_ird,
/* 1001 1100 0010 */ &movb_irs_ird,
/* 1001 1100 0011 */ &movb_irs_ird,
/* 1001 1100 0100 */ &movb_irs_ird,
/* 1001 1100 0101 */ &movb_irs_ird,
/* 1001 1100 0110 */ &movb_irs_ird,
/* 1001 1100 0111 */ &movb_irs_ird,
/* 1001 1100 1000 */ &movb_irs_ird,
/* 1001 1100 1001 */ &movb_irs_ird,
/* 1001 1100 1010 */ &movb_irs_ird,
/* 1001 1100 1011 */ &movb_irs_ird,
/* 1001 1100 1100 */ &movb_irs_ird,
/* 1001 1100 1101 */ &movb_irs_ird,
/* 1001 1100 1110 */ &movb_irs_ird,
/* 1001 1100 1111 */ &movb_irs_ird,

/* 1001 1101 0000 */ &movb_irs_ird,
/* 1001 1101 0001 */ &movb_irs_ird,
/* 1001 1101 0010 */ &movb_irs_ird,
/* 1001 1101 0011 */ &movb_irs_ird,
/* 1001 1101 0100 */ &movb_irs_ird,
/* 1001 1101 0101 */ &movb_irs_ird,
/* 1001 1101 0110 */ &movb_irs_ird,
/* 1001 1101 0111 */ &movb_irs_ird,
/* 1001 1101 1000 */ &movb_irs_ird,
/* 1001 1101 1001 */ &movb_irs_ird,
/* 1001 1101 1010 */ &movb_irs_ird,
/* 1001 1101 1011 */ &movb_irs_ird,
/* 1001 1101 1100 */ &movb_irs_ird,
/* 1001 1101 1101 */ &movb_irs_ird,
/* 1001 1101 1110 */ &movb_irs_ird,
/* 1001 1101 1111 */ &movb_irs_ird,

/* 1001 1110 0000 */ &unimplemented,
/* 1001 1110 0001 */ &unimplemented,
/* 1001 1110 0010 */ &unimplemented,
/* 1001 1110 0011 */ &unimplemented,
/* 1001 1110 0100 */ &unimplemented,
/* 1001 1110 0101 */ &unimplemented,
/* 1001 1110 0110 */ &unimplemented,
/* 1001 1110 0111 */ &unimplemented,
/* 1001 1110 1000 */ &unimplemented,
/* 1001 1110 1001 */ &unimplemented,
/* 1001 1110 1010 */ &unimplemented,
/* 1001 1110 1011 */ &unimplemented,
/* 1001 1110 1100 */ &unimplemented,
/* 1001 1110 1101 */ &unimplemented,
/* 1001 1110 1110 */ &unimplemented,
/* 1001 1110 1111 */ &unimplemented,

/* 1001 1111 0000 */ &unimplemented,
/* 1001 1111 0001 */ &unimplemented,
/* 1001 1111 0010 */ &unimplemented,
/* 1001 1111 0011 */ &unimplemented,
/* 1001 1111 0100 */ &unimplemented,
/* 1001 1111 0101 */ &unimplemented,
/* 1001 1111 0110 */ &unimplemented,
/* 1001 1111 0111 */ &unimplemented,
/* 1001 1111 1000 */ &unimplemented,
/* 1001 1111 1001 */ &unimplemented,
/* 1001 1111 1010 */ &unimplemented,
/* 1001 1111 1011 */ &unimplemented,
/* 1001 1111 1100 */ &unimplemented,
/* 1001 1111 1101 */ &unimplemented,
/* 1001 1111 1110 */ &unimplemented,
/* 1001 1111 1111 */ &unimplemented,

/* 1010 0000 0000 */ &move_rs_mird_0,
/* 1010 0000 0001 */ &move_rs_mird_0,
/* 1010 0000 0010 */ &move_rs_mird_0,
/* 1010 0000 0011 */ &move_rs_mird_0,
/* 1010 0000 0100 */ &move_rs_mird_0,
/* 1010 0000 0101 */ &move_rs_mird_0,
/* 1010 0000 0110 */ &move_rs_mird_0,
/* 1010 0000 0111 */ &move_rs_mird_0,
/* 1010 0000 1000 */ &move_rs_mird_0,
/* 1010 0000 1001 */ &move_rs_mird_0,
/* 1010 0000 1010 */ &move_rs_mird_0,
/* 1010 0000 1011 */ &move_rs_mird_0,
/* 1010 0000 1100 */ &move_rs_mird_0,
/* 1010 0000 1101 */ &move_rs_mird_0,
/* 1010 0000 1110 */ &move_rs_mird_0,
/* 1010 0000 1111 */ &move_rs_mird_0,

/* 1010 0001 0000 */ &move_rs_mird_0,
/* 1010 0001 0001 */ &move_rs_mird_0,
/* 1010 0001 0010 */ &move_rs_mird_0,
/* 1010 0001 0011 */ &move_rs_mird_0,
/* 1010 0001 0100 */ &move_rs_mird_0,
/* 1010 0001 0101 */ &move_rs_mird_0,
/* 1010 0001 0110 */ &move_rs_mird_0,
/* 1010 0001 0111 */ &move_rs_mird_0,
/* 1010 0001 1000 */ &move_rs_mird_0,
/* 1010 0001 1001 */ &move_rs_mird_0,
/* 1010 0001 1010 */ &move_rs_mird_0,
/* 1010 0001 1011 */ &move_rs_mird_0,
/* 1010 0001 1100 */ &move_rs_mird_0,
/* 1010 0001 1101 */ &move_rs_mird_0,
/* 1010 0001 1110 */ &move_rs_mird_0,
/* 1010 0001 1111 */ &move_rs_mird_0,

/* 1010 0010 0000 */ &move_rs_mird_1,
/* 1010 0010 0001 */ &move_rs_mird_1,
/* 1010 0010 0010 */ &move_rs_mird_1,
/* 1010 0010 0011 */ &move_rs_mird_1,
/* 1010 0010 0100 */ &move_rs_mird_1,
/* 1010 0010 0101 */ &move_rs_mird_1,
/* 1010 0010 0110 */ &move_rs_mird_1,
/* 1010 0010 0111 */ &move_rs_mird_1,
/* 1010 0010 1000 */ &move_rs_mird_1,
/* 1010 0010 1001 */ &move_rs_mird_1,
/* 1010 0010 1010 */ &move_rs_mird_1,
/* 1010 0010 1011 */ &move_rs_mird_1,
/* 1010 0010 1100 */ &move_rs_mird_1,
/* 1010 0010 1101 */ &move_rs_mird_1,
/* 1010 0010 1110 */ &move_rs_mird_1,
/* 1010 0010 1111 */ &move_rs_mird_1,

/* 1010 0011 0000 */ &move_rs_mird_1,
/* 1010 0011 0001 */ &move_rs_mird_1,
/* 1010 0011 0010 */ &move_rs_mird_1,
/* 1010 0011 0011 */ &move_rs_mird_1,
/* 1010 0011 0100 */ &move_rs_mird_1,
/* 1010 0011 0101 */ &move_rs_mird_1,
/* 1010 0011 0110 */ &move_rs_mird_1,
/* 1010 0011 0111 */ &move_rs_mird_1,
/* 1010 0011 1000 */ &move_rs_mird_1,
/* 1010 0011 1001 */ &move_rs_mird_1,
/* 1010 0011 1010 */ &move_rs_mird_1,
/* 1010 0011 1011 */ &move_rs_mird_1,
/* 1010 0011 1100 */ &move_rs_mird_1,
/* 1010 0011 1101 */ &move_rs_mird_1,
/* 1010 0011 1110 */ &move_rs_mird_1,
/* 1010 0011 1111 */ &move_rs_mird_1,

/* 1010 0100 0000 */ &move_mirs_rd_0,
/* 1010 0100 0001 */ &move_mirs_rd_0,
/* 1010 0100 0010 */ &move_mirs_rd_0,
/* 1010 0100 0011 */ &move_mirs_rd_0,
/* 1010 0100 0100 */ &move_mirs_rd_0,
/* 1010 0100 0101 */ &move_mirs_rd_0,
/* 1010 0100 0110 */ &move_mirs_rd_0,
/* 1010 0100 0111 */ &move_mirs_rd_0,
/* 1010 0100 1000 */ &move_mirs_rd_0,
/* 1010 0100 1001 */ &move_mirs_rd_0,
/* 1010 0100 1010 */ &move_mirs_rd_0,
/* 1010 0100 1011 */ &move_mirs_rd_0,
/* 1010 0100 1100 */ &move_mirs_rd_0,
/* 1010 0100 1101 */ &move_mirs_rd_0,
/* 1010 0100 1110 */ &move_mirs_rd_0,
/* 1010 0100 1111 */ &move_mirs_rd_0,

/* 1010 0101 0000 */ &move_mirs_rd_0,
/* 1010 0101 0001 */ &move_mirs_rd_0,
/* 1010 0101 0010 */ &move_mirs_rd_0,
/* 1010 0101 0011 */ &move_mirs_rd_0,
/* 1010 0101 0100 */ &move_mirs_rd_0,
/* 1010 0101 0101 */ &move_mirs_rd_0,
/* 1010 0101 0110 */ &move_mirs_rd_0,
/* 1010 0101 0111 */ &move_mirs_rd_0,
/* 1010 0101 1000 */ &move_mirs_rd_0,
/* 1010 0101 1001 */ &move_mirs_rd_0,
/* 1010 0101 1010 */ &move_mirs_rd_0,
/* 1010 0101 1011 */ &move_mirs_rd_0,
/* 1010 0101 1100 */ &move_mirs_rd_0,
/* 1010 0101 1101 */ &move_mirs_rd_0,
/* 1010 0101 1110 */ &move_mirs_rd_0,
/* 1010 0101 1111 */ &move_mirs_rd_0,

/* 1010 0110 0000 */ &move_mirs_rd_1,
/* 1010 0110 0001 */ &move_mirs_rd_1,
/* 1010 0110 0010 */ &move_mirs_rd_1,
/* 1010 0110 0011 */ &move_mirs_rd_1,
/* 1010 0110 0100 */ &move_mirs_rd_1,
/* 1010 0110 0101 */ &move_mirs_rd_1,
/* 1010 0110 0110 */ &move_mirs_rd_1,
/* 1010 0110 0111 */ &move_mirs_rd_1,
/* 1010 0110 1000 */ &move_mirs_rd_1,
/* 1010 0110 1001 */ &move_mirs_rd_1,
/* 1010 0110 1010 */ &move_mirs_rd_1,
/* 1010 0110 1011 */ &move_mirs_rd_1,
/* 1010 0110 1100 */ &move_mirs_rd_1,
/* 1010 0110 1101 */ &move_mirs_rd_1,
/* 1010 0110 1110 */ &move_mirs_rd_1,
/* 1010 0110 1111 */ &move_mirs_rd_1,

/* 1010 0111 0000 */ &move_mirs_rd_1,
/* 1010 0111 0001 */ &move_mirs_rd_1,
/* 1010 0111 0010 */ &move_mirs_rd_1,
/* 1010 0111 0011 */ &move_mirs_rd_1,
/* 1010 0111 0100 */ &move_mirs_rd_1,
/* 1010 0111 0101 */ &move_mirs_rd_1,
/* 1010 0111 0110 */ &move_mirs_rd_1,
/* 1010 0111 0111 */ &move_mirs_rd_1,
/* 1010 0111 1000 */ &move_mirs_rd_1,
/* 1010 0111 1001 */ &move_mirs_rd_1,
/* 1010 0111 1010 */ &move_mirs_rd_1,
/* 1010 0111 1011 */ &move_mirs_rd_1,
/* 1010 0111 1100 */ &move_mirs_rd_1,
/* 1010 0111 1101 */ &move_mirs_rd_1,
/* 1010 0111 1110 */ &move_mirs_rd_1,
/* 1010 0111 1111 */ &move_mirs_rd_1,

/* 1010 1000 0000 */ &move_mirs_mird_0,
/* 1010 1000 0001 */ &move_mirs_mird_0,
/* 1010 1000 0010 */ &move_mirs_mird_0,
/* 1010 1000 0011 */ &move_mirs_mird_0,
/* 1010 1000 0100 */ &move_mirs_mird_0,
/* 1010 1000 0101 */ &move_mirs_mird_0,
/* 1010 1000 0110 */ &move_mirs_mird_0,
/* 1010 1000 0111 */ &move_mirs_mird_0,
/* 1010 1000 1000 */ &move_mirs_mird_0,
/* 1010 1000 1001 */ &move_mirs_mird_0,
/* 1010 1000 1010 */ &move_mirs_mird_0,
/* 1010 1000 1011 */ &move_mirs_mird_0,
/* 1010 1000 1100 */ &move_mirs_mird_0,
/* 1010 1000 1101 */ &move_mirs_mird_0,
/* 1010 1000 1110 */ &move_mirs_mird_0,
/* 1010 1000 1111 */ &move_mirs_mird_0,

/* 1010 1001 0000 */ &move_mirs_mird_0,
/* 1010 1001 0001 */ &move_mirs_mird_0,
/* 1010 1001 0010 */ &move_mirs_mird_0,
/* 1010 1001 0011 */ &move_mirs_mird_0,
/* 1010 1001 0100 */ &move_mirs_mird_0,
/* 1010 1001 0101 */ &move_mirs_mird_0,
/* 1010 1001 0110 */ &move_mirs_mird_0,
/* 1010 1001 0111 */ &move_mirs_mird_0,
/* 1010 1001 1000 */ &move_mirs_mird_0,
/* 1010 1001 1001 */ &move_mirs_mird_0,
/* 1010 1001 1010 */ &move_mirs_mird_0,
/* 1010 1001 1011 */ &move_mirs_mird_0,
/* 1010 1001 1100 */ &move_mirs_mird_0,
/* 1010 1001 1101 */ &move_mirs_mird_0,
/* 1010 1001 1110 */ &move_mirs_mird_0,
/* 1010 1001 1111 */ &move_mirs_mird_0,

/* 1010 1010 0000 */ &move_mirs_mird_1,
/* 1010 1010 0001 */ &move_mirs_mird_1,
/* 1010 1010 0010 */ &move_mirs_mird_1,
/* 1010 1010 0011 */ &move_mirs_mird_1,
/* 1010 1010 0100 */ &move_mirs_mird_1,
/* 1010 1010 0101 */ &move_mirs_mird_1,
/* 1010 1010 0110 */ &move_mirs_mird_1,
/* 1010 1010 0111 */ &move_mirs_mird_1,
/* 1010 1010 1000 */ &move_mirs_mird_1,
/* 1010 1010 1001 */ &move_mirs_mird_1,
/* 1010 1010 1010 */ &move_mirs_mird_1,
/* 1010 1010 1011 */ &move_mirs_mird_1,
/* 1010 1010 1100 */ &move_mirs_mird_1,
/* 1010 1010 1101 */ &move_mirs_mird_1,
/* 1010 1010 1110 */ &move_mirs_mird_1,
/* 1010 1010 1111 */ &move_mirs_mird_1,

/* 1010 1011 0000 */ &move_mirs_mird_1,
/* 1010 1011 0001 */ &move_mirs_mird_1,
/* 1010 1011 0010 */ &move_mirs_mird_1,
/* 1010 1011 0011 */ &move_mirs_mird_1,
/* 1010 1011 0100 */ &move_mirs_mird_1,
/* 1010 1011 0101 */ &move_mirs_mird_1,
/* 1010 1011 0110 */ &move_mirs_mird_1,
/* 1010 1011 0111 */ &move_mirs_mird_1,
/* 1010 1011 1000 */ &move_mirs_mird_1,
/* 1010 1011 1001 */ &move_mirs_mird_1,
/* 1010 1011 1010 */ &move_mirs_mird_1,
/* 1010 1011 1011 */ &move_mirs_mird_1,
/* 1010 1011 1100 */ &move_mirs_mird_1,
/* 1010 1011 1101 */ &move_mirs_mird_1,
/* 1010 1011 1110 */ &move_mirs_mird_1,
/* 1010 1011 1111 */ &move_mirs_mird_1,

/* 1010 1100 0000 */ &movb_rs_irdo,
/* 1010 1100 0001 */ &movb_rs_irdo,
/* 1010 1100 0010 */ &movb_rs_irdo,
/* 1010 1100 0011 */ &movb_rs_irdo,
/* 1010 1100 0100 */ &movb_rs_irdo,
/* 1010 1100 0101 */ &movb_rs_irdo,
/* 1010 1100 0110 */ &movb_rs_irdo,
/* 1010 1100 0111 */ &movb_rs_irdo,
/* 1010 1100 1000 */ &movb_rs_irdo,
/* 1010 1100 1001 */ &movb_rs_irdo,
/* 1010 1100 1010 */ &movb_rs_irdo,
/* 1010 1100 1011 */ &movb_rs_irdo,
/* 1010 1100 1100 */ &movb_rs_irdo,
/* 1010 1100 1101 */ &movb_rs_irdo,
/* 1010 1100 1110 */ &movb_rs_irdo,
/* 1010 1100 1111 */ &movb_rs_irdo,

/* 1010 1101 0000 */ &movb_rs_irdo,
/* 1010 1101 0001 */ &movb_rs_irdo,
/* 1010 1101 0010 */ &movb_rs_irdo,
/* 1010 1101 0011 */ &movb_rs_irdo,
/* 1010 1101 0100 */ &movb_rs_irdo,
/* 1010 1101 0101 */ &movb_rs_irdo,
/* 1010 1101 0110 */ &movb_rs_irdo,
/* 1010 1101 0111 */ &movb_rs_irdo,
/* 1010 1101 1000 */ &movb_rs_irdo,
/* 1010 1101 1001 */ &movb_rs_irdo,
/* 1010 1101 1010 */ &movb_rs_irdo,
/* 1010 1101 1011 */ &movb_rs_irdo,
/* 1010 1101 1100 */ &movb_rs_irdo,
/* 1010 1101 1101 */ &movb_rs_irdo,
/* 1010 1101 1110 */ &movb_rs_irdo,
/* 1010 1101 1111 */ &movb_rs_irdo,

/* 1010 1110 0000 */ &movb_irso_rd,
/* 1010 1110 0001 */ &movb_irso_rd,
/* 1010 1110 0010 */ &movb_irso_rd,
/* 1010 1110 0011 */ &movb_irso_rd,
/* 1010 1110 0100 */ &movb_irso_rd,
/* 1010 1110 0101 */ &movb_irso_rd,
/* 1010 1110 0110 */ &movb_irso_rd,
/* 1010 1110 0111 */ &movb_irso_rd,
/* 1010 1110 1000 */ &movb_irso_rd,
/* 1010 1110 1001 */ &movb_irso_rd,
/* 1010 1110 1010 */ &movb_irso_rd,
/* 1010 1110 1011 */ &movb_irso_rd,
/* 1010 1110 1100 */ &movb_irso_rd,
/* 1010 1110 1101 */ &movb_irso_rd,
/* 1010 1110 1110 */ &movb_irso_rd,
/* 1010 1110 1111 */ &movb_irso_rd,

/* 1010 1111 0000 */ &movb_irso_rd,
/* 1010 1111 0001 */ &movb_irso_rd,
/* 1010 1111 0010 */ &movb_irso_rd,
/* 1010 1111 0011 */ &movb_irso_rd,
/* 1010 1111 0100 */ &movb_irso_rd,
/* 1010 1111 0101 */ &movb_irso_rd,
/* 1010 1111 0110 */ &movb_irso_rd,
/* 1010 1111 0111 */ &movb_irso_rd,
/* 1010 1111 1000 */ &movb_irso_rd,
/* 1010 1111 1001 */ &movb_irso_rd,
/* 1010 1111 1010 */ &movb_irso_rd,
/* 1010 1111 1011 */ &movb_irso_rd,
/* 1010 1111 1100 */ &movb_irso_rd,
/* 1010 1111 1101 */ &movb_irso_rd,
/* 1010 1111 1110 */ &movb_irso_rd,
/* 1010 1111 1111 */ &movb_irso_rd,

/* 1011 0000 0000 */ &move_rs_irdo_0,
/* 1011 0000 0001 */ &move_rs_irdo_0,
/* 1011 0000 0010 */ &move_rs_irdo_0,
/* 1011 0000 0011 */ &move_rs_irdo_0,
/* 1011 0000 0100 */ &move_rs_irdo_0,
/* 1011 0000 0101 */ &move_rs_irdo_0,
/* 1011 0000 0110 */ &move_rs_irdo_0,
/* 1011 0000 0111 */ &move_rs_irdo_0,
/* 1011 0000 1000 */ &move_rs_irdo_0,
/* 1011 0000 1001 */ &move_rs_irdo_0,
/* 1011 0000 1010 */ &move_rs_irdo_0,
/* 1011 0000 1011 */ &move_rs_irdo_0,
/* 1011 0000 1100 */ &move_rs_irdo_0,
/* 1011 0000 1101 */ &move_rs_irdo_0,
/* 1011 0000 1110 */ &move_rs_irdo_0,
/* 1011 0000 1111 */ &move_rs_irdo_0,

/* 1011 0001 0000 */ &move_rs_irdo_0,
/* 1011 0001 0001 */ &move_rs_irdo_0,
/* 1011 0001 0010 */ &move_rs_irdo_0,
/* 1011 0001 0011 */ &move_rs_irdo_0,
/* 1011 0001 0100 */ &move_rs_irdo_0,
/* 1011 0001 0101 */ &move_rs_irdo_0,
/* 1011 0001 0110 */ &move_rs_irdo_0,
/* 1011 0001 0111 */ &move_rs_irdo_0,
/* 1011 0001 1000 */ &move_rs_irdo_0,
/* 1011 0001 1001 */ &move_rs_irdo_0,
/* 1011 0001 1010 */ &move_rs_irdo_0,
/* 1011 0001 1011 */ &move_rs_irdo_0,
/* 1011 0001 1100 */ &move_rs_irdo_0,
/* 1011 0001 1101 */ &move_rs_irdo_0,
/* 1011 0001 1110 */ &move_rs_irdo_0,
/* 1011 0001 1111 */ &move_rs_irdo_0,

/* 1011 0010 0000 */ &move_rs_irdo_1,
/* 1011 0010 0001 */ &move_rs_irdo_1,
/* 1011 0010 0010 */ &move_rs_irdo_1,
/* 1011 0010 0011 */ &move_rs_irdo_1,
/* 1011 0010 0100 */ &move_rs_irdo_1,
/* 1011 0010 0101 */ &move_rs_irdo_1,
/* 1011 0010 0110 */ &move_rs_irdo_1,
/* 1011 0010 0111 */ &move_rs_irdo_1,
/* 1011 0010 1000 */ &move_rs_irdo_1,
/* 1011 0010 1001 */ &move_rs_irdo_1,
/* 1011 0010 1010 */ &move_rs_irdo_1,
/* 1011 0010 1011 */ &move_rs_irdo_1,
/* 1011 0010 1100 */ &move_rs_irdo_1,
/* 1011 0010 1101 */ &move_rs_irdo_1,
/* 1011 0010 1110 */ &move_rs_irdo_1,
/* 1011 0010 1111 */ &move_rs_irdo_1,

/* 1011 0011 0000 */ &move_rs_irdo_1,
/* 1011 0011 0001 */ &move_rs_irdo_1,
/* 1011 0011 0010 */ &move_rs_irdo_1,
/* 1011 0011 0011 */ &move_rs_irdo_1,
/* 1011 0011 0100 */ &move_rs_irdo_1,
/* 1011 0011 0101 */ &move_rs_irdo_1,
/* 1011 0011 0110 */ &move_rs_irdo_1,
/* 1011 0011 0111 */ &move_rs_irdo_1,
/* 1011 0011 1000 */ &move_rs_irdo_1,
/* 1011 0011 1001 */ &move_rs_irdo_1,
/* 1011 0011 1010 */ &move_rs_irdo_1,
/* 1011 0011 1011 */ &move_rs_irdo_1,
/* 1011 0011 1100 */ &move_rs_irdo_1,
/* 1011 0011 1101 */ &move_rs_irdo_1,
/* 1011 0011 1110 */ &move_rs_irdo_1,
/* 1011 0011 1111 */ &move_rs_irdo_1,

/* 1011 0100 0000 */ &move_irso_rd_0,
/* 1011 0100 0001 */ &move_irso_rd_0,
/* 1011 0100 0010 */ &move_irso_rd_0,
/* 1011 0100 0011 */ &move_irso_rd_0,
/* 1011 0100 0100 */ &move_irso_rd_0,
/* 1011 0100 0101 */ &move_irso_rd_0,
/* 1011 0100 0110 */ &move_irso_rd_0,
/* 1011 0100 0111 */ &move_irso_rd_0,
/* 1011 0100 1000 */ &move_irso_rd_0,
/* 1011 0100 1001 */ &move_irso_rd_0,
/* 1011 0100 1010 */ &move_irso_rd_0,
/* 1011 0100 1011 */ &move_irso_rd_0,
/* 1011 0100 1100 */ &move_irso_rd_0,
/* 1011 0100 1101 */ &move_irso_rd_0,
/* 1011 0100 1110 */ &move_irso_rd_0,
/* 1011 0100 1111 */ &move_irso_rd_0,

/* 1011 0101 0000 */ &move_irso_rd_0,
/* 1011 0101 0001 */ &move_irso_rd_0,
/* 1011 0101 0010 */ &move_irso_rd_0,
/* 1011 0101 0011 */ &move_irso_rd_0,
/* 1011 0101 0100 */ &move_irso_rd_0,
/* 1011 0101 0101 */ &move_irso_rd_0,
/* 1011 0101 0110 */ &move_irso_rd_0,
/* 1011 0101 0111 */ &move_irso_rd_0,
/* 1011 0101 1000 */ &move_irso_rd_0,
/* 1011 0101 1001 */ &move_irso_rd_0,
/* 1011 0101 1010 */ &move_irso_rd_0,
/* 1011 0101 1011 */ &move_irso_rd_0,
/* 1011 0101 1100 */ &move_irso_rd_0,
/* 1011 0101 1101 */ &move_irso_rd_0,
/* 1011 0101 1110 */ &move_irso_rd_0,
/* 1011 0101 1111 */ &move_irso_rd_0,

/* 1011 0110 0000 */ &move_irso_rd_1,
/* 1011 0110 0001 */ &move_irso_rd_1,
/* 1011 0110 0010 */ &move_irso_rd_1,
/* 1011 0110 0011 */ &move_irso_rd_1,
/* 1011 0110 0100 */ &move_irso_rd_1,
/* 1011 0110 0101 */ &move_irso_rd_1,
/* 1011 0110 0110 */ &move_irso_rd_1,
/* 1011 0110 0111 */ &move_irso_rd_1,
/* 1011 0110 1000 */ &move_irso_rd_1,
/* 1011 0110 1001 */ &move_irso_rd_1,
/* 1011 0110 1010 */ &move_irso_rd_1,
/* 1011 0110 1011 */ &move_irso_rd_1,
/* 1011 0110 1100 */ &move_irso_rd_1,
/* 1011 0110 1101 */ &move_irso_rd_1,
/* 1011 0110 1110 */ &move_irso_rd_1,
/* 1011 0110 1111 */ &move_irso_rd_1,

/* 1011 0111 0000 */ &move_irso_rd_1,
/* 1011 0111 0001 */ &move_irso_rd_1,
/* 1011 0111 0010 */ &move_irso_rd_1,
/* 1011 0111 0011 */ &move_irso_rd_1,
/* 1011 0111 0100 */ &move_irso_rd_1,
/* 1011 0111 0101 */ &move_irso_rd_1,
/* 1011 0111 0110 */ &move_irso_rd_1,
/* 1011 0111 0111 */ &move_irso_rd_1,
/* 1011 0111 1000 */ &move_irso_rd_1,
/* 1011 0111 1001 */ &move_irso_rd_1,
/* 1011 0111 1010 */ &move_irso_rd_1,
/* 1011 0111 1011 */ &move_irso_rd_1,
/* 1011 0111 1100 */ &move_irso_rd_1,
/* 1011 0111 1101 */ &move_irso_rd_1,
/* 1011 0111 1110 */ &move_irso_rd_1,
/* 1011 0111 1111 */ &move_irso_rd_1,

/* 1011 1000 0000 */ &move_irso_irdo_0,
/* 1011 1000 0001 */ &move_irso_irdo_0,
/* 1011 1000 0010 */ &move_irso_irdo_0,
/* 1011 1000 0011 */ &move_irso_irdo_0,
/* 1011 1000 0100 */ &move_irso_irdo_0,
/* 1011 1000 0101 */ &move_irso_irdo_0,
/* 1011 1000 0110 */ &move_irso_irdo_0,
/* 1011 1000 0111 */ &move_irso_irdo_0,
/* 1011 1000 1000 */ &move_irso_irdo_0,
/* 1011 1000 1001 */ &move_irso_irdo_0,
/* 1011 1000 1010 */ &move_irso_irdo_0,
/* 1011 1000 1011 */ &move_irso_irdo_0,
/* 1011 1000 1100 */ &move_irso_irdo_0,
/* 1011 1000 1101 */ &move_irso_irdo_0,
/* 1011 1000 1110 */ &move_irso_irdo_0,
/* 1011 1000 1111 */ &move_irso_irdo_0,

/* 1011 1001 0000 */ &move_irso_irdo_0,
/* 1011 1001 0001 */ &move_irso_irdo_0,
/* 1011 1001 0010 */ &move_irso_irdo_0,
/* 1011 1001 0011 */ &move_irso_irdo_0,
/* 1011 1001 0100 */ &move_irso_irdo_0,
/* 1011 1001 0101 */ &move_irso_irdo_0,
/* 1011 1001 0110 */ &move_irso_irdo_0,
/* 1011 1001 0111 */ &move_irso_irdo_0,
/* 1011 1001 1000 */ &move_irso_irdo_0,
/* 1011 1001 1001 */ &move_irso_irdo_0,
/* 1011 1001 1010 */ &move_irso_irdo_0,
/* 1011 1001 1011 */ &move_irso_irdo_0,
/* 1011 1001 1100 */ &move_irso_irdo_0,
/* 1011 1001 1101 */ &move_irso_irdo_0,
/* 1011 1001 1110 */ &move_irso_irdo_0,
/* 1011 1001 1111 */ &move_irso_irdo_0,

/* 1011 1010 0000 */ &move_irso_irdo_1,
/* 1011 1010 0001 */ &move_irso_irdo_1,
/* 1011 1010 0010 */ &move_irso_irdo_1,
/* 1011 1010 0011 */ &move_irso_irdo_1,
/* 1011 1010 0100 */ &move_irso_irdo_1,
/* 1011 1010 0101 */ &move_irso_irdo_1,
/* 1011 1010 0110 */ &move_irso_irdo_1,
/* 1011 1010 0111 */ &move_irso_irdo_1,
/* 1011 1010 1000 */ &move_irso_irdo_1,
/* 1011 1010 1001 */ &move_irso_irdo_1,
/* 1011 1010 1010 */ &move_irso_irdo_1,
/* 1011 1010 1011 */ &move_irso_irdo_1,
/* 1011 1010 1100 */ &move_irso_irdo_1,
/* 1011 1010 1101 */ &move_irso_irdo_1,
/* 1011 1010 1110 */ &move_irso_irdo_1,
/* 1011 1010 1111 */ &move_irso_irdo_1,

/* 1011 1011 0000 */ &move_irso_irdo_1,
/* 1011 1011 0001 */ &move_irso_irdo_1,
/* 1011 1011 0010 */ &move_irso_irdo_1,
/* 1011 1011 0011 */ &move_irso_irdo_1,
/* 1011 1011 0100 */ &move_irso_irdo_1,
/* 1011 1011 0101 */ &move_irso_irdo_1,
/* 1011 1011 0110 */ &move_irso_irdo_1,
/* 1011 1011 0111 */ &move_irso_irdo_1,
/* 1011 1011 1000 */ &move_irso_irdo_1,
/* 1011 1011 1001 */ &move_irso_irdo_1,
/* 1011 1011 1010 */ &move_irso_irdo_1,
/* 1011 1011 1011 */ &move_irso_irdo_1,
/* 1011 1011 1100 */ &move_irso_irdo_1,
/* 1011 1011 1101 */ &move_irso_irdo_1,
/* 1011 1011 1110 */ &move_irso_irdo_1,
/* 1011 1011 1111 */ &move_irso_irdo_1,

/* 1011 1100 0000 */ &movb_irso_irdo,
/* 1011 1100 0001 */ &movb_irso_irdo,
/* 1011 1100 0010 */ &movb_irso_irdo,
/* 1011 1100 0011 */ &movb_irso_irdo,
/* 1011 1100 0100 */ &movb_irso_irdo,
/* 1011 1100 0101 */ &movb_irso_irdo,
/* 1011 1100 0110 */ &movb_irso_irdo,
/* 1011 1100 0111 */ &movb_irso_irdo,
/* 1011 1100 1000 */ &movb_irso_irdo,
/* 1011 1100 1001 */ &movb_irso_irdo,
/* 1011 1100 1010 */ &movb_irso_irdo,
/* 1011 1100 1011 */ &movb_irso_irdo,
/* 1011 1100 1100 */ &movb_irso_irdo,
/* 1011 1100 1101 */ &movb_irso_irdo,
/* 1011 1100 1110 */ &movb_irso_irdo,
/* 1011 1100 1111 */ &movb_irso_irdo,

/* 1011 1101 0000 */ &movb_irso_irdo,
/* 1011 1101 0001 */ &movb_irso_irdo,
/* 1011 1101 0010 */ &movb_irso_irdo,
/* 1011 1101 0011 */ &movb_irso_irdo,
/* 1011 1101 0100 */ &movb_irso_irdo,
/* 1011 1101 0101 */ &movb_irso_irdo,
/* 1011 1101 0110 */ &movb_irso_irdo,
/* 1011 1101 0111 */ &movb_irso_irdo,
/* 1011 1101 1000 */ &movb_irso_irdo,
/* 1011 1101 1001 */ &movb_irso_irdo,
/* 1011 1101 1010 */ &movb_irso_irdo,
/* 1011 1101 1011 */ &movb_irso_irdo,
/* 1011 1101 1100 */ &movb_irso_irdo,
/* 1011 1101 1101 */ &movb_irso_irdo,
/* 1011 1101 1110 */ &movb_irso_irdo,
/* 1011 1101 1111 */ &movb_irso_irdo,

/* 1011 1110 0000 */ &unimplemented,
/* 1011 1110 0001 */ &unimplemented,
/* 1011 1110 0010 */ &unimplemented,
/* 1011 1110 0011 */ &unimplemented,
/* 1011 1110 0100 */ &unimplemented,
/* 1011 1110 0101 */ &unimplemented,
/* 1011 1110 0110 */ &unimplemented,
/* 1011 1110 0111 */ &unimplemented,
/* 1011 1110 1000 */ &unimplemented,
/* 1011 1110 1001 */ &unimplemented,
/* 1011 1110 1010 */ &unimplemented,
/* 1011 1110 1011 */ &unimplemented,
/* 1011 1110 1100 */ &unimplemented,
/* 1011 1110 1101 */ &unimplemented,
/* 1011 1110 1110 */ &unimplemented,
/* 1011 1110 1111 */ &unimplemented,

/* 1011 1111 0000 */ &unimplemented,
/* 1011 1111 0001 */ &unimplemented,
/* 1011 1111 0010 */ &unimplemented,
/* 1011 1111 0011 */ &unimplemented,
/* 1011 1111 0100 */ &unimplemented,
/* 1011 1111 0101 */ &unimplemented,
/* 1011 1111 0110 */ &unimplemented,
/* 1011 1111 0111 */ &unimplemented,
/* 1011 1111 1000 */ &unimplemented,
/* 1011 1111 1001 */ &unimplemented,
/* 1011 1111 1010 */ &unimplemented,
/* 1011 1111 1011 */ &unimplemented,
/* 1011 1111 1100 */ &unimplemented,
/* 1011 1111 1101 */ &unimplemented,
/* 1011 1111 1110 */ &unimplemented,
/* 1011 1111 1111 */ &unimplemented,

/* 1100 0000 0000 */ &jr_uc_0,
/* 1100 0000 0001 */ &jr_uc,
/* 1100 0000 0010 */ &jr_uc,
/* 1100 0000 0011 */ &jr_uc,
/* 1100 0000 0100 */ &jr_uc,
/* 1100 0000 0101 */ &jr_uc,
/* 1100 0000 0110 */ &jr_uc,
/* 1100 0000 0111 */ &jr_uc,
/* 1100 0000 1000 */ &jr_uc_8,
/* 1100 0000 1001 */ &jr_uc,
/* 1100 0000 1010 */ &jr_uc,
/* 1100 0000 1011 */ &jr_uc,
/* 1100 0000 1100 */ &jr_uc,
/* 1100 0000 1101 */ &jr_uc,
/* 1100 0000 1110 */ &jr_uc,
/* 1100 0000 1111 */ &jr_uc,

/* 1100 0001 0000 */ &jr_p_0,
/* 1100 0001 0001 */ &jr_p,
/* 1100 0001 0010 */ &jr_p,
/* 1100 0001 0011 */ &jr_p,
/* 1100 0001 0100 */ &jr_p,
/* 1100 0001 0101 */ &jr_p,
/* 1100 0001 0110 */ &jr_p,
/* 1100 0001 0111 */ &jr_p,
/* 1100 0001 1000 */ &jr_p_8,
/* 1100 0001 1001 */ &jr_p,
/* 1100 0001 1010 */ &jr_p,
/* 1100 0001 1011 */ &jr_p,
/* 1100 0001 1100 */ &jr_p,
/* 1100 0001 1101 */ &jr_p,
/* 1100 0001 1110 */ &jr_p,
/* 1100 0001 1111 */ &jr_p,

/* 1100 0010 0000 */ &jr_ls_0,
/* 1100 0010 0001 */ &jr_ls,
/* 1100 0010 0010 */ &jr_ls,
/* 1100 0010 0011 */ &jr_ls,
/* 1100 0010 0100 */ &jr_ls,
/* 1100 0010 0101 */ &jr_ls,
/* 1100 0010 0110 */ &jr_ls,
/* 1100 0010 0111 */ &jr_ls,
/* 1100 0010 1000 */ &jr_ls_8,
/* 1100 0010 1001 */ &jr_ls,
/* 1100 0010 1010 */ &jr_ls,
/* 1100 0010 1011 */ &jr_ls,
/* 1100 0010 1100 */ &jr_ls,
/* 1100 0010 1101 */ &jr_ls,
/* 1100 0010 1110 */ &jr_ls,
/* 1100 0010 1111 */ &jr_ls,

/* 1100 0011 0000 */ &jr_hi_0,
/* 1100 0011 0001 */ &jr_hi,
/* 1100 0011 0010 */ &jr_hi,
/* 1100 0011 0011 */ &jr_hi,
/* 1100 0011 0100 */ &jr_hi,
/* 1100 0011 0101 */ &jr_hi,
/* 1100 0011 0110 */ &jr_hi,
/* 1100 0011 0111 */ &jr_hi,
/* 1100 0011 1000 */ &jr_hi_8,
/* 1100 0011 1001 */ &jr_hi,
/* 1100 0011 1010 */ &jr_hi,
/* 1100 0011 1011 */ &jr_hi,
/* 1100 0011 1100 */ &jr_hi,
/* 1100 0011 1101 */ &jr_hi,
/* 1100 0011 1110 */ &jr_hi,
/* 1100 0011 1111 */ &jr_hi,

/* 1100 0100 0000 */ &jr_lt_0,
/* 1100 0100 0001 */ &jr_lt,
/* 1100 0100 0010 */ &jr_lt,
/* 1100 0100 0011 */ &jr_lt,
/* 1100 0100 0100 */ &jr_lt,
/* 1100 0100 0101 */ &jr_lt,
/* 1100 0100 0110 */ &jr_lt,
/* 1100 0100 0111 */ &jr_lt,
/* 1100 0100 1000 */ &jr_lt_8,
/* 1100 0100 1001 */ &jr_lt,
/* 1100 0100 1010 */ &jr_lt,
/* 1100 0100 1011 */ &jr_lt,
/* 1100 0100 1100 */ &jr_lt,
/* 1100 0100 1101 */ &jr_lt,
/* 1100 0100 1110 */ &jr_lt,
/* 1100 0100 1111 */ &jr_lt,

/* 1100 0101 0000 */ &jr_ge_0,
/* 1100 0101 0001 */ &jr_ge,
/* 1100 0101 0010 */ &jr_ge,
/* 1100 0101 0011 */ &jr_ge,
/* 1100 0101 0100 */ &jr_ge,
/* 1100 0101 0101 */ &jr_ge,
/* 1100 0101 0110 */ &jr_ge,
/* 1100 0101 0111 */ &jr_ge,
/* 1100 0101 1000 */ &jr_ge_8,
/* 1100 0101 1001 */ &jr_ge,
/* 1100 0101 1010 */ &jr_ge,
/* 1100 0101 1011 */ &jr_ge,
/* 1100 0101 1100 */ &jr_ge,
/* 1100 0101 1101 */ &jr_ge,
/* 1100 0101 1110 */ &jr_ge,
/* 1100 0101 1111 */ &jr_ge,

/* 1100 0110 0000 */ &jr_le_0,
/* 1100 0110 0001 */ &jr_le,
/* 1100 0110 0010 */ &jr_le,
/* 1100 0110 0011 */ &jr_le,
/* 1100 0110 0100 */ &jr_le,
/* 1100 0110 0101 */ &jr_le,
/* 1100 0110 0110 */ &jr_le,
/* 1100 0110 0111 */ &jr_le,
/* 1100 0110 1000 */ &jr_le_8,
/* 1100 0110 1001 */ &jr_le,
/* 1100 0110 1010 */ &jr_le,
/* 1100 0110 1011 */ &jr_le,
/* 1100 0110 1100 */ &jr_le,
/* 1100 0110 1101 */ &jr_le,
/* 1100 0110 1110 */ &jr_le,
/* 1100 0110 1111 */ &jr_le,

/* 1100 0111 0000 */ &jr_gt_0,
/* 1100 0111 0001 */ &jr_gt,
/* 1100 0111 0010 */ &jr_gt,
/* 1100 0111 0011 */ &jr_gt,
/* 1100 0111 0100 */ &jr_gt,
/* 1100 0111 0101 */ &jr_gt,
/* 1100 0111 0110 */ &jr_gt,
/* 1100 0111 0111 */ &jr_gt,
/* 1100 0111 1000 */ &jr_gt_8,
/* 1100 0111 1001 */ &jr_gt,
/* 1100 0111 1010 */ &jr_gt,
/* 1100 0111 1011 */ &jr_gt,
/* 1100 0111 1100 */ &jr_gt,
/* 1100 0111 1101 */ &jr_gt,
/* 1100 0111 1110 */ &jr_gt,
/* 1100 0111 1111 */ &jr_gt,

/* 1100 1000 0000 */ &jr_c_0,
/* 1100 1000 0001 */ &jr_c,
/* 1100 1000 0010 */ &jr_c,
/* 1100 1000 0011 */ &jr_c,
/* 1100 1000 0100 */ &jr_c,
/* 1100 1000 0101 */ &jr_c,
/* 1100 1000 0110 */ &jr_c,
/* 1100 1000 0111 */ &jr_c,
/* 1100 1000 1000 */ &jr_c_8,
/* 1100 1000 1001 */ &jr_c,
/* 1100 1000 1010 */ &jr_c,
/* 1100 1000 1011 */ &jr_c,
/* 1100 1000 1100 */ &jr_c,
/* 1100 1000 1101 */ &jr_c,
/* 1100 1000 1110 */ &jr_c,
/* 1100 1000 1111 */ &jr_c,

/* 1100 1001 0000 */ &jr_nc_0,
/* 1100 1001 0001 */ &jr_nc,
/* 1100 1001 0010 */ &jr_nc,
/* 1100 1001 0011 */ &jr_nc,
/* 1100 1001 0100 */ &jr_nc,
/* 1100 1001 0101 */ &jr_nc,
/* 1100 1001 0110 */ &jr_nc,
/* 1100 1001 0111 */ &jr_nc,
/* 1100 1001 1000 */ &jr_nc_8,
/* 1100 1001 1001 */ &jr_nc,
/* 1100 1001 1010 */ &jr_nc,
/* 1100 1001 1011 */ &jr_nc,
/* 1100 1001 1100 */ &jr_nc,
/* 1100 1001 1101 */ &jr_nc,
/* 1100 1001 1110 */ &jr_nc,
/* 1100 1001 1111 */ &jr_nc,

/* 1100 1010 0000 */ &jr_eq_0,
/* 1100 1010 0001 */ &jr_eq,
/* 1100 1010 0010 */ &jr_eq,
/* 1100 1010 0011 */ &jr_eq,
/* 1100 1010 0100 */ &jr_eq,
/* 1100 1010 0101 */ &jr_eq,
/* 1100 1010 0110 */ &jr_eq,
/* 1100 1010 0111 */ &jr_eq,
/* 1100 1010 1000 */ &jr_eq_8,
/* 1100 1010 1001 */ &jr_eq,
/* 1100 1010 1010 */ &jr_eq,
/* 1100 1010 1011 */ &jr_eq,
/* 1100 1010 1100 */ &jr_eq,
/* 1100 1010 1101 */ &jr_eq,
/* 1100 1010 1110 */ &jr_eq,
/* 1100 1010 1111 */ &jr_eq,

/* 1100 1011 0000 */ &jr_ne_0,
/* 1100 1011 0001 */ &jr_ne,
/* 1100 1011 0010 */ &jr_ne,
/* 1100 1011 0011 */ &jr_ne,
/* 1100 1011 0100 */ &jr_ne,
/* 1100 1011 0101 */ &jr_ne,
/* 1100 1011 0110 */ &jr_ne,
/* 1100 1011 0111 */ &jr_ne,
/* 1100 1011 1000 */ &jr_ne_8,
/* 1100 1011 1001 */ &jr_ne,
/* 1100 1011 1010 */ &jr_ne,
/* 1100 1011 1011 */ &jr_ne,
/* 1100 1011 1100 */ &jr_ne,
/* 1100 1011 1101 */ &jr_ne,
/* 1100 1011 1110 */ &jr_ne,
/* 1100 1011 1111 */ &jr_ne,

/* 1100 1100 0000 */ &jr_v_0,
/* 1100 1100 0001 */ &jr_v,
/* 1100 1100 0010 */ &jr_v,
/* 1100 1100 0011 */ &jr_v,
/* 1100 1100 0100 */ &jr_v,
/* 1100 1100 0101 */ &jr_v,
/* 1100 1100 0110 */ &jr_v,
/* 1100 1100 0111 */ &jr_v,
/* 1100 1100 1000 */ &jr_v_8,
/* 1100 1100 1001 */ &jr_v,
/* 1100 1100 1010 */ &jr_v,
/* 1100 1100 1011 */ &jr_v,
/* 1100 1100 1100 */ &jr_v,
/* 1100 1100 1101 */ &jr_v,
/* 1100 1100 1110 */ &jr_v,
/* 1100 1100 1111 */ &jr_v,

/* 1100 1101 0000 */ &jr_nv_0,
/* 1100 1101 0001 */ &jr_nv,
/* 1100 1101 0010 */ &jr_nv,
/* 1100 1101 0011 */ &jr_nv,
/* 1100 1101 0100 */ &jr_nv,
/* 1100 1101 0101 */ &jr_nv,
/* 1100 1101 0110 */ &jr_nv,
/* 1100 1101 0111 */ &jr_nv,
/* 1100 1101 1000 */ &jr_nv_8,
/* 1100 1101 1001 */ &jr_nv,
/* 1100 1101 1010 */ &jr_nv,
/* 1100 1101 1011 */ &jr_nv,
/* 1100 1101 1100 */ &jr_nv,
/* 1100 1101 1101 */ &jr_nv,
/* 1100 1101 1110 */ &jr_nv,
/* 1100 1101 1111 */ &jr_nv,

/* 1100 1110 0000 */ &jr_n_0,
/* 1100 1110 0001 */ &jr_n,
/* 1100 1110 0010 */ &jr_n,
/* 1100 1110 0011 */ &jr_n,
/* 1100 1110 0100 */ &jr_n,
/* 1100 1110 0101 */ &jr_n,
/* 1100 1110 0110 */ &jr_n,
/* 1100 1110 0111 */ &jr_n,
/* 1100 1110 1000 */ &jr_n_8,
/* 1100 1110 1001 */ &jr_n,
/* 1100 1110 1010 */ &jr_n,
/* 1100 1110 1011 */ &jr_n,
/* 1100 1110 1100 */ &jr_n,
/* 1100 1110 1101 */ &jr_n,
/* 1100 1110 1110 */ &jr_n,
/* 1100 1110 1111 */ &jr_n,

/* 1100 1111 0000 */ &jr_nn_0,
/* 1100 1111 0001 */ &jr_nn,
/* 1100 1111 0010 */ &jr_nn,
/* 1100 1111 0011 */ &jr_nn,
/* 1100 1111 0100 */ &jr_nn,
/* 1100 1111 0101 */ &jr_nn,
/* 1100 1111 0110 */ &jr_nn,
/* 1100 1111 0111 */ &jr_nn,
/* 1100 1111 1000 */ &jr_nn_8,
/* 1100 1111 1001 */ &jr_nn,
/* 1100 1111 1010 */ &jr_nn,
/* 1100 1111 1011 */ &jr_nn,
/* 1100 1111 1100 */ &jr_nn,
/* 1100 1111 1101 */ &jr_nn,
/* 1100 1111 1110 */ &jr_nn,
/* 1100 1111 1111 */ &jr_nn,

/* 1101 0000 0000 */ &move_irso_irdp_0,
/* 1101 0000 0001 */ &move_irso_irdp_0,
/* 1101 0000 0010 */ &move_irso_irdp_0,
/* 1101 0000 0011 */ &move_irso_irdp_0,
/* 1101 0000 0100 */ &move_irso_irdp_0,
/* 1101 0000 0101 */ &move_irso_irdp_0,
/* 1101 0000 0110 */ &move_irso_irdp_0,
/* 1101 0000 0111 */ &move_irso_irdp_0,
/* 1101 0000 1000 */ &move_irso_irdp_0,
/* 1101 0000 1001 */ &move_irso_irdp_0,
/* 1101 0000 1010 */ &move_irso_irdp_0,
/* 1101 0000 1011 */ &move_irso_irdp_0,
/* 1101 0000 1100 */ &move_irso_irdp_0,
/* 1101 0000 1101 */ &move_irso_irdp_0,
/* 1101 0000 1110 */ &move_irso_irdp_0,
/* 1101 0000 1111 */ &move_irso_irdp_0,

/* 1101 0001 0000 */ &move_irso_irdp_0,
/* 1101 0001 0001 */ &move_irso_irdp_0,
/* 1101 0001 0010 */ &move_irso_irdp_0,
/* 1101 0001 0011 */ &move_irso_irdp_0,
/* 1101 0001 0100 */ &move_irso_irdp_0,
/* 1101 0001 0101 */ &move_irso_irdp_0,
/* 1101 0001 0110 */ &move_irso_irdp_0,
/* 1101 0001 0111 */ &move_irso_irdp_0,
/* 1101 0001 1000 */ &move_irso_irdp_0,
/* 1101 0001 1001 */ &move_irso_irdp_0,
/* 1101 0001 1010 */ &move_irso_irdp_0,
/* 1101 0001 1011 */ &move_irso_irdp_0,
/* 1101 0001 1100 */ &move_irso_irdp_0,
/* 1101 0001 1101 */ &move_irso_irdp_0,
/* 1101 0001 1110 */ &move_irso_irdp_0,
/* 1101 0001 1111 */ &move_irso_irdp_0,

/* 1101 0010 0000 */ &move_irso_irdp_1,
/* 1101 0010 0001 */ &move_irso_irdp_1,
/* 1101 0010 0010 */ &move_irso_irdp_1,
/* 1101 0010 0011 */ &move_irso_irdp_1,
/* 1101 0010 0100 */ &move_irso_irdp_1,
/* 1101 0010 0101 */ &move_irso_irdp_1,
/* 1101 0010 0110 */ &move_irso_irdp_1,
/* 1101 0010 0111 */ &move_irso_irdp_1,
/* 1101 0010 1000 */ &move_irso_irdp_1,
/* 1101 0010 1001 */ &move_irso_irdp_1,
/* 1101 0010 1010 */ &move_irso_irdp_1,
/* 1101 0010 1011 */ &move_irso_irdp_1,
/* 1101 0010 1100 */ &move_irso_irdp_1,
/* 1101 0010 1101 */ &move_irso_irdp_1,
/* 1101 0010 1110 */ &move_irso_irdp_1,
/* 1101 0010 1111 */ &move_irso_irdp_1,

/* 1101 0011 0000 */ &move_irso_irdp_1,
/* 1101 0011 0001 */ &move_irso_irdp_1,
/* 1101 0011 0010 */ &move_irso_irdp_1,
/* 1101 0011 0011 */ &move_irso_irdp_1,
/* 1101 0011 0100 */ &move_irso_irdp_1,
/* 1101 0011 0101 */ &move_irso_irdp_1,
/* 1101 0011 0110 */ &move_irso_irdp_1,
/* 1101 0011 0111 */ &move_irso_irdp_1,
/* 1101 0011 1000 */ &move_irso_irdp_1,
/* 1101 0011 1001 */ &move_irso_irdp_1,
/* 1101 0011 1010 */ &move_irso_irdp_1,
/* 1101 0011 1011 */ &move_irso_irdp_1,
/* 1101 0011 1100 */ &move_irso_irdp_1,
/* 1101 0011 1101 */ &move_irso_irdp_1,
/* 1101 0011 1110 */ &move_irso_irdp_1,
/* 1101 0011 1111 */ &move_irso_irdp_1,

/* 1101 0100 0000 */ &move_addr_irsp_0,
/* 1101 0100 0001 */ &move_addr_irsp_0,
/* 1101 0100 0010 */ &unimplemented,
/* 1101 0100 0011 */ &unimplemented,
/* 1101 0100 0100 */ &unimplemented,
/* 1101 0100 0101 */ &unimplemented,
/* 1101 0100 0110 */ &unimplemented,
/* 1101 0100 0111 */ &unimplemented,
/* 1101 0100 1000 */ &unimplemented,
/* 1101 0100 1001 */ &unimplemented,
/* 1101 0100 1010 */ &unimplemented,
/* 1101 0100 1011 */ &unimplemented,
/* 1101 0100 1100 */ &unimplemented,
/* 1101 0100 1101 */ &unimplemented,
/* 1101 0100 1110 */ &unimplemented,
/* 1101 0100 1111 */ &unimplemented,

/* 1101 0101 0000 */ &exgf_rd_0,
/* 1101 0101 0001 */ &exgf_rd_0,
/* 1101 0101 0010 */ &unimplemented,
/* 1101 0101 0011 */ &unimplemented,
/* 1101 0101 0100 */ &unimplemented,
/* 1101 0101 0101 */ &unimplemented,
/* 1101 0101 0110 */ &unimplemented,
/* 1101 0101 0111 */ &unimplemented,
/* 1101 0101 1000 */ &unimplemented,
/* 1101 0101 1001 */ &unimplemented,
/* 1101 0101 1010 */ &unimplemented,
/* 1101 0101 1011 */ &unimplemented,
/* 1101 0101 1100 */ &unimplemented,
/* 1101 0101 1101 */ &unimplemented,
/* 1101 0101 1110 */ &unimplemented,
/* 1101 0101 1111 */ &unimplemented,

/* 1101 0110 0000 */ &move_addr_irsp_1,
/* 1101 0110 0001 */ &move_addr_irsp_1,
/* 1101 0110 0010 */ &unimplemented,
/* 1101 0110 0011 */ &unimplemented,
/* 1101 0110 0100 */ &unimplemented,
/* 1101 0110 0101 */ &unimplemented,
/* 1101 0110 0110 */ &unimplemented,
/* 1101 0110 0111 */ &unimplemented,
/* 1101 0110 1000 */ &unimplemented,
/* 1101 0110 1001 */ &unimplemented,
/* 1101 0110 1010 */ &unimplemented,
/* 1101 0110 1011 */ &unimplemented,
/* 1101 0110 1100 */ &unimplemented,
/* 1101 0110 1101 */ &unimplemented,
/* 1101 0110 1110 */ &unimplemented,
/* 1101 0110 1111 */ &unimplemented,

/* 1101 0111 0000 */ &exgf_rd_1,
/* 1101 0111 0001 */ &exgf_rd_1,
/* 1101 0111 0010 */ &unimplemented,
/* 1101 0111 0011 */ &unimplemented,
/* 1101 0111 0100 */ &unimplemented,
/* 1101 0111 0101 */ &unimplemented,
/* 1101 0111 0110 */ &unimplemented,
/* 1101 0111 0111 */ &unimplemented,
/* 1101 0111 1000 */ &unimplemented,
/* 1101 0111 1001 */ &unimplemented,
/* 1101 0111 1010 */ &unimplemented,
/* 1101 0111 1011 */ &unimplemented,
/* 1101 0111 1100 */ &unimplemented,
/* 1101 0111 1101 */ &unimplemented,
/* 1101 0111 1110 */ &unimplemented,
/* 1101 0111 1111 */ &unimplemented,

/* 1101 1000 0000 */ &unimplemented,
/* 1101 1000 0001 */ &unimplemented,
/* 1101 1000 0010 */ &unimplemented,
/* 1101 1000 0011 */ &unimplemented,
/* 1101 1000 0100 */ &unimplemented,
/* 1101 1000 0101 */ &unimplemented,
/* 1101 1000 0110 */ &unimplemented,
/* 1101 1000 0111 */ &unimplemented,
/* 1101 1000 1000 */ &unimplemented,
/* 1101 1000 1001 */ &unimplemented,
/* 1101 1000 1010 */ &unimplemented,
/* 1101 1000 1011 */ &unimplemented,
/* 1101 1000 1100 */ &unimplemented,
/* 1101 1000 1101 */ &unimplemented,
/* 1101 1000 1110 */ &unimplemented,
/* 1101 1000 1111 */ &unimplemented,

/* 1101 1001 0000 */ &unimplemented,
/* 1101 1001 0001 */ &unimplemented,
/* 1101 1001 0010 */ &unimplemented,
/* 1101 1001 0011 */ &unimplemented,
/* 1101 1001 0100 */ &unimplemented,
/* 1101 1001 0101 */ &unimplemented,
/* 1101 1001 0110 */ &unimplemented,
/* 1101 1001 0111 */ &unimplemented,
/* 1101 1001 1000 */ &unimplemented,
/* 1101 1001 1001 */ &unimplemented,
/* 1101 1001 1010 */ &unimplemented,
/* 1101 1001 1011 */ &unimplemented,
/* 1101 1001 1100 */ &unimplemented,
/* 1101 1001 1101 */ &unimplemented,
/* 1101 1001 1110 */ &unimplemented,
/* 1101 1001 1111 */ &unimplemented,

/* 1101 1010 0000 */ &unimplemented,
/* 1101 1010 0001 */ &unimplemented,
/* 1101 1010 0010 */ &unimplemented,
/* 1101 1010 0011 */ &unimplemented,
/* 1101 1010 0100 */ &unimplemented,
/* 1101 1010 0101 */ &unimplemented,
/* 1101 1010 0110 */ &unimplemented,
/* 1101 1010 0111 */ &unimplemented,
/* 1101 1010 1000 */ &unimplemented,
/* 1101 1010 1001 */ &unimplemented,
/* 1101 1010 1010 */ &unimplemented,
/* 1101 1010 1011 */ &unimplemented,
/* 1101 1010 1100 */ &unimplemented,
/* 1101 1010 1101 */ &unimplemented,
/* 1101 1010 1110 */ &unimplemented,
/* 1101 1010 1111 */ &unimplemented,

/* 1101 1011 0000 */ &unimplemented,
/* 1101 1011 0001 */ &unimplemented,
/* 1101 1011 0010 */ &unimplemented,
/* 1101 1011 0011 */ &unimplemented,
/* 1101 1011 0100 */ &unimplemented,
/* 1101 1011 0101 */ &unimplemented,
/* 1101 1011 0110 */ &unimplemented,
/* 1101 1011 0111 */ &unimplemented,
/* 1101 1011 1000 */ &unimplemented,
/* 1101 1011 1001 */ &unimplemented,
/* 1101 1011 1010 */ &unimplemented,
/* 1101 1011 1011 */ &unimplemented,
/* 1101 1011 1100 */ &unimplemented,
/* 1101 1011 1101 */ &unimplemented,
/* 1101 1011 1110 */ &unimplemented,
/* 1101 1011 1111 */ &unimplemented,

/* 1101 1100 0000 */ &unimplemented,
/* 1101 1100 0001 */ &unimplemented,
/* 1101 1100 0010 */ &unimplemented,
/* 1101 1100 0011 */ &unimplemented,
/* 1101 1100 0100 */ &unimplemented,
/* 1101 1100 0101 */ &unimplemented,
/* 1101 1100 0110 */ &unimplemented,
/* 1101 1100 0111 */ &unimplemented,
/* 1101 1100 1000 */ &unimplemented,
/* 1101 1100 1001 */ &unimplemented,
/* 1101 1100 1010 */ &unimplemented,
/* 1101 1100 1011 */ &unimplemented,
/* 1101 1100 1100 */ &unimplemented,
/* 1101 1100 1101 */ &unimplemented,
/* 1101 1100 1110 */ &unimplemented,
/* 1101 1100 1111 */ &unimplemented,

/* 1101 1101 0000 */ &unimplemented,
/* 1101 1101 0001 */ &unimplemented,
/* 1101 1101 0010 */ &unimplemented,
/* 1101 1101 0011 */ &unimplemented,
/* 1101 1101 0100 */ &unimplemented,
/* 1101 1101 0101 */ &unimplemented,
/* 1101 1101 0110 */ &unimplemented,
/* 1101 1101 0111 */ &unimplemented,
/* 1101 1101 1000 */ &unimplemented,
/* 1101 1101 1001 */ &unimplemented,
/* 1101 1101 1010 */ &unimplemented,
/* 1101 1101 1011 */ &unimplemented,
/* 1101 1101 1100 */ &unimplemented,
/* 1101 1101 1101 */ &unimplemented,
/* 1101 1101 1110 */ &unimplemented,
/* 1101 1101 1111 */ &unimplemented,

/* 1101 1110 0000 */ &unimplemented,
/* 1101 1110 0001 */ &unimplemented,
/* 1101 1110 0010 */ &unimplemented,
/* 1101 1110 0011 */ &unimplemented,
/* 1101 1110 0100 */ &unimplemented,
/* 1101 1110 0101 */ &unimplemented,
/* 1101 1110 0110 */ &unimplemented,
/* 1101 1110 0111 */ &unimplemented,
/* 1101 1110 1000 */ &unimplemented,
/* 1101 1110 1001 */ &unimplemented,
/* 1101 1110 1010 */ &unimplemented,
/* 1101 1110 1011 */ &unimplemented,
/* 1101 1110 1100 */ &unimplemented,
/* 1101 1110 1101 */ &unimplemented,
/* 1101 1110 1110 */ &unimplemented,
/* 1101 1110 1111 */ &unimplemented,

/* 1101 1111 0000 */ &unimplemented,
/* 1101 1111 0001 */ &unimplemented,
/* 1101 1111 0010 */ &unimplemented,
/* 1101 1111 0011 */ &unimplemented,
/* 1101 1111 0100 */ &unimplemented,
/* 1101 1111 0101 */ &unimplemented,
/* 1101 1111 0110 */ &unimplemented,
/* 1101 1111 0111 */ &unimplemented,
/* 1101 1111 1000 */ &unimplemented,
/* 1101 1111 1001 */ &unimplemented,
/* 1101 1111 1010 */ &unimplemented,
/* 1101 1111 1011 */ &unimplemented,
/* 1101 1111 1100 */ &unimplemented,
/* 1101 1111 1101 */ &unimplemented,
/* 1101 1111 1110 */ &unimplemented,
/* 1101 1111 1111 */ &unimplemented,

/* 1110 0000 0000 */ &addxy_rs_rd,
/* 1110 0000 0001 */ &addxy_rs_rd,
/* 1110 0000 0010 */ &addxy_rs_rd,
/* 1110 0000 0011 */ &addxy_rs_rd,
/* 1110 0000 0100 */ &addxy_rs_rd,
/* 1110 0000 0101 */ &addxy_rs_rd,
/* 1110 0000 0110 */ &addxy_rs_rd,
/* 1110 0000 0111 */ &addxy_rs_rd,
/* 1110 0000 1000 */ &addxy_rs_rd,
/* 1110 0000 1001 */ &addxy_rs_rd,
/* 1110 0000 1010 */ &addxy_rs_rd,
/* 1110 0000 1011 */ &addxy_rs_rd,
/* 1110 0000 1100 */ &addxy_rs_rd,
/* 1110 0000 1101 */ &addxy_rs_rd,
/* 1110 0000 1110 */ &addxy_rs_rd,
/* 1110 0000 1111 */ &addxy_rs_rd,

/* 1110 0001 0000 */ &addxy_rs_rd,
/* 1110 0001 0001 */ &addxy_rs_rd,
/* 1110 0001 0010 */ &addxy_rs_rd,
/* 1110 0001 0011 */ &addxy_rs_rd,
/* 1110 0001 0100 */ &addxy_rs_rd,
/* 1110 0001 0101 */ &addxy_rs_rd,
/* 1110 0001 0110 */ &addxy_rs_rd,
/* 1110 0001 0111 */ &addxy_rs_rd,
/* 1110 0001 1000 */ &addxy_rs_rd,
/* 1110 0001 1001 */ &addxy_rs_rd,
/* 1110 0001 1010 */ &addxy_rs_rd,
/* 1110 0001 1011 */ &addxy_rs_rd,
/* 1110 0001 1100 */ &addxy_rs_rd,
/* 1110 0001 1101 */ &addxy_rs_rd,
/* 1110 0001 1110 */ &addxy_rs_rd,
/* 1110 0001 1111 */ &addxy_rs_rd,

/* 1110 0010 0000 */ &subxy_rs_rd,
/* 1110 0010 0001 */ &subxy_rs_rd,
/* 1110 0010 0010 */ &subxy_rs_rd,
/* 1110 0010 0011 */ &subxy_rs_rd,
/* 1110 0010 0100 */ &subxy_rs_rd,
/* 1110 0010 0101 */ &subxy_rs_rd,
/* 1110 0010 0110 */ &subxy_rs_rd,
/* 1110 0010 0111 */ &subxy_rs_rd,
/* 1110 0010 1000 */ &subxy_rs_rd,
/* 1110 0010 1001 */ &subxy_rs_rd,
/* 1110 0010 1010 */ &subxy_rs_rd,
/* 1110 0010 1011 */ &subxy_rs_rd,
/* 1110 0010 1100 */ &subxy_rs_rd,
/* 1110 0010 1101 */ &subxy_rs_rd,
/* 1110 0010 1110 */ &subxy_rs_rd,
/* 1110 0010 1111 */ &subxy_rs_rd,

/* 1110 0011 0000 */ &subxy_rs_rd,
/* 1110 0011 0001 */ &subxy_rs_rd,
/* 1110 0011 0010 */ &subxy_rs_rd,
/* 1110 0011 0011 */ &subxy_rs_rd,
/* 1110 0011 0100 */ &subxy_rs_rd,
/* 1110 0011 0101 */ &subxy_rs_rd,
/* 1110 0011 0110 */ &subxy_rs_rd,
/* 1110 0011 0111 */ &subxy_rs_rd,
/* 1110 0011 1000 */ &subxy_rs_rd,
/* 1110 0011 1001 */ &subxy_rs_rd,
/* 1110 0011 1010 */ &subxy_rs_rd,
/* 1110 0011 1011 */ &subxy_rs_rd,
/* 1110 0011 1100 */ &subxy_rs_rd,
/* 1110 0011 1101 */ &subxy_rs_rd,
/* 1110 0011 1110 */ &subxy_rs_rd,
/* 1110 0011 1111 */ &subxy_rs_rd,

/* 1110 0100 0000 */ &cmpxy_rs_rd,
/* 1110 0100 0001 */ &cmpxy_rs_rd,
/* 1110 0100 0010 */ &cmpxy_rs_rd,
/* 1110 0100 0011 */ &cmpxy_rs_rd,
/* 1110 0100 0100 */ &cmpxy_rs_rd,
/* 1110 0100 0101 */ &cmpxy_rs_rd,
/* 1110 0100 0110 */ &cmpxy_rs_rd,
/* 1110 0100 0111 */ &cmpxy_rs_rd,
/* 1110 0100 1000 */ &cmpxy_rs_rd,
/* 1110 0100 1001 */ &cmpxy_rs_rd,
/* 1110 0100 1010 */ &cmpxy_rs_rd,
/* 1110 0100 1011 */ &cmpxy_rs_rd,
/* 1110 0100 1100 */ &cmpxy_rs_rd,
/* 1110 0100 1101 */ &cmpxy_rs_rd,
/* 1110 0100 1110 */ &cmpxy_rs_rd,
/* 1110 0100 1111 */ &cmpxy_rs_rd,

/* 1110 0101 0000 */ &cmpxy_rs_rd,
/* 1110 0101 0001 */ &cmpxy_rs_rd,
/* 1110 0101 0010 */ &cmpxy_rs_rd,
/* 1110 0101 0011 */ &cmpxy_rs_rd,
/* 1110 0101 0100 */ &cmpxy_rs_rd,
/* 1110 0101 0101 */ &cmpxy_rs_rd,
/* 1110 0101 0110 */ &cmpxy_rs_rd,
/* 1110 0101 0111 */ &cmpxy_rs_rd,
/* 1110 0101 1000 */ &cmpxy_rs_rd,
/* 1110 0101 1001 */ &cmpxy_rs_rd,
/* 1110 0101 1010 */ &cmpxy_rs_rd,
/* 1110 0101 1011 */ &cmpxy_rs_rd,
/* 1110 0101 1100 */ &cmpxy_rs_rd,
/* 1110 0101 1101 */ &cmpxy_rs_rd,
/* 1110 0101 1110 */ &cmpxy_rs_rd,
/* 1110 0101 1111 */ &cmpxy_rs_rd,

/* 1110 0110 0000 */ &unimplemented,
/* 1110 0110 0001 */ &unimplemented,
/* 1110 0110 0010 */ &unimplemented,
/* 1110 0110 0011 */ &unimplemented,
/* 1110 0110 0100 */ &unimplemented,
/* 1110 0110 0101 */ &unimplemented,
/* 1110 0110 0110 */ &unimplemented,
/* 1110 0110 0111 */ &unimplemented,
/* 1110 0110 1000 */ &unimplemented,
/* 1110 0110 1001 */ &unimplemented,
/* 1110 0110 1010 */ &unimplemented,
/* 1110 0110 1011 */ &unimplemented,
/* 1110 0110 1100 */ &unimplemented,
/* 1110 0110 1101 */ &unimplemented,
/* 1110 0110 1110 */ &unimplemented,
/* 1110 0110 1111 */ &unimplemented,

/* 1110 0111 0000 */ &unimplemented,
/* 1110 0111 0001 */ &unimplemented,
/* 1110 0111 0010 */ &unimplemented,
/* 1110 0111 0011 */ &unimplemented,
/* 1110 0111 0100 */ &unimplemented,
/* 1110 0111 0101 */ &unimplemented,
/* 1110 0111 0110 */ &unimplemented,
/* 1110 0111 0111 */ &unimplemented,
/* 1110 0111 1000 */ &unimplemented,
/* 1110 0111 1001 */ &unimplemented,
/* 1110 0111 1010 */ &unimplemented,
/* 1110 0111 1011 */ &unimplemented,
/* 1110 0111 1100 */ &unimplemented,
/* 1110 0111 1101 */ &unimplemented,
/* 1110 0111 1110 */ &unimplemented,
/* 1110 0111 1111 */ &unimplemented,

/* 1110 1000 0000 */ &cvxyl_rs_rd,
/* 1110 1000 0001 */ &cvxyl_rs_rd,
/* 1110 1000 0010 */ &cvxyl_rs_rd,
/* 1110 1000 0011 */ &cvxyl_rs_rd,
/* 1110 1000 0100 */ &cvxyl_rs_rd,
/* 1110 1000 0101 */ &cvxyl_rs_rd,
/* 1110 1000 0110 */ &cvxyl_rs_rd,
/* 1110 1000 0111 */ &cvxyl_rs_rd,
/* 1110 1000 1000 */ &cvxyl_rs_rd,
/* 1110 1000 1001 */ &cvxyl_rs_rd,
/* 1110 1000 1010 */ &cvxyl_rs_rd,
/* 1110 1000 1011 */ &cvxyl_rs_rd,
/* 1110 1000 1100 */ &cvxyl_rs_rd,
/* 1110 1000 1101 */ &cvxyl_rs_rd,
/* 1110 1000 1110 */ &cvxyl_rs_rd,
/* 1110 1000 1111 */ &cvxyl_rs_rd,

/* 1110 1001 0000 */ &cvxyl_rs_rd,
/* 1110 1001 0001 */ &cvxyl_rs_rd,
/* 1110 1001 0010 */ &cvxyl_rs_rd,
/* 1110 1001 0011 */ &cvxyl_rs_rd,
/* 1110 1001 0100 */ &cvxyl_rs_rd,
/* 1110 1001 0101 */ &cvxyl_rs_rd,
/* 1110 1001 0110 */ &cvxyl_rs_rd,
/* 1110 1001 0111 */ &cvxyl_rs_rd,
/* 1110 1001 1000 */ &cvxyl_rs_rd,
/* 1110 1001 1001 */ &cvxyl_rs_rd,
/* 1110 1001 1010 */ &cvxyl_rs_rd,
/* 1110 1001 1011 */ &cvxyl_rs_rd,
/* 1110 1001 1100 */ &cvxyl_rs_rd,
/* 1110 1001 1101 */ &cvxyl_rs_rd,
/* 1110 1001 1110 */ &cvxyl_rs_rd,
/* 1110 1001 1111 */ &cvxyl_rs_rd,

/* 1110 1010 0000 */ &unimplemented,
/* 1110 1010 0001 */ &unimplemented,
/* 1110 1010 0010 */ &unimplemented,
/* 1110 1010 0011 */ &unimplemented,
/* 1110 1010 0100 */ &unimplemented,
/* 1110 1010 0101 */ &unimplemented,
/* 1110 1010 0110 */ &unimplemented,
/* 1110 1010 0111 */ &unimplemented,
/* 1110 1010 1000 */ &unimplemented,
/* 1110 1010 1001 */ &unimplemented,
/* 1110 1010 1010 */ &unimplemented,
/* 1110 1010 1011 */ &unimplemented,
/* 1110 1010 1100 */ &unimplemented,
/* 1110 1010 1101 */ &unimplemented,
/* 1110 1010 1110 */ &unimplemented,
/* 1110 1010 1111 */ &unimplemented,

/* 1110 1011 0000 */ &unimplemented,
/* 1110 1011 0001 */ &unimplemented,
/* 1110 1011 0010 */ &unimplemented,
/* 1110 1011 0011 */ &unimplemented,
/* 1110 1011 0100 */ &unimplemented,
/* 1110 1011 0101 */ &unimplemented,
/* 1110 1011 0110 */ &unimplemented,
/* 1110 1011 0111 */ &unimplemented,
/* 1110 1011 1000 */ &unimplemented,
/* 1110 1011 1001 */ &unimplemented,
/* 1110 1011 1010 */ &unimplemented,
/* 1110 1011 1011 */ &unimplemented,
/* 1110 1011 1100 */ &unimplemented,
/* 1110 1011 1101 */ &unimplemented,
/* 1110 1011 1110 */ &unimplemented,
/* 1110 1011 1111 */ &unimplemented,

/* 1110 1100 0000 */ &movx_rs_rd,
/* 1110 1100 0001 */ &movx_rs_rd,
/* 1110 1100 0010 */ &movx_rs_rd,
/* 1110 1100 0011 */ &movx_rs_rd,
/* 1110 1100 0100 */ &movx_rs_rd,
/* 1110 1100 0101 */ &movx_rs_rd,
/* 1110 1100 0110 */ &movx_rs_rd,
/* 1110 1100 0111 */ &movx_rs_rd,
/* 1110 1100 1000 */ &movx_rs_rd,
/* 1110 1100 1001 */ &movx_rs_rd,
/* 1110 1100 1010 */ &movx_rs_rd,
/* 1110 1100 1011 */ &movx_rs_rd,
/* 1110 1100 1100 */ &movx_rs_rd,
/* 1110 1100 1101 */ &movx_rs_rd,
/* 1110 1100 1110 */ &movx_rs_rd,
/* 1110 1100 1111 */ &movx_rs_rd,

/* 1110 1101 0000 */ &movx_rs_rd,
/* 1110 1101 0001 */ &movx_rs_rd,
/* 1110 1101 0010 */ &movx_rs_rd,
/* 1110 1101 0011 */ &movx_rs_rd,
/* 1110 1101 0100 */ &movx_rs_rd,
/* 1110 1101 0101 */ &movx_rs_rd,
/* 1110 1101 0110 */ &movx_rs_rd,
/* 1110 1101 0111 */ &movx_rs_rd,
/* 1110 1101 1000 */ &movx_rs_rd,
/* 1110 1101 1001 */ &movx_rs_rd,
/* 1110 1101 1010 */ &movx_rs_rd,
/* 1110 1101 1011 */ &movx_rs_rd,
/* 1110 1101 1100 */ &movx_rs_rd,
/* 1110 1101 1101 */ &movx_rs_rd,
/* 1110 1101 1110 */ &movx_rs_rd,
/* 1110 1101 1111 */ &movx_rs_rd,

/* 1110 1110 0000 */ &movy_rs_rd,
/* 1110 1110 0001 */ &movy_rs_rd,
/* 1110 1110 0010 */ &movy_rs_rd,
/* 1110 1110 0011 */ &movy_rs_rd,
/* 1110 1110 0100 */ &movy_rs_rd,
/* 1110 1110 0101 */ &movy_rs_rd,
/* 1110 1110 0110 */ &movy_rs_rd,
/* 1110 1110 0111 */ &movy_rs_rd,
/* 1110 1110 1000 */ &movy_rs_rd,
/* 1110 1110 1001 */ &movy_rs_rd,
/* 1110 1110 1010 */ &movy_rs_rd,
/* 1110 1110 1011 */ &movy_rs_rd,
/* 1110 1110 1100 */ &movy_rs_rd,
/* 1110 1110 1101 */ &movy_rs_rd,
/* 1110 1110 1110 */ &movy_rs_rd,
/* 1110 1110 1111 */ &movy_rs_rd,

/* 1110 1111 0000 */ &movy_rs_rd,
/* 1110 1111 0001 */ &movy_rs_rd,
/* 1110 1111 0010 */ &movy_rs_rd,
/* 1110 1111 0011 */ &movy_rs_rd,
/* 1110 1111 0100 */ &movy_rs_rd,
/* 1110 1111 0101 */ &movy_rs_rd,
/* 1110 1111 0110 */ &movy_rs_rd,
/* 1110 1111 0111 */ &movy_rs_rd,
/* 1110 1111 1000 */ &movy_rs_rd,
/* 1110 1111 1001 */ &movy_rs_rd,
/* 1110 1111 1010 */ &movy_rs_rd,
/* 1110 1111 1011 */ &movy_rs_rd,
/* 1110 1111 1100 */ &movy_rs_rd,
/* 1110 1111 1101 */ &movy_rs_rd,
/* 1110 1111 1110 */ &movy_rs_rd,
/* 1110 1111 1111 */ &movy_rs_rd,

/* 1111 0000 0000 */ &pixt_rd_irdxy,
/* 1111 0000 0001 */ &pixt_rd_irdxy,
/* 1111 0000 0010 */ &pixt_rd_irdxy,
/* 1111 0000 0011 */ &pixt_rd_irdxy,
/* 1111 0000 0100 */ &pixt_rd_irdxy,
/* 1111 0000 0101 */ &pixt_rd_irdxy,
/* 1111 0000 0110 */ &pixt_rd_irdxy,
/* 1111 0000 0111 */ &pixt_rd_irdxy,
/* 1111 0000 1000 */ &pixt_rd_irdxy,
/* 1111 0000 1001 */ &pixt_rd_irdxy,
/* 1111 0000 1010 */ &pixt_rd_irdxy,
/* 1111 0000 1011 */ &pixt_rd_irdxy,
/* 1111 0000 1100 */ &pixt_rd_irdxy,
/* 1111 0000 1101 */ &pixt_rd_irdxy,
/* 1111 0000 1110 */ &pixt_rd_irdxy,
/* 1111 0000 1111 */ &pixt_rd_irdxy,

/* 1111 0001 0000 */ &pixt_rd_irdxy,
/* 1111 0001 0001 */ &pixt_rd_irdxy,
/* 1111 0001 0010 */ &pixt_rd_irdxy,
/* 1111 0001 0011 */ &pixt_rd_irdxy,
/* 1111 0001 0100 */ &pixt_rd_irdxy,
/* 1111 0001 0101 */ &pixt_rd_irdxy,
/* 1111 0001 0110 */ &pixt_rd_irdxy,
/* 1111 0001 0111 */ &pixt_rd_irdxy,
/* 1111 0001 1000 */ &pixt_rd_irdxy,
/* 1111 0001 1001 */ &pixt_rd_irdxy,
/* 1111 0001 1010 */ &pixt_rd_irdxy,
/* 1111 0001 1011 */ &pixt_rd_irdxy,
/* 1111 0001 1100 */ &pixt_rd_irdxy,
/* 1111 0001 1101 */ &pixt_rd_irdxy,
/* 1111 0001 1110 */ &pixt_rd_irdxy,
/* 1111 0001 1111 */ &pixt_rd_irdxy,

/* 1111 0010 0000 */ &unimplemented,
/* 1111 0010 0001 */ &unimplemented,
/* 1111 0010 0010 */ &unimplemented,
/* 1111 0010 0011 */ &unimplemented,
/* 1111 0010 0100 */ &unimplemented,
/* 1111 0010 0101 */ &unimplemented,
/* 1111 0010 0110 */ &unimplemented,
/* 1111 0010 0111 */ &unimplemented,
/* 1111 0010 1000 */ &unimplemented,
/* 1111 0010 1001 */ &unimplemented,
/* 1111 0010 1010 */ &unimplemented,
/* 1111 0010 1011 */ &unimplemented,
/* 1111 0010 1100 */ &unimplemented,
/* 1111 0010 1101 */ &unimplemented,
/* 1111 0010 1110 */ &unimplemented,
/* 1111 0010 1111 */ &unimplemented,

/* 1111 0011 0000 */ &unimplemented,
/* 1111 0011 0001 */ &unimplemented,
/* 1111 0011 0010 */ &unimplemented,
/* 1111 0011 0011 */ &unimplemented,
/* 1111 0011 0100 */ &unimplemented,
/* 1111 0011 0101 */ &unimplemented,
/* 1111 0011 0110 */ &unimplemented,
/* 1111 0011 0111 */ &unimplemented,
/* 1111 0011 1000 */ &unimplemented,
/* 1111 0011 1001 */ &unimplemented,
/* 1111 0011 1010 */ &unimplemented,
/* 1111 0011 1011 */ &unimplemented,
/* 1111 0011 1100 */ &unimplemented,
/* 1111 0011 1101 */ &unimplemented,
/* 1111 0011 1110 */ &unimplemented,
/* 1111 0011 1111 */ &unimplemented,

/* 1111 0100 0000 */ &unimplemented,
/* 1111 0100 0001 */ &unimplemented,
/* 1111 0100 0010 */ &unimplemented,
/* 1111 0100 0011 */ &unimplemented,
/* 1111 0100 0100 */ &unimplemented,
/* 1111 0100 0101 */ &unimplemented,
/* 1111 0100 0110 */ &unimplemented,
/* 1111 0100 0111 */ &unimplemented,
/* 1111 0100 1000 */ &unimplemented,
/* 1111 0100 1001 */ &unimplemented,
/* 1111 0100 1010 */ &unimplemented,
/* 1111 0100 1011 */ &unimplemented,
/* 1111 0100 1100 */ &unimplemented,
/* 1111 0100 1101 */ &unimplemented,
/* 1111 0100 1110 */ &unimplemented,
/* 1111 0100 1111 */ &unimplemented,

/* 1111 0101 0000 */ &unimplemented,
/* 1111 0101 0001 */ &unimplemented,
/* 1111 0101 0010 */ &unimplemented,
/* 1111 0101 0011 */ &unimplemented,
/* 1111 0101 0100 */ &unimplemented,
/* 1111 0101 0101 */ &unimplemented,
/* 1111 0101 0110 */ &unimplemented,
/* 1111 0101 0111 */ &unimplemented,
/* 1111 0101 1000 */ &unimplemented,
/* 1111 0101 1001 */ &unimplemented,
/* 1111 0101 1010 */ &unimplemented,
/* 1111 0101 1011 */ &unimplemented,
/* 1111 0101 1100 */ &unimplemented,
/* 1111 0101 1101 */ &unimplemented,
/* 1111 0101 1110 */ &unimplemented,
/* 1111 0101 1111 */ &unimplemented,

/* 1111 0110 0000 */ &drav_rs_rd,
/* 1111 0110 0001 */ &drav_rs_rd,
/* 1111 0110 0010 */ &drav_rs_rd,
/* 1111 0110 0011 */ &drav_rs_rd,
/* 1111 0110 0100 */ &drav_rs_rd,
/* 1111 0110 0101 */ &drav_rs_rd,
/* 1111 0110 0110 */ &drav_rs_rd,
/* 1111 0110 0111 */ &drav_rs_rd,
/* 1111 0110 1000 */ &drav_rs_rd,
/* 1111 0110 1001 */ &drav_rs_rd,
/* 1111 0110 1010 */ &drav_rs_rd,
/* 1111 0110 1011 */ &drav_rs_rd,
/* 1111 0110 1100 */ &drav_rs_rd,
/* 1111 0110 1101 */ &drav_rs_rd,
/* 1111 0110 1110 */ &drav_rs_rd,
/* 1111 0110 1111 */ &drav_rs_rd,

/* 1111 0111 0000 */ &drav_rs_rd,
/* 1111 0111 0001 */ &drav_rs_rd,
/* 1111 0111 0010 */ &drav_rs_rd,
/* 1111 0111 0011 */ &drav_rs_rd,
/* 1111 0111 0100 */ &drav_rs_rd,
/* 1111 0111 0101 */ &drav_rs_rd,
/* 1111 0111 0110 */ &drav_rs_rd,
/* 1111 0111 0111 */ &drav_rs_rd,
/* 1111 0111 1000 */ &drav_rs_rd,
/* 1111 0111 1001 */ &drav_rs_rd,
/* 1111 0111 1010 */ &drav_rs_rd,
/* 1111 0111 1011 */ &drav_rs_rd,
/* 1111 0111 1100 */ &drav_rs_rd,
/* 1111 0111 1101 */ &drav_rs_rd,
/* 1111 0111 1110 */ &drav_rs_rd,
/* 1111 0111 1111 */ &drav_rs_rd,

/* 1111 1000 0000 */ &unimplemented,
/* 1111 1000 0001 */ &unimplemented,
/* 1111 1000 0010 */ &unimplemented,
/* 1111 1000 0011 */ &unimplemented,
/* 1111 1000 0100 */ &unimplemented,
/* 1111 1000 0101 */ &unimplemented,
/* 1111 1000 0110 */ &unimplemented,
/* 1111 1000 0111 */ &unimplemented,
/* 1111 1000 1000 */ &unimplemented,
/* 1111 1000 1001 */ &unimplemented,
/* 1111 1000 1010 */ &unimplemented,
/* 1111 1000 1011 */ &unimplemented,
/* 1111 1000 1100 */ &unimplemented,
/* 1111 1000 1101 */ &unimplemented,
/* 1111 1000 1110 */ &unimplemented,
/* 1111 1000 1111 */ &unimplemented,

/* 1111 1001 0000 */ &unimplemented,
/* 1111 1001 0001 */ &unimplemented,
/* 1111 1001 0010 */ &unimplemented,
/* 1111 1001 0011 */ &unimplemented,
/* 1111 1001 0100 */ &unimplemented,
/* 1111 1001 0101 */ &unimplemented,
/* 1111 1001 0110 */ &unimplemented,
/* 1111 1001 0111 */ &unimplemented,
/* 1111 1001 1000 */ &unimplemented,
/* 1111 1001 1001 */ &unimplemented,
/* 1111 1001 1010 */ &unimplemented,
/* 1111 1001 1011 */ &unimplemented,
/* 1111 1001 1100 */ &unimplemented,
/* 1111 1001 1101 */ &unimplemented,
/* 1111 1001 1110 */ &unimplemented,
/* 1111 1001 1111 */ &unimplemented,

/* 1111 1010 0000 */ &pixt_irs_rd,
/* 1111 1010 0001 */ &pixt_irs_rd,
/* 1111 1010 0010 */ &pixt_irs_rd,
/* 1111 1010 0011 */ &pixt_irs_rd,
/* 1111 1010 0100 */ &pixt_irs_rd,
/* 1111 1010 0101 */ &pixt_irs_rd,
/* 1111 1010 0110 */ &pixt_irs_rd,
/* 1111 1010 0111 */ &pixt_irs_rd,
/* 1111 1010 1000 */ &pixt_irs_rd,
/* 1111 1010 1001 */ &pixt_irs_rd,
/* 1111 1010 1010 */ &pixt_irs_rd,
/* 1111 1010 1011 */ &pixt_irs_rd,
/* 1111 1010 1100 */ &pixt_irs_rd,
/* 1111 1010 1101 */ &pixt_irs_rd,
/* 1111 1010 1110 */ &pixt_irs_rd,
/* 1111 1010 1111 */ &pixt_irs_rd,

/* 1111 1011 0000 */ &pixt_irs_rd,
/* 1111 1011 0001 */ &pixt_irs_rd,
/* 1111 1011 0010 */ &pixt_irs_rd,
/* 1111 1011 0011 */ &pixt_irs_rd,
/* 1111 1011 0100 */ &pixt_irs_rd,
/* 1111 1011 0101 */ &pixt_irs_rd,
/* 1111 1011 0110 */ &pixt_irs_rd,
/* 1111 1011 0111 */ &pixt_irs_rd,
/* 1111 1011 1000 */ &pixt_irs_rd,
/* 1111 1011 1001 */ &pixt_irs_rd,
/* 1111 1011 1010 */ &pixt_irs_rd,
/* 1111 1011 1011 */ &pixt_irs_rd,
/* 1111 1011 1100 */ &pixt_irs_rd,
/* 1111 1011 1101 */ &pixt_irs_rd,
/* 1111 1011 1110 */ &pixt_irs_rd,
/* 1111 1011 1111 */ &pixt_irs_rd,

/* 1111 1100 0000 */ &unimplemented,
/* 1111 1100 0001 */ &unimplemented,
/* 1111 1100 0010 */ &unimplemented,
/* 1111 1100 0011 */ &unimplemented,
/* 1111 1100 0100 */ &unimplemented,
/* 1111 1100 0101 */ &unimplemented,
/* 1111 1100 0110 */ &unimplemented,
/* 1111 1100 0111 */ &unimplemented,
/* 1111 1100 1000 */ &unimplemented,
/* 1111 1100 1001 */ &unimplemented,
/* 1111 1100 1010 */ &unimplemented,
/* 1111 1100 1011 */ &unimplemented,
/* 1111 1100 1100 */ &unimplemented,
/* 1111 1100 1101 */ &unimplemented,
/* 1111 1100 1110 */ &unimplemented,
/* 1111 1100 1111 */ &unimplemented,

/* 1111 1101 0000 */ &unimplemented,
/* 1111 1101 0001 */ &unimplemented,
/* 1111 1101 0010 */ &unimplemented,
/* 1111 1101 0011 */ &unimplemented,
/* 1111 1101 0100 */ &unimplemented,
/* 1111 1101 0101 */ &unimplemented,
/* 1111 1101 0110 */ &unimplemented,
/* 1111 1101 0111 */ &unimplemented,
/* 1111 1101 1000 */ &unimplemented,
/* 1111 1101 1001 */ &unimplemented,
/* 1111 1101 1010 */ &unimplemented,
/* 1111 1101 1011 */ &unimplemented,
/* 1111 1101 1100 */ &unimplemented,
/* 1111 1101 1101 */ &unimplemented,
/* 1111 1101 1110 */ &unimplemented,
/* 1111 1101 1111 */ &unimplemented,

/* 1111 1110 0000 */ &unimplemented,
/* 1111 1110 0001 */ &unimplemented,
/* 1111 1110 0010 */ &unimplemented,
/* 1111 1110 0011 */ &unimplemented,
/* 1111 1110 0100 */ &unimplemented,
/* 1111 1110 0101 */ &unimplemented,
/* 1111 1110 0110 */ &unimplemented,
/* 1111 1110 0111 */ &unimplemented,
/* 1111 1110 1000 */ &unimplemented,
/* 1111 1110 1001 */ &unimplemented,
/* 1111 1110 1010 */ &unimplemented,
/* 1111 1110 1011 */ &unimplemented,
/* 1111 1110 1100 */ &unimplemented,
/* 1111 1110 1101 */ &unimplemented,
/* 1111 1110 1110 */ &unimplemented,
/* 1111 1110 1111 */ &unimplemented,

/* 1111 1111 0000 */ &unimplemented,
/* 1111 1111 0001 */ &unimplemented,
/* 1111 1111 0010 */ &unimplemented,
/* 1111 1111 0011 */ &unimplemented,
/* 1111 1111 0100 */ &unimplemented,
/* 1111 1111 0101 */ &unimplemented,
/* 1111 1111 0110 */ &unimplemented,
/* 1111 1111 0111 */ &unimplemented,
/* 1111 1111 1000 */ &unimplemented,
/* 1111 1111 1001 */ &unimplemented,
/* 1111 1111 1010 */ &unimplemented,
/* 1111 1111 1011 */ &unimplemented,
/* 1111 1111 1100 */ &unimplemented,
/* 1111 1111 1101 */ &unimplemented,
/* 1111 1111 1110 */ &unimplemented,
/* 1111 1111 1111 */ &unimplemented,

};

}
