static char help_c_rcsid[]="help.c,v 1.1.1.1 1994/06/18 19:43:27 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * help.c,v
 * Revision 1.1.1.1  1994/06/18  19:43:27  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/AsciiText.h>
#include "h.h"
#include "def.h"
#include "struct.h"
#include "dqs.h"
#include "globals.h"
#include "Info.h"
#include "help.h"

extern Widget TopLevelW;

static Widget DQSUsageHelpParentW;
static Widget DQSUsageHelpInfoW;

static void
DQSUsageHelpOK (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsageHelpOK"));

  XtDestroyWidget (DQSUsageHelpInfoW);
  DQSUsageHelpInfoW = NULL;
  XtPopdown (DQSUsageHelpParentW);

  DEXIT;
}

void
Help (HelpInfoNodeName)
     char *HelpInfoNodeName;
{
  static Widget DQSUsageHelpFormW;
  static Widget DQSUsageHelpTitleLabelW;
  static int DejaVu = 0;
  static XtCallbackRec DQSUsageHelpInfoWCallbacks[] = {
    { DQSUsageHelpOK, NULL },
    { NULL, NULL },
  };
  Arg wargs[2];

  DENTER ((DQS_EVENT, "Help"));

  if (DejaVu == 0)
    {
      DQSUsageHelpParentW =
	XtCreatePopupShell ("DQSUsageHelpParent", transientShellWidgetClass,
			    TopLevelW, NULL, ZERO);
      
      DQSUsageHelpFormW =
	XtCreateManagedWidget ("DQSUsageHelpForm", formWidgetClass,
			       DQSUsageHelpParentW, NULL, ZERO);
      
      DQSUsageHelpTitleLabelW =
	XtCreateManagedWidget ("DQSUsageHelpTitle", labelWidgetClass,
			      DQSUsageHelpFormW, NULL, ZERO);

      DejaVu = 1;
    }
  
  if (DQSUsageHelpInfoW != NULL)
    XtDestroyWidget (DQSUsageHelpInfoW);

  XtSetArg (wargs[0], XtNcallback, DQSUsageHelpInfoWCallbacks);
  XtSetArg (wargs[1], XpNinfoNode, HelpInfoNodeName);
  DQSUsageHelpInfoW =
    XtCreateManagedWidget ("DQSUsageHelpInfo", infoWidgetClass,
			   DQSUsageHelpFormW, wargs, TWO);

  XtPopup (DQSUsageHelpParentW, XtGrabNone);

  DEXIT;
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
