static char qsub_rcsid[]="qsub.c,v 1.2 1994/11/28 16:56:10 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qsub.c,v
 * Revision 1.2  1994/11/28  16:56:10  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  03:00:05  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/07/11  15:51:59  raju
 * updated the option list of qsub
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/

#include "globals.h"
static Widget           qsub_popup;
static Widget           widget_qsubrc;
static Widget           widget_qsublabel;
static Widget           widget_qsubframe;
static Widget           widget_qsubmenu;
static Widget           widget_qsubmain;
static Widget           widget_qsubexec;
static Widget           widget_qsubclear;
static Widget           widget_qsubclose;
static Widget           widget_qsubseparator;
static Widget           widget_qsubopt;

struct optionstruct qsubmenu[]={
  0,"Date/Time        ","-a",   INPUTTYPE,NULL,NULL,
  0,"Account  List ","-A",  MENUTYPE,NULL,NULL,
  0,"Cell          ","-cell",   MENUTYPE,NULL,NULL,
  0,"Current Directory","-cwd", FLAGTYPE,"True",NULL,
  0,"Directive Prefix ","-C", FLAGTYPE,"False",NULL,
  0,"Std. Error Path  ","-e",   INPUTTYPE,NULL,NULL,
  0,"User Hold        ","-h", FLAGTYPE,"False",NULL,
  0,"Hard             ","-hard", FLAGTYPE,"False",NULL,
  0,"Help             ","-help", FLAGTYPE,"False",NULL,
  0,"Join-Paths       ","-j",  FLAGTYPE,"False",NULL,
  0,"Resource List    ","-l",  INPUTTYPE,NULL,NULL,
  0,"Mail at Abort    ","-m a",  FLAGTYPE,"FALSE",NULL,
  0,"Mail Begin       ","-m b",  FLAGTYPE,"FALSE",NULL,
  0,"Mail End         ","-m e",  FLAGTYPE,"FALSE",NULL,
  0,"Mail Signal      ","-m s",  FLAGTYPE,"FALSE",NULL,
  0,"Mail User        ","-m u",  INPUTTYPE,NULL,NULL,
  0,"Mailing List     ","-M",INPUTTYPE,NULL,NULL,
  0,"Master Queue  ","-master",  MENUTYPE,NULL,NULL,
  0,"Notify           ","-notify", FLAGTYPE,"False",NULL,
  0,"Job Name         ","-N",  INPUTTYPE,NULL,NULL,
  0,"Std. Output Path ","-o",   INPUTTYPE,NULL,NULL,
  0,"Priority         ","-p",   INPUTTYPE,NULL,NULL,
  0,"Password         ","-passwd", FLAGTYPE,"False",NULL,
  0,"Password File    ","-passwd_file",   INPUTTYPE,NULL,NULL,
  0,"Destination   ","-q",   MENUTYPE,NULL,NULL,
  0,"Rerunable        ","-r", FLAGTYPE,"False",NULL,
  0,"Soft             ","-soft", FLAGTYPE,"False",NULL,
  0,"Reauthenticate   ","-reauth",   INPUTTYPE,NULL,NULL,
  0,"Shell Path List  ","-S",   INPUTTYPE,NULL,NULL,
  0,"Variable List    ","-v",   INPUTTYPE,NULL,NULL,
  0,"Verify           ","-verify",   FLAGTYPE,"FALSE",NULL,
  0,"Export Variables ","-V",   FLAGTYPE,"FALSE",NULL,
  0,"O/P job id ?     ","-z",   FLAGTYPE,"FALSE",NULL,
  0,"Job ID           ","-hold_jid",  INPUTTYPE,NULL,NULL,
  0,"Script File      ",NULL,   INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};
/*
  0,"Parallel         ","-par",INPUTTYPE,NULL,NULL,
*/


/***********************************************************
 * pb_qsubexec - Activate callback for exec
 */
XtCallbackProc pb_qsubexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  char 	   *str=NULL;
  char 	   command[MAX_STRING_SIZE];

  if(QmonToggleGetState(qsubmenu[22].widgetid)){
        buildcommand(QSUB_BINARY,qsubmenu,1);
  }
  else 
      buildcommand(QSUB_BINARY,qsubmenu,0);
	 
   
  sleep(2);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qsubclear - Activate callback for clear
 */
XtCallbackProc pb_qsubclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  int n=0;
  clearsubmenu(qsubmenu);
  QmonTextSetString(qsubmenu[n].widgetid ,current_date ); n++;
  QmonTextSetString(qsubmenu[n].widgetid ,current_account ); n++;
  QmonTextSetString(qsubmenu[n].widgetid ,current_cell ); n++;
  n++ ;
  n++ ;
  QmonTextSetString(qsubmenu[n].widgetid ,current_errpath ); n++;
  n++ ;
  QmonToggleSetState(qsubmenu[n].widgetid ,current_hard ); n++;
  n++ ;
  n++ ;
  QmonTextSetString(qsubmenu[n].widgetid ,current_resource ); n++;
  n++ ;
  n++ ;
  n++ ;
  n++ ;
  n++ ;
  n++ ;
  QmonTextSetString(qsubmenu[n].widgetid ,current_mqueue ); n++;
  n++ ;
  QmonTextSetString(qsubmenu[n].widgetid ,current_jobname ); n++;
  QmonTextSetString(qsubmenu[n].widgetid ,current_outpath ); n++;
  QmonTextSetString(qsubmenu[n].widgetid ,current_priority ); n++;
  n++ ;
  QmonTextSetString(qsubmenu[n].widgetid ,current_passwdfile ); n++;
  QmonTextSetString(qsubmenu[n].widgetid ,current_destination ); n++;
  QmonToggleSetState(qsubmenu[n].widgetid ,current_rerun ); n++;
  QmonToggleSetState(qsubmenu[n].widgetid ,current_soft ); n++;
  n++ ;
  QmonTextSetString(qsubmenu[n].widgetid ,current_shellpath ); n++;
  QmonTextSetString(qsubmenu[n].widgetid ,current_exportvars ); n++;
}


/***********************************************************
 * pb_qsubclose - Activate callback for close
 */

XtCallbackProc pb_qsubclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qsub_dialog - Create widgets used for the qsub menu
 */
int create_qsub_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qsub_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  qsubmenu[1].list = account_list;
  qsubmenu[2].list = cell_list;
  qsubmenu[17].list = queue_list;
  qsubmenu[24].list = queue_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qsub_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qsub_form = XtCreateManagedWidget("form", formWidgetClass, qsub_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qsublabel=
        XtCreateManagedWidget("Qsub",labelWidgetClass,qsub_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qsublabel); ii++;
  widget_qsubmain=XtCreateManagedWidget("box",formWidgetClass,qsub_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_qsubmain,NULL,"Exec",(XtCallbackProc)pb_qsubexec,NULL);
 clear=QmonAddButtonN(widget_qsubmain,exec,"Clear",(XtCallbackProc)pb_qsubclear,NULL);
 close=QmonAddButtonN(widget_qsubmain,clear,"Close",(XtCallbackProc)pb_qsubclose,NULL);

  widget_qsubopt=createmenuoptions(qsub_form,widget_qsubmain,qsubmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qsub - Open the qsub menu
 */
int openwidget_qsub()
{
  pb_qsubclear(NULL,NULL,NULL);
  XtPopup(qsub_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qsub - Close the qsub menu
 */
int closewidget_qsub()
{
   XtPopdown(qsub_popup);
}
