static char qrls_rcsid[]="qrls.c,v 1.2 1994/11/28 16:55:56 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qrls.c,v
 * Revision 1.2  1994/11/28  16:55:56  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  03:02:43  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qrls_popup;
static Widget           widget_qrlsrc;
static Widget           widget_qrlslabel;
static Widget           widget_qrlsframe;
static Widget           widget_qrlsmenu;
static Widget           widget_qrlsmain;
static Widget           widget_qrlsexec;
static Widget           widget_qrlsclear;
static Widget           widget_qrlsclose;
static Widget           widget_qrlsseparator;
static Widget           widget_qrlsopt;

struct optionstruct qrlsmenu[]={
  0,"Hold User  ","-h u",  FLAGTYPE,"False",NULL,
  0,"Hold System","-h s",  FLAGTYPE,"False",NULL,
  0,"Hold Other ","-h o",  FLAGTYPE,"False",NULL,
  0,"No Hold    ","-h n",  FLAGTYPE,"False",NULL,
  0,"Help       ","-help",FLAGTYPE,"False",NULL,
  0,"Verify     ","-verify",FLAGTYPE,"False",NULL,
  0,"Job ID List",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qrlsexec - Activate callback for exec
 */
XtCallbackProc pb_qrlsexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QRLS_BINARY,qrlsmenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qrlsclear - Activate callback for clear
 */
XtCallbackProc pb_qrlsclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qrlsmenu);
}


/***********************************************************
 * pb_qrlsclose - Activate callback for close
 */

XtCallbackProc pb_qrlsclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qrls_dialog - Create widgets used for the qrls menu
 */
int create_qrls_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qrls_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qrls_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qrls_form = XtCreateManagedWidget("form", formWidgetClass, qrls_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qrlslabel=
	XtCreateManagedWidget("Qrls",labelWidgetClass,qrls_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qrlslabel); ii++;
  widget_qrlsmain=XtCreateManagedWidget("box",formWidgetClass,qrls_form,
                                        args,ii);
  exec=QmonAddButtonN(widget_qrlsmain,NULL,"Exec",(XtCallbackProc)pb_qrlsexec,NULL);
  clear=QmonAddButtonN(widget_qrlsmain,exec,"Clear",(XtCallbackProc)pb_qrlsclear,NULL);
  close=QmonAddButtonN(widget_qrlsmain,clear,"Close",(XtCallbackProc)pb_qrlsclose,NULL);

  widget_qrlsopt=createmenuoptions(qrls_form,widget_qrlsmain,qrlsmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qrls - Open the qrls menu
 */
int openwidget_qrls()
{
  XtPopup(qrls_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qrls - Close the qrls menu
 */
int closewidget_qrls()
{
  XtPopdown(qrls_popup);
}
