static char qconf_rcsid[]="qconf.c,v 1.2 1994/11/28 16:55:30 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qconf.c,v
 * Revision 1.2  1994/11/28  16:55:30  kerce
 * *** empty log message ***
 *
 * Revision 1.2  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

#define LABEL1 "Configure Complex "
#define LABEL2 "Configure Cluster "
#define LABEL3 "Configure Queue   "
#define LABEL4 "Configure Manager "
#define LABEL5 "Configure Operator"
#define LABEL6 "Configure Host    "
#define LABEL7 "Configure User    "

static Widget           qconfopenwidget=0;
static Widget           qconf_popup ;
static Widget           widget_qconfmain;
static Widget           widget_qconfmenu;
static Widget           widget_qconflabel;
static Widget           widget_qconfseparator;
static Widget           widget_qconfcloserc;
static Widget           widget_qconfpbclose;
static Widget           widget_qconfframe;
static Widget           widget_qconfpbrc;
static Widget           widget_complexpb;
static Widget           widget_queuepb;
static Widget           widget_managerpb;
static Widget           widget_operatorpb;
static Widget           widget_hostpb;
static Widget           widget_userpb;
static Widget           widget_clusterpb;


/***********************************************************
 * pb_qconfclose - Activate callback for close
 */
XtCallbackProc pb_qconfclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * pb_submenu - Activate callback
 */
XtCallbackProc pb_submenu(Widget w, caddr_t client_data, caddr_t call_data)
{
  Arg             args[32];
  int             ii;
  
  /*
   * If this submenu is already opoen then close it
    closesubmenuwin(); 
   */
  if(qconfopenwidget==w) {
  }
  /*
   * Else we need to open the corresponding submenu
   */
  else {
    /*
     * Close any other submenu if it is open
     */
    if(qconfopenwidget) {
      closesubmenuwin();
    }

    ii=0;
    XtSetArg(args[ii],XtNforeground,defaultbackground(w)); ii++;
    XtSetArg(args[ii],XtNbackground,defaultforeground(w)); ii++;
    XtSetValues(w,args,ii);
    
    if(w==widget_clusterpb) {
      create_sorry_dialog(w,NULL, NULL);
      openwidget_sorry();

/*
      qconfopenwidget=w;
      openwidget_cluster();
*/
    }
    else if(w==widget_complexpb) {
      qconfopenwidget=w;
      openwidget_complex();
    }
    else if(w==widget_queuepb) {
      qconfopenwidget=w;
      openwidget_queue();
    }
    else if(w==widget_managerpb) {
      qconfopenwidget=w;
      openwidget_manager();
    }
    else if(w==widget_operatorpb) {
      qconfopenwidget=w;
      openwidget_operator();
    }
    else if(w==widget_hostpb) {
      qconfopenwidget=w;
      openwidget_host();
    }
    else if(w==widget_userpb) {
      qconfopenwidget=w;
      openwidget_user();
    }
  }
}


/***********************************************************
 * closesubmenuwin - Close the submenu
 */
int closesubmenuwin()
{
  int             ii;
  Arg             args[32];

  /*
   * If no submenu is open then just return
   */
  if(qconfopenwidget==0)
    return;

  ii=0;
  XtSetArg(args[ii],XtNforeground,defaultbackground(qconfopenwidget)); ii++;
  XtSetArg(args[ii],XtNbackground,defaultforeground(qconfopenwidget)); ii++;
  XtSetValues(qconfopenwidget,args,ii);

  /*
   * Find out which submenu is open and close it
   */
  if(qconfopenwidget==widget_queuepb) {
    closewidget_queue();
  }
  else if(qconfopenwidget==widget_managerpb) {
    closewidget_manager();
  }
  else if(qconfopenwidget==widget_operatorpb) {
    closewidget_operator();
  }
  else if(qconfopenwidget==widget_hostpb) {
    closewidget_host();
  }
  else if(qconfopenwidget==widget_userpb) {
    closewidget_user();
  }
  else if(qconfopenwidget==widget_clusterpb) {
    closewidget_cluster();
  }
  else if(qconfopenwidget==widget_complexpb) {
    closewidget_complex();
  }

  /*
   * Set to zero
   */
  qconfopenwidget=0;
}


/***********************************************************
 * create_qconf_dialog - Create widgets for qconf menus
 */
int create_qconf_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qconf_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, closed;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qconf_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qconf_form = XtCreateManagedWidget("form", formWidgetClass, qconf_popup,args,
ii); 

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qconflabel=
        XtCreateManagedWidget("Qconf",labelWidgetClass,qconf_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qconflabel); ii++;
  widget_qconfmain=XtCreateManagedWidget("box",formWidgetClass,qconf_form,
                                        args,ii);

 XawDialogAddButton(widget_qconfmain,"Close",(XtCallbackProc)pb_qconfclose,(XtPointer)NULL);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qconfmain); ii++;
  widget_qconfmenu=XtCreateManagedWidget("box",formWidgetClass,qconf_form,
                                        args,ii);
 widget_complexpb
	= QmonAddButtonV(widget_qconfmenu,NULL,LABEL1,(XtCallbackProc )pb_submenu,NULL);
 ii=0;
 XtSetArg(args[ii], XtNsensitive,False); ii++;
 widget_clusterpb
	= QmonAddButtonV(widget_qconfmenu,widget_complexpb,LABEL2,(XtCallbackProc )pb_submenu,NULL);
 widget_queuepb
	= QmonAddButtonV(widget_qconfmenu,widget_clusterpb,LABEL3,(XtCallbackProc )pb_submenu,NULL);
 widget_managerpb
	= QmonAddButtonV(widget_qconfmenu,widget_queuepb,LABEL4,(XtCallbackProc )pb_submenu,NULL);
 widget_operatorpb
	= QmonAddButtonV(widget_qconfmenu,widget_managerpb,LABEL5,(XtCallbackProc )pb_submenu,NULL);
 widget_hostpb
	= QmonAddButtonV(widget_qconfmenu,widget_operatorpb,LABEL6,(XtCallbackProc )pb_submenu,NULL);
 widget_userpb
	= QmonAddButtonV(widget_qconfmenu, widget_hostpb,LABEL7,(XtCallbackProc )pb_submenu,NULL);

 create_complex_dialog(widget_complexpb,NULL,NULL);
 create_cluster_dialog(widget_clusterpb,NULL,NULL);
 create_queue_dialog(widget_queuepb,NULL,NULL);
 create_manager_dialog(widget_managerpb,NULL,NULL);
 create_operator_dialog(widget_operatorpb,NULL,NULL);
 create_host_dialog(widget_hostpb,NULL,NULL);
 create_user_dialog(widget_userpb,NULL,NULL);

}

/***********************************************************
 * openwidget_qconf - Open qconf menu
 */
int openwidget_qconf()
{
  XtPopup(qconf_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qconf - Close qconf menus
 */
int closewidget_qconf()
{
  /*
   * Close any submenus if they are open
   */
  if(qconfopenwidget) {
    closesubmenuwin();
  }
   XtPopdown(qconf_popup);
}


/***********************************************************
 * openwidget_queue - Open queue configuration submenu
 */
int openwidget_queue()
{
  openwidget_queuesub();
}


/***********************************************************
 * openwidget_manager - Open manager configuration submenu
 */
int openwidget_manager()
{
  openwidget_managersub();
}


/***********************************************************
 * openwidget_operator - Open operator configuration submenu
 */
int openwidget_operator()
{
  openwidget_operatorsub();
}


/***********************************************************
 * openwidget_host - Open host configuration submenu
 */
int openwidget_host()
{
  openwidget_hostsub();
}


/***********************************************************
 * openwidget_user - Open user configuration submenu
 */
int openwidget_user()
{
  openwidget_usersub();
}


/***********************************************************
 * openwidget_complex - Open complex configuration submenu
 */
int openwidget_complex()
{
  openwidget_complexsub();
}

/***********************************************************
 * openwidget_cluster - Open cluster configuration submenu
 */
int openwidget_cluster()
{
  openwidget_clustersub(NULL,NULL,NULL);
}


/***********************************************************
 * closewidget_queue - Close queue configuration submenu
 */
int closewidget_queue()
{
  closewidget_queuesub();
}


/***********************************************************
 * closewidget_manager - Close manager configuration submenu
 */
int closewidget_manager()
{
  closewidget_managersub();
}


/***********************************************************
 * closewidget_operator - Close operator configuration submenu
 */
int closewidget_operator()
{
  closewidget_operatorsub();
}


/***********************************************************
 * closewidget_host - Close host configuration submenu
 */
int closewidget_host()
{
  closewidget_hostsub();
}


/***********************************************************
 * closewidget_user - Close user configuration submenu
 */
int closewidget_user()
{
  closewidget_usersub();
}


/***********************************************************
 * closewidget_complex - Close complex configuration submenu
 */
int closewidget_complex()
{
  closewidget_complexsub();
}

/***********************************************************
 * closewidget_cluster - Close cluster configuration submenu
 */
int closewidget_cluster()
{
  closewidget_clustersub();
}

