static char addqueue_rcsid[]="$Id";
/***********************************************************
 * globals.h - include file for qmon
 *
 * Version 3.3 by Jeff Snyder
 * Date: 6/24/92
 *
 * Versions 3.4 & 3.5 by Lakhamraju R. Raju
 * Date: 11/02/93
 *
 * Major modifications: Removed motif calls and replaced 
 *	               with athena widget set calls.
 *
 * Copyright 1992, 1993, 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  addqueue.c,v
 * Revision 1.2  1994/11/28  16:54:37  kerce
 * *** empty log message ***
 *
 * Revision 1.6  1994/09/13  18:00:47  raju
 * *** empty log message ***
 *
 * Revision 1.5  1994/08/21  02:55:56  raju
 * *** empty log message ***
 *
 **********************************************************/

#include "globals.h"
#include "qmonerrs.h"

static Widget           addqueue_popup;
static Widget           widget_addqueuerc;
static Widget           widget_addqueuelabel;
static Widget           widget_addqueueframe;
static Widget           widget_addqueuemenu;
static Widget           widget_addqueuemain;
static Widget           widget_addqueueexec;
static Widget           widget_addqueueclear;
static Widget           widget_addqueueclose;
static Widget           widget_addqueueseparator;
static Widget           widget_addqueueopt;

extern Widget iconwin, viewicon;
/*
extern queueiconstruct  *queueicon;
*/

struct optionstruct addqueuemenu[]={
  0,"Q_name      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"hostname    ",NULL,INPUTTYPE,NULL,NULL,
  0,"seq_no      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"load_masg   ",NULL,INPUTTYPE,NULL,	NULL,
  0,"load_alarm  ",NULL,INPUTTYPE,NULL,	NULL,
  0,"priority    ",NULL,INPUTTYPE,NULL,	NULL,
  0,"type        ",NULL,INPUTTYPE,NULL,	NULL,
  0,"rerun       ",NULL,INPUTTYPE,NULL,	NULL,
  0,"quantity    ",NULL,INPUTTYPE,NULL,	NULL,
  0,"tmpdir      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"shell       ",NULL,INPUTTYPE,NULL,	NULL,
  0,"klog        ",NULL,INPUTTYPE,NULL,	NULL,
  0,"reauth_time ",NULL,INPUTTYPE,NULL,	NULL,
  0,"last_user_delay ",NULL,INPUTTYPE,NULL,	NULL,
  0,"max_user_jobs ",NULL,INPUTTYPE,NULL,	NULL,
  0,"notify      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"owner_list  ",NULL,INPUTTYPE,NULL,	NULL,
  0,"user_acl    ",NULL,INPUTTYPE,NULL,	NULL,
  0,"xuser_acl   ",NULL,INPUTTYPE,NULL,	NULL,
  0,"consumables ",NULL,INPUTTYPE,NULL,	NULL,
  0,"subordinate_list ",NULL,INPUTTYPE,NULL,NULL,
  0,"complex_list",NULL,INPUTTYPE,NULL,	NULL,
  0,"s_rt        ",NULL,INPUTTYPE,NULL,	NULL,
  0,"h_rt        ",NULL,INPUTTYPE,NULL,	NULL,
  0,"s_cpu       ",NULL,INPUTTYPE,NULL,	NULL,
  0,"h_cpu       ",NULL,INPUTTYPE,NULL,	NULL,
  0,"s_fsize     ",NULL,INPUTTYPE,NULL,	NULL,
  0,"h_fsize     ",NULL,INPUTTYPE,NULL,NULL,
  0,"s_data      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"h_data      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"s_stack     ",NULL,INPUTTYPE,NULL,	NULL,
  0,"h_stack     ",NULL,INPUTTYPE,NULL,	NULL,
  0,"s_core      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"h_core      ",NULL,INPUTTYPE,NULL,	NULL,
  0,"s_rss       ",NULL,INPUTTYPE,NULL,	NULL,
  0,"h_rss       ",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL, NULL
};


/***********************************************************
 * pb_addqueueexec - Activate callback for exec
 */
XtCallbackProc pb_addqueueexec(Widget w,caddr_t client_data,caddr_t call_data)
{
  char            command[MAX_STRING_SIZE];
  char            errmsg[MAX_STRING_SIZE];
  char            tmpfilename[MAX_STRING_SIZE];
  char            *ptr;
  int             ii;
  FILE            *fp;

  char            buffer[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  static int	  added_icons=0;

  tmpnam(tmpfilename);
  if(!(fp=fopen(tmpfilename,"w"))) {
    sprintf(errmsg,ERROR_107,tmpfilename);
    logerr(errmsg);
    return;
  }

  for(ii=0;addqueuemenu[ii].name;ii++) {
    ptr=QmonTextGetString(addqueuemenu[ii].widgetid);
    fprintf(fp,"%s\t%s\n",addqueuemenu[ii].name,ptr);
  }

  fclose(fp);
  sprintf(command,"%s -cell %s -Aq %s",QCONF_BINARY,current_cell,tmpfilename);
  execit(command);
  sleep(1);
  unlink(tmpfilename);
  
  if(added_icons==MAX_ADD_ICONS-1) {
        printf("You have exceded the maximum number of queues that\n can be added in one session. To add more, restart qmon\n");
  }
  else if(added_icons>MAX_ADD_ICONS-1) {
        printf("You have exceded the maximum number of queues that\n can be added in one session. To add more, restart qmon\n");
        return ;
  }

  added_icons++;
  UnMapIconWin ();
  refreshicons ();
  MapIconWin ();
}


/***********************************************************
 * pb_addqueueclear - Activate callback for clear
 */
XtCallbackProc pb_addqueueclear(Widget w,caddr_t client_data,caddr_t call_data)
{
  char            buffer[MAX_STRING_SIZE];
  char            command[MAX_STRING_SIZE];
  char            tmpfilename[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  int             ii;
  FILE            *pfp;
  
  /*
   * We need to fill in the options with the default
   * values from qconf -sq
   */
  tmpnam(tmpfilename);
  sprintf(command,"%s -cell %s -sq",QCONF_BINARY,current_cell);
  pfp=popen(command,"r");
  if(pfp) {
    ii=0;
    while(fgets(buffer,MAX_STRING_SIZE,pfp)) {
      sscanf(buffer,"%s %s",str1,str2);
      QmonTextSetString(addqueuemenu[ii].widgetid,str2);
      ii++;
    }
    pclose(pfp);
  }
  else {
    logerr("openwidget_addqueuesub: cannot do qconf -sq");
  }
}


/*
 * pb_addqueueclose - Activate callback for close
 */
XtCallbackProc pb_addqueueclose(Widget w,caddr_t client_data,caddr_t call_data)
{
  closeaddqueuemenuwin();
}


/***********************************************************
 * addqueueaction - Activate callback for action type menu
 */
XtCallbackProc addqueueaction(Widget w,caddr_t client_data,caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];

  for(ii=0;addqueuemenu[ii].name;ii++) {
    if(w==addqueuemenu[ii].widgetid) {
      sprintf(command,"%s -cell %s %s &",QCONF_BINARY,current_cell,addqueuemenu[ii].flag);
      execit(command);
      break;
    }
  }
}


/***********************************************************
 * create_addqueue_dialog - Create widgets used for the addqueue menu
 */
void create_addqueue_dialog(Widget w,XtPointer client_data,XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        addqueue_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec,clear,close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  addqueue_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w, args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  addqueue_form = XtCreateManagedWidget("form", formWidgetClass, addqueue_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_addqueuelabel=
        XtCreateManagedWidget("Configure Addqueue",labelWidgetClass,addqueue_form,args
,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_addqueuelabel); ii++;
  widget_addqueuemain=XtCreateManagedWidget("box",formWidgetClass,addqueue_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_addqueuemain,NULL,"Exec",(XtCallbackProc)pb_addqueueexec,NULL);
 clear=QmonAddButtonN(widget_addqueuemain,exec,"Clear",(XtCallbackProc)pb_addqueueclear,NULL);
 close=QmonAddButtonN(widget_addqueuemain,clear,"Close",(XtCallbackProc)pb_addqueueclose,NULL);


  widget_addqueueopt=createmenuoptions(addqueue_form,widget_addqueuemain,addqueuemenu,(XtCallbackProc)addqueueaction);
  
}


/***********************************************************
 * openwidget_addqueuesub - Open the addqueue menu
 */
void openwidget_addqueuesub(Widget w,XtPointer client_data,XtPointer call_data) 
{
  char            buffer[MAX_STRING_SIZE];
  char            command[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  int             ii;
  FILE            *pfp;
  
  create_addqueue_dialog(w,NULL,NULL);
  XtPopup(addqueue_popup,XtGrabNone);;
  
  /*
   * We need to fill in the options with the default
   * values from qconf -sq
   */
  sprintf(command,"%s -cell %s -sq ",QCONF_BINARY,current_cell);
  pfp=popen(command,"r");
  if(pfp) {
    ii=0;
    while(fgets(buffer,MAX_STRING_SIZE,pfp)) {
      sscanf(buffer,"%s %s",str1,str2);
      QmonTextSetString(addqueuemenu[ii].widgetid,str2);
      ii++;
    }
    pclose(pfp);
  }
  else {
    logerr("openwidget_addqueuesub: cannot do qconf -sq");
  }
}


/***********************************************************
 * closewidget_addqueuesub - Close the addqueue menu
 */
void closewidget_addqueuesub()
{
  XtPopdown(addqueue_popup);
}



