static char dqs_tmpdir_rcsid[]="$Id: dqs_tmpdir.c,v 1.2 2000/03/09 04:17:27 chuck Exp $";

/*----------------------------------------------------
 * dqs_tmpdir.c Tom Green Mon Jan 31 10:43:06 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_tmpdir.c,v $
 * Revision 1.2  2000/03/09 04:17:27  chuck
 * dqs_make_tmpdir() allocated memory for a pointer then called
 * dqs_string_insert which allocated new memory and smashed the
 * original pointer.
 *
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.5  1996/11/20 23:04:43  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.4  1996/03/22  04:21:35  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.3  1996/03/12  17:12:43  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.2  1995/02/22  14:29:42  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.1  1994/11/21  13:08:17  green
 * minor reformating
 *
 * Revision 3.0  1994/03/07  04:14:45  green
 * 3.0 freeze
 *
 * Revision 1.2  1994/02/09  19:48:17  green
 * syncing source with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:48  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/*******************************************************/
char *dqs_make_tmpdir(qconf,job)
     dqs_queue_type *qconf;
     dqs_job_type   *job;
     
{
  
  char   *cp;
  string str;
  struct passwd *pw;
  
  DENTER_EXT((DQS_EVENT,"dqs_make_tmpdir"));
  
  if (!qconf->tmpdir)
    {
      DEXIT;
      return(NULL);
    }
  
  pw=(struct passwd *)getpwnam(job->owner);
  if (!pw)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0527 error: getpwnam(%s) failed",job->owner));
      DEXITE;
      return (NULL);
    }
  
  bzero(str,sizeof(str));
  /* Note could have multiple instantiations of same job, */
  /* on same machine, under same queue */
  sprintf(str,"%s/%d.%s.%d",qconf->tmpdir,job->job_number,qconf->qname,me.pid);
  cp=dqs_string_insert(NULL,str);
  
  DPRINTF((DQS_EVENT,"making TMPDIR=%s",cp));
  
  dqs_mkdir(cp,pw->pw_uid,pw->pw_gid,0755);
  
  if (me.uid==0)
    {
      if (chown(cp,pw->pw_uid,pw->pw_gid))
	{ 
	  ERROR((DQS_EVENT,"DQS_ERROR_0528 error: chown(%s) failed",job->owner));
	  DEXITE;
	  return (NULL);
	}
    }
  
  FREE(qconf->tmpdir);
  DEXIT;
  return(cp);
  
}

/************************************************************************/
int dqs_remove_tmpdir(qconf,job)
     dqs_queue_type *qconf;
     dqs_job_type   *job;
     
{
  
  int i;
  string tmpstr;
  struct stat statbuf;
  
  DENTER_EXT((DQS_EVENT,"dqs_remove_tmpdir"));
  
  if (!qconf->tmpdir)
    {
      DEXIT;
      return(0);
    }
  
  if (!(i=fork()))    
    {
      sleep(2);
      dqs_set_uid_gid(job);
      sprintf(tmpstr,"%s__%s","dqs_remove_tmpdir",qconf->tmpdir);
      dqs_getme(DQS_EXECD,tmpstr);
      me.qualified_prog_name=dqs_string_insert(me.qualified_prog_name,tmpstr);
      me.unqualified_prog_name=dqs_string_insert(me.unqualified_prog_name,tmpstr);
      sprintf(tmpstr,"%s/%d.%s.%d",qconf->tmpdir,job->job_number,qconf->qname,job->pid);
      
      DPRINTF((DQS_EVENT,"recursively unlinking \"%s\"",tmpstr));
      if (stat(qconf->tmpdir,&statbuf))
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0529 error: couldn't stat %s",tmpstr));
	  DEXITE;
	  exit(DQS_ENOENT);
	}
      
      if (S_ISDIR(statbuf.st_mode)==0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0530 error: couldn't stat %s",tmpstr));
	  DEXITE;
	  exit(DQS_ENOENT);
	}
      dqs_recursive_rmdir(tmpstr);
      DEXIT;
      exit(0);
    }
  
  DEXIT;
  return(i);
  
}

/************************************************************************/
void dqs_recursive_rmdir(cp)
     char *cp;
     
{
  DIR           *cd;
  struct DIRENT *dirent_;
  struct stat   statbuf;
  char          cwd[MAX_PATH];
  
  DENTER_EXT((DQS_EVENT,"dqs_recursive_rmdir"));
  
  if (!cp)
    {
      DEXITE;
      return;
    }
  
  cd=opendir(cp);
  if (!cd)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0531 error: opendir(%s) failed",cp));
      DEXITE;
      exit(DQS_ENOENT);
    }
  
  if (!getcwd(cwd,MAX_PATH+1))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0532 error: getcwd() failed"));
      DEXITE;
      exit(DQS_ENOENT);
    }
  
  if (chdir(cp))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0533 error: chdir() failed"));
      DEXITE;
      exit(DQS_ENOENT);
    }
  
  while (dirent_=readdir(cd))
    {
      if ((strcmp(dirent_->d_name,".")!=0)&&
	  (strcmp(dirent_->d_name,"..")))
	{
	  if (stat(dirent_->d_name,&statbuf))
	    {
	      ERROR((DQS_EVENT,"DQS_ERROR_0534 error: stat(%s) failed",dirent_->d_name));
	      DEXITE;
	      exit(DQS_ENOENT);
	    }
	  if (S_ISDIR(statbuf.st_mode))
	    {
	      dqs_recursive_rmdir(dirent_->d_name);
	      DPRINTF((DQS_EVENT,"rmdir(%s)\n",dirent_->d_name));
	    }
	  else
	    {
	      DPRINTF((DQS_EVENT,"unlink(%s)\n",dirent_->d_name));
	      if (unlink(dirent_->d_name))
		{
		  ERROR((DQS_EVENT,"DQS_ERROR_0535 error: unlink(%s) failed",
			 dirent_->d_name));
		  DEXITE;
		  exit(DQS_ENOENT);
		}
	    }
	}
    }
  
  closedir(cd);
  
  if (chdir(cwd))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0536 error: chdir() failed"));
      DEXITE;
      exit(DQS_ENOENT);
    }
  
  if (rmdir(cp))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0537 error: rmdir(%s) failed",
	     cp));
      DEXITE;
      exit(DQS_ENOENT);
    }
  
  DEXIT;
  return;
  
}
