static char dqs_start_generic_rcsid[]="$Id: dqs_start_generic.c,v 1.1.1.1 1998/08/18 14:39:13 green Exp $";

/*----------------------------------------------------
 * dqs_start_generic.c Tom Green Wed Jun 15 12:25:26 1994
 *
 * Copyright 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_start_generic.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.2  1997/04/11 14:46:00  green
 * applied Curtis Janssen's patch to open "/dev/null" rather than "/" for
 * stdin
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.7  1996/11/20 23:04:37  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.6  1996/06/27  01:56:08  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.5  1996/03/22  04:21:29  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.4  1994/06/20  11:33:37  green
 * fixed bug in building the "%remote" string
 *
 * Revision 3.3  1994/06/19  18:47:04  green
 * don't force "%remote_info" on them if they don't want it
 *
 * Revision 3.2  1994/06/16  22:58:21  green
 * it's possible that the user didn't request an "exec_str" for some
 * nodes
 *
 * malloc memory and handle...
 *
 * Revision 3.1  1994/06/16  11:58:06  green
 * added the generic "exec"er
 *
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"
#include "prognames.h"

int requested_remote_info;

/************************************************************************/
void dqs_start_generic(shell_path,job,queue)
     char           *shell_path;
     dqs_job_type   *job;
     dqs_queue_type *queue;
     
     /*
       dqs_start_generic - is used soley by the dqs_execd.
       
       this routine is responsible for starting the local 
       and remote generic processes prior to the execl of 
       the "master" script.
       
     */
     
{
  
  char          *cp;
  string        tmpstr;
  dqs_list_type *lp;
  
  DENTER((DQS_EVENT,"dqs_start_generic"));
  
  requested_remote_info=FALSE;
  
  dqs_parse_generic_exec_str(job);
  
  dqs_start_generic_slave(job,queue);
  
  lp=job->granted_destin_identifier_list;
  lp=lp->next;
  
  if (!job->granted_destin_identifier_list->str3)
    job->granted_destin_identifier_list->str3=dqs_malloc(MAX_STRING_SIZE);
  
  if (requested_remote_info)
    {
      while (lp)
	{
	  strcat(job->granted_destin_identifier_list->str3," -remote_info ");
	  strcat(job->granted_destin_identifier_list->str3,lp->str1);
	  sprintf(tmpstr," %d",lp->int0);
	  strcat(job->granted_destin_identifier_list->str3,tmpstr);
	  strcat(job->granted_destin_identifier_list->str3," 1 ");
	  strcat(job->granted_destin_identifier_list->str3,lp->str3);
	  lp=lp->next;
	}
    }
  
  DEXIT;
  return;
  
}

/************************************************************************/
void dqs_start_generic_slave(job,queue)
     dqs_job_type   *job;
     dqs_queue_type *queue;
     
     
{
  
  int           i,fd;
  int           in,out,err;
  char          *stdout_path;
  char          *stderr_path;
  string        exec_str;
  dqs_list_type *lp;
  
  DENTER((DQS_EVENT,"dqs_start_generic_slave"));
  
  if (!fork())
    {
      for (i=0; i<_NFILE-1; i++)
	close(i);
      
      in=open("/dev/null",O_RDONLY);
      if (in<0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0507 error: cannot open stdin file \"/\""));
	  DEXITE;
	  exit(DQS_ENOENT);
	}
      
      stdout_path=dqs_get_path(job->stdout_path_list,job->job_name,
			       job->job_number,DQS_PAR_STDOUT);
      stderr_path=dqs_get_path(job->stderr_path_list,job->job_name,
			       job->job_number,DQS_PAR_STDERR);
      
      out=open(stdout_path,O_WRONLY|O_CREAT|O_TRUNC,0744);
      if (out<0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0508 error: cannot open output file \"%s\"",
		 stdout_path));
	  DEXITE;
	  exit(DQS_ENOENT);
	}
      
      err=open(stderr_path,O_WRONLY|O_CREAT|O_TRUNC,0744);
      if (err<0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0509 error: cannot open stdout \"%s\"",
		 stderr_path));
	  DEXITE;
	  exit(DQS_ENOENT);
	}
      
      lp=job->granted_destin_identifier_list;
      if (job->parallel_package==GENERIC_SLA)
	lp=lp->next; /* first is the "master" */
      
      bzero((char *)exec_str,sizeof(exec_str));
      sprintf(exec_str,"%s/%s",conf.dqs_bin,DSH_BINARY);
      
      while (lp)
	{
	  if ((lp->str1)&&(lp->str3))
	    if (!fork())
	      {
		ERROR((DQS_EVENT,"DQS_ERROR_0510 JID %d execl'ing(%s,%s,%s,%s)",
		       job->job_number,exec_str,DSH_BINARY,
		       lp->str1,lp->str3));
		
		execl(exec_str,DSH_BINARY,lp->str1,lp->str3,0);
		ERROR((DQS_EVENT,"DQS_ERROR_0511 JID %d execl(%s,%s,%s,%s) - failed",
		       job->job_number,exec_str,DSH_BINARY,
		       lp->str1,lp->str3));
	      }
	  lp=lp->next;
	}
      
      DEXIT;
      exit(0);
    }
  else
    {
      DEXIT;
      return;
    }
  
}

/************************************************************************/
void dqs_parse_generic_exec_str(job)
     dqs_job_type *job;
     
{
  
  /*
    
    binary [args]
    
    -execer_id      %execer_id
    
    -master_host    %master_host
    
    -my_hostname    %my_hostname
    
    -my_nodenum     %my_nodenum
    
    -total_numnodes %total_numnodes
    
    =================================================
    
    -remote_info    %remote_info
    
    "remote_hostname remote_nodenum remote_qual_path [,...]"
    
    <must be "in order" by remote_nodenum">
    
    =================================================
    
    -l qty.eq.5,-exec.eq."systest a b -my_hostname %my_hostname"
    
    =================================================
    
    EXECer/parser
    
    fills in above as needed/requested
    
    only forwards whats needed/requested
    (whether or not its used...)
    
    =================================================
    
    EXECed process
    
    must be able to "dijest" everything
    (whether or not its used...)
    
  */
  
  int           granted=0;
  int           nodenum=0;
  int           total_numnodes;
  char          *cp;
  string        tmpstr;
  dqs_list_type *granted_lp,*lp;
  dqs_list_type *head;
  
  DENTER((DQS_EVENT,"dqs_parse_generic_exec_str"));
  
  if (!job)
    {
      DEXITE;
      return;
    }
  
  if (!job->granted_destin_identifier_list)
    {
      DEXITE;
      return;
    }
  
  total_numnodes=dqs_length_of_list(job->granted_destin_identifier_list);
  
  granted_lp=job->granted_destin_identifier_list;
  
  while (granted_lp)
    {
      granted++;
      head=dqs_string2list(granted_lp->str2);
      lp=head;
      
      while (lp)
	{
	  DPRINTF((DQS_EVENT,"++>%s<++",lp->str0));
	  bzero((char *)tmpstr,sizeof(tmpstr));
	  
	  if (!strcmp(lp->str0,"%execer_id"))
	    sprintf(tmpstr,"DQS");
	  
	  else if (!strcmp(lp->str0,"%master_host"))
	    sprintf(tmpstr,"%s",job->granted_destin_identifier_list->str1);
	  
	  else if (!strcmp(lp->str0,"%my_hostname"))
	    sprintf(tmpstr,"%s",granted_lp->str1);
	  
	  else if (!strcmp(lp->str0,"%my_nodenum"))
	    sprintf(tmpstr,"%d",nodenum);
	  
	  else if (!strcmp(lp->str0,"%total_numnodes"))
	    sprintf(tmpstr,"%d",total_numnodes);
	  
	  else if (!strcmp(lp->str0,"%job_id"))
	    sprintf(tmpstr,"%d",job->job_number);
	  
	  else if (!strcmp(lp->str0,"%remote_info"))
	    {
	      if (granted==1)
		requested_remote_info=TRUE;
	      sprintf(tmpstr," ");
	    }
	  
	  else 
	    sprintf(tmpstr,"%s",lp->str0);
	  
	  lp->str1=dqs_string_insert(NULL,tmpstr);
	  
	  lp=lp->next;
	}
      
      lp=head;
      cp=dqs_malloc(MAX_STRING_SIZE);
      
      while (lp)
	{
	  strcat(cp,lp->str1);
	  strcat(cp," ");
	  lp=lp->next;
	}
      
      granted_lp->int0=nodenum;
      nodenum++;
      granted_lp->str3=dqs_string_insert(NULL,cp);
      granted_lp=granted_lp->next;
      
    }
  
  DEXIT;
  return;
  
}
