static char dqs_send_receive_rcsid[]="$Id: dqs_send_receive.c,v 1.1.1.1 1998/08/18 14:39:13 green Exp $";

/*----------------------------------------------------
 * dqs_send_receive.c Tom Green Mon Jan 31 10:43:02 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_send_receive.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.14  1996/11/20 23:04:20  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.13  1996/06/27  01:56:03  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.12  1996/03/22  04:21:12  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.11  1995/05/14  18:28:59  nrl
 * Plugged one hole in dqs_execd and qmaster handhsaking...
 * added gethostbyname calls to overcome problems with some
 * systems
 *
 * Revision 3.10  1995/03/05  04:36:45  nrl
 * Repaired error check for realloc return
 *
 * Revision 3.9  1995/03/05  03:47:36  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.8  1995/02/22  14:29:33  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.7  1995/02/15  18:40:53  nrl
 * oops... pluggin memory leak shot ourselves in the foot..
 * accidentally cleaned out good tid info
 *
 * Revision 3.6  1995/02/14  18:46:11  nrl
 * Added minor sanity check for input packets to dqs_get_list
 *
 * Revision 3.5  1995/02/12  21:55:50  nrl
 * plugged memory leak due to tid processing
 *
 * Revision 3.4  1995/02/01  23:17:39  nrl
 * Tidied up and hopefully bulletproofed "tid" management. Reversed
 * tid file naming to sort by time.
 *
 * Revision 3.3  1995/01/30  15:22:05  nrl
 * added "tid" verification between execd and qmaster to prevent
 * "ghost" jobs from persisting in visible queue. Changed ERROR messages
 * which were for information only to DEBUG messages.
 *
 * Revision 3.2  1994/06/19  14:12:59  green
 * additional error logging
 *
 * Revision 3.1  1994/06/11  19:20:06  green
 * moved the execl(dshd) out of /etc/inetd.conf and into the dqs_execd.
 * (not nearly as easy as I had thought...)
 *
 * no longer need DQS_DSHD_SERVICE
 *
 * mods were required to dqs_send_receive_list() which need to be
 * propogated to ALL ancillaries...
 *
 * Revision 3.0  1994/03/07  04:14:32  green
 * 3.0 freeze
 *
 * Revision 1.5  1994/02/25  00:08:49  green
 * added some debugging to dqs_resolve.c
 * this routine needs beefing up - BAD
 *
 * forgot to "nullify" a pointer in dqs_get_ack() causing SEGVs
 * in dqs_free_list();
 *
 * Revision 1.4  1994/02/23  20:07:41  green
 * got that puppy!
 *
 * insideous little memory leak in dqs_send_ack()/dqs_send_nak()
 *
 * Revision 1.3  1994/02/23  19:27:21  green
 * fixed memory leak numbers 503 and 504
 *
 * added additional logging into dqs_resolve.c to track
 * memory leaks 505-510
 *
 * Revision 1.2  1994/02/23  18:21:04  green
 * forgot to dqs_free_list in dqs_get_ack()
 *
 * memory leak number 449 down - only 600 more to go ...
 *
 * Revision 1.1.1.1  1994/02/01  17:57:46  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/*****************************************************************/
int  dqs_send_list_(host,service,sfd,head)
     char *host;
     char *service;
     int  sfd;
     dqs_list_type *head;
     
     /*
       dqs_send_list_ - should only be called from dqs_send_list()
       
       if (host)
       initiates connection
       else
       uses sfd
       
       returns    sfd >= 0 on success (side effect of associating SFD)
       -1 on failure       (side effect of dissassociating SFD)
     */
     
     
{
  
  int  mem_size=0;
  int  bytes_packed=0;
  int  nibbles=0;
  char *buf_ptr;
  char *cur_buf_ptr;
  
  DENTER((DQS_EVENT,"dqs_send_list_"));
  buf_ptr=NULL;
  cur_buf_ptr=NULL;
  dqs_pack_list(&buf_ptr,&cur_buf_ptr,head,&bytes_packed,&mem_size,ALL);
  nibbles=NIBBLE_SIZE(bytes_packed);
  dqs_pack_header(buf_ptr,nibbles,bytes_packed);
  
  if (host)
    {
      if (!service)
	{
	  FREE(buf_ptr);
	  ERROR((DQS_EVENT,"DQS_ERROR_0457 error: NULL service passed to dqs_send_list_()"));
	  DEXITE;
	  return(-1);
	}
      
      sfd=dqs_open_tcp(host,0,service,conf.reserved_port);
      
      if (sfd<=0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0458 unable to connect to host \"%s\"",host));
	  FREE(buf_ptr);
	  /* lets re-read the resolve_file */
	  dqs_read_resolve_file();
	  DEXITE;
	  return(-1);
	}
    }     
  
  SFD=sfd;
  
  if (dqs_writenbytes(sfd,buf_ptr,nibbles)!=nibbles)
    {
      dqs_close_sfd(sfd);
      FREE(buf_ptr);
      ERROR((DQS_EVENT,"DQS_ERROR_0459 error writting in dqs_send_list()"));
      DEXITE;
      return(-1);
    }
  
  FREE(buf_ptr);
  
  DEXIT;
  return(sfd);
  
} /* dqs_send_list_ */

/*****************************************************************/
int  dqs_send_list(cell,service,sfd,head)
     char *cell;
     char *service;
     int  sfd;
     dqs_list_type *head;
     
     /*
       dqs_send_list_ - should only be called from dqs_send_list()
       
       if (cell)
       initiates connection
       else
       use fd
     */
     
{
  
  char *host;
  char *cur_buf_ptr;
  dqs_list_type *lp;
  int clear_user, clear_tid;
  
  DENTER((DQS_EVENT,"dqs_send_list"));
  
  if (cell)
    {
      if ((me.who==QMASTER)||(me.who==DSH))
	{
	  host=cell;
	}
      else
	{
	  lp=dqs_resolve_cell(cell);
	  if (!lp)
	    {
	      ERROR((DQS_EVENT,"DQS_ERROR_0460 error: unable to resolve cell \"%s\"",cell));
	      DEXITE;
	      return(-1);
	    }
	  if (!lp->str0)
	    {
	      ERROR((DQS_EVENT,"DQS_ERROR_0461 error: bogus host associated with cell cell \"%s\"",cell));
	      DEXITE;
	      return(-1);
	    }
	  host=lp->str0;
	}
    }
  clear_tid=0;
  if (!head->tid)
    {
      head->tid=dqs_get_tid();
      clear_tid=1;
      if (!head->tid)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0462 error: dqs_get_tid() failed"));
	  DEXITE;
	  return(-1);
	}
    }
  
  clear_user=FALSE;
  if (!head->user)
    {
      head->user=dqs_string_insert(NULL,me.user_name);
      clear_user=TRUE;
    }
  
  
  switch (me.who)
    {
    case QMASTER:
      alarm(conf.alarml);
      break;
      
    case DSH:
      alarm(conf.alarml);
      break;
      
    case DQS_EXECD:
      alarm(conf.alarmm);
      break;
      
    case QMOD:
      alarm(conf.alarml*50);
      break;
      
    default:
      alarm(conf.alarms);
      break;
    }
  
  if (me.who==QMASTER)
    alarm(conf.alarml);
  
  if (cell)
    sfd=dqs_send_list_(host,service,sfd,head);
  else
    sfd=dqs_send_list_(NULL,NULL,sfd,head);
  if(clear_tid) head->tid=dqs_free_list(head->tid);
  if(clear_user){
    FREE(head->user);
  }
  
  alarm(0);
  
  if (sfd<0)
    {
      DEXITE;
      return(sfd);
    }
  else
    {
      DEXIT;
      return(sfd);
    }
  
}

/*****************************************************************/
int dqs_send_ack(sfd,request_list)
     int sfd;
     dqs_list_type *request_list;
{
  
  dqs_list_type *lp;
  
  DENTER((DQS_EVENT,"dqs_send_ack"));
  
  lp=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
  lp->status=DQS_ACK;
  
  lp->tid= (dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
  bzero((char *) lp->tid,sizeof(dqs_list_type) );
  
  if( request_list->tid){
    lp->tid->int0= request_list->tid->int0;   /* pass tid for synchronization */     
    lp->tid->int1= request_list->tid->int1;
    
    lp->tid->str0= dqs_string_insert(NULL,request_list->tid->str0);
  }
  sfd=dqs_send_list(NULL,NULL,sfd,lp);
  
  (void) dqs_free_list(lp);
  if (sfd<0)
    {
      DEXITE;
      return(-1);
    }
  
  DEXIT;
  return(0);
  
}


/*****************************************************************/
int dqs_send_nak(sfd,request_list)
     int sfd;
     dqs_list_type *request_list;
{
  
  dqs_list_type *lp;
  
  DENTER((DQS_EVENT,"dqs_send_ack"));
  
  lp=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
  lp->status=DQS_NAK;
  sfd=dqs_send_list(NULL,NULL,sfd,lp);
  (void) dqs_free_list(lp);
  if (sfd<0)
    {
      DEXITE;
      return(-1);
    }
  
  DEXIT;
  return(0);
  
}

/*****************************************************************/
int  dqs_get_list(sfd,head)
     int           sfd;
     dqs_list_type **head;
     
     
     /*
       dqs_get_list_ - should only be called from dqs_get_list
       returns 0 on success
       returns -1 on failure
     */
     
{
  PACK_MACRO_DEFS;     
  char *cur_ptr;
  char *buf_ptr;
  int  bytes_packed=0;
  int  bytes_unpacked=0;
  int  mem_size;
  int  nibbles;
  
  DENTER((DQS_EVENT,"dqs_get_list"));
  
  if (me.who==QMASTER)
    alarm(conf.alarms);
  else if (me.who==DQS_EXECD)
    alarm(conf.alarmm);
  else
    alarm(conf.alarml * 4);
  
  buf_ptr=dqs_malloc(OFFSET);
  cur_ptr=buf_ptr;
  
  SFD=sfd;
  if (dqs_readnbytes(sfd,buf_ptr,OFFSET)!=OFFSET)
    {
      dqs_close_sfd(sfd);
      ERROR((DQS_EVENT,"DQS_ERROR_0463 error: reading in dqs_get_list()"));
      FREE(buf_ptr);
      DEXITE;
      return(-1);
    }
  
  dqs_unpack_header(buf_ptr,&nibbles,&bytes_packed);
  DPRINTF((DQS_EVENT,"========> %d nibbles %d bytes are in package",
	   nibbles,bytes_packed));
  
  if(nibbles!= NIBBLE_SIZE(bytes_packed) ) {
    ERROR((DQS_EVENT,"DQS_ERROR_0464 error reading in dqs_get_list()  bogus packet"));
    DEXITE;
    return(-1);
  }         
  buf_ptr=dqs_realloc(buf_ptr,nibbles);
  if (!buf_ptr ) {
    ERROR((DQS_EVENT,"DQS_ERROR_0465 error: reading in dqs_get_list() - 2"));
    DEXITE;
    return(-1);
  }
  
  if (dqs_readnbytes(sfd,buf_ptr+OFFSET,nibbles-OFFSET)!=nibbles-OFFSET)
    {
      dqs_close_sfd(sfd);
      FREE(buf_ptr);
      ERROR((DQS_EVENT,"DQS_ERROR_0466 error reading in dqs_get_list()"));
      DEXITE;
      return(-1);
    }
  alarm(0);
  SFD=DQS_MAX_FD;
  
  cur_ptr=buf_ptr;
  cur_ptr+=OFFSET;
  bytes_unpacked=OFFSET;
  
  *head=dqs_unpack_list(buf_ptr,&cur_ptr,&bytes_unpacked,nibbles);
  
  FREE(buf_ptr);
  
  DEXIT;
  return(0);
  
} /* dqs_get_list */

/*****************************************************************/
int dqs_get_ack(sfd,request_list)
     int sfd;
     dqs_list_type *request_list;
     
{
  
  int           status;
  dqs_list_type *lp=NULL;
  
  DENTER((DQS_EVENT,"dqs_get_ack"));
  
  status=dqs_get_list(sfd,&lp);
  
  DTRACE;
  
  (void) dqs_free_list(lp);
  
  if (status)
    {
      DTRACE;
      DEXITE;
      return(-1);
    }
  
  DEXIT;
  return(0);
  
} /* dqs_get_ack */

/*****************************************************************/
int dqs_send_receive_list(cell,service,out,in)
     char *cell;
     char *service;
     dqs_list_type *out;
     dqs_list_type **in;
     
{
  
  int sfd;
  int retry;
  int sleep_time=2;
  
  DENTER((DQS_EVENT,"dqs_send_receive_list"));
  
  if (!cell)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0467 error: NULL cell passed to dqs_send_receive_list()"));
      DEXITE;
      return(-1);
    }
  
  if (!service)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0468 error: NULL service passed to dqs_send_receive_list()"));
      DEXITE;
      return(-1);
    }
  
  if (!out)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0469 error: NULL list passed to dqs_send_receive_list()"));
      DEXITE;
      return(-1);
    }
  
  if (me.who==QMASTER)
    retry=1;
  else if (me.who==DQS_EXECD)
    retry=1;
  else
    retry=DQS_NRETRIES;
  
  while (retry)
    {
      sfd=dqs_send_list(cell,service,sfd,out);
      if (sfd<0)
	{
	  DPRINTF((DQS_EVENT,"error: unable to contact cell \"%s\" - retrying",cell));
	  sleep_time+=2;
	  sleep(dqs_rand(2,sleep_time));
	  retry--;
	  continue;
	}
      if (dqs_get_list(sfd,in))
	{
	  DPRINTF((DQS_EVENT,"error: unable to get list from cell \"%s\" - retrying",cell));
	  sleep_time+=2;
	  sleep(dqs_rand(2,sleep_time));
	  retry--;
	  continue;
	}
      DEXIT;
      return(sfd);
    }
  
  ERROR((DQS_EVENT,"DQS_ERROR_0470 error: max_retries encountered - bailing out"));
  DEXITE;
  return(-1);
  
}

/*****************************************************************/
void dqs_close_sfd(sfd)
     int sfd;
     
{
  
  alarm(0);
  SFD=9999;
  shutdown(sfd,2);
  close(sfd);
  
}
