static char dqs_replicate_rcsid[]="$Id: dqs_replicate.c,v 1.2 1999/05/12 14:14:17 green Exp $";

/*----------------------------------------------------
 * dqs_replicate.c Tom Green Mon Jan 31 10:42:59 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_replicate.c,v $
 * Revision 1.2  1999/05/12 14:14:17  green
 * added support for per job cpu hard/soft max parameters
 *
 * Revision 1.1.1.1  1998/08/18 14:39:12  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:33  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.16  1997/03/26 00:48:21  nrl
 * removed "compatability" code with earlier DQS 3.1.3 to clear
 * up a problem in some installations.
 *
 * Revision 3.15  1997/03/18 17:31:42  nrl
 * replaced missing line for intercell service..
 *
 * Revision 3.14  1996/08/26  14:20:54  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.13  1996/03/17  00:57:48  nrl
 * merge in qsub prevalidation scheme and consumable restoration
 *
 * Revision 3.12  1996/02/19  19:02:20  nrl
 * added a separate subpriority field, pluys scheduling_flags and
 * job_seq_number to remove the 3.1.2.4 kludges , modified the
 * scheduling algorith once again
 *
 * Revision 3.11  1996/02/07  13:08:15  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.10  1996/01/14  22:26:37  nrl
 * Added job_status_info to contain detailed information about
 * the job status
 *
 * Revision 3.9  1996/01/14  22:16:08  nrl
 * Added last_user delay function and consumables list to
 * queue definitions
 *
 * Revision 3.8  1995/03/05  03:47:30  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.7  1994/08/02  23:11:10  green
 * added support for a crude job staging mechanism
 *
 * Revision 3.6  1994/06/12  04:45:39  green
 * yanked conf.dqs_dshd_service
 *
 * Revision 3.5  1994/06/05  16:53:54  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.4  1994/06/04  14:54:59  green
 * added the variable "job->parallel_package"
 *
 * Revision 3.3  1994/06/03  00:25:50  green
 * replaced "DQSX_STR12" with "master_queue_exec_str" in support of MPI
 * mods
 *
 * Revision 3.2  1994/05/31  02:36:24  green
 * cleaned up some WAPs(Wild Ass Pointers) wrt q->lt_heard_from_ptr
 * and q->load_avg_ptr
 *
 * Revision 3.1  1994/04/01  02:59:31  green
 * added "qalter" support
 *
 * Revision 3.0  1994/03/07  04:14:22  green
 * 3.0 freeze
 *
 * Revision 1.2  1994/02/02  20:22:17  green
 * cleaned up "qconf.c" to sync with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:46  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
dqs_list_type *dqs_replicate_list(ohead,qty)
     dqs_list_type *ohead;
     int           qty;
     
{
  
  dqs_list_type *head;
  
  DENTER_EXT((DQS_EVENT,"dqs_replicate"));   
  
  if ((ohead)&&(qty)) 
    {
      head=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
    }
  else
    {
      DEXIT;
      return(NULL);
    }
  
  head->type=ohead->type;
  head->status=ohead->status;
  head->int0=ohead->int0;
  head->int1=ohead->int1;
  head->int2=ohead->int2;
  head->int3=ohead->int3;
  head->bufsize=ohead->bufsize;
  head->user=dqs_string_insert(NULL,ohead->user);
  head->str0=dqs_string_insert(NULL,ohead->str0);
  head->str1=dqs_string_insert(NULL,ohead->str1);
  head->str2=dqs_string_insert(NULL,ohead->str2);
  head->str3=dqs_string_insert(NULL,ohead->str3);
  if (ohead->buf)
    {
      head->buf=dqs_malloc(head->bufsize);
      bcopy(ohead->buf,head->buf,head->bufsize);
    }
  
  head->rusage=dqs_replicate_rusage(ohead->rusage);
  head->queue=dqs_replicate_queue(ohead->queue);
  head->conf=dqs_replicate_conf(ohead->conf);
  head->job=dqs_replicate_job(ohead->job);
  head->me=dqs_replicate_me(ohead->me);
  head->chain=dqs_replicate_list(ohead->chain,ALL);
  head->next=dqs_replicate_list(ohead->next,qty-1);
  
  DEXIT;
  return(head);
  
}

/************************************************************************/
dqs_rusage_type *dqs_replicate_rusage(rusage)
     dqs_rusage_type *rusage;
{
  return(NULL);
}

/************************************************************************/
dqs_queue_type *dqs_replicate_queue(queue)
     dqs_queue_type *queue;
{
  dqs_queue_type *q;
  
  DENTER((DQS_EVENT,"dqs_replicate_queue"));
  
  if (queue)
    {
      q=(dqs_queue_type *)dqs_malloc(sizeof(dqs_queue_type));
    }
  else
    {
      DEXITE;
      return(NULL);
    }
  
  q->qname=dqs_string_insert(NULL,queue->qname);
  q->qhostname=dqs_string_insert(NULL,queue->qhostname);
  q->hostname=dqs_string_insert(NULL,queue->hostname);
  q->tmpdir=dqs_string_insert(NULL,queue->tmpdir);
  q->shell=dqs_string_insert(NULL,queue->shell);
  q->klog=dqs_string_insert(NULL,queue->klog);
  q->DQSX_STR22=dqs_string_insert(NULL,queue->DQSX_STR22);
  q->DQSX_STR23=dqs_string_insert(NULL,queue->DQSX_STR23);
  q->DQSX_STR24=dqs_string_insert(NULL,queue->DQSX_STR24);
  q->DQSX_STR25=dqs_string_insert(NULL,queue->DQSX_STR25);
  q->seq_no=queue->seq_no;
  q->load_massage=queue->load_massage;
  q->load_alarm=queue->load_alarm;
  q->priority=queue->priority;
  q->rerun=queue->rerun;
  q->qtype=queue->qtype;
  q->qty=queue->qty;
  q->qty_active=queue->qty_active;
  q->s_rt=queue->s_rt;
  q->h_rt=queue->h_rt;
  q->s_cpu_job=queue->s_cpu_job;
  q->h_cpu_job=queue->h_cpu_job;
  q->s_cpu=queue->s_cpu;
  q->h_cpu=queue->h_cpu;
  q->s_fsize=queue->s_fsize;
  q->h_fsize=queue->h_fsize;
  q->s_data=queue->s_data;
  q->h_data=queue->h_data;
  q->s_stack=queue->s_stack;
  q->h_stack=queue->h_stack;
  q->s_core=queue->s_core;
  q->h_core=queue->h_core;
  q->s_rss=queue->s_rss;
  q->h_rss=queue->h_rss;
  q->status=queue->status;
  q->prev_status=queue->prev_status;
  if(!(queue->load_avg_ptr))
    q->load_avg=0;
  else
    q->load_avg= *queue->load_avg_ptr;
  q->alive=queue->alive;
  if(!(queue->lt_heard_from_ptr))
    q->lt_heard_from=0;
  else
    q->lt_heard_from= *queue->lt_heard_from_ptr;
  
  q->soc=queue->soc;
  q->master=queue->master;
  q->dirty=queue->dirty;
  q->reauth_time=queue->reauth_time;
  q->state=queue->state;
  q->notify=queue->notify;
  q->last_user_delay=queue->last_user_delay;
  q->max_user_jobs=queue->max_user_jobs;
  q->acl=dqs_replicate_list(queue->acl,ALL);
  q->xacl=dqs_replicate_list(queue->xacl,ALL);
  q->owner_list=dqs_replicate_list(queue->owner_list,ALL);
  q->subordinate_list=dqs_replicate_list(queue->subordinate_list,ALL);
  q->q_activation_list=dqs_replicate_list(queue->q_activation_list,ALL);
  q->complex_list=dqs_replicate_list(queue->complex_list,ALL);
  q->job_list=dqs_replicate_list(queue->job_list,ALL);
  q->last_user=dqs_replicate_list(queue->last_user,ALL);
  q->consumables=dqs_replicate_list(queue->consumables,ALL);
  q->DQSX_L23=dqs_replicate_list(queue->DQSX_L23,ALL);
  q->DQSX_L24=dqs_replicate_list(queue->DQSX_L24,ALL);
  q->DQSX_L25=dqs_replicate_list(queue->DQSX_L25,ALL);
  
  q->suitable=queue->suitable;
  q->tagged=queue->tagged;
  q->hard_master_tagged=queue->hard_master_tagged;
  q->hard_destin_id_tagged=queue->hard_destin_id_tagged;
  q->hard_resource_tagged=queue->hard_resource_tagged;
  q->soft_master_tagged=queue->soft_master_tagged;
  q->soft_destin_id_tagged=queue->soft_destin_id_tagged;
  q->soft_resource_tagged=queue->soft_resource_tagged;
  q->suitability_level=queue->suitability_level;
  
  DEXIT;
  return(q);
}

/************************************************************************/
dqs_conf_type *dqs_replicate_conf(config)
     dqs_conf_type *config;
{
  dqs_conf_type *c;
  
  DENTER((DQS_EVENT,"dqs_replicate_conf"));
  
  if (config)
    {
      c=(dqs_conf_type *)dqs_malloc(sizeof(dqs_conf_type));
    }
  else
    {
      DEXITE;
      return(NULL);
    }
  
  c->qmaster_spool_dir=dqs_string_insert(NULL,config->qmaster_spool_dir);
  c->execd_spool_dir=dqs_string_insert(NULL,config->execd_spool_dir);
  c->default_cell=dqs_string_insert(NULL,config->default_cell);
  
  c->reserved_port=config->reserved_port;
  
  c->qmaster_service=dqs_string_insert(NULL,config->qmaster_service);
  c->dqs_execd_service=dqs_string_insert(NULL,config->dqs_execd_service);
  c->intercell_service=dqs_string_insert(NULL,config->intercell_service); 
  c->klog=dqs_string_insert(NULL,config->klog);
  
  c->reauth_time=config->reauth_time;
  
  c->mailer=dqs_string_insert(NULL,config->mailer);
  c->dqs_bin=dqs_string_insert(NULL,config->dqs_bin);
  c->administrator=dqs_string_insert(NULL,config->administrator);
  c->default_account=dqs_string_insert(NULL,config->default_account);
  
  c->min_gid=config->min_gid;
  c->min_uid=config->min_uid;
  c->maxujobs=config->maxujobs;
  c->user_access=config->user_access;
  c->default_rerun=config->default_rerun;
  c->sort_seq_no=config->sort_seq_no;
  c->sync_io=config->sync_io;
  c->loglevel=config->loglevel;
  c->logfacility=config->logfacility;
  c->load_log_time=config->load_log_time;
  c->stat_log_time=config->stat_log_time;
  c->schedule_time=config->schedule_time;
  c->max_unheard=config->max_unheard;
  c->logmail=config->logmail;
  c->alarms=config->alarms;
  c->alarmm=config->alarmm;
  c->alarml=config->alarml;
  
  c->DQSX_STR1=dqs_string_insert(NULL,config->DQSX_STR1);
  c->DQSX_STR2=dqs_string_insert(NULL,config->DQSX_STR2);
  c->DQSX_STR3=dqs_string_insert(NULL,config->DQSX_STR3);
  c->DQSX_STR4=dqs_string_insert(NULL,config->DQSX_STR4);
  c->DQSX_STR5=dqs_string_insert(NULL,config->DQSX_STR5);
  
  c->DQSX_INT1=config->DQSX_INT1;
  c->DQSX_INT2=config->DQSX_INT2;
  c->DQSX_INT3=config->DQSX_INT3;
  c->DQSX_INT4=config->DQSX_INT4;
  c->DQSX_INT5=config->DQSX_INT5;
  
  DEXIT;
  return(c);
  
}

/************************************************************************/
dqs_job_type *dqs_replicate_job(ojob)
     dqs_job_type *ojob;
{
  dqs_job_type *job;
  
  DENTER((DQS_EVENT,"dqs_replicate_job"));
  
  if (ojob)
    {
      job=(dqs_job_type *)dqs_malloc(sizeof(dqs_job_type));
    }
  else
    {
      DEXIT;
      return(NULL);
    }
  
  job->job_number=ojob->job_number;
  job->submission_time=ojob->submission_time;
  job->start_time=ojob->start_time;
  job->end_time=ojob->end_time;
  job->owner=dqs_string_insert(NULL,ojob->owner);
  job->uid=ojob->uid;
  job->euid=ojob->euid;
  job->jobs_per_user=ojob->jobs_per_user;     
  job->dqs_o_home=dqs_string_insert(NULL,ojob->dqs_o_home);
  job->dqs_o_log_name=dqs_string_insert(NULL,ojob->dqs_o_log_name);
  job->dqs_o_path=dqs_string_insert(NULL,ojob->dqs_o_path);
  job->dqs_o_mail=dqs_string_insert(NULL,ojob->dqs_o_mail);
  job->dqs_o_shell=dqs_string_insert(NULL,ojob->dqs_o_shell);
  job->dqs_o_tz=dqs_string_insert(NULL,ojob->dqs_o_tz);
  job->dqs_o_workdir=dqs_string_insert(NULL,ojob->dqs_o_workdir);
  job->dqs_o_host=dqs_string_insert(NULL,ojob->dqs_o_host);
  job->execution_time=ojob->execution_time;
  job->execution_time_op=ojob->execution_time_op;
  job->account_list=dqs_replicate_list(ojob->account_list,ALL);
  job->server_name=ojob->server_name;
  job->checkpoint_attr=ojob->checkpoint_attr;
  job->checkpoint_attr_op=ojob->checkpoint_attr_op;
  job->checkpoint_interval=ojob->checkpoint_interval;
  job->cell=dqs_string_insert(NULL,ojob->cell);
  job->cwd=dqs_string_insert(NULL,ojob->cwd);
  job->directive_prefix=dqs_string_insert(NULL,ojob->directive_prefix);
  job->stderr_path_list=dqs_replicate_list(ojob->stderr_path_list,ALL);
  job->exec_list=dqs_replicate_list(ojob->exec_list,ALL);
  job->send_msg_to_stderr=ojob->send_msg_to_stderr;
  job->full_listing=ojob->full_listing;
  job->force_submission=ojob->force_submission;     
  job->group_list=dqs_replicate_list(ojob->group_list,ALL);
  job->hold=ojob->hold;
  job->merge_stderr=ojob->merge_stderr;
  job->maint_local_output=ojob->maint_local_output;
  job->hard_resource_list=dqs_replicate_list(ojob->hard_resource_list,ALL);
  job->soft_resource_list=dqs_replicate_list(ojob->soft_resource_list,ALL);
  job->mail_options=ojob->mail_options;
  job->hard_master_list=dqs_replicate_list(ojob->hard_master_list,ALL);
  job->soft_master_list=dqs_replicate_list(ojob->soft_master_list,ALL);
  job->mail_list=dqs_replicate_list(ojob->mail_list,ALL);
  job->job_name=dqs_string_insert(NULL,ojob->job_name);
  job->stdout_path_list=dqs_replicate_list(ojob->stdout_path_list,ALL);
  job->send_msg_to_stdout=ojob->send_msg_to_stdout;
  job->priority=ojob->priority;
  job->priority_op=ojob->priority_op;
  job->hard_queue_list=dqs_replicate_list(ojob->hard_queue_list,ALL);
  job->soft_queue_list=dqs_replicate_list(ojob->soft_queue_list,ALL);
  job->op_is_destin_id=ojob->op_is_destin_id;
  job->restart=ojob->restart;
  job->states=ojob->states;
  job->signal=ojob->signal;
  job->shell_list=dqs_replicate_list(ojob->shell_list,ALL);
  job->user_list=dqs_replicate_list(ojob->user_list,ALL);
  
  job->variable_list=dqs_replicate_list(ojob->variable_list,ALL);
  job->verify=ojob->verify;
  job->env_list=dqs_replicate_list(ojob->env_list,ALL);
  job->silent=ojob->silent;
  job->destin_identifier_list=dqs_replicate_list(ojob->destin_identifier_list,ALL);
  job->consumable_resources_used=dqs_replicate_list(ojob->consumable_resources_used,ALL);
  job->job_identifier_list=dqs_replicate_list(ojob->job_identifier_list,ALL);
  job->message=dqs_string_insert(NULL,ojob->message);
  job->script_size=ojob->script_size;
  job->script_file=dqs_string_insert(NULL,ojob->script_file);
  job->script_ptr=dqs_string_insert(NULL,ojob->script_ptr);
  job->srvr_nm_list=dqs_replicate_list(ojob->srvr_nm_list,ALL);
  
  job->master_queue=dqs_string_insert(NULL,ojob->master_queue);
  job->master_queue_exec_str=dqs_string_insert(NULL,ojob->master_queue_exec_str);
  job->DQSX_STR13=dqs_string_insert(NULL,ojob->DQSX_STR13);
  job->DQSX_STR14=dqs_string_insert(NULL,ojob->DQSX_STR14);
  job->DQSX_STR15=dqs_string_insert(NULL,ojob->DQSX_STR15);
  job->ext=ojob->ext;
  job->state=ojob->state;
  job->clean=ojob->clean;
  job->parallel_package=ojob->parallel_package;
  job->scheduling_flags=ojob->scheduling_flags;
  job->subpriority=ojob->subpriority;
  job->schedule_seq_num=ojob->schedule_seq_num;          
  
  job->jid_hold_list=dqs_replicate_list(ojob->jid_hold_list,ALL);
  job->job_status_info=dqs_replicate_list(ojob->job_status_info,ALL);
  job->DQSX_L13=dqs_replicate_list(ojob->DQSX_L13,ALL);
  job->DQSX_L14=dqs_replicate_list(ojob->DQSX_L14,ALL);
  job->DQSX_L15=dqs_replicate_list(ojob->DQSX_L15,ALL);
  
  job->pid=ojob->pid;
  job->pvm_pid=ojob->pvm_pid;
  job->sig_time=ojob->sig_time;
  job->sig=ojob->sig;
  job->notified=ojob->notified;
  job->machine=dqs_string_insert(NULL,ojob->machine);
  job->script_argv_list = dqs_replicate_list(ojob->script_argv_list,ALL);
  
  DEXIT;
  return(job);
}

/************************************************************************/
dqs_me_type *dqs_replicate_me(mee)
     dqs_me_type *mee;
     
{
  return(NULL);
}

