static char dqs_pack_rcsid[]="$Id: dqs_pack.c,v 1.5 1999/05/20 18:35:29 green Exp $";

/*----------------------------------------------------
 * dqs_pack.c Tom Green Mon Jan 31 10:42:50 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_pack.c,v $
 * Revision 1.5  1999/05/20 18:35:29  green
 * added support for REAPED_ON_RESTART and DEFAULT_RESTART
 *
 * Revision 1.4  1999/05/20 17:43:31  green
 * added job_to_be_restarted field along with a number of DQS_XINT and
 * DQS_XSTR for future use
 *
 * Revision 1.3  1999/05/12 14:14:16  green
 * added support for per job cpu hard/soft max parameters
 *
 * Revision 1.2  1998/10/21 14:45:00  green
 * Red Hat Alpha port - PACKINT macros not functioning correctly with 64 bit
 * pointers - fixed
 *
 * Revision 1.1.1.1  1998/08/18 14:39:12  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.2  1997/10/15 19:14:28  decker
 * Quick mods, cleanup mostly
 *
 * Revision 1.1.1.1  1997/04/10 15:10:33  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.21  1997/03/26 00:48:19  nrl
 * removed "compatability" code with earlier DQS 3.1.3 to clear
 * up a problem in some installations.
 *
 * Revision 3.20  1996/08/26 14:20:50  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.19  1996/03/17  00:57:38  nrl
 * merge in qsub prevalidation scheme and consumable restoration
 *
 * Revision 3.18  1996/03/12  17:12:17  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.17  1996/02/19  19:02:08  nrl
 * added a separate subpriority field, pluys scheduling_flags and
 * job_seq_number to remove the 3.1.2.4 kludges , modified the
 * scheduling algorith once again
 *
 * Revision 3.16  1996/02/07  13:08:03  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.15  1996/01/14  22:26:27  nrl
 * Added job_status_info to contain detailed information about
 * the job status
 *
 * Revision 3.14  1996/01/14  22:16:04  nrl
 * Added last_user delay function and consumables list to
 * queue definitions
 *
 * Revision 3.13  1995/06/21  16:57:38  nrl
 * Major scheduling changes... added a subpriority field to manage
 * things within the user submitted priority. Added priority info to the
 * accounting file.
 *
 * Revision 3.12  1995/03/05  03:47:20  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.11  1995/02/23  23:13:54  nrl
 * Cleaned up some dangling pointers which were causing memory
 * corruption.
 *
 * Revision 3.10  1995/02/06  16:31:53  nrl
 * Added "account" info to rusage structure and to the "acc_file"
 * for analysis by user.
 *
 * Revision 3.9  1994/08/02  23:11:08  green
 * added support for a crude job staging mechanism
 *
 * Revision 3.8  1994/06/15  12:49:46  green
 * additional DEBUG info
 *
 * Revision 3.7  1994/06/12  04:45:39  green
 * yanked conf.dqs_dshd_service
 *
 * Revision 3.6  1994/06/06  01:23:03  green
 * added "dqs_dshd_service" to the DQS config
 *
 * add "-par pvm" - though we do NOT intend to support it
 * (see dqs_start_pvm.c for a more thorough discussion)
 *
 * Revision 3.5  1994/06/05  16:53:53  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.4  1994/06/04  14:54:56  green
 * added the variable "job->parallel_package"
 *
 * Revision 3.3  1994/06/03  00:25:50  green
 * replaced "DQSX_STR12" with "master_queue_exec_str" in support of MPI
 * mods
 *
 * Revision 3.2  1994/05/31  02:36:23  green
 * cleaned up some WAPs(Wild Ass Pointers) wrt q->lt_heard_from_ptr
 * and q->load_avg_ptr
 *
 * Revision 3.1  1994/04/01  02:59:29  green
 * added "qalter" support
 *
 * Revision 3.0  1994/03/07  04:14:08  green
 * 3.0 freeze
 *
 * Revision 1.2  1994/02/23  21:29:58  green
 * fixed bug with errant pointer causing Suns to choke
 *
 * added some more "cells" to "resolve_file"
 *
 * Revision 1.1.1.1  1994/02/01  17:57:43  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"


/*****************************************************************/
void dqs_pack_header(buf_ptr,nibbles,bytes_packed)
     char *buf_ptr;
     int  nibbles;
     int  bytes_packed;
     
{
  PACK_MACRO_DEFS;
  
  int  mem_size=OFFSET;
  int  total_bytes_packed;
  char *cur_buf_ptr=buf_ptr;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_header"));
  
  /* PLACE mem_size AND bytes_packed AT FRONT OF OFFSET */
  /* NOTE: we make sure to write in nibbles for encryption purposes */
  
  total_bytes_packed=bytes_packed;
  nibbles=NIBBLE_SIZE(bytes_packed);
  
  DPRINTF((DQS_EVENT,">=====dqs_pack_header() nibbles %d total_bytes_packed %d",nibbles,total_bytes_packed));
  
  bytes_packed=0;
  
  PACKINT(buf_ptr,cur_buf_ptr,nibbles,bytes_packed,mem_size);
  PACKINT(buf_ptr,cur_buf_ptr,total_bytes_packed,bytes_packed,mem_size);
  
  DEXIT;
  return;
  
}

/*****************************************************************/
void dqs_pack_list(head_ptr,cur_ptr,list_head,bytes_written,mem_size,qty)
     char          **head_ptr;
     char          **cur_ptr;
     dqs_list_type *list_head;
     int           *bytes_written;
     int           *mem_size;
     int           qty;
     
     /* 
	returns char *
	returns NULL on error
     */
     
{
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_list"));
  
  if (*mem_size==0)
    {
      *head_ptr=dqs_malloc(CHUNK);
      *cur_ptr= *head_ptr;
      *cur_ptr+=OFFSET;
      *bytes_written=OFFSET;
      *mem_size=CHUNK;
    }
  
  if ((!qty) || (!list_head))
    {
      PACKINT(*head_ptr,*cur_ptr,(u_long32)dqs_zero,*bytes_written,*mem_size);
      DEXIT;
      return;
    }
  else 
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_one,*bytes_written,*mem_size);
    }
  list_head->who=me.who;
  PACKINT(*head_ptr,*cur_ptr,list_head->who,*bytes_written,*mem_size);
  PACKINT(*head_ptr,*cur_ptr,list_head->type,*bytes_written,*mem_size);
  PACKINT(*head_ptr,*cur_ptr,list_head->status,*bytes_written,*mem_size);
  PACKINT(*head_ptr,*cur_ptr,list_head->int0,*bytes_written,*mem_size);
  PACKINT(*head_ptr,*cur_ptr,list_head->int1,*bytes_written,*mem_size);
  PACKINT(*head_ptr,*cur_ptr,list_head->int2,*bytes_written,*mem_size);
  PACKINT(*head_ptr,*cur_ptr,list_head->int3,*bytes_written,*mem_size);
  PACKINT(*head_ptr,*cur_ptr,list_head->bufsize,*bytes_written,*mem_size);
  PACKBUF(*head_ptr,*cur_ptr,list_head->buf,list_head->bufsize,*bytes_written,*mem_size);
  PACKSTR(*head_ptr,*cur_ptr,list_head->user,*bytes_written,*mem_size);
  PACKSTR(*head_ptr,*cur_ptr,list_head->str0,*bytes_written,*mem_size);
  PACKSTR(*head_ptr,*cur_ptr,list_head->str1,*bytes_written,*mem_size);
  PACKSTR(*head_ptr,*cur_ptr,list_head->str2,*bytes_written,*mem_size);
  PACKSTR(*head_ptr,*cur_ptr,list_head->str3,*bytes_written,*mem_size);
  
  dqs_pack_rusage(head_ptr,cur_ptr,list_head->rusage,bytes_written,mem_size);
  dqs_pack_queue(head_ptr,cur_ptr,list_head->queue,bytes_written,mem_size);
  dqs_pack_conf(head_ptr,cur_ptr,list_head->conf,bytes_written,mem_size);
  dqs_pack_job(head_ptr,cur_ptr,list_head->job,bytes_written,mem_size);
  dqs_pack_me(head_ptr,cur_ptr,list_head->me,bytes_written,mem_size);
  
  dqs_pack_list(head_ptr,cur_ptr,list_head->chain,bytes_written,mem_size,ALL);
  dqs_pack_list(head_ptr,cur_ptr,list_head->tid,bytes_written,mem_size,ALL);
  dqs_pack_list(head_ptr,cur_ptr,list_head->next,bytes_written,mem_size,ALL);
  
  DEXIT;
  return;
  
}

/*****************************************************************/
void dqs_pack_rusage(head_ptr,cur_ptr,rusage,bytes_written,mem_size)
     char            **head_ptr;
     char            **cur_ptr;
     dqs_rusage_type *rusage;
     int            *bytes_written;
     int            *mem_size;
     
{
  
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_rusage"));

  if (!rusage)
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_zero,*bytes_written,*mem_size);
    }
  else
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_one,*bytes_written,*mem_size);
    }

  if (!rusage)
    {
      DEXIT;
      return;
    }
  else
    {
      rusage->Version= dqs_string_insert(rusage->Version,DQS_VERSION);
      PACKSTR(*head_ptr,*cur_ptr,rusage->Version,*bytes_written,*mem_size);     	
      PACKSTR(*head_ptr,*cur_ptr,rusage->qname,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->hostname,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->master,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->group,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->owner,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->job_name,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->dqs_job_name,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->account,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->priority,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->job_number,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->submission_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->start_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->end_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->exit_status,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_wallclock,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_utime,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_stime,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_maxrss,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_ixrss,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_ismrss,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_idrss,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_isrss,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_minflt,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_majflt,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_nswap,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_inblock,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_oublock,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_msgsnd,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_msgrcv,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_nsignals,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_nvcsw,*bytes_written,*mem_size);
      /*misspell caught here by Ron Lee*/
      PACKINT(*head_ptr,*cur_ptr,rusage->ru_nivcsw,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->DQSX_STR6,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->DQSX_STR7,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->DQSX_STR8,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->DQSX_STR9,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,rusage->DQSX_STR10,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->pid,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->job_to_be_restarted,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->DQSX_INT8,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->DQSX_INT9,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,rusage->DQSX_INT10,*bytes_written,*mem_size);
    }
  
  DEXIT;
  return;
  
}

/*****************************************************************/
void dqs_pack_queue(head_ptr,cur_ptr,queue,bytes_written,mem_size)
     char           **head_ptr;
     char           **cur_ptr;
     dqs_queue_type *queue;
     int            *bytes_written;
     int            *mem_size;
     
{
  
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_queue"));

  if (!queue)
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_zero,*bytes_written,*mem_size);
    }
  else
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_one,*bytes_written,*mem_size);
    }

  if (!queue)
    {
      DEXIT;
      return;
    }
  else
    {
      queue->Version=dqs_string_insert(queue->Version, DQS_VERSION);
      PACKSTR(*head_ptr,*cur_ptr,queue->Version,*bytes_written,*mem_size);     	  
      PACKSTR(*head_ptr,*cur_ptr,queue->qname,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->qhostname,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->hostname,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->tmpdir,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->shell,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->klog,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->DQSX_STR22,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->DQSX_STR23,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->DQSX_STR24,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,queue->DQSX_STR25,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->seq_no,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->load_massage,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->load_alarm,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->priority,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->rerun,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->qtype,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->qty,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->qty_active,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_rt,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_rt,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_cpu_job,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_cpu_job,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_cpu,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_cpu,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_fsize,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_fsize,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_data,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_data,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_stack,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_stack,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_core,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_core,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->s_rss,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->h_rss,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->status,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->prev_status,*bytes_written,*mem_size);
      if (me.who==QMASTER)
	{
	  if(!queue->load_avg_ptr)
	    queue->load_avg=0;
	  else
	    queue->load_avg= *queue->load_avg_ptr;
	}
      PACKINT(*head_ptr,*cur_ptr,queue->load_avg,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->alive,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->lt_heard_from,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->soc,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->master,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->dirty,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->reauth_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->state,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->notify,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->last_user_delay,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->max_user_jobs,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->DQSX_INT25,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->DQSX_INT2006,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->DQSX_INT2007,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->DQSX_INT2008,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->DQSX_INT2009,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,queue->DQSX_INT2010,*bytes_written,*mem_size);
      

      dqs_pack_list(head_ptr,cur_ptr,queue->acl,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->xacl,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->owner_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->subordinate_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->q_activation_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->complex_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->job_list,bytes_written,mem_size,ALL);
      
      dqs_pack_list(head_ptr,cur_ptr,queue->last_user,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->consumables,bytes_written,mem_size,ALL);
      
      dqs_pack_list(head_ptr,cur_ptr,queue->DQSX_L23,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->DQSX_L24,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,queue->DQSX_L25,bytes_written,mem_size,ALL);
      
    }
  
  DEXIT;
  return;
}


/*****************************************************************/
void dqs_pack_conf(head_ptr,cur_ptr,conf,bytes_written,mem_size)
     char           **head_ptr;
     char           **cur_ptr;
     dqs_conf_type  *conf;
     int            *bytes_written;
     int            *mem_size;
{
  
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_conf"));
  
  if (!conf)
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_zero,*bytes_written,*mem_size);
    }
  else
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_one,*bytes_written,*mem_size);
    }

  if (!conf)
    {
      DEXIT;
      return;
    }
  else
    {
      conf->Version=dqs_string_insert(conf->Version, DQS_VERSION);
      PACKSTR(*head_ptr,*cur_ptr,conf->Version,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->qmaster_spool_dir,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->execd_spool_dir,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->default_cell,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->reserved_port,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->qmaster_service,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->dqs_execd_service,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->intercell_service,*bytes_written,*mem_size);
      
      PACKSTR(*head_ptr,*cur_ptr,conf->klog,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->reauth_time,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->mailer,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->dqs_bin,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->administrator,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->default_account,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->min_gid,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->min_uid,*bytes_written,*mem_size);
      
      PACKINT(*head_ptr,*cur_ptr,conf->maxujobs,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->output_handling,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->addon_script,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->addon_info,*bytes_written,*mem_size);          
      
      PACKINT(*head_ptr,*cur_ptr,conf->user_access,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->default_rerun,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->sort_seq_no,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->sync_io,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->loglevel,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->logfacility,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->load_log_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->stat_log_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->schedule_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->max_unheard,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->logmail,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->alarms,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->alarmm,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->alarml,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->DQSX_STR1,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->DQSX_STR2,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->DQSX_STR3,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->DQSX_STR4,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,conf->DQSX_STR5,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->DQSX_INT1,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->DQSX_INT2,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->DQSX_INT3,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->DQSX_INT4,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,conf->DQSX_INT5,*bytes_written,*mem_size);
    }
  
  DEXIT;
  return;
}


/*****************************************************************/
void dqs_pack_job(head_ptr,cur_ptr,job,bytes_written,mem_size)
     char           **head_ptr;
     char           **cur_ptr;
     dqs_job_type   *job;
     int            *bytes_written;
     int            *mem_size;
     
{
  
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_job"));

  if (!job)
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_zero,*bytes_written,*mem_size);
    }
  else
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_one,*bytes_written,*mem_size);
    }

  if (!job)
    {
      DEXIT;
      return;
    }
  else
    {
      
      PACKINT(*head_ptr,*cur_ptr,job->job_number,*bytes_written,*mem_size);
      job->Version= dqs_string_insert(job->Version, DQS_VERSION);
      PACKSTR(*head_ptr,*cur_ptr,job->Version,*bytes_written,*mem_size);          
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_job_name,*bytes_written,*mem_size);
      
      PACKSTR(*head_ptr,*cur_ptr,job->job_file,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->exec_file,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->status,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->submission_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->start_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->end_time,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->owner,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->uid,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->euid,*bytes_written,*mem_size);
      
      PACKINT(*head_ptr,*cur_ptr,job->jobs_per_user,*bytes_written,*mem_size);          
      
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_home,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_log_name,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_path,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_mail,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_shell,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_tz,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_workdir,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->dqs_o_host,*bytes_written,*mem_size);
      
      PACKINT(*head_ptr,*cur_ptr,job->execution_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->execution_time_op,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->account_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->server_name,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->checkpoint_attr,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->checkpoint_attr_op,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->checkpoint_interval,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->cell,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->cwd,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->directive_prefix,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->stderr_path_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->exec_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->send_msg_to_stderr,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->full_listing,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->force_submission,*bytes_written,*mem_size);          
      
      dqs_pack_list(head_ptr,cur_ptr,job->group_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->hold,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->merge_stderr,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->maint_local_output,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->hard_resource_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->soft_resource_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->mail_options,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->hard_master_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->soft_master_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->mail_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->notify,*bytes_written,*mem_size);
      
      PACKSTR(*head_ptr,*cur_ptr,job->job_name,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->stdout_path_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->send_msg_to_stdout,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->priority,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->priority_op,*bytes_written,*mem_size);
      
      dqs_pack_token_list(head_ptr,cur_ptr,job->passwd_list,bytes_written,mem_size,ALL);
      
      PACKSTR(*head_ptr,*cur_ptr,job->Passwd,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->hard_queue_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->soft_queue_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->op_is_destin_id,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->reauth_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->restart,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->state,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->states,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->signal,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->shell_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->user_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->unlog,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->variable_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->verify,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->env_list,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->silent,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->destin_identifier_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->granted_destin_identifier_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->consumable_resources_used,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->job_identifier_list,bytes_written,mem_size,ALL);
      
      PACKSTR(*head_ptr,*cur_ptr,job->message,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->script_size,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->script_file,*bytes_written,*mem_size);
      PACKBUF(*head_ptr,*cur_ptr,job->script_ptr,job->script_size,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->srvr_nm_list,bytes_written,mem_size,ALL);
      
      PACKSTR(*head_ptr,*cur_ptr,job->master_queue,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->master_queue_exec_str,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR13,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR14,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR15,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->ext,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->state,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->clean,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->parallel_package,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->scheduling_flags,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->subpriority,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->schedule_seq_num,*bytes_written,*mem_size);     
      
      dqs_pack_list(head_ptr,cur_ptr,job->jid_hold_list,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->job_status_info,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->DQSX_L13,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->DQSX_L14,bytes_written,mem_size,ALL);
      dqs_pack_list(head_ptr,cur_ptr,job->DQSX_L15,bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->pid,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->pvm_pid,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->sig_time,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->sig,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->notified,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->machine,*bytes_written,*mem_size);
      
      dqs_pack_list(head_ptr,cur_ptr,job->script_argv_list,
		    bytes_written,mem_size,ALL);
      
      PACKINT(*head_ptr,*cur_ptr,job->suspend_enable,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->soc_xsoc,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->force,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->job_to_be_restarted,*bytes_written,*mem_size);

      PACKINT(*head_ptr,*cur_ptr,job->DQSX_INT2001,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->DQSX_INT2002,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->DQSX_INT2003,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->DQSX_INT2004,*bytes_written,*mem_size);
      PACKINT(*head_ptr,*cur_ptr,job->DQSX_INT2005,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR2001,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR2002,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR2003,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR2004,*bytes_written,*mem_size);
      PACKSTR(*head_ptr,*cur_ptr,job->DQSX_STR2005,*bytes_written,*mem_size);
    }
  
  
  DEXIT;
  return;
  
}


/*****************************************************************/
void dqs_pack_me(head_ptr,cur_ptr,me,bytes_written,mem_size)
     char           **head_ptr;
     char           **cur_ptr;
     dqs_me_type    *me;
     int            *bytes_written;
     int            *mem_size;
     
{
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_me"));
  
  
  DEXIT;
  return;
  
}

/*****************************************************************/
void dqs_pack_token(head_ptr,cur_ptr,cp,bytes_written,mem_size,qty)
     char          **head_ptr;
     char          **cur_ptr;
     char          *cp;
     int           *bytes_written;
     int           *mem_size;
     int           qty;
     
     /* 
	returns char *
	returns NULL on error
     */
     
{
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_list"));
  
  if (*mem_size==0)
    {
      *head_ptr=dqs_malloc(CHUNK);
      *cur_ptr= *head_ptr;
      *cur_ptr+=OFFSET;
      *bytes_written=OFFSET;
      *mem_size=CHUNK;
    }
  
  if (!cp)
    {
      PACKINT(*head_ptr,*cur_ptr,(u_long32)dqs_zero,*bytes_written,*mem_size);
      DEXIT;
      return;
    }
  else 
    {
      PACKBUF(*head_ptr,*cur_ptr,cp,TOKEN_SIZE,*bytes_written,*mem_size);
    }
  
  DEXIT;
  return;
  
}

/*****************************************************************/
void dqs_pack_token_list(head_ptr,cur_ptr,list_head,bytes_written,mem_size,qty)
     char          **head_ptr;
     char          **cur_ptr;
     dqs_list_type *list_head;
     int           *bytes_written;
     int           *mem_size;
     int           qty;
     
     /* 
	returns char *
	returns NULL on error
     */
     
{
  PACK_MACRO_DEFS;
  
  DENTER_EXT((DQS_EVENT,"dqs_pack_token_list"));
  
  if (*mem_size==0)
    {
      *head_ptr=dqs_malloc(CHUNK);
      *cur_ptr= *head_ptr;
      *cur_ptr+=OFFSET;
      *bytes_written=OFFSET;
      *mem_size=CHUNK;
    }
  
  if ((!qty) || (!list_head))
    {
      PACKINT(*head_ptr,*cur_ptr,(u_long32)dqs_zero,*bytes_written,*mem_size);
      DEXIT;
      return;
    }
  else 
    {
      PACKINT(*head_ptr,*cur_ptr,dqs_one,*bytes_written,*mem_size);
    }
  
  PACKBUF(*head_ptr,*cur_ptr,list_head->buf,TOKEN_SIZE,*bytes_written,*mem_size);
  PACKSTR(*head_ptr,*cur_ptr,list_head->str0,*bytes_written,*mem_size);
  PACKSTR(*head_ptr,*cur_ptr,list_head->str1,*bytes_written,*mem_size);
  
  dqs_pack_token_list(head_ptr,cur_ptr,list_head->next,bytes_written,mem_size,ALL);
  
  DEXIT;
  return;
  
}
