/*
 * This file is part of the Code::Blocks IDE and licensed under the GNU General Public License, version 3
 * http://www.gnu.org/licenses/gpl-3.0.html
 *
 * $Revision: 10292 $
 * $Id: ProjectOptionsManipulatorResultDlg.cpp 10292 2015-05-15 10:58:48Z jenslody $
 * $HeadURL: http://svn.code.sf.net/p/codeblocks/code/branches/release-16.xx/src/plugins/contrib/ProjectOptionsManipulator/ProjectOptionsManipulatorResultDlg.cpp $
 */

#include "ProjectOptionsManipulatorResultDlg.h"

//(*InternalHeaders(ProjectOptionsManipulatorResultDlg)
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
//*)

//(*IdInit(ProjectOptionsManipulatorResultDlg)
const long ProjectOptionsManipulatorResultDlg::ID_TXT_RESULT = wxNewId();
//*)

BEGIN_EVENT_TABLE(ProjectOptionsManipulatorResultDlg,wxDialog)
	//(*EventTable(ProjectOptionsManipulatorResultDlg)
	//*)
END_EVENT_TABLE()

ProjectOptionsManipulatorResultDlg::ProjectOptionsManipulatorResultDlg(wxWindow* parent,wxWindowID id)
{
	//(*Initialize(ProjectOptionsManipulatorResultDlg)
	wxStdDialogButtonSizer* sbzOK;
	wxStaticText* lblResult;
	wxBoxSizer* bszMainV;
	wxBoxSizer* bszMainH;

	Create(parent, id, _("Project Options Plugin - Results"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER, _T("id"));
	bszMainH = new wxBoxSizer(wxHORIZONTAL);
	bszMainV = new wxBoxSizer(wxVERTICAL);
	lblResult = new wxStaticText(this, wxID_ANY, _("Result of search:"), wxDefaultPosition, wxDefaultSize, 0, _T("wxID_ANY"));
	bszMainV->Add(lblResult, 0, wxTOP|wxLEFT|wxRIGHT|wxEXPAND, 5);
	m_TxtResult = new wxTextCtrl(this, ID_TXT_RESULT, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY, wxDefaultValidator, _T("ID_TXT_RESULT"));
	m_TxtResult->SetMinSize(wxSize(400,200));
	bszMainV->Add(m_TxtResult, 1, wxLEFT|wxRIGHT|wxEXPAND, 5);
	sbzOK = new wxStdDialogButtonSizer();
	sbzOK->AddButton(new wxButton(this, wxID_OK, wxEmptyString));
	sbzOK->Realize();
	bszMainV->Add(sbzOK, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 5);
	bszMainH->Add(bszMainV, 1, wxEXPAND, 5);
	SetSizer(bszMainH);
	bszMainH->Fit(this);
	bszMainH->SetSizeHints(this);
	//*)
}

ProjectOptionsManipulatorResultDlg::~ProjectOptionsManipulatorResultDlg()
{
	//(*Destroy(ProjectOptionsManipulatorResultDlg)
	//*)
}

void ProjectOptionsManipulatorResultDlg::ApplyResult(const wxArrayString& result)
{
  m_TxtResult->Clear();
  for (size_t i=0; i<result.Count(); ++i)
    m_TxtResult->AppendText( result[i] + wxT("\n") );
}
