# Makefile for PGPLOT. 
# This file is automatically generated.  
# 
# This generates the PGPLOT binary files (libraries and demos) in the 
# current default directory. 
#----------------------------------------------------------------------- 
#	PGPLOT subdirectories 
SRCDIR = :src: 
DEMDIR = :examples: 
FNTDIR = :fonts: 
DRVDIR = :drivers: 
SYSDIR = :sys_mac: 
GENDIR = :sys: 
# 
# FCOMPL contains the name of the fortran compiler.  FFLAGC contains the 
# compiler options for the pgplot routines.  FFLAGD contains the compiler 
# options used for the example programs.  To produce 68020 or 
# or 68030 code, add -mc68020 to FFLAGC or FFLAGD.  If you to produce 
# 68881 or 68882 code, add -mc68881 to FFLAGC or FFLAGD.  If you do 
# use the 68020 or the 68881 then you should used them when compiling the 
# other files that are link with the pgplot library.  If you use the 68881 
# option then you also need to link in the FPU libraries,  
# APS Drive:MPW:Libraries:FLibraries:IntrinsicLibFPU.o, APS Drive:MPW:Libraries:FLibraries:FSANELibFPU.o.  FLINK contains 
# the name of the fortran link command used for creating the example programs. 
# If mc68881 is used to create pgplot.lib, change FLINK to LinkFortranFPU  
# instead of LinkFortran.  However, I did not get pgdemo1 to work with mc68881. 
# The other example programs work fine. 
# FFLAGU contains the compiler options for create_grexec, create_doc, and 
# pgpack.  FLINK contains the link options for these same programs. Using 
# the mc68881 compiler option probably will not speed up performance in 
# these programs because very little real operations are performed.  I set 
# the optimization lower since compile time is more important.  I also set 
# the background option higher since these programs do not call many 
# subroutines. 
# 
FCOMPL = FORTRAN 
FFLAGC = -u -saveall -b -opt=0 -bkg=0 -mc68020 
FFLAGD = -u -saveall -b -opt=0 -bkg=0 -mc68020
FFLAGU = -u -saveall -b -opt=0 -bkg=0 -mc68020
FLINK = LinkFortran 
#  
#  Name of script to set memory size in demo programs. 
#  
SizRes = AddSizeResource  
# 
# Routine lists. 
# 
PG_ROUTINES = 
		 {SRCDIR}pgarro.f.o 
		 {SRCDIR}pgask.f.o 
		 {SRCDIR}pgband.f.o 
		 {SRCDIR}pgbbuf.f.o 
		 {SYSDIR}pgbeg.f.o 
		 {SRCDIR}pgbin.f.o 
		 {SRCDIR}pgbox.f.o 
		 {SRCDIR}pgbox1.f.o 
		 {SRCDIR}pgcirc.f.o 
		 {SRCDIR}pgcl.f.o 
		 {SRCDIR}pgcn01.f.o 
		 {SRCDIR}pgcnsc.f.o 
		 {SRCDIR}pgconb.f.o 
		 {SRCDIR}pgconl.f.o 
		 {SRCDIR}pgcons.f.o 
		 {SRCDIR}pgcont.f.o 
		 {SRCDIR}pgconx.f.o 
		 {SRCDIR}pgcp.f.o 
		 {SRCDIR}pgctab.f.o 
		 {SRCDIR}pgcurs.f.o 
		 {SRCDIR}pgdraw.f.o 
		 {SRCDIR}pgebuf.f.o 
		 {SRCDIR}pgend.f.o 
		 {SRCDIR}pgenv.f.o 
		 {SRCDIR}pgeras.f.o 
		 {SRCDIR}pgerrb.f.o 
		 {SRCDIR}pgerrx.f.o 
		 {SRCDIR}pgerry.f.o 
		 {SRCDIR}pgetxt.f.o 
		 {SRCDIR}pgfunt.f.o 
		 {SRCDIR}pgfunx.f.o 
		 {SRCDIR}pgfuny.f.o 
		 {SRCDIR}pggray.f.o 
		 {SRCDIR}pghi2d.f.o 
		 {SRCDIR}pghis1.f.o 
		 {SRCDIR}pghist.f.o 
		 {SRCDIR}pghtch.f.o 
		 {SRCDIR}pgiden.f.o 
		 {SRCDIR}pgimag.f.o 
		 {SRCDIR}pglab.f.o 
		 {SRCDIR}pglcur.f.o 
		 {SRCDIR}pgldev.f.o 
		 {SRCDIR}pglen.f.o 
		 {SRCDIR}pgline.f.o 
		 {SRCDIR}pgmove.f.o 
		 {SRCDIR}pgmtxt.f.o 
		 {SRCDIR}pgncur.f.o 
		 {SRCDIR}pgnoto.f.o 
		 {SRCDIR}pgnpl.f.o 
		 {SRCDIR}pgnumb.f.o 
		 {SRCDIR}pgolin.f.o 
		 {SYSDIR}pgpage.f.o 
		 {SRCDIR}pgpanl.f.o 
		 {SRCDIR}pgpap.f.o 
		 {SRCDIR}pgpixl.f.o 
		 {SRCDIR}pgpnts.f.o 
		 {SRCDIR}pgpoly.f.o 
		 {SRCDIR}pgpt.f.o 
		 {SRCDIR}pgptxt.f.o 
		 {SRCDIR}pgqah.f.o 
		 {SRCDIR}pgqcf.f.o 
		 {SRCDIR}pgqch.f.o 
		 {SRCDIR}pgqci.f.o 
		 {SRCDIR}pgqcir.f.o 
		 {SRCDIR}pgqcol.f.o 
		 {SRCDIR}pgqcr.f.o 
		 {SRCDIR}pgqcs.f.o 
		 {SRCDIR}pgqfs.f.o 
		 {SRCDIR}pgqhs.f.o 
		 {SRCDIR}pgqinf.f.o 
		 {SRCDIR}pgqitf.f.o 
		 {SRCDIR}pgqls.f.o 
		 {SRCDIR}pgqlw.f.o 
		 {SRCDIR}pgqpos.f.o 
		 {SRCDIR}pgqtbg.f.o 
		 {SRCDIR}pgqtxt.f.o 
		 {SRCDIR}pgqvp.f.o 
		 {SRCDIR}pgqvsz.f.o 
		 {SRCDIR}pgqwin.f.o 
		 {SRCDIR}pgrect.f.o 
		 {SRCDIR}pgrnd.f.o 
		 {SRCDIR}pgrnge.f.o 
		 {SRCDIR}pgsah.f.o 
		 {SRCDIR}pgsave.f.o 
		 {SRCDIR}pgscf.f.o 
		 {SRCDIR}pgsch.f.o 
		 {SRCDIR}pgsci.f.o 
		 {SRCDIR}pgscir.f.o 
		 {SRCDIR}pgscr.f.o 
		 {SRCDIR}pgscrn.f.o 
		 {SRCDIR}pgsfs.f.o 
		 {SRCDIR}pgshls.f.o 
		 {SRCDIR}pgshs.f.o 
		 {SRCDIR}pgsitf.f.o 
		 {SRCDIR}pgsls.f.o 
		 {SRCDIR}pgslw.f.o 
		 {SRCDIR}pgstbg.f.o 
		 {SRCDIR}pgsubp.f.o 
		 {SRCDIR}pgsvp.f.o 
		 {SRCDIR}pgswin.f.o 
		 {SRCDIR}pgtbox.f.o 
		 {SRCDIR}pgtext.f.o 
		 {SRCDIR}pgupdt.f.o 
		 {SRCDIR}pgvect.f.o 
		 {SRCDIR}pgvsiz.f.o 
		 {SRCDIR}pgvstd.f.o 
		 {SRCDIR}pgvw.f.o 
		 {SRCDIR}pgwedg.f.o 
		 {SRCDIR}pgwnad.f.o

PG_NON_STANDARD = 
		 {SRCDIR}pgadvance.f.o 
		 {SRCDIR}pgbegin.f.o 
		 {SRCDIR}pgcurse.f.o 
		 {SRCDIR}pglabel.f.o 
		 {SRCDIR}pgmtext.f.o 
		 {SRCDIR}pgncurse.f.o 
		 {SRCDIR}pgpaper.f.o 
		 {SRCDIR}pgpoint.f.o 
		 {SRCDIR}pgptext.f.o 
		 {SRCDIR}pgvport.f.o 
		 {SRCDIR}pgvsize.f.o 
		 {SRCDIR}pgvstand.f.o 
		 {SRCDIR}pgwindow.f.o

GR_ROUTINES = 
		 {SRCDIR}grarea.f.o 
		 {SRCDIR}grbpic.f.o 
		 {SRCDIR}grchsz.f.o 
		 {SRCDIR}grclip.f.o 
		 {SRCDIR}grclos.f.o 
		 {SRCDIR}grclpl.f.o 
		 {SRCDIR}grctoi.f.o 
		 {SRCDIR}grcurs.f.o 
		 {SRCDIR}grdot0.f.o 
		 {SRCDIR}grdtyp.f.o 
		 {SRCDIR}gresc.f.o 
		 {SRCDIR}grepic.f.o 
		 {SRCDIR}gretxt.f.o 
		 {SRCDIR}grfa.f.o 
		 {SRCDIR}grfao.f.o 
		 {SYSDIR}grgfil.f.o 
		 {SRCDIR}grgray.f.o 
		 {SRCDIR}grimg0.f.o 
		 {SRCDIR}grimg1.f.o 
		 {SRCDIR}grimg2.f.o 
		 {SRCDIR}grimg3.f.o 
		 {SRCDIR}gritoc.f.o 
		 {SRCDIR}grldev.f.o 
		 {SRCDIR}grlen.f.o 
		 {SRCDIR}grlin0.f.o 
		 {SRCDIR}grlin1.f.o 
		 {SRCDIR}grlin2.f.o 
		 {SRCDIR}grlin3.f.o 
		 {SRCDIR}grlina.f.o 
		 {SRCDIR}grmcur.f.o 
		 {SRCDIR}grmker.f.o 
		 {SRCDIR}grmova.f.o 
		 {SRCDIR}grmsg.f.o 
		 {SYSDIR}gropen.f.o 
		 {SRCDIR}grpage.f.o 
		 {SRCDIR}grpars.f.o 
		 {SRCDIR}grpixl.f.o 
		 {SRCDIR}grpocl.f.o 
		 {SRCDIR}grprom.f.o 
		 {SRCDIR}grpxpo.f.o 
		 {SRCDIR}grpxps.f.o 
		 {SRCDIR}grpxpx.f.o 
		 {SRCDIR}grpxre.f.o 
		 {SRCDIR}grqcap.f.o 
		 {SRCDIR}grqci.f.o 
		 {SRCDIR}grqcol.f.o 
		 {SRCDIR}grqcr.f.o 
		 {SRCDIR}grqdev.f.o 
		 {SRCDIR}grqdt.f.o 
		 {SRCDIR}grqfnt.f.o 
		 {SRCDIR}grqls.f.o 
		 {SRCDIR}grqlw.f.o 
		 {SRCDIR}grqpos.f.o 
		 {SRCDIR}grqtxt.f.o 
		 {SRCDIR}grqtyp.f.o 
		 {SRCDIR}grquit.f.o 
		 {SRCDIR}grrec0.f.o 
		 {SRCDIR}grrect.f.o 
		 {SRCDIR}grsci.f.o 
		 {SRCDIR}grscr.f.o 
		 {SRCDIR}grsetc.f.o 
		 {SRCDIR}grsets.f.o 
		 {SRCDIR}grsfnt.f.o 
		 {SRCDIR}grsize.f.o 
		 {SRCDIR}grskpb.f.o 
		 {SRCDIR}grslct.f.o 
		 {SRCDIR}grsls.f.o 
		 {SRCDIR}grslw.f.o 
		 {SRCDIR}grsyds.f.o 
		 {SRCDIR}grsymk.f.o 
		 {SRCDIR}grsyxd.f.o 
		 {SRCDIR}grterm.f.o 
		 {SRCDIR}grtext.f.o 
		 {SRCDIR}grtoup.f.o 
		 {SRCDIR}grtrim.f.o 
		 {SRCDIR}grtrn0.f.o 
		 {SRCDIR}grtxy0.f.o 
		 {SRCDIR}grvct0.f.o 
		 {SRCDIR}grwarn.f.o 
		 {SRCDIR}grxhls.f.o 
		 {SRCDIR}grxrgb.f.o

SYSTEM_ROUTINES = 
		 {SYSDIR}grdate.f.o 
		 {GENDIR}grflun.f.o 
		 {GENDIR}grgcom.f.o 
		 {SYSDIR}grgenv.f.o 
		 {GENDIR}grglun.f.o 
		 {SYSDIR}grgmem.f.o 
		 {GENDIR}grgmsg.f.o 
		 {GENDIR}grlgtr.f.o 
		 {GENDIR}groptx.f.o 
		 {SYSDIR}grsy00.f.o 
		 {SYSDIR}grtrml.f.o 
		 {GENDIR}grtter.f.o 
		 {SYSDIR}gruser.f.o

DRIV_LIST = 
		 {DRVDIR}GLDRIV.f.o 
		 {SYSDIR}HGDRIV.f.o 
		 {DRVDIR}HPDRIV.f.o 
		 {DRVDIR}LXDRIV.f.o 
		 {SYSDIR}MCDRIV.f.o 
		 {SYSDIR}MFDRIV.f.o 
		 {DRVDIR}NUDRIV.f.o 
		 {DRVDIR}PSDRIV.f.o

OBSOLETE_ROUTINES = 
		 {SRCDIR}grchar.f.o 
		 {SRCDIR}grchr0.f.o 
		 {SRCDIR}grdat2.f.o 
		 {SRCDIR}grgtc0.f.o 
		 {SRCDIR}grinqfont.f.o 
		 {SRCDIR}grinqli.f.o 
		 {SRCDIR}grinqpen.f.o 
		 {SRCDIR}grlinr.f.o 
		 {SRCDIR}grmark.f.o 
		 {SRCDIR}grmovr.f.o 
		 {SRCDIR}grsetfont.f.o 
		 {SRCDIR}grsetli.f.o 
		 {SRCDIR}grsetpen.f.o 
		 {SRCDIR}grtran.f.o 
		 {SRCDIR}grvect.f.o 
		 {SRCDIR}pgsetc.f.o 
		 {SRCDIR}pgsize.f.o

MAC_ROUTINES = 
		 {SYSDIR}pgblck.f.o

# 
#----------------------------------------------------------------------- 
# Rules for compiling the .o files 
#----------------------------------------------------------------------- 
#
all  pgplot.lib grfont.dat demos
pgplot.lib  {PG_ROUTINES} {PG_NON_STANDARD} {GR_ROUTINES} 
grexec.f.o {DRIV_LIST} {SYSTEM_ROUTINES} {MAC_ROUTINES}
	 Lib -f -mf {PG_ROUTINES} 
		 {PG_NON_STANDARD} 
		 {GR_ROUTINES} 
		 {DRIV_LIST} 
		 {SYSTEM_ROUTINES} 
		 {MAC_ROUTINES} 
		 grexec.f.o  -o pgplot.lib
{SRCDIR}pgarro.f.o  {SRCDIR}pgarro.f
	 {FCOMPL}  {SRCDIR}pgarro.f  {FFLAGC}
{SRCDIR}pgask.f.o  {SRCDIR}pgask.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgask.f  {FFLAGC}
{SRCDIR}pgband.f.o  {SRCDIR}pgband.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgband.f  {FFLAGC}
{SRCDIR}pgbbuf.f.o  {SRCDIR}pgbbuf.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgbbuf.f  {FFLAGC}
{SYSDIR}pgbeg.f.o  {SYSDIR}pgbeg.f pgplot.inc
	 {FCOMPL}  {SYSDIR}pgbeg.f  {FFLAGC}
{SRCDIR}pgbin.f.o  {SRCDIR}pgbin.f
	 {FCOMPL}  {SRCDIR}pgbin.f  {FFLAGC}
{SRCDIR}pgbox.f.o  {SRCDIR}pgbox.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgbox.f  {FFLAGC}
{SRCDIR}pgbox1.f.o  {SRCDIR}pgbox1.f
	 {FCOMPL}  {SRCDIR}pgbox1.f  {FFLAGC}
{SRCDIR}pgcirc.f.o  {SRCDIR}pgcirc.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgcirc.f  {FFLAGC}
{SRCDIR}pgcl.f.o  {SRCDIR}pgcl.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgcl.f  {FFLAGC}
{SRCDIR}pgcn01.f.o  {SRCDIR}pgcn01.f
	 {FCOMPL}  {SRCDIR}pgcn01.f  {FFLAGC}
{SRCDIR}pgcnsc.f.o  {SRCDIR}pgcnsc.f
	 {FCOMPL}  {SRCDIR}pgcnsc.f  {FFLAGC}
{SRCDIR}pgconb.f.o  {SRCDIR}pgconb.f
	 {FCOMPL}  {SRCDIR}pgconb.f  {FFLAGC}
{SRCDIR}pgconl.f.o  {SRCDIR}pgconl.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgconl.f  {FFLAGC}
{SRCDIR}pgcons.f.o  {SRCDIR}pgcons.f
	 {FCOMPL}  {SRCDIR}pgcons.f  {FFLAGC}
{SRCDIR}pgcont.f.o  {SRCDIR}pgcont.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgcont.f  {FFLAGC}
{SRCDIR}pgconx.f.o  {SRCDIR}pgconx.f
	 {FCOMPL}  {SRCDIR}pgconx.f  {FFLAGC}
{SRCDIR}pgcp.f.o  {SRCDIR}pgcp.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgcp.f  {FFLAGC}
{SRCDIR}pgctab.f.o  {SRCDIR}pgctab.f
	 {FCOMPL}  {SRCDIR}pgctab.f  {FFLAGC}
{SRCDIR}pgcurs.f.o  {SRCDIR}pgcurs.f
	 {FCOMPL}  {SRCDIR}pgcurs.f  {FFLAGC}
{SRCDIR}pgdraw.f.o  {SRCDIR}pgdraw.f
	 {FCOMPL}  {SRCDIR}pgdraw.f  {FFLAGC}
{SRCDIR}pgebuf.f.o  {SRCDIR}pgebuf.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgebuf.f  {FFLAGC}
{SRCDIR}pgend.f.o  {SRCDIR}pgend.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgend.f  {FFLAGC}
{SRCDIR}pgenv.f.o  {SRCDIR}pgenv.f
	 {FCOMPL}  {SRCDIR}pgenv.f  {FFLAGC}
{SRCDIR}pgeras.f.o  {SRCDIR}pgeras.f
	 {FCOMPL}  {SRCDIR}pgeras.f  {FFLAGC}
{SRCDIR}pgerrb.f.o  {SRCDIR}pgerrb.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgerrb.f  {FFLAGC}
{SRCDIR}pgerrx.f.o  {SRCDIR}pgerrx.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgerrx.f  {FFLAGC}
{SRCDIR}pgerry.f.o  {SRCDIR}pgerry.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgerry.f  {FFLAGC}
{SRCDIR}pgetxt.f.o  {SRCDIR}pgetxt.f
	 {FCOMPL}  {SRCDIR}pgetxt.f  {FFLAGC}
{SRCDIR}pgfunt.f.o  {SRCDIR}pgfunt.f
	 {FCOMPL}  {SRCDIR}pgfunt.f  {FFLAGC}
{SRCDIR}pgfunx.f.o  {SRCDIR}pgfunx.f
	 {FCOMPL}  {SRCDIR}pgfunx.f  {FFLAGC}
{SRCDIR}pgfuny.f.o  {SRCDIR}pgfuny.f
	 {FCOMPL}  {SRCDIR}pgfuny.f  {FFLAGC}
{SRCDIR}pggray.f.o  {SRCDIR}pggray.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pggray.f  {FFLAGC}
{SRCDIR}pghi2d.f.o  {SRCDIR}pghi2d.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pghi2d.f  {FFLAGC}
{SRCDIR}pghis1.f.o  {SRCDIR}pghis1.f
	 {FCOMPL}  {SRCDIR}pghis1.f  {FFLAGC}
{SRCDIR}pghist.f.o  {SRCDIR}pghist.f
	 {FCOMPL}  {SRCDIR}pghist.f  {FFLAGC}
{SRCDIR}pghtch.f.o  {SRCDIR}pghtch.f
	 {FCOMPL}  {SRCDIR}pghtch.f  {FFLAGC}
{SRCDIR}pgiden.f.o  {SRCDIR}pgiden.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgiden.f  {FFLAGC}
{SRCDIR}pgimag.f.o  {SRCDIR}pgimag.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgimag.f  {FFLAGC}
{SRCDIR}pglab.f.o  {SRCDIR}pglab.f
	 {FCOMPL}  {SRCDIR}pglab.f  {FFLAGC}
{SRCDIR}pglcur.f.o  {SRCDIR}pglcur.f
	 {FCOMPL}  {SRCDIR}pglcur.f  {FFLAGC}
{SRCDIR}pgldev.f.o  {SRCDIR}pgldev.f
	 {FCOMPL}  {SRCDIR}pgldev.f  {FFLAGC}
{SRCDIR}pglen.f.o  {SRCDIR}pglen.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pglen.f  {FFLAGC}
{SRCDIR}pgline.f.o  {SRCDIR}pgline.f
	 {FCOMPL}  {SRCDIR}pgline.f  {FFLAGC}
{SRCDIR}pgmove.f.o  {SRCDIR}pgmove.f
	 {FCOMPL}  {SRCDIR}pgmove.f  {FFLAGC}
{SRCDIR}pgmtxt.f.o  {SRCDIR}pgmtxt.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgmtxt.f  {FFLAGC}
{SRCDIR}pgncur.f.o  {SRCDIR}pgncur.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgncur.f  {FFLAGC}
{SRCDIR}pgnoto.f.o  {SRCDIR}pgnoto.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgnoto.f  {FFLAGC}
{SRCDIR}pgnpl.f.o  {SRCDIR}pgnpl.f
	 {FCOMPL}  {SRCDIR}pgnpl.f  {FFLAGC}
{SRCDIR}pgnumb.f.o  {SRCDIR}pgnumb.f
	 {FCOMPL}  {SRCDIR}pgnumb.f  {FFLAGC}
{SRCDIR}pgolin.f.o  {SRCDIR}pgolin.f
	 {FCOMPL}  {SRCDIR}pgolin.f  {FFLAGC}
{SYSDIR}pgpage.f.o  {SYSDIR}pgpage.f pgplot.inc
	 {FCOMPL}  {SYSDIR}pgpage.f  {FFLAGC}
{SRCDIR}pgpanl.f.o  {SRCDIR}pgpanl.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgpanl.f  {FFLAGC}
{SRCDIR}pgpap.f.o  {SRCDIR}pgpap.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgpap.f  {FFLAGC}
{SRCDIR}pgpixl.f.o  {SRCDIR}pgpixl.f
	 {FCOMPL}  {SRCDIR}pgpixl.f  {FFLAGC}
{SRCDIR}pgpnts.f.o  {SRCDIR}pgpnts.f
	 {FCOMPL}  {SRCDIR}pgpnts.f  {FFLAGC}
{SRCDIR}pgpoly.f.o  {SRCDIR}pgpoly.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgpoly.f  {FFLAGC}
{SRCDIR}pgpt.f.o  {SRCDIR}pgpt.f
	 {FCOMPL}  {SRCDIR}pgpt.f  {FFLAGC}
{SRCDIR}pgptxt.f.o  {SRCDIR}pgptxt.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgptxt.f  {FFLAGC}
{SRCDIR}pgqah.f.o  {SRCDIR}pgqah.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqah.f  {FFLAGC}
{SRCDIR}pgqcf.f.o  {SRCDIR}pgqcf.f
	 {FCOMPL}  {SRCDIR}pgqcf.f  {FFLAGC}
{SRCDIR}pgqch.f.o  {SRCDIR}pgqch.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqch.f  {FFLAGC}
{SRCDIR}pgqci.f.o  {SRCDIR}pgqci.f
	 {FCOMPL}  {SRCDIR}pgqci.f  {FFLAGC}
{SRCDIR}pgqcir.f.o  {SRCDIR}pgqcir.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqcir.f  {FFLAGC}
{SRCDIR}pgqcol.f.o  {SRCDIR}pgqcol.f
	 {FCOMPL}  {SRCDIR}pgqcol.f  {FFLAGC}
{SRCDIR}pgqcr.f.o  {SRCDIR}pgqcr.f
	 {FCOMPL}  {SRCDIR}pgqcr.f  {FFLAGC}
{SRCDIR}pgqcs.f.o  {SRCDIR}pgqcs.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqcs.f  {FFLAGC}
{SRCDIR}pgqfs.f.o  {SRCDIR}pgqfs.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqfs.f  {FFLAGC}
{SRCDIR}pgqhs.f.o  {SRCDIR}pgqhs.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqhs.f  {FFLAGC}
{SRCDIR}pgqinf.f.o  {SRCDIR}pgqinf.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqinf.f  {FFLAGC}
{SRCDIR}pgqitf.f.o  {SRCDIR}pgqitf.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqitf.f  {FFLAGC}
{SRCDIR}pgqls.f.o  {SRCDIR}pgqls.f
	 {FCOMPL}  {SRCDIR}pgqls.f  {FFLAGC}
{SRCDIR}pgqlw.f.o  {SRCDIR}pgqlw.f
	 {FCOMPL}  {SRCDIR}pgqlw.f  {FFLAGC}
{SRCDIR}pgqpos.f.o  {SRCDIR}pgqpos.f
	 {FCOMPL}  {SRCDIR}pgqpos.f  {FFLAGC}
{SRCDIR}pgqtbg.f.o  {SRCDIR}pgqtbg.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqtbg.f  {FFLAGC}
{SRCDIR}pgqtxt.f.o  {SRCDIR}pgqtxt.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqtxt.f  {FFLAGC}
{SRCDIR}pgqvp.f.o  {SRCDIR}pgqvp.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqvp.f  {FFLAGC}
{SRCDIR}pgqvsz.f.o  {SRCDIR}pgqvsz.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqvsz.f  {FFLAGC}
{SRCDIR}pgqwin.f.o  {SRCDIR}pgqwin.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgqwin.f  {FFLAGC}
{SRCDIR}pgrect.f.o  {SRCDIR}pgrect.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgrect.f  {FFLAGC}
{SRCDIR}pgrnd.f.o  {SRCDIR}pgrnd.f
	 {FCOMPL}  {SRCDIR}pgrnd.f  {FFLAGC}
{SRCDIR}pgrnge.f.o  {SRCDIR}pgrnge.f
	 {FCOMPL}  {SRCDIR}pgrnge.f  {FFLAGC}
{SRCDIR}pgsah.f.o  {SRCDIR}pgsah.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgsah.f  {FFLAGC}
{SRCDIR}pgsave.f.o  {SRCDIR}pgsave.f
	 {FCOMPL}  {SRCDIR}pgsave.f  {FFLAGC}
{SRCDIR}pgscf.f.o  {SRCDIR}pgscf.f
	 {FCOMPL}  {SRCDIR}pgscf.f  {FFLAGC}
{SRCDIR}pgsch.f.o  {SRCDIR}pgsch.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgsch.f  {FFLAGC}
{SRCDIR}pgsci.f.o  {SRCDIR}pgsci.f
	 {FCOMPL}  {SRCDIR}pgsci.f  {FFLAGC}
{SRCDIR}pgscir.f.o  {SRCDIR}pgscir.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgscir.f  {FFLAGC}
{SRCDIR}pgscr.f.o  {SRCDIR}pgscr.f
	 {FCOMPL}  {SRCDIR}pgscr.f  {FFLAGC}
{SRCDIR}pgscrn.f.o  {SRCDIR}pgscrn.f
	 {FCOMPL}  {SRCDIR}pgscrn.f  {FFLAGC}
{SRCDIR}pgsfs.f.o  {SRCDIR}pgsfs.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgsfs.f  {FFLAGC}
{SRCDIR}pgshls.f.o  {SRCDIR}pgshls.f
	 {FCOMPL}  {SRCDIR}pgshls.f  {FFLAGC}
{SRCDIR}pgshs.f.o  {SRCDIR}pgshs.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgshs.f  {FFLAGC}
{SRCDIR}pgsitf.f.o  {SRCDIR}pgsitf.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgsitf.f  {FFLAGC}
{SRCDIR}pgsls.f.o  {SRCDIR}pgsls.f
	 {FCOMPL}  {SRCDIR}pgsls.f  {FFLAGC}
{SRCDIR}pgslw.f.o  {SRCDIR}pgslw.f
	 {FCOMPL}  {SRCDIR}pgslw.f  {FFLAGC}
{SRCDIR}pgstbg.f.o  {SRCDIR}pgstbg.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgstbg.f  {FFLAGC}
{SRCDIR}pgsubp.f.o  {SRCDIR}pgsubp.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgsubp.f  {FFLAGC}
{SRCDIR}pgsvp.f.o  {SRCDIR}pgsvp.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgsvp.f  {FFLAGC}
{SRCDIR}pgswin.f.o  {SRCDIR}pgswin.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgswin.f  {FFLAGC}
{SRCDIR}pgtbox.f.o  {SRCDIR}pgtbox.f
	 {FCOMPL}  {SRCDIR}pgtbox.f  {FFLAGC}
{SRCDIR}pgtext.f.o  {SRCDIR}pgtext.f
	 {FCOMPL}  {SRCDIR}pgtext.f  {FFLAGC}
{SRCDIR}pgupdt.f.o  {SRCDIR}pgupdt.f
	 {FCOMPL}  {SRCDIR}pgupdt.f  {FFLAGC}
{SRCDIR}pgvect.f.o  {SRCDIR}pgvect.f
	 {FCOMPL}  {SRCDIR}pgvect.f  {FFLAGC}
{SRCDIR}pgvsiz.f.o  {SRCDIR}pgvsiz.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgvsiz.f  {FFLAGC}
{SRCDIR}pgvstd.f.o  {SRCDIR}pgvstd.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgvstd.f  {FFLAGC}
{SRCDIR}pgvw.f.o  {SRCDIR}pgvw.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgvw.f  {FFLAGC}
{SRCDIR}pgwedg.f.o  {SRCDIR}pgwedg.f
	 {FCOMPL}  {SRCDIR}pgwedg.f  {FFLAGC}
{SRCDIR}pgwnad.f.o  {SRCDIR}pgwnad.f pgplot.inc
	 {FCOMPL}  {SRCDIR}pgwnad.f  {FFLAGC}
{SRCDIR}pgadvance.f.o  {SRCDIR}pgadvance.f
	 {FCOMPL}  {SRCDIR}pgadvance.f  {FFLAGC}
{SRCDIR}pgbegin.f.o  {SRCDIR}pgbegin.f
	 {FCOMPL}  {SRCDIR}pgbegin.f  {FFLAGC}
{SRCDIR}pgcurse.f.o  {SRCDIR}pgcurse.f
	 {FCOMPL}  {SRCDIR}pgcurse.f  {FFLAGC}
{SRCDIR}pglabel.f.o  {SRCDIR}pglabel.f
	 {FCOMPL}  {SRCDIR}pglabel.f  {FFLAGC}
{SRCDIR}pgmtext.f.o  {SRCDIR}pgmtext.f
	 {FCOMPL}  {SRCDIR}pgmtext.f  {FFLAGC}
{SRCDIR}pgncurse.f.o  {SRCDIR}pgncurse.f
	 {FCOMPL}  {SRCDIR}pgncurse.f  {FFLAGC}
{SRCDIR}pgpaper.f.o  {SRCDIR}pgpaper.f
	 {FCOMPL}  {SRCDIR}pgpaper.f  {FFLAGC}
{SRCDIR}pgpoint.f.o  {SRCDIR}pgpoint.f
	 {FCOMPL}  {SRCDIR}pgpoint.f  {FFLAGC}
{SRCDIR}pgptext.f.o  {SRCDIR}pgptext.f
	 {FCOMPL}  {SRCDIR}pgptext.f  {FFLAGC}
{SRCDIR}pgvport.f.o  {SRCDIR}pgvport.f
	 {FCOMPL}  {SRCDIR}pgvport.f  {FFLAGC}
{SRCDIR}pgvsize.f.o  {SRCDIR}pgvsize.f
	 {FCOMPL}  {SRCDIR}pgvsize.f  {FFLAGC}
{SRCDIR}pgvstand.f.o  {SRCDIR}pgvstand.f
	 {FCOMPL}  {SRCDIR}pgvstand.f  {FFLAGC}
{SRCDIR}pgwindow.f.o  {SRCDIR}pgwindow.f
	 {FCOMPL}  {SRCDIR}pgwindow.f  {FFLAGC}
{SRCDIR}grarea.f.o  {SRCDIR}grarea.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grarea.f  {FFLAGC}
{SRCDIR}grbpic.f.o  {SRCDIR}grbpic.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grbpic.f  {FFLAGC}
{SRCDIR}grchsz.f.o  {SRCDIR}grchsz.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grchsz.f  {FFLAGC}
{SRCDIR}grclip.f.o  {SRCDIR}grclip.f
	 {FCOMPL}  {SRCDIR}grclip.f  {FFLAGC}
{SRCDIR}grclos.f.o  {SRCDIR}grclos.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grclos.f  {FFLAGC}
{SRCDIR}grclpl.f.o  {SRCDIR}grclpl.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grclpl.f  {FFLAGC}
{SRCDIR}grctoi.f.o  {SRCDIR}grctoi.f
	 {FCOMPL}  {SRCDIR}grctoi.f  {FFLAGC}
{SRCDIR}grcurs.f.o  {SRCDIR}grcurs.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grcurs.f  {FFLAGC}
{SRCDIR}grdot0.f.o  {SRCDIR}grdot0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grdot0.f  {FFLAGC}
{SRCDIR}grdtyp.f.o  {SRCDIR}grdtyp.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grdtyp.f  {FFLAGC}
{SRCDIR}gresc.f.o  {SRCDIR}gresc.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}gresc.f  {FFLAGC}
{SRCDIR}grepic.f.o  {SRCDIR}grepic.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grepic.f  {FFLAGC}
{SRCDIR}gretxt.f.o  {SRCDIR}gretxt.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}gretxt.f  {FFLAGC}
{SRCDIR}grfa.f.o  {SRCDIR}grfa.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grfa.f  {FFLAGC}
{SRCDIR}grfao.f.o  {SRCDIR}grfao.f
	 {FCOMPL}  {SRCDIR}grfao.f  {FFLAGC}
{SYSDIR}grgfil.f.o  {SYSDIR}grgfil.f
	 {FCOMPL}  {SYSDIR}grgfil.f  {FFLAGC}
{SRCDIR}grgray.f.o  {SRCDIR}grgray.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grgray.f  {FFLAGC}
{SRCDIR}grimg0.f.o  {SRCDIR}grimg0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grimg0.f  {FFLAGC}
{SRCDIR}grimg1.f.o  {SRCDIR}grimg1.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grimg1.f  {FFLAGC}
{SRCDIR}grimg2.f.o  {SRCDIR}grimg2.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grimg2.f  {FFLAGC}
{SRCDIR}grimg3.f.o  {SRCDIR}grimg3.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grimg3.f  {FFLAGC}
{SRCDIR}gritoc.f.o  {SRCDIR}gritoc.f
	 {FCOMPL}  {SRCDIR}gritoc.f  {FFLAGC}
{SRCDIR}grldev.f.o  {SRCDIR}grldev.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grldev.f  {FFLAGC}
{SRCDIR}grlen.f.o  {SRCDIR}grlen.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grlen.f  {FFLAGC}
{SRCDIR}grlin0.f.o  {SRCDIR}grlin0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grlin0.f  {FFLAGC}
{SRCDIR}grlin1.f.o  {SRCDIR}grlin1.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grlin1.f  {FFLAGC}
{SRCDIR}grlin2.f.o  {SRCDIR}grlin2.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grlin2.f  {FFLAGC}
{SRCDIR}grlin3.f.o  {SRCDIR}grlin3.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grlin3.f  {FFLAGC}
{SRCDIR}grlina.f.o  {SRCDIR}grlina.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grlina.f  {FFLAGC}
{SRCDIR}grmcur.f.o  {SRCDIR}grmcur.f
	 {FCOMPL}  {SRCDIR}grmcur.f  {FFLAGC}
{SRCDIR}grmker.f.o  {SRCDIR}grmker.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grmker.f  {FFLAGC}
{SRCDIR}grmova.f.o  {SRCDIR}grmova.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grmova.f  {FFLAGC}
{SRCDIR}grmsg.f.o  {SRCDIR}grmsg.f
	 {FCOMPL}  {SRCDIR}grmsg.f  {FFLAGC}
{SYSDIR}gropen.f.o  {SYSDIR}gropen.f grpckg1.inc
	 {FCOMPL}  {SYSDIR}gropen.f  {FFLAGC}
{SRCDIR}grpage.f.o  {SRCDIR}grpage.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grpage.f  {FFLAGC}
{SRCDIR}grpars.f.o  {SRCDIR}grpars.f
	 {FCOMPL}  {SRCDIR}grpars.f  {FFLAGC}
{SRCDIR}grpixl.f.o  {SRCDIR}grpixl.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grpixl.f  {FFLAGC}
{SRCDIR}grpocl.f.o  {SRCDIR}grpocl.f
	 {FCOMPL}  {SRCDIR}grpocl.f  {FFLAGC}
{SRCDIR}grprom.f.o  {SRCDIR}grprom.f
	 {FCOMPL}  {SRCDIR}grprom.f  {FFLAGC}
{SRCDIR}grpxpo.f.o  {SRCDIR}grpxpo.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grpxpo.f  {FFLAGC}
{SRCDIR}grpxps.f.o  {SRCDIR}grpxps.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grpxps.f  {FFLAGC}
{SRCDIR}grpxpx.f.o  {SRCDIR}grpxpx.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grpxpx.f  {FFLAGC}
{SRCDIR}grpxre.f.o  {SRCDIR}grpxre.f
	 {FCOMPL}  {SRCDIR}grpxre.f  {FFLAGC}
{SRCDIR}grqcap.f.o  {SRCDIR}grqcap.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqcap.f  {FFLAGC}
{SRCDIR}grqci.f.o  {SRCDIR}grqci.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqci.f  {FFLAGC}
{SRCDIR}grqcol.f.o  {SRCDIR}grqcol.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqcol.f  {FFLAGC}
{SRCDIR}grqcr.f.o  {SRCDIR}grqcr.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqcr.f  {FFLAGC}
{SRCDIR}grqdev.f.o  {SRCDIR}grqdev.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqdev.f  {FFLAGC}
{SRCDIR}grqdt.f.o  {SRCDIR}grqdt.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqdt.f  {FFLAGC}
{SRCDIR}grqfnt.f.o  {SRCDIR}grqfnt.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqfnt.f  {FFLAGC}
{SRCDIR}grqls.f.o  {SRCDIR}grqls.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqls.f  {FFLAGC}
{SRCDIR}grqlw.f.o  {SRCDIR}grqlw.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqlw.f  {FFLAGC}
{SRCDIR}grqpos.f.o  {SRCDIR}grqpos.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqpos.f  {FFLAGC}
{SRCDIR}grqtxt.f.o  {SRCDIR}grqtxt.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqtxt.f  {FFLAGC}
{SRCDIR}grqtyp.f.o  {SRCDIR}grqtyp.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grqtyp.f  {FFLAGC}
{SRCDIR}grquit.f.o  {SRCDIR}grquit.f
	 {FCOMPL}  {SRCDIR}grquit.f  {FFLAGC}
{SRCDIR}grrec0.f.o  {SRCDIR}grrec0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grrec0.f  {FFLAGC}
{SRCDIR}grrect.f.o  {SRCDIR}grrect.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grrect.f  {FFLAGC}
{SRCDIR}grsci.f.o  {SRCDIR}grsci.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grsci.f  {FFLAGC}
{SRCDIR}grscr.f.o  {SRCDIR}grscr.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grscr.f  {FFLAGC}
{SRCDIR}grsetc.f.o  {SRCDIR}grsetc.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grsetc.f  {FFLAGC}
{SRCDIR}grsets.f.o  {SRCDIR}grsets.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grsets.f  {FFLAGC}
{SRCDIR}grsfnt.f.o  {SRCDIR}grsfnt.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grsfnt.f  {FFLAGC}
{SRCDIR}grsize.f.o  {SRCDIR}grsize.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grsize.f  {FFLAGC}
{SRCDIR}grskpb.f.o  {SRCDIR}grskpb.f
	 {FCOMPL}  {SRCDIR}grskpb.f  {FFLAGC}
{SRCDIR}grslct.f.o  {SRCDIR}grslct.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grslct.f  {FFLAGC}
{SRCDIR}grsls.f.o  {SRCDIR}grsls.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grsls.f  {FFLAGC}
{SRCDIR}grslw.f.o  {SRCDIR}grslw.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grslw.f  {FFLAGC}
{SRCDIR}grsyds.f.o  {SRCDIR}grsyds.f
	 {FCOMPL}  {SRCDIR}grsyds.f  {FFLAGC}
{SRCDIR}grsymk.f.o  {SRCDIR}grsymk.f
	 {FCOMPL}  {SRCDIR}grsymk.f  {FFLAGC}
{SRCDIR}grsyxd.f.o  {SRCDIR}grsyxd.f
	 {FCOMPL}  {SRCDIR}grsyxd.f  {FFLAGC}
{SRCDIR}grterm.f.o  {SRCDIR}grterm.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grterm.f  {FFLAGC}
{SRCDIR}grtext.f.o  {SRCDIR}grtext.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grtext.f  {FFLAGC}
{SRCDIR}grtoup.f.o  {SRCDIR}grtoup.f
	 {FCOMPL}  {SRCDIR}grtoup.f  {FFLAGC}
{SRCDIR}grtrim.f.o  {SRCDIR}grtrim.f
	 {FCOMPL}  {SRCDIR}grtrim.f  {FFLAGC}
{SRCDIR}grtrn0.f.o  {SRCDIR}grtrn0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grtrn0.f  {FFLAGC}
{SRCDIR}grtxy0.f.o  {SRCDIR}grtxy0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grtxy0.f  {FFLAGC}
{SRCDIR}grvct0.f.o  {SRCDIR}grvct0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grvct0.f  {FFLAGC}
{SRCDIR}grwarn.f.o  {SRCDIR}grwarn.f
	 {FCOMPL}  {SRCDIR}grwarn.f  {FFLAGC}
{SRCDIR}grxhls.f.o  {SRCDIR}grxhls.f
	 {FCOMPL}  {SRCDIR}grxhls.f  {FFLAGC}
{SRCDIR}grxrgb.f.o  {SRCDIR}grxrgb.f
	 {FCOMPL}  {SRCDIR}grxrgb.f  {FFLAGC}
{SYSDIR}grdate.f.o  {SYSDIR}grdate.f
	 {FCOMPL}  {SYSDIR}grdate.f  {FFLAGC}
{GENDIR}grflun.f.o  {GENDIR}grflun.f
	 {FCOMPL}  {GENDIR}grflun.f  {FFLAGC}
{GENDIR}grgcom.f.o  {GENDIR}grgcom.f
	 {FCOMPL}  {GENDIR}grgcom.f  {FFLAGC}
{SYSDIR}grgenv.f.o  {SYSDIR}grgenv.f
	 {FCOMPL}  {SYSDIR}grgenv.f  {FFLAGC}
{GENDIR}grglun.f.o  {GENDIR}grglun.f
	 {FCOMPL}  {GENDIR}grglun.f  {FFLAGC}
{SYSDIR}grgmem.f.o  {SYSDIR}grgmem.f
	 {FCOMPL}  {SYSDIR}grgmem.f  {FFLAGC}
{GENDIR}grgmsg.f.o  {GENDIR}grgmsg.f
	 {FCOMPL}  {GENDIR}grgmsg.f  {FFLAGC}
{GENDIR}grlgtr.f.o  {GENDIR}grlgtr.f
	 {FCOMPL}  {GENDIR}grlgtr.f  {FFLAGC}
{GENDIR}groptx.f.o  {GENDIR}groptx.f
	 {FCOMPL}  {GENDIR}groptx.f  {FFLAGC}
{SYSDIR}grsy00.f.o  {SYSDIR}grsy00.f
	 {FCOMPL}  {SYSDIR}grsy00.f  {FFLAGC}
{SYSDIR}grtrml.f.o  {SYSDIR}grtrml.f
	 {FCOMPL}  {SYSDIR}grtrml.f  {FFLAGC}
{GENDIR}grtter.f.o  {GENDIR}grtter.f
	 {FCOMPL}  {GENDIR}grtter.f  {FFLAGC}
{SYSDIR}gruser.f.o  {SYSDIR}gruser.f
	 {FCOMPL}  {SYSDIR}gruser.f  {FFLAGC}
{DRVDIR}GLDRIV.f.o  {DRVDIR}GLDRIV.f
	 {FCOMPL}  {DRVDIR}GLDRIV.f  {FFLAGC}
{SYSDIR}HGDRIV.f.o  {SYSDIR}HGDRIV.f
	 {FCOMPL}  {SYSDIR}HGDRIV.f  {FFLAGC}
{DRVDIR}HPDRIV.f.o  {DRVDIR}HPDRIV.f
	 {FCOMPL}  {DRVDIR}HPDRIV.f  {FFLAGC}
{DRVDIR}LXDRIV.f.o  {DRVDIR}LXDRIV.f
	 {FCOMPL}  {DRVDIR}LXDRIV.f  {FFLAGC}
{SYSDIR}MCDRIV.f.o  {SYSDIR}MCDRIV.f
	 {FCOMPL}  {SYSDIR}MCDRIV.f  -u -b -opt=0 -bkg=0 -mc68020
{SYSDIR}MFDRIV.f.o  {SYSDIR}MFDRIV.f
	 {FCOMPL}  {SYSDIR}MFDRIV.f  {FFLAGC}
{DRVDIR}NUDRIV.f.o  {DRVDIR}NUDRIV.f
	 {FCOMPL}  {DRVDIR}NUDRIV.f  {FFLAGC}
{DRVDIR}PSDRIV.f.o  {DRVDIR}PSDRIV.f
	 {FCOMPL}  {DRVDIR}PSDRIV.f  {FFLAGC}
grexec.f.o  grexec.f 
	 {FCOMPL}  grexec.f  {FFLAGC} 
grexec.f  drivers.list :sys_mac:create_grexec.f 
	 Directory {SYSDIR} 
	 {FCOMPL} create_grexec.f {FFLAGU} 
	 LinkFORTRANtool create_grexec create_grexec.f.o 
	 Move -y create_grexec :: 
	 Directory :: 
	 create_grexec
{SYSDIR}pgblck.f.o  {SYSDIR}pgblck.f grpckg1.inc pgplot.inc
	 {FCOMPL}  {SYSDIR}pgblck.f  {FFLAGC}
pgplotold.lib  {OBSOLETE_ROUTINES}
	 Lib -f -mf  {OBSOLETE_ROUTINES} -o pgplotold.lib
{SRCDIR}grchar.f.o  {SRCDIR}grchar.f
	 {FCOMPL}  {SRCDIR}grchar.f  {FFLAGC}
{SRCDIR}grchr0.f.o  {SRCDIR}grchr0.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grchr0.f  {FFLAGC}
{SRCDIR}grdat2.f.o  {SRCDIR}grdat2.f
	 {FCOMPL}  {SRCDIR}grdat2.f  {FFLAGC}
{SRCDIR}grgtc0.f.o  {SRCDIR}grgtc0.f
	 {FCOMPL}  {SRCDIR}grgtc0.f  {FFLAGC}
{SRCDIR}grinqfont.f.o  {SRCDIR}grinqfont.f
	 {FCOMPL}  {SRCDIR}grinqfont.f  {FFLAGC}
{SRCDIR}grinqli.f.o  {SRCDIR}grinqli.f
	 {FCOMPL}  {SRCDIR}grinqli.f  {FFLAGC}
{SRCDIR}grinqpen.f.o  {SRCDIR}grinqpen.f
	 {FCOMPL}  {SRCDIR}grinqpen.f  {FFLAGC}
{SRCDIR}grlinr.f.o  {SRCDIR}grlinr.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grlinr.f  {FFLAGC}
{SRCDIR}grmark.f.o  {SRCDIR}grmark.f
	 {FCOMPL}  {SRCDIR}grmark.f  {FFLAGC}
{SRCDIR}grmovr.f.o  {SRCDIR}grmovr.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grmovr.f  {FFLAGC}
{SRCDIR}grsetfont.f.o  {SRCDIR}grsetfont.f
	 {FCOMPL}  {SRCDIR}grsetfont.f  {FFLAGC}
{SRCDIR}grsetli.f.o  {SRCDIR}grsetli.f grpckg1.inc
	 {FCOMPL}  {SRCDIR}grsetli.f  {FFLAGC}
{SRCDIR}grsetpen.f.o  {SRCDIR}grsetpen.f
	 {FCOMPL}  {SRCDIR}grsetpen.f  {FFLAGC}
{SRCDIR}grtran.f.o  {SRCDIR}grtran.f
	 {FCOMPL}  {SRCDIR}grtran.f  {FFLAGC}
{SRCDIR}grvect.f.o  {SRCDIR}grvect.f
	 {FCOMPL}  {SRCDIR}grvect.f  {FFLAGC}
{SRCDIR}pgsetc.f.o  {SRCDIR}pgsetc.f
	 {FCOMPL}  {SRCDIR}pgsetc.f  {FFLAGC}
{SRCDIR}pgsize.f.o  {SRCDIR}pgsize.f
	 {FCOMPL}  {SRCDIR}pgsize.f  {FFLAGC}
demos  {DEMDIR}pgdemo1 {DEMDIR}pgdemo2 {DEMDIR}pgdemo3 {DEMDIR}pgdemo4 {DEMDIR}pgdemo5 {DEMDIR}pgdemo6 {DEMDIR}pgdemo7 {DEMDIR}pgdemo8 {DEMDIR}pgdemo9 {DEMDIR}pgdemo10 {DEMDIR}pgdemo11 {DEMDIR}pgdemo12 pgplot.lib
	 Echo `Date -t` Creating demonstration programs.
{DEMDIR}pgdemo1  {DEMDIR}pgdemo1.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo1 {DEMDIR}pgdemo1.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo1
	 {SizRes} {DEMDIR}pgdemo1 512
{DEMDIR}pgdemo2  {DEMDIR}pgdemo2.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo2 {DEMDIR}pgdemo2.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo2
	 {SizRes} {DEMDIR}pgdemo2 512
{DEMDIR}pgdemo3  {DEMDIR}pgdemo3.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo3 {DEMDIR}pgdemo3.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo3
	 {SizRes} {DEMDIR}pgdemo3 1024
{DEMDIR}pgdemo4  {DEMDIR}pgdemo4.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo4 {DEMDIR}pgdemo4.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo4
	 {SizRes} {DEMDIR}pgdemo4 512
{DEMDIR}pgdemo5  {DEMDIR}pgdemo5.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo5 {DEMDIR}pgdemo5.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo5
	 {SizRes} {DEMDIR}pgdemo5 512
{DEMDIR}pgdemo6  {DEMDIR}pgdemo6.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo6 {DEMDIR}pgdemo6.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo6
	 {SizRes} {DEMDIR}pgdemo6 512
{DEMDIR}pgdemo7  {DEMDIR}pgdemo7.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo7 {DEMDIR}pgdemo7.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo7
	 {SizRes} {DEMDIR}pgdemo7 512
{DEMDIR}pgdemo8  {DEMDIR}pgdemo8.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo8 {DEMDIR}pgdemo8.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo8
	 {SizRes} {DEMDIR}pgdemo8 512
{DEMDIR}pgdemo9  {DEMDIR}pgdemo9.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo9 {DEMDIR}pgdemo9.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo9
	 {SizRes} {DEMDIR}pgdemo9 512
{DEMDIR}pgdemo10  {DEMDIR}pgdemo10.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo10 {DEMDIR}pgdemo10.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo10
	 {SizRes} {DEMDIR}pgdemo10 512
{DEMDIR}pgdemo11  {DEMDIR}pgdemo11.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo11 {DEMDIR}pgdemo11.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo11
	 {SizRes} {DEMDIR}pgdemo11 512
{DEMDIR}pgdemo12  {DEMDIR}pgdemo12.f.o pgplot.lib
	 {FLINK} {DEMDIR}pgdemo12 {DEMDIR}pgdemo12.f.o pgplot.lib
	 AddResourceFile {DEMDIR}pgdemo12
	 {SizRes} {DEMDIR}pgdemo12 512
{DEMDIR}pgdemo1.f.o  {DEMDIR}pgdemo1.f
	 {FCOMPL} {DEMDIR}pgdemo1.f  {FFLAGD}
{DEMDIR}pgdemo2.f.o  {DEMDIR}pgdemo2.f
	 {FCOMPL} {DEMDIR}pgdemo2.f  {FFLAGD}
{DEMDIR}pgdemo3.f.o  {DEMDIR}pgdemo3.f
	 {FCOMPL} {DEMDIR}pgdemo3.f  {FFLAGD}
{DEMDIR}pgdemo4.f.o  {DEMDIR}pgdemo4.f
	 {FCOMPL} {DEMDIR}pgdemo4.f  {FFLAGD}
{DEMDIR}pgdemo5.f.o  {DEMDIR}pgdemo5.f
	 {FCOMPL} {DEMDIR}pgdemo5.f  {FFLAGD}
{DEMDIR}pgdemo6.f.o  {DEMDIR}pgdemo6.f
	 {FCOMPL} {DEMDIR}pgdemo6.f  {FFLAGD}
{DEMDIR}pgdemo7.f.o  {DEMDIR}pgdemo7.f
	 {FCOMPL} {DEMDIR}pgdemo7.f  {FFLAGD}
{DEMDIR}pgdemo8.f.o  {DEMDIR}pgdemo8.f
	 {FCOMPL} {DEMDIR}pgdemo8.f  {FFLAGD}
{DEMDIR}pgdemo9.f.o  {DEMDIR}pgdemo9.f
	 {FCOMPL} {DEMDIR}pgdemo9.f  {FFLAGD}
{DEMDIR}pgdemo10.f.o  {DEMDIR}pgdemo10.f
	 {FCOMPL} {DEMDIR}pgdemo10.f  {FFLAGD}
{DEMDIR}pgdemo11.f.o  {DEMDIR}pgdemo11.f
	 {FCOMPL} {DEMDIR}pgdemo11.f  {FFLAGD}
{DEMDIR}pgdemo12.f.o  {DEMDIR}pgdemo12.f
	 {FCOMPL} {DEMDIR}pgdemo12.f  {FFLAGD}
grfont.dat  {FNTDIR}grfont.txt {SYSDIR}pgpack.f 
 	 Duplicate -y {SYSDIR}pgpack.f {FNTDIR} 
 	 Directory {FNTDIR} 
 	 If grfont.dat == `Exists -f grfont.dat` 
 		 Delete grfont.dat 
 	 End 
 	 FORTRAN pgpack.f {FFLAGU} 
 	 LinkFORTRANtool pgpack pgpack.f.o 
 	 Echo `Date -t` Executing pgpack, which takes a while and the ball does not spin. n
 	 Should report: n
 	 Characters defined:   996 n
 	 Array cells used:   26732 
 	 pgpack 
 	 Echo `Date -t` Finished creating grfont.dat. 
 	 Directory ::
pgplot.doc  :sys_mac:create_doc.f 
 	 Directory {SYSDIR} 
 	 {FCOMPL} create_doc.f {FFLAGU} 
 	 LinkFORTRANtool create_doc create_doc.f.o 
 	 Move -y create_doc :: 
 	 Directory :: 
 	 Echo `Date -t` Executing create_doc, which takes a long time and the ball does not spin.
	 create_doc {SRCDIR} 
		 pgarro.f 
		 pgask.f 
		 pgband.f 
		 pgbbuf.f 
		 pgbeg.f 
		 pgbin.f 
		 pgbox.f 
		 pgbox1.f 
		 pgcirc.f 
		 pgcl.f 
		 pgcn01.f 
		 pgcnsc.f 
		 pgconb.f 
		 pgconl.f 
		 pgcons.f 
		 pgcont.f 
		 pgconx.f 
		 pgcp.f 
		 pgctab.f 
		 pgcurs.f 
		 pgdraw.f 
		 pgebuf.f 
		 pgend.f 
		 pgenv.f 
		 pgeras.f 
		 pgerrb.f 
		 pgerrx.f 
		 pgerry.f 
		 pgetxt.f 
		 pgfunt.f 
		 pgfunx.f 
		 pgfuny.f 
		 pggray.f 
		 pghi2d.f 
		 pghis1.f 
		 pghist.f 
		 pghtch.f 
		 pgiden.f 
		 pgimag.f 
		 pglab.f 
		 pglcur.f 
		 pgldev.f 
		 pglen.f 
		 pgline.f 
		 pgmove.f 
		 pgmtxt.f 
		 pgncur.f 
		 pgnoto.f 
		 pgnpl.f 
		 pgnumb.f 
		 pgolin.f 
		 pgpage.f 
		 pgpanl.f 
		 pgpap.f 
		 pgpixl.f 
		 pgpnts.f 
		 pgpoly.f 
		 pgpt.f 
		 pgptxt.f 
		 pgqah.f 
		 pgqcf.f 
		 pgqch.f 
		 pgqci.f 
		 pgqcir.f 
		 pgqcol.f 
		 pgqcr.f 
		 pgqcs.f 
		 pgqfs.f 
		 pgqhs.f 
		 pgqinf.f 
		 pgqitf.f 
		 pgqls.f 
		 pgqlw.f 
		 pgqpos.f 
		 pgqtbg.f 
		 pgqtxt.f 
		 pgqvp.f 
		 pgqvsz.f 
		 pgqwin.f 
		 pgrect.f 
		 pgrnd.f 
		 pgrnge.f 
		 pgsah.f 
		 pgsave.f 
		 pgscf.f 
		 pgsch.f 
		 pgsci.f 
		 pgscir.f 
		 pgscr.f 
		 pgscrn.f 
		 pgsfs.f 
		 pgshls.f 
		 pgshs.f 
		 pgsitf.f 
		 pgsls.f 
		 pgslw.f 
		 pgstbg.f 
		 pgsubp.f 
		 pgsvp.f 
		 pgswin.f 
		 pgtbox.f 
		 pgtext.f 
		 pgupdt.f 
		 pgvect.f 
		 pgvsiz.f 
		 pgvstd.f 
		 pgvw.f 
		 pgwedg.f 
		 pgwnad.f
	 Echo `Date -t` Finished creating pgplot.html and pgplot.doc.
clean  
 	 Delete -i {PG_ROUTINES} 
 	 {PG_NON_STANDARD} 
 	 {GR_ROUTINES} 
 	 grexec.f.o {DRIV_LIST} 
 	 {SYSTEM_ROUTINES} 
 	 {MAC_ROUTINES}
