#!/bin/sh -ex

if [[ `whoami` != "root" ]]; then
	sudo $0
	exit
fi

LANG=C

chroot edit apt-get clean

umount edit/proc || true
umount edit/sys || true

chroot edit <<'EOF'
    GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    HOME=/root \
      gconftool-2 --direct \
                  --config-source=${GCONF_CONFIG_SOURCE} \
                  --load /usr/share/gconf/schemas/panel-default-setup.entries
EOF

rm -rf edit/root/* || true
rm -rf edit/root/.bash_history || true
rm -rf edit/root/.viminfo || true
rm -rf edit/tmp/* || true
rm -rf edit/var/tmp/* || true
cp /dev/null edit/etc/resolv.conf || true
rm -rf edit/etc/hosts || true
rm -rf edit/var/lib/acpi-support/* || true
chroot edit updatedb

chroot edit dpkg-query -W --showformat='${Package} ${Version}\n' > extract-cd/casper/filesystem.manifest
chmod 644 extract-cd/casper/filesystem.manifest
grep -v -f live-only.list extract-cd/casper/filesystem.manifest > extract-cd/casper/filesystem.manifest-desktop

EXTRA_OPTS=""
if [ -e "rootfs.sort" ] ; then
  EXTRA_OPTS="-sort rootfs.sort"
fi
rm extract-cd/casper/filesystem.squashfs || true
./squashfs-tools/mksquashfs edit extract-cd/casper/filesystem.squashfs -info $EXTRA_OPTS > mksquashfs.log
chmod 644 extract-cd/casper/filesystem.squashfs
