#!/bin/sh -ex

LANG=C

#
# create initrd.gz
#
if [ -d initrd-edit ]; then
  rm extract-cd/casper/initrd.gz || true
  ( cd initrd-edit/ && find | cpio -H newc -o | gzip > ../extract-cd/casper/initrd.gz )

  [ -d initrd-trace ] || mkdir initrd-trace
  rsync -a --delete initrd-edit/ initrd-trace/
  cp -a squashfs.ko initrd-trace/lib/modules/2.6.15-26-386/kernel/fs/squashfs/
  cp -a udev initrd-trace/scripts/init-bottom/
  rm -f initrd-trace/scripts/casper-bottom/00readahead_rofs
  rm extract-cd/casper/trace.gz || true
  ( cd initrd-trace/ && find | cpio -H newc -o | gzip > ../extract-cd/casper/trace.gz )

  [ -d initrd-bootchart ] || mkdir initrd-bootchart
  rsync -a --delete initrd-edit/ initrd-bootchart/
  cp -a bootchart initrd-bootchart/scripts/init-top/
  rm extract-cd/casper/chart.gz || true
  ( cd initrd-bootchart/ && find | cpio -H newc -o | gzip > ../extract-cd/casper/chart.gz )

  rm extract-cd/casper/original.gz || true
  ( cd initrd-orig/ && find | cpio -H newc -o | gzip > ../extract-cd/casper/original.gz )
fi
