/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KREETINGKARD_H_
#define _KREETINGKARD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "kkglobal.h"

#include <qptrlist.h>

#include <kmainwindow.h>

class KJanusWidget;
class KKNavigator;
class KKWidgetBase;
class KCommandHistory;

namespace KKAddressBook
{
	class KKAContactData;
}

/**
 * @english
 * @short Main Window of KreetingKard
 * @author SUZUKI Tasuku <tasuku@linux-life.net>
 * @endenglish
 *
 * @japanese
 * @short KreetingKard のメインウィンドウ
 * @author 鈴木 佑 <tasuku@linux-life.net>
 * @endjapanese
 */
class KreetingKard : public KMainWindow
{
	Q_OBJECT
public:
	KreetingKard();
	virtual ~KreetingKard();

	QPtrList<KKAddressBook::KKAContactData> printData();

public slots:
	void fileOpen( const QString& filename );

protected:
	virtual bool queryClose();

private slots:
	void fileNew( const QString& filename );
	void activeIndexChanged( QWidget* pane = 0 );

private:
	enum Mode
	{
		Template,
		Designer,
		AddressBook,
	};

	/// base widget;
	KJanusWidget* m_base;
	KKNavigator* m_navigator;
	QPtrList<KKWidgetBase> m_pane;
	int m_currentIndex;

	KCommandHistory* m_cmdHistory;
	void readConfig();
	void saveConfig();
};

#endif // _KREETINGKARD_H_
