/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkaprintstatuswidget.h"

#include <qradiobutton.h>

#include <klocale.h>

using namespace KKAddressBook;

KKAPrintStatusWidget::KKAPrintStatusWidget( QWidget* parent, const char* name )
 : QHButtonGroup( parent, name )
{
	setInsideMargin( 0 );
	setLineWidth( 0 );
/*	setFlat( true );*/
	QRadioButton* radio = new QRadioButton( i18n( "None" ), this );
	radio = new QRadioButton( i18n( "Print" ), this );
	radio = new QRadioButton( i18n( "Printed" ), this );
	connect( this, SIGNAL( clicked( int ) ), this, SLOT( buttonClicked( int ) ) );
	setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Fixed );
}


KKAPrintStatusWidget::~KKAPrintStatusWidget()
{
}

void KKAPrintStatusWidget::buttonClicked( int i )
{
	emit statusChanged( (KKAAddressData::PrintStatus)i );
}
