#!/bin/sh

DEBUG=0

if [ $DEBUG -gt 0 ]; then
  set -x
  echo "Debug mode."
fi

version=1.4.0.74

if [ -e /usr/lib/skype/version ] && [ "`cat /usr/lib/skype/version 2>/dev/null`" = "$version" ]; then
  echo "Skype Version $version is already installed."
  exit 0
fi

package_name=skype
tmp_dir="${TMPDIR:-/var/tmp}/${package_name}.$$"
archive_url="http://download.skype.com/linux/skype-1.4.0.74-static.tar.bz2"
archive=`basename $archive_url`
lib_dir="/usr/lib"
extract_dir="skype_static-1.4.0.74"
http_proxy=`apt-config dump | grep -i '^Acquire::http::Proxy' | cut -d ' ' -f 2 | cut -d '"' -f 2 | grep "^http://" | cut -d '/' -f 3`
if [ -n "$http_proxy" ]; then
  export http_proxy
  export https_proxy=$http_proxy
fi

abort() {
  cd /
  rm -rf ${tmp_dir}
  rm -rf ${lib_dir}/${extract_dir}
  exit 1
}

rm -rf "${TMPDIR:-/var/tmp}/${package_name}.*"
mkdir ${tmp_dir} || exit 1
cd ${tmp_dir} || abort
cd ${lib_dir} || abort
if [ $DEBUG -gt 0 ]; then
  tar xvjf /home/kbys/${archive} || abort
else
  wget --timeout=60 -P ${tmp_dir} ${archive_url} || abort
  tar xvjf ${tmp_dir}/${archive} || abort
fi
mv ${extract_dir} skype || abort
extract_dir="skype"
cd ${extract_dir} || abort
app_path="$lib_dir/$extract_dir"

#
# wrapper script
#
rm -f /usr/bin/skype || true
cat <<EOF > /usr/bin/skype
#!/bin/sh

cd ${app_path}
${app_path}/skype "\$@"
EOF
chmod +x /usr/bin/skype || true
ln -s /usr/bin/skype /usr/bin/skype-dsp-hijacker

#
# chown
#
chown root.root ${lib_dir}/${extract_dir} || true

#
# write version
#
echo $version > /usr/lib/skype/version

#
# remove tmp_dir
#
rm -rf ${tmp_dir}
