#include <stdio.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include "global.h"

#ifndef MD
#  define MD MD5
#endif

#if MD == 2
#  include "md2.h"
#elif MD == 4
#  include "md4.h"
#elif MD == 5
#  include "md5.h"
#endif

#if MD == 2
#  define MD_CTX MD2_CTX
#  define MDInit MD2Init
#  define MDUpdate MD2Update
#  define MDFinal MD2Final
#elif MD == 4
#  define MD_CTX MD4_CTX
#  define MDInit MD4Init
#  define MDUpdate MD4Update
#  define MDFinal MD4Final
#elif MD == 5
#  define MD_CTX MD5_CTX
#  define MDInit MD5Init
#  define MDUpdate MD5Update
#  define MDFinal MD5Final
#endif

unsigned char *MDString (char *string, unsigned int len)
{
    MD_CTX context;
    unsigned char digest[16];
    unsigned char *retval;
    int i;

//    fprintf(stderr, "INFO: block length = %d\n", len);
    retval = malloc(16 * sizeof(unsigned char));
    memset(retval, 0, 16);
    MDInit (&context);
    MDUpdate (&context, string, len);
    MDFinal (digest, &context);
    memcpy(retval, digest, 16);
    return retval;
}
