/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.workGenerators;

import com.sittinglittleduck.DirBuster.BaseCase;
import com.sittinglittleduck.DirBuster.GenBaseCase;
import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.WorkUnit;
import com.sittinglittleduck.DirBuster.utils.HeadRequestCheck;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;

public class WorkerGeneratorURLFuzz
implements Runnable {
    private Manager manager = Manager.getInstance();
    private BlockingQueue<WorkUnit> workQueue;
    private String inputFile;
    private String firstPart;
    private boolean stopMe = false;
    HttpClient httpclient;
    private boolean isWorking = true;
    private String urlFuzzStart;
    private String urlFuzzEnd;
    private int counter = 0;

    public WorkerGeneratorURLFuzz() {
        this.workQueue = this.manager.workQueue;
        this.inputFile = this.manager.getInputFile();
        this.firstPart = this.manager.getFirstPartOfURL();
        this.httpclient = this.manager.getHttpclient();
        this.urlFuzzStart = this.manager.getUrlFuzzStart();
        this.urlFuzzEnd = this.manager.getUrlFuzzEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BufferedReader d = null;
        try {
            String line;
            this.manager.setURLFuzzGenFinished(false);
            HeadRequestCheck.test(this.firstPart);
            d = new BufferedReader(new InputStreamReader(new FileInputStream(this.inputFile)));
            System.out.println("Starting fuzz on " + this.firstPart + this.urlFuzzStart + "{dir}" + this.urlFuzzEnd);
            this.manager.setStatus("Starting fuzz on " + this.firstPart + this.urlFuzzStart + "{dir}" + this.urlFuzzEnd);
            BaseCase baseCaseObj = GenBaseCase.genURLFuzzBaseCase(this.firstPart + this.urlFuzzStart, this.urlFuzzEnd);
            while ((line = d.readLine()) != null) {
                if (this.stopMe) {
                    this.isWorking = false;
                    return;
                }
                if (line.startsWith("#")) continue;
                String method = this.manager.getAuto() && !baseCaseObj.useContentAnalysisMode() && !baseCaseObj.isUseRegexInstead() ? "HEAD" : "GET";
                line = URLEncoder.encode(line);
                URL currentURL = new URL(this.firstPart + this.urlFuzzStart + line + this.urlFuzzEnd);
                this.workQueue.put(new WorkUnit(currentURL, true, method, baseCaseObj, line));
                ++this.counter;
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(WorkerGeneratorURLFuzz.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(WorkerGeneratorURLFuzz.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(WorkerGeneratorURLFuzz.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                d.close();
                this.manager.setURLFuzzGenFinished(true);
            }
            catch (IOException ex) {
                Logger.getLogger(WorkerGeneratorURLFuzz.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.isWorking = false;
    }

    public void stopMe() {
        this.stopMe = true;
    }

    public String getStartPoint() {
        return this.urlFuzzStart + "{dir}" + this.urlFuzzEnd;
    }

    public int getCurrentCount() {
        return this.counter;
    }

    public boolean isWorking() {
        return this.isWorking;
    }
}

