/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui.tree;

import com.sittinglittleduck.DirBuster.Result;
import com.sittinglittleduck.DirBuster.gui.JTableTree.AbstractTreeTableModel;
import com.sittinglittleduck.DirBuster.gui.JTableTree.TreeTableModel;
import com.sittinglittleduck.DirBuster.gui.tree.ResultsNode;
import java.net.URL;
import java.util.Vector;

public class ResultsTableTreeModel
extends AbstractTreeTableModel
implements TreeTableModel {
    protected static final String[] cNames = new String[]{new String("Directory Stucture"), new String("Response Code"), new String("Response Size")};
    protected static final Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class};
    private ResultsNode rootNode = new ResultsNode("/");

    public ResultsTableTreeModel() {
        super(null);
        this.root = this.rootNode;
    }

    public Object getRoot() {
        return this.rootNode;
    }

    public void cleartable() {
        this.rootNode.clearData();
        this.fireTreeStructureChanged(this.rootNode, this.getPathToRoot(this.rootNode), null, this.rootNode.getChildren());
    }

    public Object getChild(Object parent, int index) {
        return ((ResultsNode)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        return ((ResultsNode)parent).getNumberOfChildren();
    }

    public boolean isLeaf(Object node) {
        return ((ResultsNode)node).isLeaf();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int column) {
        return cNames[column];
    }

    public Object getValueAt(Object node, int col) {
        ResultsNode resultsNode = (ResultsNode)node;
        if (col == 0) {
            return resultsNode.toString();
        }
        if (col == 1) {
            if (resultsNode.result == null) {
                return "???";
            }
            return resultsNode.result.getResponceCode();
        }
        if (col == 2) {
            if (resultsNode.result == null) {
                return "???";
            }
            return resultsNode.result.getResponseHeader().length() + resultsNode.result.getResponseBody().length();
        }
        return null;
    }

    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    public void addRow(Result result) {
        ResultsNode rootTemp = this.rootNode;
        URL url = result.getItemFound();
        String fullItem = url.getPath();
        if (fullItem.equals("/")) {
            if (!rootTemp.isResultSet()) {
                rootTemp.setResult(result);
            }
            return;
        }
        Vector<String> items = new Vector<String>(10, 1);
        int index = 0;
        while ((index = fullItem.indexOf("/")) != -1) {
            String realitem = fullItem.substring(0, index);
            String rest = fullItem.substring(index + 1);
            if (realitem.length() > 0) {
                items.addElement(realitem);
            }
            fullItem = rest;
        }
        if (!fullItem.contains("/") && fullItem.length() > 0) {
            items.addElement(fullItem);
        }
        for (int a = 0; a < items.size(); ++a) {
            ResultsNode node = rootTemp.findChildBasedOnString((String)items.elementAt(a));
            if (node == null) {
                if (a == items.size() - 1) {
                    rootTemp.addChild(new ResultsNode(result));
                    this.fireTreeNodesInserted(rootTemp, this.getPathToRoot(rootTemp), new int[]{rootTemp.getChildren().length - 1}, rootTemp.getChildren());
                } else {
                    rootTemp.addChild(new ResultsNode((String)items.elementAt(a)));
                    this.fireTreeNodesInserted(rootTemp, this.getPathToRoot(rootTemp), new int[]{rootTemp.getChildren().length - 1}, rootTemp.getChildren());
                    node = rootTemp.findChildBasedOnString((String)items.elementAt(a));
                }
            } else if (!rootTemp.isResultSet() && a == items.size() - 1) {
                rootTemp.setResult(result);
                this.fireTreeNodesChanged(rootTemp, this.getPathToRoot(rootTemp), new int[]{rootTemp.getChildren().length - 1}, rootTemp.getChildren());
                return;
            }
            rootTemp = node;
        }
    }
}

