---
title: "SonarQube"
toc_hide: true
---
# SonarQube Scan
There are two ways to retrieve findings from SonarQube. You can either use the [soprasteria package](https://github.com/soprasteria/sonar-report) or the SonarQube REST API directly. 
Both ways (**SonarQube REST API** and **Soprasteria**) are depicted below. 

### Sample Scan Data
Sample SonarQube scans can be found [here](https://github.com/DefectDojo/django-DefectDojo/tree/master/unittests/scans/sonarqube).

## SonarQube REST API 
You can retrieve the JSON directly from SonarQube if you use one of the following REST API endpoint:  
- `<sonarqubeurl>/api/issues/search?projects=<projectkey>`
- `<sonarqubeurl>/api/hotspots/search?projectKey=<projectkey>`

### JSON
The REST API JSON output can be uploaded to DefectDojo with "SonarQube Scan". 

### ZIP
If you have too many findings in one project, you can implement a small script to handle pagination and put all JSON files in a .zip file. This zip file can also be parsed from DefectDojo with "SonarQube Scan". 

## Soprasteria
### Soprasteria SonarQube Scan (Aggregates findings per cwe, title, description, file\_path.)

SonarQube output file can be imported in HTML format or JSON format. JSON format generated by options `--save-report-json` and have same behavior with HTML format.

To generate the report, see
<https://github.com/soprasteria/sonar-report>

Version: \>= 1.1.0
Recommend version for both format \>= 3.1.2

### Soprasteria SonarQube Scan Detailed (Import all findings from SonarQube html report.)

SonarQube output file can be imported in HTML format or JSON format. JSON format generated by options `--save-report-json` and have same behavior with HTML format.

To generate the report, see
<https://github.com/soprasteria/sonar-report>

Version: \>= 1.1.0.
Recommend version for both format \>= 3.1.2



