# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataTableResponseObject(Model):
    """Data Table which defines columns and raw row values.

    :param table_name: Name of the table
    :type table_name: str
    :param columns: List of columns with data types
    :type columns: list[~azure.mgmt.web.models.DataTableResponseColumn]
    :param rows: Raw row values
    :type rows: list[list[str]]
    """

    _attribute_map = {
        'table_name': {'key': 'tableName', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[DataTableResponseColumn]'},
        'rows': {'key': 'rows', 'type': '[[str]]'},
    }

    def __init__(self, **kwargs):
        super(DataTableResponseObject, self).__init__(**kwargs)
        self.table_name = kwargs.get('table_name', None)
        self.columns = kwargs.get('columns', None)
        self.rows = kwargs.get('rows', None)
