/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.HashNode;

public class GeneralHashTable {
    protected HashNode[] table;
    protected int mask;
    protected int num_bindings;

    public GeneralHashTable() {
        this(64);
    }

    public GeneralHashTable(int capacity) {
        int log2Size = 4;
        while (capacity > 1 << log2Size) {
            ++log2Size;
        }
        capacity = 1 << log2Size;
        this.table = new HashNode[capacity];
        this.mask = capacity - 1;
    }

    protected HashNode makeEntry(Object key, int hash, Object value) {
        HashNode node = new HashNode();
        node.key = key;
        node.hash = hash;
        node.value = value;
        return node;
    }

    public int hash(Object key) {
        return key == null ? 0 : key.hashCode();
    }

    public int hash(HashNode node) {
        return node.hash;
    }

    public boolean matches(Object key, int hash, HashNode node) {
        return node.hash == hash && this.matches(node.getKey(), key);
    }

    public boolean matches(Object value1, Object value2) {
        return value1 == value2 || value1 != null && value1.equals(value2);
    }

    public Object get(Object key, Object defaultValue) {
        int hash = this.hash(key);
        int index = hash & this.mask;
        HashNode node = this.table[index];
        while (node != null) {
            if (this.matches(key, hash, node)) {
                return node.getValue();
            }
            node = node.next;
        }
        return defaultValue;
    }

    public HashNode getNode(Object key) {
        int hash = this.hash(key);
        int index = hash & this.mask;
        HashNode node = this.table[index];
        while (node != null) {
            if (this.matches(key, hash, node)) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        return this.put(key, this.hash(key), value);
    }

    public Object put(Object key, int hash, Object value) {
        HashNode first;
        int index = hash & this.mask;
        HashNode node = first = this.table[index];
        while (true) {
            if (node == null) {
                if (++this.num_bindings >= this.table.length) {
                    this.rehash();
                    index = hash & this.mask;
                    first = this.table[index];
                }
                node = this.makeEntry(key, hash, value);
                node.next = first;
                this.table[index] = node;
                return null;
            }
            if (this.matches(key, hash, node)) {
                return node.setValue(value);
            }
            node = node.next;
        }
    }

    public Object remove(Object key) {
        int hash = this.hash(key);
        int index = hash & this.mask;
        HashNode prev = null;
        HashNode node = this.table[index];
        while (node != null) {
            HashNode next = node.next;
            if (this.matches(key, hash, node)) {
                if (prev == null) {
                    this.table[index] = next;
                } else {
                    prev.next = node;
                }
                --this.num_bindings;
                return node.getValue();
            }
            prev = node;
            node = next;
        }
        return null;
    }

    protected void rehash() {
        HashNode[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        int newCapacity = 2 * oldCapacity;
        HashNode[] newTable = new HashNode[newCapacity];
        int newMask = newCapacity - 1;
        int i = oldCapacity;
        while (--i >= 0) {
            HashNode chain = oldTable[i];
            if (chain != null && chain.next != null) {
                HashNode prev = null;
                do {
                    HashNode node = chain;
                    chain = node.next;
                    node.next = prev;
                    prev = node;
                } while (chain != null);
                chain = prev;
            }
            HashNode element = chain;
            while (element != null) {
                HashNode head;
                HashNode next = element.next;
                int hash = this.hash(element);
                int j = hash & newMask;
                element.next = head = newTable[j];
                newTable[j] = element;
                element = next;
            }
        }
        this.table = newTable;
        this.mask = newMask;
    }

    public void clear() {
        HashNode[] t = this.table;
        int i = t.length;
        while (--i >= 0) {
            t[i] = null;
        }
        this.num_bindings = 0;
    }

    public int size() {
        return this.num_bindings;
    }

    protected static HashNode next(HashNode node) {
        return node.next;
    }
}

