/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.Arrays;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.CompressedWhitespace;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.Twine16;
import net.sf.saxon.str.Twine24;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntIterator;

public class StringTool {
    public static int getStringLength(CharSequence s2) {
        int n = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public static int[] expand(UnicodeString s2) {
        int[] array = new int[s2.length32()];
        IntIterator iter = s2.codePoints();
        int i = 0;
        while (iter.hasNext()) {
            array[i++] = iter.next();
        }
        return array;
    }

    public static boolean containsSurrogates(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!UTF16CharacterSet.isSurrogate(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static UnicodeString fromCodePoints(int[] codes, int used) {
        UnicodeBuilder sb = new UnicodeBuilder();
        for (int i = 0; i < used; ++i) {
            sb.append(codes[i]);
        }
        return sb.toUnicodeString();
    }

    public static UnicodeString fromCharSequence(CharSequence chars) {
        UnicodeBuilder sb = new UnicodeBuilder();
        IntIterator iter = StringTool.codePoints(chars);
        while (iter.hasNext()) {
            sb.append(iter.next());
        }
        return sb.toUnicodeString();
    }

    public static UnicodeString fromLatin1(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            bytes[i] = (byte)(str.charAt(i) & 0xFF);
        }
        return new Twine8(bytes);
    }

    public static IntIterator codePoints(final CharSequence value) {
        return new IntIterator(){
            int i = 0;
            boolean expectingLowSurrogate;

            @Override
            public boolean hasNext() {
                return this.i < value.length();
            }

            @Override
            public int next() {
                char c;
                if (UTF16CharacterSet.isHighSurrogate(c = value.charAt(this.i++))) {
                    try {
                        int d;
                        int n = d = this.hasNext() ? (int)value.charAt(this.i++) : -1;
                        if (!UTF16CharacterSet.isLowSurrogate(d)) {
                            throw new IllegalStateException("Unmatched surrogate code value " + c + " at position " + this.i);
                        }
                        return UTF16CharacterSet.combinePair(c, (char)d);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalStateException("Invalid surrogate at end of string");
                    }
                }
                return c;
            }
        };
    }

    public static String diagnosticDisplay(String s2) {
        StringBuilder fsb = new StringBuilder(s2.length());
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            if (c >= ' ' && c <= '~') {
                fsb.append(c);
                continue;
            }
            fsb.append("\\u");
            for (int shift = 12; shift >= 0; shift -= 4) {
                fsb.append("0123456789ABCDEF".charAt(c >> shift & 0xF));
            }
        }
        return fsb.toString();
    }

    public static void prependWideChar(StringBuilder builder, int ch) {
        if (ch > 65535) {
            char[] pair = new char[]{UTF16CharacterSet.highSurrogate(ch), UTF16CharacterSet.lowSurrogate(ch)};
            builder.insert(0, pair);
        } else {
            builder.insert(0, (char)ch);
        }
    }

    public static void prependRepeated(StringBuilder builder, char ch, int count) {
        char[] array = new char[count];
        Arrays.fill(array, ch);
        builder.insert(0, array);
    }

    public static void appendRepeated(StringBuilder builder, char ch, int count) {
        for (int i = 0; i < count; ++i) {
            builder.append(ch);
        }
    }

    public static int lastCodePoint(UnicodeString str) {
        return str.codePointAt(str.length() - 1L);
    }

    public static long lastIndexOf(UnicodeString str, int codePoint) {
        for (long i = str.length() - 1L; i >= 0L; --i) {
            if (str.codePointAt(i) != codePoint) continue;
            return i;
        }
        return -1L;
    }

    public static int requireInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("String exceeds 2^31 characters");
        }
        return (int)value;
    }

    public static UnicodeString compress(char[] in, int offset, int len, boolean compressWS) {
        int i;
        if (len == 0) {
            return EmptyUnicodeString.getInstance();
        }
        int max = 255;
        int end = offset + len;
        boolean allWhite = compressWS;
        int surrogates = 0;
        for (int i2 = offset; i2 < end; ++i2) {
            char c = in[i2];
            max |= c;
            if (allWhite && !Whitespace.isWhite(c)) {
                allWhite = false;
            }
            if (!UTF16CharacterSet.isSurrogate(c)) continue;
            ++surrogates;
        }
        if (allWhite) {
            return CompressedWhitespace.compressWS(in, offset, end);
        }
        if (max < 256) {
            byte[] array = new byte[len];
            i = offset;
            int j = 0;
            while (i < end) {
                array[j++] = (byte)in[i++];
            }
            return new Twine8(array);
        }
        if (surrogates == 0) {
            char[] array = Arrays.copyOfRange(in, offset, offset + len);
            return new Twine16(array);
        }
        byte[] array = new byte[3 * (len - surrogates / 2)];
        i = offset;
        int j = 0;
        while (i < end) {
            char c;
            if (UTF16CharacterSet.isSurrogate(c = in[i++])) {
                int cp = UTF16CharacterSet.combinePair(c, in[i++]);
                array[j++] = (byte)((cp & 0xFFFFFF) >> 16);
                array[j++] = (byte)((cp & 0xFFFF) >> 8);
                array[j++] = (byte)(cp & 0xFF);
                continue;
            }
            array[j++] = 0;
            array[j++] = (byte)((c & 0xFFFF) >> 8);
            array[j++] = (byte)(c & 0xFF);
        }
        return new Twine24(array);
    }

    public static void copy8to16(byte[] source, int sourcePos, char[] dest, int destPos, int count) {
        int last = sourcePos + count;
        int i = sourcePos;
        int j = destPos;
        while (i < last) {
            dest[j++] = (char)(source[i++] & 0xFF);
        }
    }

    public static void copy8to24(byte[] source, int sourcePos, byte[] dest, int destPos, int count) {
        int last = sourcePos + count;
        int i = sourcePos;
        int j = destPos * 3;
        while (i < last) {
            dest[j++] = 0;
            dest[j++] = 0;
            dest[j++] = source[i++];
        }
    }

    public static void copy16to24(char[] source, int sourcePos, byte[] dest, int destPos, int count) {
        int last = sourcePos + count;
        int i = sourcePos;
        int j = destPos * 3;
        while (i < last) {
            char c = source[i++];
            dest[j++] = 0;
            dest[j++] = (byte)(c >> 8 & 0xFF);
            dest[j++] = (byte)(c & 0xFF);
        }
    }
}

