#!/usr/bin/env python
# coding: utf-8
#
# Copyright 2010 Alexandre Fiori
# based on the original Tornado by Facebook
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import sys
import hashlib
import time

import cyclone.escape
import cyclone.web
import digest

from twisted.python import log
from twisted.internet import reactor


class Application(cyclone.web.Application):
    def __init__(self):
        handlers = [
            (r"/", MainHandler),
        ]
        settings = dict(
            cookie_secret="32oETzKXQAGaYdkL5gEmGeJJFuYh7EQnp2XdTP1o/Vo=",
            debug=True,
            login_url="/auth/login",
        )
        cyclone.web.Application.__init__(self, handlers, **settings)


class MainHandler(digest.DigestAuthMixin, cyclone.web.RequestHandler):
    # forces this handler to parse only GET / PROPFIND methods
    SUPPORTED_METHODS = ("GET", "PROPFIND")
    def passwordz(username):
        creds = {
                'auth_username': 'test',
                'auth_password': 'foobar'
                }
        if username == creds['auth_username']:
            return creds

    @digest.digest_auth('Cyclone', passwordz)
    def get(self):
        self.write("Hello %s" % (self.current_user))

    @digest.digest_auth('Cyclone', passwordz)
    def propfind(self):
        self.write("Hello %s" % (self.current_user))


def main():
    log.startLogging(sys.stdout)
    reactor.listenTCP(8888, Application(), interface="127.0.0.1")
    reactor.run()


if __name__ == "__main__":
    main()
