/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.projectimport.eclipse.core;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

/**
 *
 */
public class ImportProblemsPanel extends javax.swing.JPanel {

    /** Creates new form ImportProblemsPanel */
    private ImportProblemsPanel(List<String> problems) {
        initComponents();
        text.setEditable(false);
        StringBuffer sb = new StringBuffer();
        for (String s : problems) {
            if (s.startsWith(" ")) { //NOI18N
                sb.append(" \u2022 "); //NOI18N
            }
            sb.append(s);
            sb.append("\r\n"); //NOI18N
            sb.append("\r\n"); //NOI18N
        }
        text.setText(sb.toString());
    }
    
    public static void showReport(String title, List<String> problems) {
        if (problems.size() == 0) {
            return;
        }
        ImportProblemsPanel p = new ImportProblemsPanel(problems);
        DialogDescriptor dd = new DialogDescriptor (p, title,
            true, new Object[]{DialogDescriptor.CLOSED_OPTION}, null, 
            DialogDescriptor.DEFAULT_ALIGN, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog (dd);
        dlg.setVisible(true);
    }
    
    public static List<String> indentAllButFirst(List<String> importProblems) {
        List<String> l = new ArrayList<String>();
        boolean first = true;
        for (String s : importProblems) {
            l.add((first ? "" : " ") + s); //NOI18N
            first = false;
        }
        return l;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        text = new javax.swing.JTextPane();

        jScrollPane1.setViewportView(text);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 457, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 331, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextPane text;
    // End of variables declaration//GEN-END:variables

}
