/* Copyright (c) 2005 Michael Schroeder (mls@suse.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 ****************************************************************
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include "common.h"

/*******************************************************************/

char header[256];

void
printdiff(srpm, h)
struct srpm *srpm;
int h;
{
  static int hp = 0;
  if (!hp)
    {
      hp = 1;
      printf("%s\n", header);
    }
  printf("%c %s\n", h, srpm->cp.path);
}

int
main(argc, argv)
int argc;
char **argv;
{
  int ret = 0;
  int r, i, nrpms, rc;
  struct srpm *srpms, *srpm, *msrpm;
  int found;

  if (argc != 3)
    {
      fprintf(stderr, "Usage: rpmlistdiff old new\n");
      exit(1);
    }
  nrpms = 2;
  srpms = xcalloc(nrpms, sizeof(*srpms));
  for (i = 0, srpm = srpms; i < nrpms; i++, srpm++)
    {
      srpm->name = argv[1 + i];
      srpm->ffd = open(srpm->name, O_RDONLY);
      if (srpm->ffd == -1)
	{
	  perror(srpm->name);
	  exit(1);
	}
      rpmopen(srpm);
      if (!srpm->fp)
	{
	  fprintf(stderr, "%s: not a rpmlist\n", srpm->name);
	  exit(1);
	}
      if (srpm->patchesCount)
	{
	  fprintf(stderr, "%s: is a patch\n", srpm->name);
	  exit(1);
	}
      rpmlgethead(srpm);
    }

  /* read files from all but the last */
  for (i = 0, srpm = srpms; i < nrpms - 1; i++, srpm++)
    rpmgetent(srpm);

  /* all files opened, process cpio archive of last rpm */
  msrpm = srpms + nrpms - 1;
  sprintf(header, "%s %s", srpms[0].rpmnevr, srpms[1].rpmnevr);

  for (;;)
    {
      if (rpmgetent(msrpm) == 0)
	break;
      found = 1;
      for (i = 0, srpm = srpms; i < nrpms - 1; i++, srpm++)
	{
	  for (;;)
	    {
	      rc = -1;
	      if (srpm->cp.eof)
		break;
	      rc = strcmp(msrpm->cp.path, srpm->cp.path);
	      if (rc <= 0)
		break;
	      printdiff(srpm, '-');
	      ret = 1;
	      rpmeat(srpm);
	      rpmgetent(srpm);
	    }
	  if (rc)
	    found = 0;
	}
      if (found)
	{
	  /* found in all rpms, have to check bytes */
	  if ((r = rpmcmp(srpms, nrpms)) != 0)
	    {
	      printdiff(msrpm, r == 1 ? '!' : '?');
	      ret = 1;
	    }
	  /* get next headers */
	  for (i = 0, srpm = srpms; i < nrpms - 1; i++, srpm++)
	    rpmgetent(srpm);
	}
      else
	{
	  printdiff(srpm, '+');
	  ret = 1;
          rpmeat(msrpm);
	}
    }

  /* check all rpms till eof */
  for (i = 0, srpm = srpms; i < nrpms - 1; i++, srpm++)
    {
      while (!srpm->cp.eof)
	{
	  rpmgetent(srpm);
	  if (!srpm->cp.eof)
	    {
	      printdiff(srpm, '-');
	      ret = 1;
	    }
	  rpmeat(srpm);
	}
    }
  exit(ret);
}
