/* Copyright (c) 2005 Michael Schroeder (mls@suse.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 ****************************************************************
 */

#include <rpmlib.h>

#define	RPMFILE_UNPATCHED	(1 << 10)
#define	RPMFILE_UNPATCHED_OLD	(1 << 15)
#define RPMTAG_PATCHESNAME		1133
#define RPMTAG_PATCHESFLAGS		1134
#define RPMTAG_PATCHESVERSION		1135

typedef unsigned int uint32; 

extern void expandFilelist(Header);

struct hardlink
{
  struct hardlink *next;
  char *path;
};

struct cpioHeader {
    ino_t inode;
    mode_t mode;
    uid_t uid;
    char *owner;
    gid_t gid;
    char *group;
    int nlink;
    time_t mtime;
    long size;
    dev_t dev, rdev;
    char *path;
    struct hardlink *next;
    int num;
    int bytes;
    int eof;
    int md5set;
    char md5[16];
};

struct cpioCrcPhysicalHeader {
    char magic[6];
    char inode[8];
    char mode[8];
    char uid[8];
    char gid[8];
    char nlink[8];
    char mtime[8];
    char filesize[8];
    char devMajor[8];
    char devMinor[8];
    char rdevMajor[8];
    char rdevMinor[8];
    char namesize[8];
    char checksum[8];
};

struct srpm {
  char *name;
  Header h;
  int  ffd;
  FILE *fp;
  FD_t fd;
  char *comp;
  FD_t cfd;
  uint_32 cpiopos;
  struct cpioHeader cp;
  const char *rpmname;
  char *rpmevr;
  char *rpmnevr;
  int patchesCount;
  char **patchesNEVR;
  int fileCount;
  char **fileNames;
  uint_32 *fileFlags;
  uint_16 *fileModes;
  char **fileOwners;
  char **fileGroups;
  char *buildhost;
  uint_32 buildtime;

  char *lastfn;
  int  lastfnl;
  char lastown[9];
  char lastgrp[9];
  int  bytesread;
};

extern void *xmalloc(int);
extern void *xrealloc(void *, int);
extern void *xcalloc(int, int);
extern int strntoul(const char *, char **, int, int);
extern Header readPackageHeader(FD_t);

extern int  rpmlgetent(struct srpm *);
extern void rpmlgethead(struct srpm *);

extern int  rpmfgetent(struct srpm *);
extern void rpmfmap(struct srpm *);
extern void rpmfsetmd5(struct srpm *);
extern void rpmfeat(struct srpm *);
extern void rpmfgethead(struct srpm *);

extern int  rpmgetent(struct srpm *);
extern void rpmeat(struct srpm *);
extern void rpmopen(struct srpm *);
extern int  rpmcmp(struct srpm *, int);

