#ifndef _LINUX_KBD_SNIFF_H
#define _LINUX_KBD_SNIFF_H

#include <linux/ioctl.h>

/*
 * linux/include/kbd_sniff.h
 * 
 * Copyright 1998-2004: Roger Butenuth
 * butenuth@online.de
 * 
 * modified by Marco Skambraks <marco@suse.de>
 * - added work-arround for kernel 2.6.x
 */


/*
 * we have to re-define _IOW and _IOWR
 * if we use the default definitions 
 * KBD_SNIFF_SET and KBD_SNIFF_GET will generate a compiler error
 * reason: _IOC_TYPECHECK
 */
#undef _IOW
#undef _IOWR

#define _IOW(type,nr,size)	_IOC(_IOC_WRITE,(type),(nr),(sizeof(size)))
#define _IOWR(type,nr,size)	_IOC(_IOC_READ|_IOC_WRITE,(type),(nr),(sizeof(size)))

#define KBD_SNIFF_SET _IOW(0x42, 1, sizeof(struct sniff_ioctl_set))
#define KBD_SNIFF_GET _IOWR(0x42, 2, sizeof(struct sniff_ioctl_get))

#define SNIFF_NR_HOT_KEYS     4
#define SNIFF_EVENT_BUF_SIZE 20

#define SNIFF_HOT_MODE 0x0100
#define SNIFF_CAPSLOCK 0x0200

struct sniff_event {
	unsigned short shift_state;
	unsigned short keycode;
};

struct sniff_ioctl_set {
	int hot_key_enable;
	int nr_hot_keys;
	int hot_key[SNIFF_NR_HOT_KEYS];
	int disable_key;
};

struct sniff_ioctl_get {
	int                blocking;
	int                count;
	struct sniff_event event[SNIFF_EVENT_BUF_SIZE];
};

int kbd_sniff_hook(int shift_state, int keycode);

#endif /* _LINUX_KBD_SNIFF_H */
