#ifndef _kbd_h
#define _kbd_h
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/kd.h>
#include <linux/keyboard.h>
#include "kbd_sniff.h"

/* static input_listener_t input_listener;  */

static int vcsa_fd = -1;
static int cons_fd = -1;
static int kbd_sniffing = 0;

/* void set_input_listener(input_listener_t fun); */
static int open_kbd_sniff (int on1, int on2, int off);
static int get_key (int *shift_state, int *keycode);
static void close_kbd_sniff (void);
static int key_to_ascii (int shift_state, int keycode);
static int build_command (int shift_state, int keycode);

int get_input_event ();
int get_input_event ()
{
  int result = EOF;

  if (kbd_sniffing)
   {
     int shift_state=0, keycode=0;

     (void) get_key (&shift_state, &keycode);
     if (keycode != 0)
      {
	if (shift_state & SNIFF_HOT_MODE)
	 {
	   result = build_command (shift_state, keycode);
	 }
/*		else 
		if (input_listener != NULL && 
                           (keycode & 0x80) == 0) {
                    int ascii = key_to_ascii(shift_state, keycode);
                    (*input_listener)(shift_state, keycode, ascii);
                } */
      }

   }

#if 0
  if (result != EOF)
    LogPrint (LOG_DEBUG, "get_input_event -> %d", result);
#endif

  return result;
}

/*
 * ----------------------------------------------------------------------
 * Set a input listener function or clear it (fun == NULL). The function
 * is called on every key press.
 * ----------------------------------------------------------------------
 */
/* void set_input_listener(input_listener_t fun)
{
    input_listener = fun;
} */

static int open_kbd_sniff (int on1, int on2, int off)
{
  struct sniff_ioctl_set set;

  if (on1 >= 0 && off <= 0)
   {
     sbl_log ("warn: kbdsniffoff is not defined - disable kbdsniff\n");
     kbd_sniffing = 0;
     return 0;
   }
  vcsa_fd = open ("/dev/vcsa", O_RDWR);
  cons_fd = open ("/dev/console", O_RDWR);

  set.hot_key_enable = 1;
  set.hot_key[0] = on1 - 500;	/* left shift */

  if (on2 > 500)
   {
     set.hot_key[1] = on2 - 500;
     set.nr_hot_keys = 2;
   }
  else
    set.nr_hot_keys = 1;

  set.disable_key = off - 500;

  if (ioctl (vcsa_fd, KBD_SNIFF_SET, &set) < 0)
   {
     sbl_log ("no kernel support for keyboard sniffing\n");
     kbd_sniffing = 0;
     return 0;
   }
  else
   {
     sbl_log ("keyboard sniffing in kernel and activated");
     kbd_sniffing = 1;
     return 1;
   }
}

static void close_kbd_sniff (void)
{
  struct sniff_ioctl_set set;

  if (kbd_sniffing)
   {
     set.hot_key_enable = 0;
     if (ioctl (vcsa_fd, KBD_SNIFF_SET, &set) < 0)
       sbl_log ("Failed to disable keyboard sniffing\n");
   }
  close (vcsa_fd);
  close (cons_fd);
}

/*
 *----------------------------------------------------------------------
 * Convert given shift state and keycode to ascii. 
 * Return 0 whenever there is no meaningful translation.
 *----------------------------------------------------------------------
 */
static int key_to_ascii (int shift_state, int keycode)
{
  struct kbentry key;
  int type, sym;
  int ascii = 0;

  if (keycode & 0x80)
    return 0;			/* ignore key release */

  key.kb_table = shift_state & 0xff;
  key.kb_index = keycode;
  key.kb_value = 0;

  if (ioctl (cons_fd, KDGKBENT, &key) < 0)
   {
     LogPrint (LOG_ERR, "get key entry ioctl: %s", strerror (errno));
     return 0;
   }
  if (key.kb_value != K_HOLE)
   {
     type = KTYP (key.kb_value) & 0x0f;
     sym = KVAL (key.kb_value);
     switch (type)
      {
      case KT_LETTER:
	if ((shift_state & SNIFF_CAPSLOCK) != 0)
	  ascii = sym - 'a' + 'A';
	else
	  ascii = sym;
	break;
      case KT_LATIN:
	ascii = sym;
	break;
      case KT_ASCII:
      case KT_FN:
      case KT_SPEC:
      case KT_PAD:
      case KT_DEAD:
      case KT_CONS:
      case KT_CUR:
      case KT_SHIFT:
      case KT_META:
      case KT_LOCK:
      case KT_SLOCK:
	break;
      }
   }
  return ascii;
}

/*
 *----------------------------------------------------------------------
 * Get one keypress. This can be done blocking or with polling.
 * keycode == 0 means no key available (polling only)
 *----------------------------------------------------------------------
 */
static int get_key (int *shift_state, int *keycode)
{
  static struct sniff_ioctl_get get;
  static int pos = 0;
  int result = 0;

  if (pos == get.count)
   {
     /*
      * buffer is empty
      */
     pos = 0;
     get.blocking = 0;
     get.count = 0;
     result = ioctl (vcsa_fd, KBD_SNIFF_GET, &get);
     if (result < 0)
       return result;
   }

  if (pos < get.count)
   {
     *shift_state = get.event[pos].shift_state;
     *keycode = get.event[pos].keycode;
     pos++;
   }
  else
   {
     *shift_state = 0;
     *keycode = 0;
   }

  return result;
}

/*
 * ----------------------------------------------------------------------
 * Take a keypress/keyrelease as input and convert it into an braille
 * command.
 * ----------------------------------------------------------------------
 */
static int build_command (int shift_state, int keycode)
{
  int cmd;
  unsigned char ascii;

  if ((keycode & 0x80) != 0)
   {
     /*
      * key release, ignore
      */
     cmd = EOF;
   }
  /*
   * key press
   */
  ascii = key_to_ascii (shift_state, keycode);

  /* function-keys tab backspace enter lft_shft rgt_shft */
  if ((keycode >= 55 && keycode <= 111) || keycode == 0x2a || keycode == 0x36
      || keycode == 0x1c || keycode == 0x0e || keycode == 0x0f)
    return keycode + 500;
  if (keycode == 1)		/* return ESC */
    return 501;

  return ascii;
}

#endif
