#include <string.h>
#include "ringbuffer.h"
static int *in_ptr = NULL, *out_ptr = NULL;
static volatile int bufcnt = 0;
static int key_buffer[BUF_ELEMENTS * BUF_LEN];
void key_init_buf ()
{
  memset (key_buffer, 0, sizeof (key_buffer));
  bufcnt = 0;
  out_ptr = key_buffer;
  in_ptr = key_buffer;

}

/* return bufcnt if OK and NULL on error */
int key_put_buf (int key, int pressed)
{
  if (bufcnt < BUF_ELEMENTS)	// If buffer not full
   {
     in_ptr[0] = key;
     in_ptr[1] = pressed;	// Put character into buffer
     in_ptr += BUF_LEN;		// Increment pointer
     bufcnt++;
     if (in_ptr >= (key_buffer + (BUF_ELEMENTS * BUF_LEN)))
       in_ptr = key_buffer;
   }
  else
    return 0;

  return bufcnt;
}

/* returns 0 if queue is empty and current bufcnt if not */
int key_get_buf (int *key, int *pressed)
{

  if (!bufcnt)
    return 0;

  *key = out_ptr[0];
  *pressed = out_ptr[1];
  out_ptr[0] = out_ptr[1] = 0;
  out_ptr += BUF_LEN;		// Increment pointer
  if (out_ptr >= (key_buffer + (BUF_ELEMENTS * BUF_LEN)))
    out_ptr = key_buffer;
  bufcnt--;			// Decrement buffer count
  return bufcnt + 1;
}

int key_getbufcnt ()
{
  return bufcnt;
}
