
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*****************************************************************************
 *****************************************************************************
		    GENERIC FUNCTION PROTOTYPES OF DRIVER
 *****************************************************************************
 *****************************************************************************/

#define GENPROTO_DRIVER_INIT( shortex ) \
\
extern ACLvoid	acl_ ## shortex ## _update_accel_mod ( ACLContext ctx ); \
extern ACLvoid	acl_ ## shortex ## _update_depth_mod ( ACLContext ctx ); \
extern ACLvoid	acl_ ## shortex ## _update_tex_mod ( ACLContext ctx ); \
\
ACLvoid	shortex ## _InitACLAPI ( ACLContext );



#define GENPROTO_DRIVER_SETUP( shortex, FSCOPE ) \
\
FSCOPE ACLvoid	shortex ## _InitMain( ACLContext ); \
\
FSCOPE ACLvoid	shortex ## _InitDepthStencil( ACLContext ); \
\
FSCOPE ACLvoid	shortex ## _SetLB( ACLContext ); \
\
FSCOPE ACLvoid	shortex ## _SetFB( ACLContext ); \
\
FSCOPE ACLvoid	shortex ## _UpdateWindow ( ACLContext ); \
\
FSCOPE ACLvoid  shortex ## _SetSmoothShading( ACLContext, ACLbool ); \
\
FSCOPE ACLint	shortex ## _SetColorsRGBA( ACLContext ); \
\
FSCOPE ACLint	shortex ## _FindFormatRGBA(ACLubyte r, ACLubyte g, \
				ACLubyte b, ACLubyte a ); \
\
FSCOPE ACLvoid	shortex ## _InitColorMod( ACLContext );



/*****************************************************************************
 *****************************************************************************
		    GENERIC FUNCTION PROTOTYPES FOR ACL API
 *****************************************************************************
 *****************************************************************************/

/*************************
 * Main module functions:
 *************************/

#define GENPROTO_ACLAPI_MODULE( shortex, FSCOPE ) \
\
FSCOPE ACLint	acl_ ## shortex ## _init_client( ACLContext, ACLSetup ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _exit_client( ACLContext ); \
\
FSCOPE ACLbool	acl_ ## shortex ## _draw_buffer( ACLContext, ACLglenum ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _swap_buffer_bitblt( ACLContext ); \
FSCOPE ACLvoid	acl_ ## shortex ## _swap_buffer_scroff( ACLContext ); \
FSCOPE ACLvoid	acl_ ## shortex ## _swap_buffer_pixdepth( ACLContext );



/**************************
 * Color module functions:
 **************************/

#define GENPROTO_ACLAPI_COLOR( shortex, FSCOPE ) \
\
FSCOPE ACLvoid	acl_ ## shortex ## _color( ACLContext, \
			ACLubyte, ACLubyte, ACLubyte, ACLubyte ); \
\
/* RGB(A) SPAN FUNCTIONS */ \
/* ===================== */ \
FSCOPE ACLvoid	acl_ ## shortex ## _write_rgba_span( const ACLHyperContext, \
			ACLuint n, ACLint x, ACLint y, \
			const ACLubyte rgba[][4], const ACLubyte mask[] ); \
\
FSCOPE ACLuint acl_ ## shortex ## _write_rgba_depth_span(ACLHyperContext, \
			ACLuint n, ACLint x, ACLint y, const GLdepth z[], \
			ACLubyte mask[]); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _write_rgb_span( const ACLHyperContext, \
			ACLuint n, ACLint x, ACLint y, \
			const ACLubyte rgb[][3], const ACLubyte mask[] ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _write_monorgba_span(const ACLHyperContext,\
			ACLuint n, ACLint x, ACLint y, \
			const ACLubyte mask[] ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _read_rgba_span( const ACLHyperContext, \
			ACLuint n, ACLint x, ACLint y, ACLubyte rgba[][4] ); \
\
/* RGB(A) PIXEL FUNCTIONS */ \
/* ====================== */ \
FSCOPE ACLvoid acl_ ## shortex ## _write_rgba_depth_pixels(ACLHyperContext ctx, \
				       ACLuint n, const ACLint x[], const ACLint y[], \
				       const GLdepth z[], ACLubyte mask[]); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _write_rgba_pixels( const ACLHyperContext, \
			ACLuint n, const ACLint x[], const ACLint y[], \
			const ACLubyte rgba[][4], const ACLubyte mask[] ); \
\
FSCOPE ACLvoid	acl_ ##shortex## _write_monorgba_pixels(const ACLHyperContext,\
			ACLuint n, const ACLint x[], const ACLint y[], \
			const ACLubyte mask[] ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _read_rgba_pixels( const ACLHyperContext, \
			ACLuint n, const ACLint x[], const ACLint y[], \
			ACLubyte rgba[][4], const ACLubyte mask[] ); \
\
/* CI SPAN FUNCTIONS */\
/* ================= */\
\
/* CI PIXEL FUNCTIONS */\
/* ================== */\
\



/**************************
 * Depth module functions:
 **************************/

#define GENPROTO_ACLAPI_DEPTH( shortex, FSCOPE ) \
\
ACLvoid		acl_ ## shortex ## _update_depth_mod ( ACLContext ctx ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _clear_depth(ACLContext, ACLfloat ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _depth_func(ACLContext, ACLenum ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _depth_mask(ACLContext, ACLbool ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _depth_enabled(ACLContext, ACLbool ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _clear_stencil(ACLContext aclctx, ACLint s); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _stencil_func(ACLContext aclctx, ACLenum func, \
				    ACLint ref, ACLuint mask); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _stencil_op(ACLContext aclctx, ACLenum fail, \
                                    ACLenum zfail, ACLenum zpass); \
\
FSCOPE ACLvoid acl_ ## shortex ## _stencil_enable(ACLContext aclctx, ACLbool enable ); \


/********************************
 * Accelerated module functions:
 ********************************/

#define GENPROTO_ACLAPI_ACCEL( shortex, FSCOPE ) \
\
ACLvoid		acl_ ## shortex ## _update_accel_mod ( ACLContext ctx ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _clear_color( ACLContext, \
			ACLubyte, ACLubyte, ACLubyte, ACLubyte ); \
\
FSCOPE ACLbitfield acl_ ## shortex ## _clear(ACLHyperContext, \
			ACLbitfield, ACLbool, \
			ACLint, ACLint, ACLint, ACLint ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _set_logop(ACLContext aclctx, \
                         ACLbool enable, ACLint logop); \
FSCOPE ACLvoid	acl_ ## shortex ## _set_dither(ACLContext aclctx, \
                         ACLbool enable, ACLbool modeline); \
FSCOPE ACLvoid	acl_ ## shortex ## _set_alpha(ACLContext aclctx, \
                         ACLbool enable, ACLint func, ACLint ref); \
FSCOPE ACLvoid	acl_ ## shortex ## _set_blend(ACLContext aclctx, \
                         ACLbool enable, ACLint src, ACLint dst); \
FSCOPE ACLvoid	acl_ ## shortex ## _set_fog(ACLContext aclctx, \
				ACLbool enable, ACLint mode, ACLfloat density, \
				ACLfloat r, ACLfloat g, \
				ACLfloat b, ACLfloat a); \
\
/* POINTS FUNCTIONS */\
/* ================ */\
FSCOPE ACLvoid	acl_ ## shortex ## _points_flat(ACLHyperContext, \
			ACLuint, ACLuint ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _points_smooth(ACLHyperContext, \
			ACLuint, ACLuint ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _points_texture(ACLHyperContext, \
			ACLuint, ACLuint ); \
\
/* LINE FUNCTIONS */\
/* ============== */\
FSCOPE ACLvoid	acl_ ## shortex ## _line_flat(ACLHyperContext, \
			ACLuint, ACLuint, ACLuint ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _line_smooth(ACLHyperContext, \
			ACLuint, ACLuint, ACLuint ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _line_texture(ACLHyperContext, \
			ACLuint, ACLuint, ACLuint ); \
\
/* TRIANGLE FUNCTIONS */\
/* ================== */\
FSCOPE ACLvoid	acl_ ## shortex ## _triangle_flat(ACLHyperContext, \
			ACLuint, ACLuint, ACLuint, ACLuint ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _triangle_smooth(ACLHyperContext, \
			ACLuint, ACLuint, ACLuint, ACLuint ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _triangle_texture(ACLHyperContext, \
			ACLuint, ACLuint, ACLuint, ACLuint );



/****************************
 * TEXTURE MODULE FUNCTIONS:
 ****************************/

#define GENPROTO_ACLAPI_TEX( shortex, FSCOPE ) \
\
ACLvoid		acl_ ## shortex ## _update_tex_mod ( ACLContext ctx ); \
\
ACLvoid	acl_ ## shortex ## _tex_enable(ACLContext, ACLbool state); \
\
FSCOPE ACLvoid *acl_ ## shortex ## _tex_alloc(ACLContext); \
\
FSCOPE ACLvoid *acl_ ## shortex ## _tex_free(ACLContext, ACLvoid * dd); \
\
FSCOPE ACLbool	acl_ ## shortex ## _tex_translate_image(ACLContext, \
			const ACLTexImage tex, ACLint format, ACLint level, \
			ACLuint name, ACLvoid *dd); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _tex_download_lb(ACLContext ctx, \
			ACLint level, ACLvoid *dd); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _tex_bind(ACLContext, ACLuint name, ACLvoid *dd); \
\
FSCOPE ACLbool	acl_ ## shortex ## _tex_env(ACLContext, ACLglenum pname, \
			const ACLfloat *param ); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _tex_SetLUT(ACLContext aclctx, \
			ACLuint anz, ACLuint * index, ACLuint adr, \
			ACLuint * pixels); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _tex_Palette(ACLContext aclctx, \
			ACLuint size, ACLuint * data, ACLvoid *dd); \
\
FSCOPE ACLvoid	acl_##shortex##_tex_SwitchToGlobalPalette(ACLContext aclctx); \
\
FSCOPE ACLvoid	acl_##shortex##_tex_DownloadGlobalPalette(ACLContext aclctx, \
			ACLuint size, ACLuint * data, ACLvoid *dd); \
\
FSCOPE ACLvoid	acl_ ## shortex ## _tex_param(ACLContext, \
			ACLglenum target, ACLglenum pname, \
                        const ACLfloat *param, ACLvoid * dd); \
\
FSCOPE ACLvoid acl_ ## shortex ## _subimage(ACLContext *ctx, ACLglenum target,\
	 ACLvoid *dd, ACLint level, \
	 ACLint xoffset, ACLint yoffset, ACLint width, ACLint height, \
	 ACLint internalFormat, ACLTexImage image);



#define NEW_TEXMAN \
FSCOPE ACLTexAddress acl_ ## shortex ## _tex_get_min_memaddr(ACLContext); \
\
FSCOPE ACLTexAddress acl_ ## shortex ## _tex_get_max_memaddr(ACLContext); \
\
FSCOPE ACLuint	acl_ ## shortex ## _tex_required_mem(ACLContext, \
			ACLTexImage tex);
