
/* ACL API, Accellerated Library Application Interface */
/* (C) SuSE GmbH, 1997, 1998 */
/* Authors: David Bucciarelli, Simon Pogarcic, Alexander Stohr */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/******************************************************************************
 ******************************************************************************
         THIS INCLUDE FILE IS AUTOMATICLY GENERATED FROM aclapi.pl FILE !
        IF YOU WANT TO MAKE SOME PERMANENT CHANGES, PLEASE EDIT aclapi.pl,
         SET PERMISSIONS TO +x OF aclapi.pl (IF NOT ALREADY) AND RUN IT.
 ******************************************************************************
 ******************************************************************************/

/*
 * Handling of Mesa sources dependency:
 *     Put in your application '#define _ACL_MESA_'
 *     before including aclapi.h
 */

/*
 * Handling of OpenGL data types dependency
 *     Put in your application '#define _ACL_OPENGL_'
 *     before including aclapi.h
 */



#ifndef _ACLAPI_H_
#define _ACLAPI_H_

#define _ACL_API_VERSION_STRING_	"v2.00"
#define _ACL_API_AUTHORS_STRING_ \
	"David Bucciarelli, Simon Pogarcic, Alexander Stohr"



#ifdef _ACL_OPENGL_

    #include "GL/gl.h"

    #define ACLbyte		GLbyte
    #define ACLubyte		GLubyte

    #define ACLshort		GLshort
    #define ACLushort		GLushort

    #define ACLint		GLint
    #define ACLuint		GLuint

    #define ACLfloat		GLfloat
    #define ACLdouble		GLdouble
    #define ACLvoid		GLvoid
    #define ACLbool		GLboolean

    #define ACLclampf		GLclampf
    #define ACLclampd		GLclampd

    #define ACLsizei		GLsizei
    #define ACLglenum		GLenum

    #define ACLbitfield		GLbitfield

#else

    typedef char		ACLbyte;
    typedef unsigned char	ACLubyte;
    
    typedef short		ACLshort;
    typedef unsigned short	ACLushort;
    
    typedef int			ACLint;
    typedef unsigned int	ACLuint;
    
    typedef float		ACLfloat;
    typedef double		ACLdouble;
    typedef void		ACLvoid;
    typedef unsigned char	ACLbool;

    typedef float		ACLclampf;
    typedef double		ACLclampd;

    typedef int			ACLsizei;

    typedef enum {
	GL_FALSE = 		0,
	GL_TRUE =		1,

	GL_FRONT =		0x0404,
	GL_BACK =		0x0405,
	GL_FRONT_AND_BACK = 	0x0408,

	GL_COLOR_BUFFER_BIT =	0x00004000,
	GL_DEPTH_BUFFER_BIT =	0x00000100,

        GL_NEVER =		0x0200,
        GL_LESS =		0x0201,
        GL_GEQUAL =		0x0206,
        GL_LEQUAL =		0x0203,
        GL_GREATER =		0x0204,
        GL_NOTEQUAL =		0x0205,
        GL_EQUAL =		0x0202,
        GL_ALWAYS =		0x0207
    } ACLglenum;

    typedef unsigned int 	ACLbitfield;

#endif



typedef ACLuint			ACLTexAddress;
typedef unsigned int *		ACLPointer;



typedef enum {

/*
 * All supported drivers are enumerated here. These enums
 * are used by Query function. The library which implements ACL
 * API uses those enums to init the proper driver for client.
 * However, more generic access won't be bad.
 */
	ACL_DRIVER_NONE =	0x0,
	ACL_DRIVER_TXMX =	0x1,
	ACL_DRIVER_PM =		0x2,
	ACL_DRIVER_PM2 =	0x3,
	/**************************/
	ACL_DRIVER_LAST =	0x3,	/* keep it always up-to-date! */

/*
 * How to connect to a particular hardware and driver could be
 * specified with the folowing enums. The _FIRST and _LAST would
 * return the first or last registered resource of specified group.
 * Analoguos, _PREV and _NEXT would return previous and next hw
 * resource within currently used group.
 */
	ACL_GET_FIRST =		0x1,
	ACL_GET_LAST =		0x2,
	ACL_GET_PREV =		0x3,
	ACL_GET_NEXT =		0x4,

/*
 * The folowing defines are used for setting of ACLContext->Flags
 */
	ACL_RENDER_FLAT =	0,
	ACL_SWAP_BITBLT = 	0,

	ACL_RENDER_TWOSIDE =	0x00000001,
	ACL_RENDER_SMOOTH =	0x00000002,
	ACL_RENDER_TEX =	0x00000004,
	ACL_SWAP_SCREEN =	0x00000008,
	ACL_SWAP_PIXDEPTH =	0x00000010,
	ACL_QUAKE_HACK =	0x00000020,

/*
 * Which rendering modules are supported ? (for acl_modules.ModFlags)
 */
	ACL_MODULE_NONE =	0,
	ACL_MODULE_ACCEL =	0x00000001,
	ACL_MODULE_DEPTH =	0x00000002,
	ACL_MODULE_TEX =	0x00000004

} ACLenum;



typedef struct acl_color_mod 		*ACLColorMod;
typedef struct acl_accel_mod 		*ACLAccelMod;
typedef struct acl_depth_mod 		*ACLDepthMod;
typedef struct acl_tex_mod 		*ACLTexMod;

typedef struct acl_modules 		*ACLModules;

typedef struct acl_setup		*ACLSetup;

typedef struct acl_context 		*ACLContext;




#ifdef _ACL_MESA_

    #include "vb.h"
    #include "ACL/aclApiDrv.h"

    #define acl_hyper_context		GLcontext
    #define ACLHyperContext		GLcontext*

    #define acl_visual			GLvisual
    #define ACLVisual			GLvisual*

    #define acl_frame_buffer		GLframebuffer
    #define ACLFramebuffer		GLframebuffer*

    #define acl_vertex_buffer		struct vertex_buffer
    #define ACLVertexBuffer		struct vertex_buffer*

    #define acl_tex_image		struct gl_texture_image
    typedef struct gl_texture_image	*ACLTexImage;

    #define aclTexmanCtx		taclTexManagerCtx

#else

/* Set here the size of vertex buffer: */
    #define VB_SIZE			0xff
    #define MAX_TEX_SETS		2

    typedef struct acl_hyper_context	*ACLHyperContext;
    typedef struct acl_visual		*ACLVisual;
    typedef struct acl_frame_buffer	*ACLFramebuffer;
    typedef struct acl_vertex_buffer	*ACLVertexBuffer;

    typedef struct acl_tex_image	*ACLTexImage;

    typedef struct acl_texman_ctx	aclTexmanCtx;


typedef struct acl_vertex_buffer {
	ACLfloat Win[VB_SIZE][3];		/* Window coords */
	ACLubyte Fcolor[VB_SIZE][4];		/* Front colors (RGBA) */
	ACLubyte Bcolor[VB_SIZE][4];		/* Back colors (RGBA) */
	ACLubyte (*Color)[4];			/* == Fcolor or Bcolor */
	ACLfloat (*TexCoord)[4];
	ACLfloat MultiTexCoord[MAX_TEX_SETS][VB_SIZE][4];
} acl_vertex_buffer;



typedef struct acl_visual {
	ACLbool RGBAflag;
	ACLbool DBflag;
	ACLbool StereoFlag;
	ACLint RedBits;
	ACLint GreenBits;
	ACLint BlueBits;
	ACLint AlphaBits;
	ACLint IndexBits;
	ACLint AccumBits;
	ACLint DepthBits;
	ACLint StencilBits;
	ACLbool FrontAlphaEnabled;
	ACLbool BackAlphaEnabled;
} acl_visual;



typedef struct acl_frame_buffer {
	ACLVisual Visual;
	ACLint Width;
	ACLint Height;
#if 0
	ACLDepth Depth;
	ACLStencil Stencil;
	ACLAccum Accum;
#endif
	ACLubyte *FrontAlpha;
	ACLubyte *BackAlpha;
	ACLubyte *Alpha;
	ACLint Xmin, Xmax, Ymin, Ymax;
} acl_frame_buffer;



typedef struct acl_tex_image {
	ACLuint Border;
	ACLuint Width;
	ACLuint Height;
	ACLuint Depth;
	ACLuint Width2;
	ACLuint Height2;
	ACLuint Depth2;
	ACLuint WidthLog2;
	ACLuint HeightLog2;
	ACLuint DepthLog2;
	ACLuint MaxLog2;
	ACLubyte *Data;

	void *DriverData;

} acl_tex_image;



typedef struct acl_texman_ctx {
    	ACLuint	CURRENTLY_NOTHING;
} acl_texman_ctx;




typedef struct acl_hyper_context {
	ACLVisual Visual;
	ACLContext DriverCtx;
	ACLVertexBuffer VB;
} acl_hyper_context;

#endif /* _ACL_MESA_ */



typedef struct acl_color_mod {

    ACLvoid (*Index)
	( ACLContext ctx,
	  ACLuint index );

    ACLvoid (* Color)
	( ACLContext ctx,
	  ACLubyte red, ACLubyte green, ACLubyte blue, ACLubyte alpha );

    ACLvoid (* WriteRGBASpan)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x, ACLint y,
	  const ACLubyte rgba[][4], const ACLubyte mask[]);


/*
  GLuint (* WriteRGBADSpanGeneric)(GLcontext *ctx,
				       GLuint n, GLint x, GLint y, const GLdepth z[],
				       GLubyte mask[]);
*/
    ACLuint (* WriteRGBADSpanGeneric)(ACLHyperContext ctx,
				       ACLuint n, ACLint x, ACLint y, const GLdepth z[],
				       ACLubyte mask[]);


   ACLvoid (* WriteRGBADPixelsGeneric)(ACLHyperContext ctx,
				       ACLuint n, const ACLint x[], const ACLint y[],
				       const GLdepth z[], ACLubyte mask[]);

    ACLvoid (* WriteRGBSpan)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x, ACLint y,
	  const ACLubyte rgb[][3], const ACLubyte mask[] );

    ACLvoid (* WriteMonoRGBASpan)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x, ACLint y, const ACLubyte mask[] );

    ACLvoid (* WriteCI32Span)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x, ACLint y, ACLuint index[]);

    ACLvoid (* ReadRGBASpan)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x, ACLint y, ACLubyte rgba[][4] );

    ACLvoid (* ReadCI32Span)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x, ACLint y, ACLuint index[] );

    ACLvoid (* WriteRGBAPixels)
	( const ACLHyperContext hctx,
	  ACLuint n, const ACLint x[], const ACLint y[],
	  const ACLubyte rgba[][4], const ACLubyte mask[] );

    ACLvoid (* WriteMonoRGBAPixels)
	( const ACLHyperContext hctx,
	  ACLuint n, const ACLint x[], const ACLint y[], const ACLubyte mask[]);

    ACLvoid (* WriteCI32Pixels)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x[], ACLint y[], ACLuint index[], ACLubyte mask[] );

    ACLvoid (* ReadRGBAPixels)
	( const ACLHyperContext hctx,
	  ACLuint n, const ACLint x[], const ACLint y[],
	  ACLubyte rgba[][4], const ACLubyte mask[] );

    ACLvoid (* ReadCI32Pixels)
	( const ACLHyperContext hctx,
	  ACLuint n, ACLint x[], ACLint y[], ACLuint index[], ACLubyte mask[] );

} acl_color_mod;



typedef struct acl_accel_mod {

    ACLvoid (* UpdateFuncPointers)
	( ACLContext ctx );

    ACLvoid (* ClearIndex)
	( ACLContext ctx, ACLuint index );

    ACLvoid (* ClearColor)
	( ACLContext ctx,
	  ACLubyte red, ACLubyte green, ACLubyte blue, ACLubyte alpha );

    ACLbitfield (*Clear)
	( ACLHyperContext hctx,
	  ACLbitfield mask, ACLbool all,
	  ACLint x, ACLint y, ACLint width, ACLint height );

    ACLvoid (*SetLogOp)(ACLContext aclctx, 
          ACLbool enable, ACLint logop);


   ACLvoid (*SetDither)(ACLContext aclctx, ACLbool enable, 
				  ACLbool modeline);

   ACLvoid (*SetAlpha)(ACLContext , ACLbool , ACLint , ACLint );

   ACLvoid (*SetBlend)(ACLContext , ACLbool , ACLint , ACLint );


   ACLvoid (*SetFog)(ACLContext aclctx,
	ACLbool enable, ACLint mode, ACLfloat density,
	ACLfloat r, ACLfloat g, ACLfloat b, ACLfloat a);

    ACLvoid (* Points)
	( ACLHyperContext hctx,
	  ACLuint first, ACLuint last);

    ACLvoid (* Line)
	( ACLHyperContext hctx,
	  ACLuint v1, ACLuint v2,  ACLuint pv);
  
    ACLvoid (* Triangle)
	( ACLHyperContext hctx,
	  ACLuint v1, ACLuint v2, ACLuint v3, ACLuint pv);

    ACLvoid (* Quad)
	( ACLHyperContext hctx,
	  ACLuint v1, ACLuint v2, ACLuint v3, ACLuint v4, ACLuint pv);

} acl_accel_mod;



typedef struct acl_depth_mod {

    ACLvoid (* UpdateFuncPointers)
	( ACLContext ctx );

    ACLvoid  (* Enabled)
	( ACLContext ctx,
	  ACLbool state);

    ACLvoid (* ClearDepth)
	( ACLContext ctx,
	  ACLfloat depth );

    ACLvoid (* Func)
	( ACLContext ctx,
	  ACLglenum func );

    ACLvoid (* Mask)
	( ACLContext ctx,
	  ACLbool mask );

    ACLvoid (* Range)
	( ACLContext ctx,
	  ACLclampd near, ACLclampd far );

    ACLvoid (*ReadSpan)
	( ACLContext ctx,
	  ACLuint n, ACLint x, ACLint y, ACLfloat depth[] );

    ACLvoid (*WriteSpan)
	( ACLContext ctx,
	  ACLuint n, ACLint x, ACLint y, ACLfloat depth[] );

    ACLuint (*DepthTestSpan)
	( ACLContext ctx,
	  ACLuint n, ACLint x, ACLint y, ACLfloat z[], ACLubyte mask[] );

    ACLvoid (*DepthTestPixels)
	( ACLContext ctx,
	  ACLuint n, ACLint x[], ACLint y[], ACLfloat z[], ACLubyte mask[] );

  ACLvoid (*ClearStencil)(ACLContext aclctx, ACLint s);


  ACLvoid (*StencilFunc)(ACLContext aclctx, ACLenum func, 
				    ACLint ref, ACLuint mask);


  ACLvoid (*StencilOp)(ACLContext aclctx, ACLenum fail, ACLenum zfail, ACLenum zpass);


  ACLvoid (*StencilEnable)(ACLContext aclctx, ACLbool enable);

} acl_depth_mod;



typedef struct acl_tex_mod {

    ACLvoid (* UpdateFuncPointers)
	( ACLContext ctx );

    ACLvoid  (* Enabled)
	( ACLContext ctx,
	  ACLbool state);



    ACLbool (* TranslateImage)
	( ACLContext ctx,
	  ACLTexImage tex, ACLint format, ACLint level, ACLuint name, 
          ACLvoid *dd);

    ACLvoid (* SubImage)
       ( ACLContext * ctx, ACLenum target,
	 ACLvoid *dd, ACLint level,
	 ACLint xoffset, ACLint yoffset, ACLint width, ACLint height,
	 ACLint internalFormat, ACLTexImage image);

    ACLvoid (* DownloadToTexMem)
	( ACLContext ctx,
	  ACLint level, ACLvoid * dd);

    ACLvoid (* Bind)
	( ACLContext ctx, ACLuint name, 
	  ACLvoid * dd );

    ACLbool (* Env)
	( ACLContext ctx,
	  ACLglenum pname, const ACLfloat *param );

    ACLvoid (* Param)
	( ACLContext ctx,
	  ACLglenum target, ACLglenum pname, 
	  const ACLfloat *param, ACLvoid *dd);

    ACLvoid * (* TexDel)
	( ACLContext ctx,
	  ACLvoid * dd );

   ACLvoid * (* AllocTexObjData)
   	( ACLContext ctx );

    ACLvoid (* Palette)
         (ACLContext aclctx, ACLuint size, ACLuint * data, ACLvoid *dd);


   ACLvoid (*SwitchToGlobalPalette)
         (ACLContext aclctx);


   ACLvoid (*DownloadGlobalPalette)
         (ACLContext aclctx, ACLuint size, ACLuint * data, ACLvoid *dd);

} acl_tex_mod;



typedef struct acl_modules {

/* The flags about presence of different modules (max 32) */
    ACLuint ModFlags;

/* For the color buffer (NOT OPTIONAL) */
    struct acl_color_mod Color;

/* For the accelerated rendering of primitives (optional, can be NULL) */
    ACLAccelMod Accel;

/* For the depth buffer (optional, can be NULL) */
    ACLDepthMod Depth;

/* Texturing */
    ACLTexMod Tex;

/******************************************
 * The folowing functions are obligatory: *
 ******************************************/
/* has to be called before any rendering, for screen setup */
    ACLint (*InitClient)
	( ACLContext, ACLSetup );

/* after rendering finished, this should return screen in default state */
    ACLvoid (*ExitClient)
	( ACLContext );

/* swaps rendering buffers */
    ACLvoid (*SwapBuffer)
	( ACLContext );

/* sets current rendering buffer */
    ACLbool (*DrawBuffer)
	( ACLContext, ACLglenum buffer );

} acl_modules;



typedef struct acl_setup {
/* visible screen area */
    ACLuint VisibleWidth;
    ACLuint VisibleHeight;

/* virtual screen area */
    ACLuint VirtualWidth;
    ACLuint VirtualHeight;

/* color depth */
    ACLubyte ScreenBpp;
} acl_setup;



typedef struct acl_context {

/***********************************************************
 * Common hw information about current accelerated context *
 ***********************************************************/
/* The card/driver currently used */
    ACLint drvidx;

/* The modules bound to the driver context */
    ACLModules	mod;

/**************************
 * Rendering informations *
 **************************/
/* ACL_RENDER_TWOSIDE, ACL_RENDER_SMOOTH, ACL_RENDER_TEX */
    ACLuint Flags;

/****************************************************************
 * Other informations needed by core renderer / Mesa compatible *
 ****************************************************************/
/* the core context */
    ACLHyperContext hctx;

/* describes the color buffer */
    ACLVisual vis;

/* the ancillary buffers */
    ACLFramebuffer buff;

/* context of texture manager */
    aclTexmanCtx tmCtx;
    
/* other data */
    ACLuint clearColor, currentColor;

    ACLint width, height;

    ACLbool haveDoubleBuffer;

/* the current TexEnv() settings are supported ? */
    ACLbool isTexEnvHWSupported;
} acl_context;



ACLint		AclEnter
		    ( ACLvoid );

ACLint		AclQueryCard
		    ( ACLint drvidx, ACLenum hw, ACLenum position );

ACLContext	AclCreateContext
		    ( ACLint drvidx );

ACLvoid		AclExit
		    ( ACLContext aclctx );



#endif

