
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "demo.h"



ACLHyperContext	Hyperctx;
ACLSetup	HwSetup;



void demoTestColor( ACLContext aclctx )
{
    ACLModules mod = aclctx->mod;
    ACLAccelMod accmod = mod->Accel;
    ACLDepthMod depthmod = mod->Depth;

    acl_vertex_buffer vdata;
    int cnt;

    MSG("### TestColor (start)\n");

    vdata.Color = vdata.Fcolor;
    Hyperctx->VB = &vdata;


    mod->DrawBuffer(aclctx, GL_FRONT);
    depthmod->Enabled(aclctx, GL_FALSE);
    depthmod->Func(aclctx, GL_ALWAYS);

    /* triangle 1 */
    cnt = 0;
    vdata.Win[0][0] = 0;
    vdata.Win[0][1] = 0;
    vdata.Win[1][0] = 500;
    vdata.Win[1][1] = 0;
    vdata.Win[2][0] = 250;
    vdata.Win[2][1] = 500;

    /* depth values */
    vdata.Win[0][2] = 0x0; 
    vdata.Win[1][2] = 0x0;
    vdata.Win[2][2] = 0x0;

    accmod->ClearColor(aclctx, 255, 0, 0, 0);
    accmod->Clear(Hyperctx, GL_COLOR_BUFFER_BIT, GL_TRUE, 0,0,0,0);

    for (cnt=0; cnt < 256; cnt++) {
	vdata.Fcolor[0][0]=vdata.Fcolor[1][0]=vdata.Fcolor[2][0]=0;
	vdata.Fcolor[0][1]=vdata.Fcolor[1][1]=vdata.Fcolor[2][1]=cnt;
	vdata.Fcolor[0][2]=vdata.Fcolor[1][2]=vdata.Fcolor[2][2]=0;
	vdata.Fcolor[0][3]=vdata.Fcolor[1][3]=vdata.Fcolor[2][3]=0;
	accmod->Triangle( Hyperctx, 0, 1, 2, 0 );
    }


    /* triangle 2 */
    cnt = 255; 
    vdata.Win[3][0] = 250;
    vdata.Win[3][1] = 500;
    vdata.Win[4][0] = 750;
    vdata.Win[4][1] = 500;
    vdata.Win[5][0] = 500;
    vdata.Win[5][1] = 0;
    vdata.Fcolor[3][0]=vdata.Fcolor[4][0]=vdata.Fcolor[5][0]=cnt;
    vdata.Fcolor[3][1]=vdata.Fcolor[4][1]=vdata.Fcolor[5][1]=cnt;
    vdata.Fcolor[3][2]=vdata.Fcolor[4][2]=vdata.Fcolor[5][2]=cnt;
    vdata.Fcolor[3][3]=vdata.Fcolor[4][3]=vdata.Fcolor[5][3]=0;

    /* depth values */
    vdata.Win[3][2] = 0x0; 
    vdata.Win[4][2] = 0x0;
    vdata.Win[5][2] = 0x0;

    accmod->Triangle( Hyperctx, 3, 4, 5, 0 );

}



void demoTestDepth( ACLContext aclctx )
{
    ACLModules mod = aclctx->mod;
    ACLAccelMod accmod = mod->Accel;
    ACLDepthMod depthmod = mod->Depth;

    acl_vertex_buffer vdata;

    MSG("### TestDepth (start)\n");

    depthmod->Enabled(aclctx, GL_TRUE);

    mod->DrawBuffer(aclctx, GL_FRONT);
    accmod->ClearColor(aclctx, 0, 0, 128, 0);
    depthmod->ClearDepth(aclctx, 1.0);

    accmod->Clear(Hyperctx, GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT,
			 GL_TRUE, 0, 0, 0, 0);

    vdata.Color = vdata.Fcolor;
    Hyperctx->VB = &vdata;

    /* triangle 1 */
    vdata.Win[0][0] = 0;
    vdata.Win[0][1] = 0;
    vdata.Win[1][0] = 500;
    vdata.Win[1][1] = 0;
    vdata.Win[2][0] = 250;
    vdata.Win[2][1] = 500;
    vdata.Fcolor[0][0]=vdata.Fcolor[1][0]=vdata.Fcolor[2][0]=0;
    vdata.Fcolor[0][1]=vdata.Fcolor[1][1]=vdata.Fcolor[2][1]=0;
    vdata.Fcolor[0][2]=vdata.Fcolor[1][2]=vdata.Fcolor[2][2]=255;
    vdata.Fcolor[0][3]=vdata.Fcolor[1][3]=vdata.Fcolor[2][3]=0;

    /* depth values */
    vdata.Win[0][2] = 0x7fff; 
    vdata.Win[1][2] = 0x7fff;
    vdata.Win[2][2] = 0x0;



    /* triangle 2 */ 
    vdata.Win[3][0] = 0;
    vdata.Win[3][1] = 500;
    vdata.Win[4][0] = 500;
    vdata.Win[4][1] = 500;
    vdata.Win[5][0] = 250;
    vdata.Win[5][1] = 0;
    vdata.Fcolor[3][0]=vdata.Fcolor[4][0]=vdata.Fcolor[5][0]=0;
    vdata.Fcolor[3][1]=vdata.Fcolor[4][1]=vdata.Fcolor[5][1]=255;
    vdata.Fcolor[3][2]=vdata.Fcolor[4][2]=vdata.Fcolor[5][2]=0;
    vdata.Fcolor[3][3]=vdata.Fcolor[4][3]=vdata.Fcolor[5][3]=0;

    /* depth values */
    vdata.Win[3][2] = 0xffff; 
    vdata.Win[4][2] = 0xffff;
    vdata.Win[5][2] = 0x0;

    depthmod->Mask(aclctx, GL_TRUE);
    depthmod->Func(aclctx, GL_LESS);

    accmod->Triangle(Hyperctx, 0, 1, 2, 0 );

    depthmod->Func(aclctx, GL_LESS);

    accmod->Triangle(Hyperctx, 3, 4, 5, 0 );
}



ACLvoid demoTest ( ACLvoid )
{
    ACLContext aclctx;
    ACLModules mod;
    ACLint drvidx;

    acl_setup		setup;
    acl_visual		vinfo;
    acl_hyper_context	hctx;

TON
    drvidx = AclQueryCard(-1, ACL_DRIVER_PM2, ACL_GET_FIRST );

    if (drvidx == -1) {
        AclExit( NULL );
	return;
    }
    else
        aclctx = AclCreateContext(drvidx);

    aclctx->hctx = &hctx;
    aclctx->vis = &vinfo;
    aclctx->width = 800;
    aclctx->height = 600;
    aclctx->Flags = 0;

/*
 * set visual data:
 */
    vinfo.RGBAflag = GL_TRUE;
    vinfo.DBflag = GL_FALSE;
    vinfo.StereoFlag = GL_FALSE;

    vinfo.RedBits = 5;
    vinfo.GreenBits = 5;
    vinfo.BlueBits = 5;
    vinfo.AlphaBits = 0;
    
    vinfo.DepthBits = 16;
    vinfo.StencilBits = 0;

    vinfo.IndexBits = 0;
    vinfo.AccumBits = 0;

    vinfo.FrontAlphaEnabled = vinfo.BackAlphaEnabled = GL_FALSE;

    HwSetup = &setup;
    Hyperctx = &hctx;
    Hyperctx->Visual = &vinfo;
    Hyperctx->DriverCtx = aclctx;

    mod = aclctx->mod;

#if 1
    HwSetup->VisibleWidth = 800;
    HwSetup->VisibleHeight = 600;
    HwSetup->VirtualWidth = 800;
    HwSetup->VirtualHeight = 600;
    HwSetup->ScreenBpp = 16;
#else
    XinfoInitVidModes( Display *dpy, aclctx->width, aclctx->height)
#endif

LOG("%d %d\n", aclctx->width, aclctx->height);

    mod->InitClient( aclctx, HwSetup );

LOG("%d %d\n", aclctx->width, aclctx->height);

    demoTestColor( aclctx );
    demoTestDepth( aclctx );

    mod->ExitClient( aclctx );

#if 0
    XinfoSetDefaultVidModes();
#endif

}



void main( void )
{
    if ( AclEnter() ) {
	AclExit( NULL );
	return;
    }

    demoTest();

    AclExit( NULL );
}
