
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* Author: simon pogarcic, sim@suse.de */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <linux/pci.h>
#include <stdlib.h>

#if 0
#define LOG_DEBUG
#endif

#define LOG_DBGINFO "<MLXagent/glintdrv>: "
#include "log_debug.h"

#include "mlx.h"
#include "glint/glintmacros.h"


#define PMMemConfig			0x10C0
#define FBMemoryCtl			0x1800
#define LBMemoryCtl			0x1000
#define PMRomControl			0x1040
#define ChipConfig			0x0070



extern int			glintIBMRGB_Probe();
extern volatile ACLPointer	GLINTMMIOBase;


/*
 * Supported RAMDACs
 */
static char *RamDac[] = {
	_RD_UNKNOWN,
	_RD_IBM_526DB,
	_RD_IBM_526,
	_RD_IBM_524,
	_RD_IBM_624,
	_RD_IBM_640
};



/************************
 * 500TX/MX driver info *
 ************************/
#if 0
extern ACLvoid TXMX_InitACLAPI();
#endif
ACLubyte txmxmsg[] = "<TXMX>: ";
ACLubyte txmxinfo[] = "GLINT 500TX/MX/Delta OpenGL/Mesa Driver";
MLXDriverRec txmx_driver = {
	ACL_DRIVER_TXMX, txmxmsg, txmxinfo, NULL, /* TXMX_InitACLAPI, */
	ACL_MODULE_ACCEL | ACL_MODULE_DEPTH
};

/************************
 * Permedia driver info *
 ************************/
#if 0
extern ACLvoid PM_InitACLAPI();
#endif
ACLubyte pmmsg[] = "<PM>: ";
ACLubyte pminfo[] = "PERMEDIA/Delta OpenGL/Mesa Driver";
MLXDriverRec pm_driver = {
	ACL_DRIVER_PM, pmmsg, pminfo, NULL, /* PM_InitACLAPI, */
	ACL_MODULE_NONE
};

/**************************
 * Permedia 2 driver info *
 **************************/
extern ACLvoid PM2_InitACLAPI();
ACLubyte pm2msg[] = "<PM2>: ";
ACLubyte pm2info[] = "PERMEDIA 2 OpenGL/Mesa Driver";
MLXDriverRec pm2_driver = {
	ACL_DRIVER_PM2, pm2msg, pm2info, PM2_InitACLAPI,
	ACL_MODULE_ACCEL | ACL_MODULE_DEPTH | ACL_MODULE_TEX
};



/*****************************************************************************
 *****************************************************************************/

ACLint 
mlx_glint_init( ACLvoid )
{
    Tulong base_fb, size_fb, base_lb, size_lb;
    volatile ACLPointer MMIOBASE;
    ACLuint ramdac_idx = 0, type, cardnr;
    ACLint tmp = 0, notfound = 1, ibm_id;
    ACLbool VGAcore;

    GPMCardInfo_t *mcard;
    GPMCard_t *scard;

    GPMPciParam_t pciparam = {
	0, {
	 { PCI_COMMAND, SIZE_BYTE, 
	   PCI_COMMAND_IO | PCI_COMMAND_MEMORY | PCI_COMMAND_MASTER,
	   0, FALSE
	 },
	 { PCI_COMMAND, SIZE_BYTE, 
	   PCI_COMMAND_IO | PCI_COMMAND_MEMORY | PCI_COMMAND_MASTER,
	   0, FALSE
	 },
	}
    };

    MLXDriverRecPtr driver;
    MLXDriverCtxPtr drvctx;
    MLXDriverCtxPtr lastdrvctx;

    for (cardnr = 0; cardnr < GpcliCardsFound; cardnr++) {

	mcard = GpcliCardsInfo + cardnr;
	scard = GpcliSupportedCards + mcard->idx;
	type = scard->chip_type[0];
	base_fb = size_fb = base_lb = size_lb = 0;

	if (!IS_CHIP_FAMILY_GLINT(type))
	    continue;

	if(mcard->error)
	    continue;

	switch (type) {
	case CHIP_CLASS_500TX:
	case CHIP_CLASS_MX:
	    driver = &txmx_driver;
	    break;
	case CHIP_CLASS_PERMEDIA:
	    driver = &pm_driver;
	    break;
	case CHIP_CLASS_PERMEDIA2:
	    driver = &pm2_driver;
	    break;
	default:
	    continue;
	}

	MSG("### Init card #%d: %s\n", cardnr, scard->name);

	if( !(drvctx = (MLXDriverCtxPtr) malloc ( sizeof(MLXDriverCtx) )) ) {
	    ERR("mlx_glint_init(): malloc() MLXDriverCtx\n");
	    return 1;
	}

	/*
	 * mmap the card's register file (MMIO)
	 */

	if (IS_CHIP_FAMILY_TXMX(type) || IS_CHIP_CLASS_PM(type)) {

	    MSG("    Mapping Graphic Core control region:\n");
	    drvctx->mapCTL0 =
	        gpcli_mmap_pcidev(BASE_0, cardnr, 0);

	    MSG("    Mapping Delta control region:\n");
	    drvctx->mapCTL = drvctx->mapCTL1 =
	    	gpcli_mmap_pcidev(BASE_0, cardnr, 1);
	}

	else if (IS_CHIP_CLASS_PM2(type)) {

	    MSG("    Mapping Permedia 2 control region:\n");
	    drvctx->mapCTL = drvctx->mapCTL0 =
	    	gpcli_mmap_pcidev(BASE_0, cardnr, 0);
	}

	if ( !(GLINTMMIOBase = MMIOBASE = drvctx->mapCTL) )
	    continue;

/*
	drvctx->mapStartDMA = MMIOBASE + ???????????;
	drvctx->mapCountDMA = MMIOBASE + ???????????;
*/

	/*
	 * Before init, enable IO and memory of the card(s);
	 * we expect maximal two devices (something + maybe Delta)
	 */
	pciparam.Icardnr = cardnr;

#if 0
	gpcli_set_pciconfig( &pciparam );
#endif

	if (IS_CHIP_FAMILY_PM(type)) {
	    base_fb = mcard->cd[0].PCIBase[1].base;
	    tmp = REG_READ(PMMemConfig);
	    size_fb = PMFBSize(tmp);
	    MSG("    FB at 0x%lx; RAM: %ldk\n", base_fb, size_fb/1024 );
	}
	else if (IS_CHIP_FAMILY_TXMX(type)) {
	    base_fb = mcard->cd[0].PCIBase[1].base;
	    base_lb = mcard->cd[0].PCIBase[2].base;
	    tmp = REG_READ(FBMemoryCtl);
	    size_fb = TXFBSize(tmp);
	    tmp = REG_READ(LBMemoryCtl);
	    size_lb = TXLBSize(tmp);
	    MSG("    FB at 0x%lx; RAM: %ldk\n", base_fb, size_fb/1024 );
	    MSG("    LB at 0x%lx; RAM: %ldk\n", base_lb, size_lb/1024 );
	}

	if (IS_CHIP_FAMILY_TXMX(type) || IS_CHIP_CLASS_PM(type)) {
	    ibm_id = glintIBMRGB_Probe();
	    if (ibm_id) {
		switch (ibm_id) {
		case 0x280:
		    ramdac_idx = RD_IBM_526DB;
		    break;
		case 0x2C0:
		    ramdac_idx = RD_IBM_526;
		    break;
		case 0x2F0:
		case 0x2E0:
		    ramdac_idx = RD_IBM_524;
		    break;
		case 0x30C0:
		    ramdac_idx = RD_IBM_624;
		    break;
		case 0x121C:
		    ramdac_idx = RD_IBM_640;
		    break;
		default:
		    ramdac_idx = RD_UNKNOWN;
		}

		MSG("    Found %s RAMDAC, id: 0x%x\n",
			RamDac[ramdac_idx], ibm_id);
	    }

	    else {
		MSG(" ### FAILED! ### (Unsupported RAMDAC)\n");
		continue;
	    }
	}

	else if (IS_CHIP_CLASS_PM2(type))
	    MSG("    Using built-in RAMDAC chip\n");

	if (IS_CHIP_FAMILY_PM(type)) {
	    MSG("    Fitted Memory type is : %s\n",
		   REG_READ(PMRomControl) & 0x10 ? "SDRAM" : "SGRAM");

	    if (REG_READ(ChipConfig) & 0x2)
		VGAcore = TRUE;
	    else
		VGAcore = FALSE;

	    MSG("    VGA core is %s\n", VGAcore ? "ENABLED" : "DISABLED");

	}

	/*
	 * Now register driver for hardware found...
	 */
	drvctx->hw = driver->hw;
	drvctx->drv = driver;

	drvctx->tween_idx = 0;
	drvctx->card_idx = cardnr;
	drvctx->card_slot = mcard->slot;
	drvctx->card_info = (ACLbyte *) scard->name;

	drvctx->VidMemSize = size_fb;

	drvctx->screen_set = FALSE;
	drvctx->hwaccess_set = TRUE;

	drvctx->next = NULL;
	drvctx->prev = NULL;

	/*
	 * update double linked drivers list
	 */
	lastdrvctx = mlx_search_driver( driver->hw, ACL_GET_LAST );
	if (lastdrvctx) {
	    MLXDriverCtxPtr nextdrvctx = lastdrvctx->next;

	    drvctx->next = nextdrvctx;
	    drvctx->prev = lastdrvctx;
	    if (nextdrvctx)
		nextdrvctx->prev = drvctx;
	    lastdrvctx->next = drvctx;
	    if (lastdrvctx->hw == drvctx->hw)
		drvctx->tween_idx = lastdrvctx->tween_idx + 1;
	}
	else
	    MLXfirstdrvctx = drvctx;

	MLXdriverctx[cardnr] = drvctx;
	notfound = 0;
    }

    MSG("\n");

    return notfound;
}

