/* -*- mode: C; tab-width:8;  -*-

	aclApiDrv.h - driver types used in mesa dependent ACL API
*/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclApi.c for more informations about authors
 *
 */

#ifndef ACLAPIDRV_H
#define ACLAPIDRV_H


/*
 * List of free blocks in the texture memory
 */

typedef struct taclTMFreeListNode {
  struct taclTMFreeListNode *next;
  ACLTexAddress startAddress, endAddress;
} taclTMFreeNode;


/*
 * List of used blocks in the texture memory
 */

typedef struct taclTMAllocListNode {
  struct taclTMAllocListNode *next;
  ACLTexAddress startAddress, endAddress;
  struct gl_texture_object *tObj;
} taclTMAllocNode;


/*
 * The texture memory manager is able
 * to collect some useful statistics
 */

typedef struct {
  GLuint reqTexUpload;
  GLuint texUpload;
  GLuint memTexUpload;
} taclTexStats;


/*
 * The texture memory manager context
 * stores all the information for using
 * the texture memory as a cache;
 */

typedef struct {
  GLuint bindNumber;
  GLuint freeMem;
  taclTMFreeNode *freeBlocks;
  taclTMAllocNode *allocBlocks;

  taclTexStats stats;

} taclTexManagerCtx;


/*
 * This structure is pointed gl_texture_object->DriverData
 * and includes several driver information related to the
 * to the texture object
 */

typedef struct {
  GLboolean isHWValidated;        /* the ACL library has checked if it
                                     is supported by the hardware */
  GLboolean isHWSupported;        /* it is supported by the hardware */
  GLboolean isInTM;               /* it is already in texture memory */

  GLuint lastTimeUsed;

  taclTMAllocNode *tm;            /* used block if in texture memory */
  unsigned char *translatedImage; /* the texture map translated in a format
                                     directly supported by the hardware */

  GLenum sClampMode;              /* GL_CLAMP or GL_REPEAT */
  GLenum tClampMode;              /* GL_CLAMP or GL_REPEAT */
  GLenum minFilterMode;           /* GL_NEAREST or GL_LINEAR */
  GLenum magFilterMode;           /* GL_NEAREST or GL_LINEAR */

  GLuint size;                    /* the size in bytes of the texture map */
} taclTexInfo;


#endif
