/* -*- mode: C; tab-width:8;  -*-

	aclmesa.h - ACL driver public declarations
*/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef ACLMESA_H
#define ACLMESA_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "ACL/aclapi.h"

#ifdef __cplusplus
extern "C" {
#endif



/*
 * This structure has the same function as 'attribs[]', for
 * information transfer to the hw context.
 */
typedef struct aclmesa_vis_attribs {
	GLboolean	is_rgba, is_db, is_stereo;
	GLint		r, g, b, a, i;
	GLint		accum, depth, stencil;
	GLboolean	is_frontalpha, is_backalpha;
} aclMesaVisAtr;



extern ACLContext APIENTRY
	aclMesaCreateContext (Display*, Window, GLint, GLint, aclMesaVisAtr*);

extern void APIENTRY
	aclMesaDestroyContext( ACLContext );

extern void APIENTRY
	aclMesaSwapBuffers( ACLContext );

extern void APIENTRY
	aclMesaMakeCurrent( ACLContext );

#ifdef __cplusplus
}
#endif

#endif
