/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGComponentTransferFunctionElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedNumberList.h"
#include "SVGComponentTransferFunctionElement.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGComponentTransferFunctionElement)

/* Hash table */

static const HashTableValue JSSVGComponentTransferFunctionElementTableValues[9] =
{
    { "type", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementType, (intptr_t)0 },
    { "tableValues", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementTableValues, (intptr_t)0 },
    { "slope", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSlope, (intptr_t)0 },
    { "intercept", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementIntercept, (intptr_t)0 },
    { "amplitude", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementAmplitude, (intptr_t)0 },
    { "exponent", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementExponent, (intptr_t)0 },
    { "offset", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementOffset, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGComponentTransferFunctionElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGComponentTransferFunctionElementTableValues, 0 };
#else
    { 19, 15, JSSVGComponentTransferFunctionElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGComponentTransferFunctionElementConstructorTableValues[7] =
{
    { "SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_IDENTITY, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_TABLE", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_TABLE, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_DISCRETE, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_LINEAR", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_LINEAR, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_GAMMA", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_GAMMA, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGComponentTransferFunctionElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGComponentTransferFunctionElementConstructorTableValues, 0 };
#else
    { 17, 15, JSSVGComponentTransferFunctionElementConstructorTableValues, 0 };
#endif

class JSSVGComponentTransferFunctionElementConstructor : public DOMObject {
public:
    JSSVGComponentTransferFunctionElementConstructor(ExecState* exec)
        : DOMObject(JSSVGComponentTransferFunctionElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGComponentTransferFunctionElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGComponentTransferFunctionElementConstructor::s_info = { "SVGComponentTransferFunctionElementConstructor", 0, &JSSVGComponentTransferFunctionElementConstructorTable, 0 };

bool JSSVGComponentTransferFunctionElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGComponentTransferFunctionElementConstructor, DOMObject>(exec, &JSSVGComponentTransferFunctionElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGComponentTransferFunctionElementPrototypeTableValues[7] =
{
    { "SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_IDENTITY, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_TABLE", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_TABLE, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_DISCRETE, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_LINEAR", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_LINEAR, (intptr_t)0 },
    { "SVG_FECOMPONENTTRANSFER_TYPE_GAMMA", DontDelete|ReadOnly, (intptr_t)jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_GAMMA, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGComponentTransferFunctionElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGComponentTransferFunctionElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGComponentTransferFunctionElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGComponentTransferFunctionElementPrototype::s_info = { "SVGComponentTransferFunctionElementPrototype", 0, &JSSVGComponentTransferFunctionElementPrototypeTable, 0 };

JSObject* JSSVGComponentTransferFunctionElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGComponentTransferFunctionElement>(exec, globalObject);
}

bool JSSVGComponentTransferFunctionElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGComponentTransferFunctionElementPrototype, JSObject>(exec, &JSSVGComponentTransferFunctionElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGComponentTransferFunctionElement::s_info = { "SVGComponentTransferFunctionElement", &JSSVGElement::s_info, &JSSVGComponentTransferFunctionElementTable, 0 };

JSSVGComponentTransferFunctionElement::JSSVGComponentTransferFunctionElement(PassRefPtr<Structure> structure, PassRefPtr<SVGComponentTransferFunctionElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGComponentTransferFunctionElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGComponentTransferFunctionElementPrototype(JSSVGComponentTransferFunctionElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGComponentTransferFunctionElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGComponentTransferFunctionElement, Base>(exec, &JSSVGComponentTransferFunctionElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGComponentTransferFunctionElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGComponentTransferFunctionElement* imp = static_cast<SVGComponentTransferFunctionElement*>(static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->typeAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGComponentTransferFunctionElementTableValues(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGComponentTransferFunctionElement* imp = static_cast<SVGComponentTransferFunctionElement*>(static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumberList> obj = imp->tableValuesAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGComponentTransferFunctionElementSlope(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGComponentTransferFunctionElement* imp = static_cast<SVGComponentTransferFunctionElement*>(static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->slopeAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGComponentTransferFunctionElementIntercept(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGComponentTransferFunctionElement* imp = static_cast<SVGComponentTransferFunctionElement*>(static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->interceptAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGComponentTransferFunctionElementAmplitude(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGComponentTransferFunctionElement* imp = static_cast<SVGComponentTransferFunctionElement*>(static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->amplitudeAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGComponentTransferFunctionElementExponent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGComponentTransferFunctionElement* imp = static_cast<SVGComponentTransferFunctionElement*>(static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->exponentAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGComponentTransferFunctionElementOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGComponentTransferFunctionElement* imp = static_cast<SVGComponentTransferFunctionElement*>(static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->offsetAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGComponentTransferFunctionElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGComponentTransferFunctionElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSSVGComponentTransferFunctionElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGComponentTransferFunctionElementConstructor>(exec);
}

// Constant getters

JSValuePtr jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValuePtr jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_IDENTITY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_TABLE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValuePtr jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_DISCRETE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValuePtr jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_LINEAR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValuePtr jsSVGComponentTransferFunctionElementSVG_FECOMPONENTTRANSFER_TYPE_GAMMA(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
