/* event-test.c generated by valac 0.20.1, the Vala compiler
 * generated from event-test.vala, do not modify */

/* event-test.vala
 *
 * Copyright © 2012 Christian Dywan <christian@twotoasts.de>
 *
 * Based upon a C implementation (© 2010 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-datamodel.h"
#include "tests.h"
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



gint _vala_main (gchar** argv, int argv_length1);
void create_empty_test (void);
static void _create_empty_test_gtest_func (void);
void create_full_test (void);
static void _create_full_test_gtest_func (void);
void actor_from_app_info_test (void);
static void _actor_from_app_info_test_gtest_func (void);
void from_variant_test (void);
static void _from_variant_test_gtest_func (void);
void from_variant_with_new_fields_test (void);
static void _from_variant_with_new_fields_test_gtest_func (void);
void empty_to_from_variant_test (void);
static void _empty_to_from_variant_test_gtest_func (void);
void with_one_subject_to_from_variant_test (void);
static void _with_one_subject_to_from_variant_test_gtest_func (void);
void three_events_to_from_variant_test (void);
static void _three_events_to_from_variant_test_gtest_func (void);
void zero_events_to_from_variant_test (void);
static void _zero_events_to_from_variant_test_gtest_func (void);
static void _g_object_unref0_ (gpointer var);


static void _create_empty_test_gtest_func (void) {
#line 30 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	create_empty_test ();
#line 72 "event-test.c"
}


static void _create_full_test_gtest_func (void) {
#line 31 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	create_full_test ();
#line 79 "event-test.c"
}


static void _actor_from_app_info_test_gtest_func (void) {
#line 32 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	actor_from_app_info_test ();
#line 86 "event-test.c"
}


static void _from_variant_test_gtest_func (void) {
#line 33 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	from_variant_test ();
#line 93 "event-test.c"
}


static void _from_variant_with_new_fields_test_gtest_func (void) {
#line 34 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	from_variant_with_new_fields_test ();
#line 100 "event-test.c"
}


static void _empty_to_from_variant_test_gtest_func (void) {
#line 35 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	empty_to_from_variant_test ();
#line 107 "event-test.c"
}


static void _with_one_subject_to_from_variant_test_gtest_func (void) {
#line 36 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	with_one_subject_to_from_variant_test ();
#line 114 "event-test.c"
}


static void _three_events_to_from_variant_test_gtest_func (void) {
#line 37 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	three_events_to_from_variant_test ();
#line 121 "event-test.c"
}


static void _zero_events_to_from_variant_test_gtest_func (void) {
#line 38 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zero_events_to_from_variant_test ();
#line 128 "event-test.c"
}


gint _vala_main (gchar** argv, int argv_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 28 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_init (&argv_length1, &argv, NULL);
#line 30 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/CreateEmpty", _create_empty_test_gtest_func);
#line 31 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/CreateFull", _create_full_test_gtest_func);
#line 32 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/ActorFromAppInfo", _actor_from_app_info_test_gtest_func);
#line 33 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/FromVariant", _from_variant_test_gtest_func);
#line 34 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/FromVariantWithNewFields", _from_variant_with_new_fields_test_gtest_func);
#line 35 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/EmptyToFromVariant", _empty_to_from_variant_test_gtest_func);
#line 36 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/WithOneSubjectToFromVariant", _with_one_subject_to_from_variant_test_gtest_func);
#line 37 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/3EventsToFromVariant", _three_events_to_from_variant_test_gtest_func);
#line 38 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_test_add_func ("/Event/0EventsToFromVariant", _zero_events_to_from_variant_test_gtest_func);
#line 40 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = g_test_run ();
#line 40 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	result = _tmp0_;
#line 40 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	return result;
#line 161 "event-test.c"
}


int main (int argc, char ** argv) {
#line 26 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_type_init ();
#line 26 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	return _vala_main (argv, argc);
#line 170 "event-test.c"
}


void create_empty_test (void) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* ev;
	guint32 _tmp1_;
	guint32 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_ = 0;
	GByteArray* _tmp14_;
	GByteArray* _tmp15_;
#line 45 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = zeitgeist_event_new ();
#line 45 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	ev = _tmp0_;
#line 47 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = zeitgeist_event_get_id (ev);
#line 47 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = _tmp1_;
#line 47 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp2_ == ((guint32) 0), "ev.id == 0");
#line 48 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = zeitgeist_event_get_timestamp (ev);
#line 48 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp4_ = _tmp3_;
#line 48 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp4_ == ((gint64) 0), "ev.timestamp == 0");
#line 49 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp5_ = zeitgeist_event_get_interpretation (ev);
#line 49 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_ = _tmp5_;
#line 49 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp6_, ==, NULL);
#line 50 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp7_ = zeitgeist_event_get_manifestation (ev);
#line 50 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = _tmp7_;
#line 50 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp8_, ==, NULL);
#line 51 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp9_ = zeitgeist_event_get_actor (ev);
#line 51 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp10_ = _tmp9_;
#line 51 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp10_, ==, NULL);
#line 52 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp11_ = zeitgeist_event_get_origin (ev);
#line 52 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp12_ = _tmp11_;
#line 52 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp12_, ==, NULL);
#line 53 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp13_ = zeitgeist_event_num_subjects (ev);
#line 53 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint (_tmp13_, ==, 0);
#line 54 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp14_ = zeitgeist_event_get_payload (ev);
#line 54 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp15_ = _tmp14_;
#line 54 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp15_ == NULL, "ev.payload == null");
#line 43 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (ev);
#line 244 "event-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 75 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 251 "event-test.c"
}


void create_full_test (void) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* ev;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistSubject* _tmp3_;
	guint32 _tmp4_;
	guint32 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_ = 0;
	GByteArray* _tmp17_;
	GByteArray* _tmp18_;
	GPtrArray* _tmp19_;
	GPtrArray* _tmp20_;
	gconstpointer _tmp21_ = NULL;
	ZeitgeistSubject* _tmp22_;
	ZeitgeistSubject* su;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
#line 59 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, "application://firefox.desktop", NULL, NULL);
#line 59 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	ev = _tmp0_;
#line 61 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = zeitgeist_subject_new_full ("http://example.com", ZEITGEIST_NFO_WEBSITE, ZEITGEIST_NFO_REMOTE_DATA_OBJECT, "text/html", "http://example.com", "example.com", "net");
#line 61 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zeitgeist_event_take_subject (ev, _tmp1_);
#line 64 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = zeitgeist_subject_new ();
#line 64 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = _tmp2_;
#line 64 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zeitgeist_event_add_subject (ev, _tmp3_);
#line 64 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (_tmp3_);
#line 66 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp4_ = zeitgeist_event_get_id (ev);
#line 66 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp5_ = _tmp4_;
#line 66 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp5_ == ((guint32) 0), "ev.id == 0");
#line 67 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_ = zeitgeist_event_get_timestamp (ev);
#line 67 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp7_ = _tmp6_;
#line 67 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp7_ == ((gint64) 0), "ev.timestamp == 0");
#line 68 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = zeitgeist_event_get_interpretation (ev);
#line 68 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp9_ = _tmp8_;
#line 68 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp9_, ==, ZEITGEIST_ZG_ACCESS_EVENT);
#line 69 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp10_ = zeitgeist_event_get_manifestation (ev);
#line 69 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp11_ = _tmp10_;
#line 69 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp11_, ==, ZEITGEIST_ZG_USER_ACTIVITY);
#line 70 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp12_ = zeitgeist_event_get_actor (ev);
#line 70 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp13_ = _tmp12_;
#line 70 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp13_, ==, "application://firefox.desktop");
#line 71 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp14_ = zeitgeist_event_get_origin (ev);
#line 71 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp15_ = _tmp14_;
#line 71 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp15_, ==, NULL);
#line 72 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp16_ = zeitgeist_event_num_subjects (ev);
#line 72 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint (_tmp16_, ==, 2);
#line 73 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp17_ = zeitgeist_event_get_payload (ev);
#line 73 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp18_ = _tmp17_;
#line 73 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp18_ == NULL, "ev.payload == null");
#line 75 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp19_ = zeitgeist_event_get_subjects (ev);
#line 75 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp20_ = _tmp19_;
#line 75 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp21_ = g_ptr_array_index (_tmp20_, (guint) 1);
#line 75 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp22_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp21_);
#line 75 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	su = _tmp22_;
#line 76 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp23_ = zeitgeist_subject_get_uri (su);
#line 76 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp24_ = _tmp23_;
#line 76 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp24_, ==, NULL);
#line 77 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp25_ = zeitgeist_subject_get_interpretation (su);
#line 77 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp26_ = _tmp25_;
#line 77 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp26_, ==, NULL);
#line 78 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp27_ = zeitgeist_subject_get_manifestation (su);
#line 78 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp28_ = _tmp27_;
#line 78 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp28_, ==, NULL);
#line 79 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp29_ = zeitgeist_subject_get_mimetype (su);
#line 79 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp30_ = _tmp29_;
#line 79 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp30_, ==, NULL);
#line 80 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp31_ = zeitgeist_subject_get_origin (su);
#line 80 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp32_ = _tmp31_;
#line 80 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp32_, ==, NULL);
#line 81 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp33_ = zeitgeist_subject_get_text (su);
#line 81 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp34_ = _tmp33_;
#line 81 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp34_, ==, NULL);
#line 82 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp35_ = zeitgeist_subject_get_storage (su);
#line 82 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp36_ = _tmp35_;
#line 82 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp36_, ==, NULL);
#line 83 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp37_ = zeitgeist_subject_get_current_uri (su);
#line 83 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp38_ = _tmp37_;
#line 83 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp38_, ==, NULL);
#line 57 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (su);
#line 57 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (ev);
#line 421 "event-test.c"
}


void actor_from_app_info_test (void) {
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* appinfo;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* ev;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 88 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = g_desktop_app_info_new_from_filename (DIR "/test.desktop");
#line 88 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	appinfo = _tmp0_;
#line 89 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (appinfo, g_app_info_get_type ()), "appinfo is AppInfo");
#line 91 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = zeitgeist_event_new ();
#line 91 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	ev = _tmp1_;
#line 92 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zeitgeist_event_set_actor_from_app_info (ev, (GAppInfo*) appinfo);
#line 93 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = zeitgeist_event_get_actor (ev);
#line 93 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = _tmp2_;
#line 93 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp3_, ==, "application://test.desktop");
#line 86 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (ev);
#line 86 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (appinfo);
#line 454 "event-test.c"
}


static gpointer _g_byte_array_ref0 (gpointer self) {
#line 156 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	return self ? g_byte_array_ref (self) : NULL;
#line 461 "event-test.c"
}


void from_variant_test (void) {
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* b;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariantType* _tmp10_;
	GVariantType* _tmp11_;
	GVariant* _tmp12_ = NULL;
	GVariant* var;
	ZeitgeistEvent* ev = NULL;
	guint32 _tmp16_;
	guint32 _tmp17_;
	gint64 _tmp18_;
	gint64 _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_ = 0;
	GPtrArray* _tmp29_;
	GPtrArray* _tmp30_;
	gconstpointer _tmp31_ = NULL;
	ZeitgeistSubject* _tmp32_;
	ZeitgeistSubject* su;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	GByteArray* _tmp45_;
	GByteArray* _tmp46_;
	GByteArray* _tmp47_;
	GByteArray* payload;
	guint _tmp48_;
	guint8* _tmp49_;
	gint _tmp49__length1;
	guint8 _tmp50_;
	guint8* _tmp51_;
	gint _tmp51__length1;
	guint8 _tmp52_;
	guint8* _tmp53_;
	gint _tmp53__length1;
	guint8 _tmp54_;
	GError * _inner_error_ = NULL;
#line 98 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
#line 98 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = _tmp0_;
#line 98 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = g_variant_builder_new (_tmp1_);
#line 98 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = _tmp2_;
#line 98 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp1_);
#line 98 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	b = _tmp3_;
#line 101 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp4_ = g_variant_type_new ("as");
#line 101 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp5_ = _tmp4_;
#line 101 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp5_);
#line 101 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp5_);
#line 102 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "27", NULL);
#line 103 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "68", NULL);
#line 104 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_ZG_ACCESS_EVENT, NULL);
#line 105 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_ZG_USER_ACTIVITY, NULL);
#line 106 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "application://foo.desktop", NULL);
#line 107 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 110 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_ = g_variant_type_new ("aas");
#line 110 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp7_);
#line 110 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp7_);
#line 111 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = g_variant_type_new ("as");
#line 111 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp9_ = _tmp8_;
#line 111 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp9_);
#line 111 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp9_);
#line 112 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "file:///tmp/foo.txt", NULL);
#line 113 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_NFO_DOCUMENT, NULL);
#line 114 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_NFO_FILE_DATA_OBJECT, NULL);
#line 115 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "file://tmp", NULL);
#line 116 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "text/plain", NULL);
#line 117 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "foo.text", NULL);
#line 118 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "36e5604e-7e1b-4ebd-bb6a-184c6ea99627", NULL);
#line 119 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 120 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 123 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp10_ = g_variant_type_new ("ay");
#line 123 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp11_ = _tmp10_;
#line 123 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp11_);
#line 123 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp11_);
#line 124 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "y", 1, NULL);
#line 125 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "y", 2, NULL);
#line 126 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "y", 3, NULL);
#line 127 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 129 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp12_ = g_variant_builder_end (b);
#line 129 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_ref_sink (_tmp12_);
#line 129 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	var = _tmp12_;
#line 615 "event-test.c"
	{
		ZeitgeistEvent* _tmp13_;
		ZeitgeistEvent* _tmp14_;
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp13_ = zeitgeist_event_new_from_variant (var, &_inner_error_);
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp14_ = _tmp13_;
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		if (_inner_error_ != NULL) {
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
#line 627 "event-test.c"
				goto __catch0_zeitgeist_data_model_error;
			}
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_object_unref0 (ev);
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_variant_unref0 (var);
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_variant_builder_unref0 (b);
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			g_clear_error (&_inner_error_);
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			return;
#line 642 "event-test.c"
		}
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (ev);
#line 133 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		ev = _tmp14_;
#line 648 "event-test.c"
	}
	goto __finally0;
	__catch0_zeitgeist_data_model_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp15_;
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_error_ = _inner_error_;
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_inner_error_ = NULL;
#line 137 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp15_ = _error_->message;
#line 137 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_error ("event-test.vala:137: %s", _tmp15_);
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_error_free0 (_error_);
#line 665 "event-test.c"
	}
	__finally0:
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	if (_inner_error_ != NULL) {
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (ev);
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_variant_unref0 (var);
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_variant_builder_unref0 (b);
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_clear_error (&_inner_error_);
#line 131 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		return;
#line 682 "event-test.c"
	}
#line 140 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp16_ = zeitgeist_event_get_id (ev);
#line 140 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp17_ = _tmp16_;
#line 140 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp17_ == ((guint32) 27), "ev.id == 27");
#line 141 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp18_ = zeitgeist_event_get_timestamp (ev);
#line 141 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp19_ = _tmp18_;
#line 141 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp19_ == ((gint64) 68), "ev.timestamp == 68");
#line 142 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp20_ = zeitgeist_event_get_interpretation (ev);
#line 142 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp21_ = _tmp20_;
#line 142 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp21_, ==, ZEITGEIST_ZG_ACCESS_EVENT);
#line 143 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp22_ = zeitgeist_event_get_manifestation (ev);
#line 143 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp23_ = _tmp22_;
#line 143 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp23_, ==, ZEITGEIST_ZG_USER_ACTIVITY);
#line 144 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp24_ = zeitgeist_event_get_actor (ev);
#line 144 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp25_ = _tmp24_;
#line 144 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp25_, ==, "application://foo.desktop");
#line 145 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp26_ = zeitgeist_event_get_origin (ev);
#line 145 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp27_ = _tmp26_;
#line 145 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp27_, ==, NULL);
#line 146 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp28_ = zeitgeist_event_num_subjects (ev);
#line 146 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint (_tmp28_, ==, 1);
#line 148 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp29_ = zeitgeist_event_get_subjects (ev);
#line 148 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp30_ = _tmp29_;
#line 148 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp31_ = g_ptr_array_index (_tmp30_, (guint) 0);
#line 148 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp32_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp31_);
#line 148 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	su = _tmp32_;
#line 149 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp33_ = zeitgeist_subject_get_uri (su);
#line 149 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp34_ = _tmp33_;
#line 149 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp34_, ==, "file:///tmp/foo.txt");
#line 150 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp35_ = zeitgeist_subject_get_interpretation (su);
#line 150 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp36_ = _tmp35_;
#line 150 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp36_, ==, ZEITGEIST_NFO_DOCUMENT);
#line 151 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp37_ = zeitgeist_subject_get_manifestation (su);
#line 151 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp38_ = _tmp37_;
#line 151 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp38_, ==, ZEITGEIST_NFO_FILE_DATA_OBJECT);
#line 152 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp39_ = zeitgeist_subject_get_mimetype (su);
#line 152 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp40_ = _tmp39_;
#line 152 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp40_, ==, "text/plain");
#line 153 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp41_ = zeitgeist_subject_get_origin (su);
#line 153 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp42_ = _tmp41_;
#line 153 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp42_, ==, "file://tmp");
#line 154 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp43_ = zeitgeist_subject_get_storage (su);
#line 154 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp44_ = _tmp43_;
#line 154 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp44_, ==, "36e5604e-7e1b-4ebd-bb6a-184c6ea99627");
#line 156 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp45_ = zeitgeist_event_get_payload (ev);
#line 156 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp46_ = _tmp45_;
#line 156 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp47_ = _g_byte_array_ref0 (_tmp46_);
#line 156 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	payload = _tmp47_;
#line 157 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (payload != NULL, "payload != null");
#line 158 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp48_ = payload->len;
#line 158 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpuint (_tmp48_, ==, (guint) 3);
#line 159 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp49_ = payload->data;
#line 159 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp49__length1 = (gint) payload->len;
#line 159 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp50_ = _tmp49_[0];
#line 159 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint ((gint) _tmp50_, ==, 1);
#line 160 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp51_ = payload->data;
#line 160 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp51__length1 = (gint) payload->len;
#line 160 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp52_ = _tmp51_[1];
#line 160 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint ((gint) _tmp52_, ==, 2);
#line 161 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp53_ = payload->data;
#line 161 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp53__length1 = (gint) payload->len;
#line 161 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp54_ = _tmp53_[2];
#line 161 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint ((gint) _tmp54_, ==, 3);
#line 96 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_byte_array_unref0 (payload);
#line 96 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (su);
#line 96 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (ev);
#line 96 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_unref0 (var);
#line 96 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_builder_unref0 (b);
#line 818 "event-test.c"
}


void from_variant_with_new_fields_test (void) {
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* b;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariantType* _tmp10_;
	GVariantType* _tmp11_;
	GVariant* _tmp12_ = NULL;
	GVariant* var;
	ZeitgeistEvent* ev = NULL;
	guint32 _tmp16_;
	guint32 _tmp17_;
	gint64 _tmp18_;
	gint64 _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_ = 0;
	GPtrArray* _tmp29_;
	GPtrArray* _tmp30_;
	gconstpointer _tmp31_ = NULL;
	ZeitgeistSubject* _tmp32_;
	ZeitgeistSubject* su;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	GByteArray* _tmp51_;
	GByteArray* _tmp52_;
	GByteArray* _tmp53_;
	GByteArray* payload;
	guint _tmp54_;
	guint8* _tmp55_;
	gint _tmp55__length1;
	guint8 _tmp56_;
	guint8* _tmp57_;
	gint _tmp57__length1;
	guint8 _tmp58_;
	guint8* _tmp59_;
	gint _tmp59__length1;
	guint8 _tmp60_;
	GError * _inner_error_ = NULL;
#line 166 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
#line 166 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = _tmp0_;
#line 166 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = g_variant_builder_new (_tmp1_);
#line 166 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = _tmp2_;
#line 166 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp1_);
#line 166 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	b = _tmp3_;
#line 169 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp4_ = g_variant_type_new ("as");
#line 169 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp5_ = _tmp4_;
#line 169 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp5_);
#line 169 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp5_);
#line 170 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "27", NULL);
#line 171 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "68", NULL);
#line 172 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_ZG_ACCESS_EVENT, NULL);
#line 173 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_ZG_USER_ACTIVITY, NULL);
#line 174 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "application://foo.desktop", NULL);
#line 175 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "origin", NULL);
#line 176 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 179 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_ = g_variant_type_new ("aas");
#line 179 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp7_ = _tmp6_;
#line 179 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp7_);
#line 179 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp7_);
#line 180 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = g_variant_type_new ("as");
#line 180 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp9_ = _tmp8_;
#line 180 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp9_);
#line 180 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp9_);
#line 181 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "file:///tmp/foo.txt", NULL);
#line 182 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_NFO_DOCUMENT, NULL);
#line 183 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", ZEITGEIST_NFO_FILE_DATA_OBJECT, NULL);
#line 184 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "file:///tmp", NULL);
#line 185 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "text/plain", NULL);
#line 186 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "foo.text", NULL);
#line 187 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "36e5604e-7e1b-4ebd-bb6a-184c6ea99627", NULL);
#line 188 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "file:///tmp/current.txt", NULL);
#line 189 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "s", "file:///tmp1", NULL);
#line 190 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 191 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 194 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp10_ = g_variant_type_new ("ay");
#line 194 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp11_ = _tmp10_;
#line 194 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_open (b, _tmp11_);
#line 194 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_type_free0 (_tmp11_);
#line 195 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "y", 1, NULL);
#line 196 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "y", 2, NULL);
#line 197 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_add (b, "y", 3, NULL);
#line 198 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_builder_close (b);
#line 200 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp12_ = g_variant_builder_end (b);
#line 200 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_variant_ref_sink (_tmp12_);
#line 200 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	var = _tmp12_;
#line 984 "event-test.c"
	{
		ZeitgeistEvent* _tmp13_;
		ZeitgeistEvent* _tmp14_;
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp13_ = zeitgeist_event_new_from_variant (var, &_inner_error_);
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp14_ = _tmp13_;
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		if (_inner_error_ != NULL) {
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
#line 996 "event-test.c"
				goto __catch1_zeitgeist_data_model_error;
			}
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_object_unref0 (ev);
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_variant_unref0 (var);
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_variant_builder_unref0 (b);
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			g_clear_error (&_inner_error_);
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			return;
#line 1011 "event-test.c"
		}
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (ev);
#line 204 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		ev = _tmp14_;
#line 1017 "event-test.c"
	}
	goto __finally1;
	__catch1_zeitgeist_data_model_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp15_;
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_error_ = _inner_error_;
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_inner_error_ = NULL;
#line 208 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp15_ = _error_->message;
#line 208 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_error ("event-test.vala:208: %s", _tmp15_);
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_error_free0 (_error_);
#line 1034 "event-test.c"
	}
	__finally1:
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	if (_inner_error_ != NULL) {
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (ev);
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_variant_unref0 (var);
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_variant_builder_unref0 (b);
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_clear_error (&_inner_error_);
#line 202 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		return;
#line 1051 "event-test.c"
	}
#line 211 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp16_ = zeitgeist_event_get_id (ev);
#line 211 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp17_ = _tmp16_;
#line 211 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp17_ == ((guint32) 27), "ev.id == 27");
#line 212 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp18_ = zeitgeist_event_get_timestamp (ev);
#line 212 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp19_ = _tmp18_;
#line 212 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp19_ == ((gint64) 68), "ev.timestamp == 68");
#line 213 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp20_ = zeitgeist_event_get_interpretation (ev);
#line 213 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp21_ = _tmp20_;
#line 213 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp21_, ==, ZEITGEIST_ZG_ACCESS_EVENT);
#line 214 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp22_ = zeitgeist_event_get_manifestation (ev);
#line 214 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp23_ = _tmp22_;
#line 214 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp23_, ==, ZEITGEIST_ZG_USER_ACTIVITY);
#line 215 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp24_ = zeitgeist_event_get_actor (ev);
#line 215 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp25_ = _tmp24_;
#line 215 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp25_, ==, "application://foo.desktop");
#line 216 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp26_ = zeitgeist_event_get_origin (ev);
#line 216 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp27_ = _tmp26_;
#line 216 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp27_, ==, "origin");
#line 217 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp28_ = zeitgeist_event_num_subjects (ev);
#line 217 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint (_tmp28_, ==, 1);
#line 219 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp29_ = zeitgeist_event_get_subjects (ev);
#line 219 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp30_ = _tmp29_;
#line 219 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp31_ = g_ptr_array_index (_tmp30_, (guint) 0);
#line 219 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp32_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp31_);
#line 219 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	su = _tmp32_;
#line 220 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp33_ = zeitgeist_subject_get_uri (su);
#line 220 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp34_ = _tmp33_;
#line 220 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp34_, ==, "file:///tmp/foo.txt");
#line 221 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp35_ = zeitgeist_subject_get_interpretation (su);
#line 221 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp36_ = _tmp35_;
#line 221 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp36_, ==, ZEITGEIST_NFO_DOCUMENT);
#line 222 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp37_ = zeitgeist_subject_get_manifestation (su);
#line 222 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp38_ = _tmp37_;
#line 222 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp38_, ==, ZEITGEIST_NFO_FILE_DATA_OBJECT);
#line 223 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp39_ = zeitgeist_subject_get_mimetype (su);
#line 223 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp40_ = _tmp39_;
#line 223 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp40_, ==, "text/plain");
#line 224 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp41_ = zeitgeist_subject_get_origin (su);
#line 224 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp42_ = _tmp41_;
#line 224 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp42_, ==, "file:///tmp");
#line 225 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp43_ = zeitgeist_subject_get_text (su);
#line 225 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp44_ = _tmp43_;
#line 225 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp44_, ==, "foo.text");
#line 226 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp45_ = zeitgeist_subject_get_storage (su);
#line 226 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp46_ = _tmp45_;
#line 226 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp46_, ==, "36e5604e-7e1b-4ebd-bb6a-184c6ea99627");
#line 227 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp47_ = zeitgeist_subject_get_current_uri (su);
#line 227 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp48_ = _tmp47_;
#line 227 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp48_, ==, "file:///tmp/current.txt");
#line 228 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp49_ = zeitgeist_subject_get_current_origin (su);
#line 228 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp50_ = _tmp49_;
#line 228 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp50_, ==, "file:///tmp1");
#line 230 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp51_ = zeitgeist_event_get_payload (ev);
#line 230 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp52_ = _tmp51_;
#line 230 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp53_ = _g_byte_array_ref0 (_tmp52_);
#line 230 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	payload = _tmp53_;
#line 231 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (payload != NULL, "payload != null");
#line 232 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp54_ = payload->len;
#line 232 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpuint (_tmp54_, ==, (guint) 3);
#line 233 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp55_ = payload->data;
#line 233 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp55__length1 = (gint) payload->len;
#line 233 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp56_ = _tmp55_[0];
#line 233 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint ((gint) _tmp56_, ==, 1);
#line 234 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp57_ = payload->data;
#line 234 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp57__length1 = (gint) payload->len;
#line 234 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp58_ = _tmp57_[1];
#line 234 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint ((gint) _tmp58_, ==, 2);
#line 235 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp59_ = payload->data;
#line 235 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp59__length1 = (gint) payload->len;
#line 235 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp60_ = _tmp59_[2];
#line 235 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint ((gint) _tmp60_, ==, 3);
#line 164 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_byte_array_unref0 (payload);
#line 164 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (su);
#line 164 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (ev);
#line 164 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_unref0 (var);
#line 164 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_builder_unref0 (b);
#line 1205 "event-test.c"
}


void empty_to_from_variant_test (void) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* orig;
	gint64 _tmp1_ = 0LL;
	ZeitgeistEvent* marshalled = NULL;
	guint32 _tmp8_;
	guint32 _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gint64 _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_ = 0;
	GByteArray* _tmp23_;
	GByteArray* _tmp24_;
	GError * _inner_error_ = NULL;
#line 241 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = zeitgeist_event_new ();
#line 241 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	orig = _tmp0_;
#line 242 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = zeitgeist_timestamp_from_now ();
#line 242 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zeitgeist_event_set_timestamp (orig, _tmp1_);
#line 1240 "event-test.c"
	{
		GVariant* _tmp2_ = NULL;
		GVariant* _tmp3_;
		ZeitgeistEvent* _tmp4_;
		ZeitgeistEvent* _tmp5_;
		ZeitgeistEvent* _tmp6_;
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp2_ = zeitgeist_event_to_variant (orig);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp3_ = _tmp2_;
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp4_ = zeitgeist_event_new_from_variant (_tmp3_, &_inner_error_);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp5_ = _tmp4_;
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_variant_unref0 (_tmp3_);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp6_ = _tmp5_;
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		if (_inner_error_ != NULL) {
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
#line 1263 "event-test.c"
				goto __catch2_zeitgeist_data_model_error;
			}
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_object_unref0 (marshalled);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			_g_object_unref0 (orig);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			g_clear_error (&_inner_error_);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
			return;
#line 1276 "event-test.c"
		}
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (marshalled);
#line 246 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		marshalled = _tmp6_;
#line 1282 "event-test.c"
	}
	goto __finally2;
	__catch2_zeitgeist_data_model_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp7_;
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_error_ = _inner_error_;
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_inner_error_ = NULL;
#line 250 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_tmp7_ = _error_->message;
#line 250 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_error ("event-test.vala:250: %s", _tmp7_);
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_error_free0 (_error_);
#line 1299 "event-test.c"
	}
	__finally2:
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	if (_inner_error_ != NULL) {
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (marshalled);
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (orig);
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_clear_error (&_inner_error_);
#line 244 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		return;
#line 1314 "event-test.c"
	}
#line 253 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = zeitgeist_event_get_id (marshalled);
#line 253 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp9_ = _tmp8_;
#line 253 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp9_ == ((guint32) 0), "marshalled.id == 0");
#line 254 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp10_ = zeitgeist_event_get_timestamp (marshalled);
#line 254 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp11_ = _tmp10_;
#line 254 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp12_ = zeitgeist_event_get_timestamp (orig);
#line 254 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp13_ = _tmp12_;
#line 254 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp11_ == _tmp13_, "marshalled.timestamp == orig.timestamp");
#line 255 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp14_ = zeitgeist_event_get_interpretation (marshalled);
#line 255 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp15_ = _tmp14_;
#line 255 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp15_, ==, NULL);
#line 256 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp16_ = zeitgeist_event_get_manifestation (marshalled);
#line 256 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp17_ = _tmp16_;
#line 256 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp17_, ==, NULL);
#line 257 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp18_ = zeitgeist_event_get_actor (marshalled);
#line 257 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp19_ = _tmp18_;
#line 257 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp19_, ==, NULL);
#line 258 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp20_ = zeitgeist_event_get_origin (marshalled);
#line 258 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp21_ = _tmp20_;
#line 258 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp21_, ==, NULL);
#line 259 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp22_ = zeitgeist_event_num_subjects (marshalled);
#line 259 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint (_tmp22_, ==, 0);
#line 260 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp23_ = zeitgeist_event_get_payload (marshalled);
#line 260 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp24_ = _tmp23_;
#line 260 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp24_ == NULL, "marshalled.payload == null");
#line 239 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (marshalled);
#line 239 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (orig);
#line 1370 "event-test.c"
}


void with_one_subject_to_from_variant_test (void) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* orig;
	ZeitgeistSubject* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	GByteArray* _tmp5_;
	GByteArray* payload;
	guint8* _tmp6_ = NULL;
	guint8* byte;
	gint byte_length1;
	gint _byte_size_;
	GByteArray* _tmp7_;
	GByteArray* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_;
	ZeitgeistEvent* _tmp11_;
	ZeitgeistEvent* _tmp12_;
	ZeitgeistEvent* marshalled;
	guint32 _tmp13_;
	guint32 _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_ = 0;
	GByteArray* _tmp24_;
	GByteArray* _tmp25_;
	GByteArray* _tmp26_;
	GByteArray* _tmp27_;
	GByteArray* _tmp28_;
	guint _tmp29_;
	GByteArray* _tmp30_;
	guint8* _tmp31_;
	gint _tmp31__length1;
	guint8 _tmp32_;
	GPtrArray* _tmp33_;
	GPtrArray* _tmp34_;
	gconstpointer _tmp35_ = NULL;
	ZeitgeistSubject* _tmp36_;
	ZeitgeistSubject* su;
	ZeitgeistSubject* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	ZeitgeistSubject* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	ZeitgeistSubject* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	ZeitgeistSubject* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	ZeitgeistSubject* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	ZeitgeistSubject* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	ZeitgeistSubject* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	ZeitgeistSubject* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	GError * _inner_error_ = NULL;
#line 265 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, "application://firefox.desktop", "origin", NULL);
#line 265 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	orig = _tmp0_;
#line 268 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = zeitgeist_subject_new_full ("http://example.com", ZEITGEIST_NFO_WEBSITE, ZEITGEIST_NFO_REMOTE_DATA_OBJECT, "text/html", "http://example.com", "example.com", "net");
#line 268 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zeitgeist_event_take_subject (orig, _tmp1_);
#line 271 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = zeitgeist_event_get_subjects (orig);
#line 271 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = _tmp2_;
#line 271 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp4_ = g_ptr_array_index (_tmp3_, (guint) 0);
#line 271 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zeitgeist_subject_set_current_uri ((ZeitgeistSubject*) _tmp4_, "http://current-example.com");
#line 273 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp5_ = g_byte_array_new ();
#line 273 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	payload = _tmp5_;
#line 274 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_ = g_new0 (guint8, 1);
#line 274 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_[0] = (guint8) 255;
#line 274 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	byte = _tmp6_;
#line 274 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	byte_length1 = 1;
#line 274 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_byte_size_ = byte_length1;
#line 275 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp7_ = payload;
#line 275 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_byte_array_append (_tmp7_, byte, byte_length1);
#line 276 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = payload;
#line 276 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	zeitgeist_event_set_payload (orig, _tmp8_);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp9_ = zeitgeist_event_to_variant (orig);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp10_ = _tmp9_;
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp11_ = zeitgeist_event_new_from_variant (_tmp10_, &_inner_error_);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp12_ = _tmp11_;
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_unref0 (_tmp10_);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	marshalled = _tmp12_;
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	if (_inner_error_ != NULL) {
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		byte = (g_free (byte), NULL);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_byte_array_unref0 (payload);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_object_unref0 (orig);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_clear_error (&_inner_error_);
#line 278 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		return;
#line 1509 "event-test.c"
	}
#line 280 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp13_ = zeitgeist_event_get_id (marshalled);
#line 280 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp14_ = _tmp13_;
#line 280 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp14_ == ((guint32) 0), "marshalled.id == 0");
#line 281 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp15_ = zeitgeist_event_get_interpretation (marshalled);
#line 281 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp16_ = _tmp15_;
#line 281 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp16_, ==, ZEITGEIST_ZG_ACCESS_EVENT);
#line 282 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp17_ = zeitgeist_event_get_manifestation (marshalled);
#line 282 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp18_ = _tmp17_;
#line 282 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp18_, ==, ZEITGEIST_ZG_USER_ACTIVITY);
#line 283 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp19_ = zeitgeist_event_get_actor (marshalled);
#line 283 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp20_ = _tmp19_;
#line 283 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp20_, ==, "application://firefox.desktop");
#line 284 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp21_ = zeitgeist_event_get_origin (marshalled);
#line 284 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp22_ = _tmp21_;
#line 284 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp22_, ==, "origin");
#line 285 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp23_ = zeitgeist_event_num_subjects (marshalled);
#line 285 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint (_tmp23_, ==, 1);
#line 287 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp24_ = zeitgeist_event_get_payload (marshalled);
#line 287 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp25_ = _tmp24_;
#line 287 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp26_ = _g_byte_array_ref0 (_tmp25_);
#line 287 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_byte_array_unref0 (payload);
#line 287 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	payload = _tmp26_;
#line 288 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp27_ = payload;
#line 288 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp27_ != NULL, "payload != null");
#line 289 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp28_ = payload;
#line 289 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp29_ = _tmp28_->len;
#line 289 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp29_ == ((guint) 1), "payload.len == 1");
#line 290 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp30_ = payload;
#line 290 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp31_ = _tmp30_->data;
#line 290 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp31__length1 = (gint) _tmp30_->len;
#line 290 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp32_ = _tmp31_[0];
#line 290 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (((gint) _tmp32_) == 255, "payload.data[0] == 255");
#line 292 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp33_ = zeitgeist_event_get_subjects (marshalled);
#line 292 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp34_ = _tmp33_;
#line 292 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp35_ = g_ptr_array_index (_tmp34_, (guint) 0);
#line 292 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp36_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp35_);
#line 292 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	su = _tmp36_;
#line 293 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp37_ = su;
#line 293 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp38_ = zeitgeist_subject_get_uri (_tmp37_);
#line 293 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp39_ = _tmp38_;
#line 293 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp39_, ==, "http://example.com");
#line 294 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp40_ = su;
#line 294 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp41_ = zeitgeist_subject_get_interpretation (_tmp40_);
#line 294 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp42_ = _tmp41_;
#line 294 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp42_, ==, ZEITGEIST_NFO_WEBSITE);
#line 295 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp43_ = su;
#line 295 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp44_ = zeitgeist_subject_get_manifestation (_tmp43_);
#line 295 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp45_ = _tmp44_;
#line 295 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp45_, ==, ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
#line 296 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp46_ = su;
#line 296 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp47_ = zeitgeist_subject_get_mimetype (_tmp46_);
#line 296 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp48_ = _tmp47_;
#line 296 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp48_, ==, "text/html");
#line 297 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp49_ = su;
#line 297 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp50_ = zeitgeist_subject_get_origin (_tmp49_);
#line 297 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp51_ = _tmp50_;
#line 297 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp51_, ==, "http://example.com");
#line 298 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp52_ = su;
#line 298 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp53_ = zeitgeist_subject_get_text (_tmp52_);
#line 298 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp54_ = _tmp53_;
#line 298 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp54_, ==, "example.com");
#line 299 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp55_ = su;
#line 299 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp56_ = zeitgeist_subject_get_storage (_tmp55_);
#line 299 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp57_ = _tmp56_;
#line 299 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp57_, ==, "net");
#line 300 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp58_ = su;
#line 300 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp59_ = zeitgeist_subject_get_current_uri (_tmp58_);
#line 300 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp60_ = _tmp59_;
#line 300 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpstr (_tmp60_, ==, "http://current-example.com");
#line 263 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (su);
#line 263 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (marshalled);
#line 263 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	byte = (g_free (byte), NULL);
#line 263 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_byte_array_unref0 (payload);
#line 263 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_object_unref0 (orig);
#line 1659 "event-test.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 305 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1666 "event-test.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1681 "event-test.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
#line 4096 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4096 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4096 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 1693 "event-test.c"
}


void three_events_to_from_variant_test (void) {
	GPtrArray* _tmp0_;
	GPtrArray* events;
	GPtrArray* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	GPtrArray* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	GPtrArray* _tmp5_;
	ZeitgeistEvent* _tmp6_;
	GPtrArray* _tmp7_;
	GVariant* _tmp8_ = NULL;
	GVariant* vevents;
	gsize _tmp9_ = 0UL;
	GPtrArray* _tmp10_ = NULL;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GPtrArray* _tmp15_;
	gconstpointer _tmp16_ = NULL;
	GPtrArray* _tmp17_;
	gconstpointer _tmp18_ = NULL;
	GPtrArray* _tmp19_;
	gconstpointer _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 305 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 305 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	events = _tmp0_;
#line 306 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = events;
#line 306 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = zeitgeist_event_new ();
#line 306 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_ptr_array_add (_tmp1_, _tmp2_);
#line 307 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = events;
#line 307 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp4_ = zeitgeist_event_new ();
#line 307 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_ptr_array_add (_tmp3_, _tmp4_);
#line 308 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp5_ = events;
#line 308 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_ = zeitgeist_event_new ();
#line 308 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_ptr_array_add (_tmp5_, _tmp6_);
#line 310 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp7_ = events;
#line 310 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = zeitgeist_events_to_variant (_tmp7_);
#line 310 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	vevents = _tmp8_;
#line 311 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp9_ = g_variant_n_children (vevents);
#line 311 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp9_ == ((gsize) 3), "vevents.n_children () == 3");
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp10_ = zeitgeist_events_from_variant (vevents, &_inner_error_);
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp11_ = _tmp10_;
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	if (_inner_error_ != NULL) {
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_variant_unref0 (vevents);
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_ptr_array_unref0 (events);
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_clear_error (&_inner_error_);
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		return;
#line 1770 "event-test.c"
	}
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_ptr_array_unref0 (events);
#line 313 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	events = _tmp11_;
#line 314 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp12_ = events;
#line 314 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp13_ = g_ptr_array_get_length (_tmp12_);
#line 314 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp14_ = _tmp13_;
#line 314 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp14_ == 3, "events.length == 3");
#line 315 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp15_ = events;
#line 315 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp16_ = g_ptr_array_index (_tmp15_, (guint) 0);
#line 315 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE ((ZeitgeistEvent*) _tmp16_, ZEITGEIST_TYPE_EVENT), "events.get (0) is Event");
#line 316 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp17_ = events;
#line 316 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp18_ = g_ptr_array_index (_tmp17_, (guint) 1);
#line 316 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE ((ZeitgeistEvent*) _tmp18_, ZEITGEIST_TYPE_EVENT), "events.get (1) is Event");
#line 317 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp19_ = events;
#line 317 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp20_ = g_ptr_array_index (_tmp19_, (guint) 2);
#line 317 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE ((ZeitgeistEvent*) _tmp20_, ZEITGEIST_TYPE_EVENT), "events.get (2) is Event");
#line 303 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_unref0 (vevents);
#line 303 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_ptr_array_unref0 (events);
#line 1806 "event-test.c"
}


void zero_events_to_from_variant_test (void) {
	GPtrArray* _tmp0_;
	GPtrArray* events;
	GPtrArray* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* vevents;
	gsize _tmp3_ = 0UL;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
#line 323 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 323 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	events = _tmp0_;
#line 324 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp1_ = events;
#line 324 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp2_ = zeitgeist_events_to_variant (_tmp1_);
#line 324 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	vevents = _tmp2_;
#line 325 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp3_ = g_variant_n_children (vevents);
#line 325 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_vala_assert (_tmp3_ == ((gsize) 0), "vevents.n_children () == 0");
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp4_ = zeitgeist_events_from_variant (vevents, &_inner_error_);
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp5_ = _tmp4_;
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	if (_inner_error_ != NULL) {
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_variant_unref0 (vevents);
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		_g_ptr_array_unref0 (events);
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		g_clear_error (&_inner_error_);
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
		return;
#line 1853 "event-test.c"
	}
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_ptr_array_unref0 (events);
#line 326 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	events = _tmp5_;
#line 327 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp6_ = events;
#line 327 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 327 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_tmp8_ = _tmp7_;
#line 327 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	g_assert_cmpint (_tmp8_, ==, 0);
#line 321 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_variant_unref0 (vevents);
#line 321 "/home/manish/code/zeitgeist/test/direct/event-test.vala"
	_g_ptr_array_unref0 (events);
#line 1871 "event-test.c"
}



