/*************************************************************************\
*   Copyright (C) 2011 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
\*************************************************************************/

#ifndef YAWP_DESKTOP_PAINTER_H
#define YAWP_DESKTOP_PAINTER_H

//--- LOCAL CLASSES ---
#include "basedesktoppainter.h"
#include "yawpday.h"
#include "yawpdefines.h"

//--- QT4 CLASSES ---
#include <QPixmap>

/*  The DesktopPainter is the traditional painter for
 *  the "desktop mode" of yaWP.
 */
class DesktopPainter : public BaseDesktopPainter
{
public:
	//--- Desktop Layout Constants ---
	// I do not use #define constructs for this two variables anymore
	// because we might want to access this variables from other painters as well
	// e.g.: access this variables from extended desktop painter
	//        to calculate the area for the mini applet on the left side
	static const qreal YAWP_ORIGINAL_WIDTH;
	static const qreal YAWP_ORIGINAL_HEIGHT;
  
	DesktopPainter (
		QGraphicsWidget * widget,
		const Yawp::ConfigData * configData,
		StateMachine * stateMachine);
	virtual ~DesktopPainter();
	
	virtual Plasma::AspectRatioMode aspectRatioMode() const;
	
	virtual Yawp::PainterType painterType() const;
	
	virtual int heightForWidth(int width) const;
	virtual int widthForHeight(int height) const;
	
	virtual void mousePressEvent (QGraphicsSceneMouseEvent * event);
	
	virtual void triggerWeatherIconAnimation(int dayIndex);
	
	QPixmap createSimpleToolTip(const int pixmapWidth) const;
	QPixmap createExtendedToolTip(const int pixmapWidth) const;

protected:
	virtual void handleLayoutChanges();

	virtual void drawPage(QPainter * painter, const QRect & contentsRect) const;
	virtual void drawBackground (QPainter * painter, const QRect & contentsRect) const;

	virtual QRect getContentsRect(const QRect & contentsRect) const;

	void setButtonNames();
	const QString & getButtonName(Yawp::PageType pageType) const;
	QString createVisualCityName( const CityWeather * pCity, int maxWidth ) const;

	
	void drawTopWeatherInfo(QPainter * painter, int dayIndex, const QRect & contentsRect, bool fancyTemperature = false) const;
	
	/** Draws the forcast table header that contains the daynames or dates of the forecast days.
	 *  @param paintDayNames True when method should paint the daynames otherwise the date will be painted.
	 */
	void drawForecastHeader(QPainter * painter, const QRect & contentsRect, bool paintDayNames) const;
	void drawForecast(QPainter * painter, const QRect & contentsRect, bool fancyTemperature = false) const;
	
	void drawDetailsHeader(QPainter * painter, int dayIndex, const QRect & detailsHeaderRect) const;
	void drawDetails(QPainter * painter, int dayIndex, const QRect & detailsContentsRect) const;

	// the contentsRect is the rectange where the satellite image will be painted
	// the top with the page buttons and the city name is not included in this contentsRect
	void drawSatelliteImage(QPainter * painter,
	                        const QRect & satelliteRect,
	                        bool drawBlackBackground = true,
	                        Qt::Alignment alignment = Qt::AlignCenter) const;

	QRect getDetailsDayButtonRect(const QRect & detailsHeaderRect, bool previous) const;
	
	QRect getTodaysWeatherIconRect(const QRect & contentsRect) const;
	QRect getForecastWeatherIconRect(const QRect & detailsContentsRect, int forecastIndex) const;
	
	/** The header of the details rectangle is the highlighted part in the YaWP-Applet
	 * that contains the dayname or date or text "Forecast" right above the details contents.
	 */
	QRect getDetailsHeaderRect(const QRect & contentsRect) const;
	QRect getDetailsContentsRect(const QRect & contentsRect) const;

	void drawPlainPage (QPainter * painter, const QRect & contentsRect) const;

	void drawTemperature(QPainter * painter, const YawpWeather * weather, const QRect & tempRect) const;
	void drawFancyTemperature(QPainter * painter, const YawpDay * day, const QRect & tempRect) const;
	
	/**
	 *  Get one of the buttons on the left top page (Preview, Details or Satellite).
	 *  This buttons will change the page.
	 */
	QRect getPageButtonRect (const QRect & contentsRect, Yawp::PageType pageType) const;

	/**
	 *  This button are on the left and right side of the city name and will change
	 *  the currently shown city.
	 */
	QRect getCityButtonRect(const QRect & contentsRect, bool previous) const;

	void initPartChange(
		const QRect & contentsRect,
		AbstractPainter::AnimationType animationType,
		bool showDayNames,
		bool showFancyTemperature);
	
private:
	QStringList m_vButtonNames;
	QString m_sVisualCityName;
	
	bool m_bDayNames;
};

#endif // YAWP_DESKTOP_PAINTER_H
